/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.PercentBase;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.properties.CommonAccessibility;
import org.apache.fop.fo.properties.CommonAural;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fo.properties.CommonMarginInline;
import org.apache.fop.fo.properties.CommonRelativePosition;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fo.properties.LengthRangeProperty;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.ImageFactory;
import org.xml.sax.Locator;

public class ExternalGraphic
extends FObj {
    private CommonAccessibility commonAccessibility;
    private CommonAural commonAural;
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private CommonMarginInline commonMarginInline;
    private CommonRelativePosition commonRelativePosition;
    private Length alignmentAdjust;
    private int alignmentBaseline;
    private Length baselineShift;
    private LengthRangeProperty blockProgressionDimension;
    private Length contentHeight;
    private String contentType;
    private Length contentWidth;
    private int displayAlign;
    private int dominantBaseline;
    private Length height;
    private String id;
    private LengthRangeProperty inlineProgressionDimension;
    private KeepProperty keepWithNext;
    private KeepProperty keepWithPrevious;
    private Length lineHeight;
    private int overflow;
    private int scaling;
    private int scalingMethod;
    private String src;
    private int textAlign;
    private int verticalAlign;
    private Length width;
    private String url;
    private FopImage fopimage;

    public ExternalGraphic(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        this.commonAccessibility = pList.getAccessibilityProps();
        this.commonAural = pList.getAuralProps();
        this.commonBorderPaddingBackground = pList.getBorderPaddingBackgroundProps();
        this.commonMarginInline = pList.getMarginInlineProps();
        this.commonRelativePosition = pList.getRelativePositionProps();
        this.alignmentAdjust = pList.get(3).getLength();
        this.alignmentBaseline = pList.get(4).getEnum();
        this.baselineShift = pList.get(15).getLength();
        this.blockProgressionDimension = pList.get(17).getLengthRange();
        this.contentHeight = pList.get(72).getLength();
        this.contentType = pList.get(73).getString();
        this.contentWidth = pList.get(74).getLength();
        this.displayAlign = pList.get(81).getEnum();
        this.dominantBaseline = pList.get(82).getEnum();
        this.height = pList.get(106).getLength();
        this.id = pList.get(113).getString();
        this.inlineProgressionDimension = pList.get(116).getLengthRange();
        this.keepWithNext = pList.get(119).getKeep();
        this.keepWithPrevious = pList.get(120).getKeep();
        this.lineHeight = pList.get(131).getLength();
        this.overflow = pList.get(153).getEnum();
        this.scaling = pList.get(193).getEnum();
        this.scalingMethod = pList.get(194).getEnum();
        this.src = pList.get(210).getString();
        this.textAlign = pList.get(223).getEnum();
        this.verticalAlign = pList.get(234).getEnum();
        this.width = pList.get(241).getLength();
        this.url = ImageFactory.getURL(this.getSrc());
        ImageFactory fact = ImageFactory.getInstance();
        this.fopimage = fact.getImage(this.url, this.getUserAgent());
        if (this.fopimage == null) {
            this.getLogger().error("Image not available: " + this.getSrc());
        } else if (!this.fopimage.load(1)) {
            this.getLogger().error("Cannot read image dimensions: " + this.getSrc());
        }
    }

    protected void startOfNode() throws FOPException {
        this.checkId(this.id);
        this.getFOEventHandler().image(this);
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        this.invalidChildError(loc, nsURI, localName);
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public CommonMarginInline getCommonMarginInline() {
        return this.commonMarginInline;
    }

    public LengthRangeProperty getBlockProgressionDimension() {
        return this.blockProgressionDimension;
    }

    public Length getContentHeight() {
        return this.contentHeight;
    }

    public Length getContentWidth() {
        return this.contentWidth;
    }

    public int getDisplayAlign() {
        return this.displayAlign;
    }

    public Length getHeight() {
        return this.height;
    }

    public String getId() {
        return this.id;
    }

    public LengthRangeProperty getInlineProgressionDimension() {
        return this.inlineProgressionDimension;
    }

    public int getOverflow() {
        return this.overflow;
    }

    public int getScaling() {
        return this.scaling;
    }

    public String getSrc() {
        return this.src;
    }

    public String getURL() {
        return this.url;
    }

    public int getTextAlign() {
        return this.textAlign;
    }

    public Length getWidth() {
        return this.width;
    }

    public int getVerticalAlign() {
        return this.verticalAlign;
    }

    public String getName() {
        return "fo:external-graphic";
    }

    public int getNameId() {
        return 9;
    }

    public Number getLayoutDimension(PercentBase.LayoutDimension key) {
        if (key == PercentBase.IMAGE_INTRINSIC_WIDTH) {
            return new Integer(this.getIntrinsicWidth());
        }
        if (key == PercentBase.IMAGE_INTRINSIC_HEIGHT) {
            return new Integer(this.getIntrinsicHeight());
        }
        return super.getLayoutDimension(key);
    }

    public int getIntrinsicWidth() {
        if (this.fopimage != null) {
            return this.fopimage.getIntrinsicWidth();
        }
        return 0;
    }

    public int getIntrinsicHeight() {
        if (this.fopimage != null) {
            return this.fopimage.getIntrinsicHeight();
        }
        return 0;
    }
}

