/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow;

import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.Length;
import org.apache.fop.datatypes.Numeric;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.xml.sax.Locator;

public class TableColumn
extends FObj {
    private CommonBorderPaddingBackground commonBorderPaddingBackground;
    private Numeric columnNumber;
    private Length columnWidth;
    private Numeric numberColumnsRepeated;
    private Numeric numberColumnsSpanned;
    private int visibility;

    public TableColumn(FONode parent) {
        super(parent);
    }

    public void bind(PropertyList pList) throws FOPException {
        this.commonBorderPaddingBackground = pList.getBorderPaddingBackgroundProps();
        this.columnNumber = pList.get(70).getNumeric();
        this.columnWidth = pList.get(71).getLength();
        this.numberColumnsRepeated = pList.get(148).getNumeric();
        this.numberColumnsSpanned = pList.get(149).getNumeric();
        this.visibility = pList.get(235).getEnum();
        if (this.columnNumber.getValue() < 0) {
            throw new PropertyException("column-number must be 1 or bigger, but got " + this.columnNumber.getValue());
        }
        if (this.numberColumnsRepeated.getValue() <= 0) {
            throw new PropertyException("number-columns-repeated must be 1 or bigger, but got " + this.numberColumnsRepeated.getValue());
        }
        if (this.numberColumnsSpanned.getValue() <= 0) {
            throw new PropertyException("number-columns-spanned must be 1 or bigger, but got " + this.numberColumnsSpanned.getValue());
        }
    }

    protected void startOfNode() throws FOPException {
        this.getFOEventHandler().startColumn(this);
    }

    protected void endOfNode() throws FOPException {
        this.getFOEventHandler().endColumn(this);
    }

    protected void validateChildNode(Locator loc, String nsURI, String localName) throws ValidationException {
        this.invalidChildError(loc, nsURI, localName);
    }

    public CommonBorderPaddingBackground getCommonBorderPaddingBackground() {
        return this.commonBorderPaddingBackground;
    }

    public Length getColumnWidth() {
        return this.columnWidth;
    }

    public boolean hasColumnNumber() {
        return this.columnNumber.getValue() >= 1;
    }

    public int getColumnNumber() {
        return this.columnNumber.getValue();
    }

    public int getNumberColumnsRepeated() {
        return this.numberColumnsRepeated.getValue();
    }

    public int getNumberColumnsSpanned() {
        return this.numberColumnsSpanned.getValue();
    }

    public String getName() {
        return "fo:table-column";
    }

    public int getNameId() {
        return 51;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("fo:table-column");
        if (this.hasColumnNumber()) {
            sb.append(" column-number=").append(this.getColumnNumber());
        }
        if (this.getNumberColumnsRepeated() > 1) {
            sb.append(" number-columns-repeated=").append(this.getNumberColumnsRepeated());
        }
        if (this.getNumberColumnsSpanned() > 1) {
            sb.append(" number-columns-spanned=").append(this.getNumberColumnsSpanned());
        }
        sb.append(" column-width=").append(this.getColumnWidth());
        return sb.toString();
    }
}

