/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.connection;

import com.insightful.splus.SplusBadDataException;
import com.insightful.splus.SplusDataResult;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.connection.DefaultConnection;
import com.insightful.splus.eclipse.connection.NoConnection;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class DrillableObjectsModel
implements TableModel,
TreeModel {
    private static int g_maxChildren = 25;
    private static boolean g_hideDotObjects;
    private String dataExpression;
    private Vector dataObjects;
    private int numCols;
    private int numRows;
    private String[] colNames;
    private String[] rowNames;
    private Vector m_listeners = new Vector();
    private DefaultMutableTreeNode m_root = null;

    public static void setMaxChildren(int n) {
        g_maxChildren = n;
    }

    public static int getMaxChildren() {
        return g_maxChildren;
    }

    public static void setHideDotObjects(boolean bl) {
        g_hideDotObjects = bl;
    }

    public static boolean getHideDotObjects() {
        return g_hideDotObjects;
    }

    public DrillableObjectsModel(String string) {
        this.dataExpression = string;
        g_hideDotObjects = true;
        this.refresh();
    }

    public void refresh() {
        MessageBox messageBox;
        NoConnection noConnection;
        SplusDataResult splusDataResult = null;
        boolean bl = false;
        try {
            noConnection = SplusEditorPlugin.getDefault().getConnection();
            if (noConnection instanceof DefaultConnection && !noConnection.isEngineBusy()) {
                splusDataResult = ((DefaultConnection)noConnection).processDataQuery(this.dataExpression);
            }
            if (splusDataResult == null) {
                bl = true;
            } else {
                int n;
                int n2;
                messageBox = splusDataResult.getStringData();
                this.numRows = new Integer(messageBox[0]);
                this.numCols = new Integer(messageBox[1]);
                int n3 = 2;
                this.rowNames = new String[this.numRows];
                for (n2 = 0; n2 < this.numRows; ++n2) {
                    this.rowNames[n2] = messageBox[n3];
                    ++n3;
                }
                this.colNames = new String[this.numCols];
                for (n2 = 0; n2 < this.numCols; ++n2) {
                    this.colNames[n2] = messageBox[n3];
                    ++n3;
                }
                n2 = this.numRows * this.numCols;
                String[] stringArray = new String[n2];
                for (n = 0; n < n2; ++n) {
                    stringArray[n] = messageBox[n3];
                    ++n3;
                }
                this.dataObjects = new Vector(this.numRows);
                for (n = 0; n < this.numRows; ++n) {
                    String string = stringArray[this.numRows * 0 + n];
                    String string2 = stringArray[this.numRows * 1 + n];
                    String string3 = stringArray[this.numRows * 2 + n];
                    String string4 = stringArray[this.numRows * 3 + n];
                    String string5 = stringArray[this.numRows * 4 + n];
                    String string6 = stringArray[this.numRows * 5 + n];
                    if (g_hideDotObjects && string.charAt(0) == '.') continue;
                    this.dataObjects.add(new DrillableNode(string, string2, string3, string4, string5, string6));
                }
                this.numRows = this.dataObjects.size();
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        if (bl) {
            this.dataObjects = new Vector(0);
            this.numCols = 0;
            this.numRows = 0;
            noConnection = Display.getDefault().getActiveShell();
            messageBox = new MessageBox((Shell)noConnection);
            messageBox.setMessage("Query for table values failed.  Creating and empty table.");
            messageBox.setText("Table Creation Error");
            messageBox.open();
        }
        this.nodeStructureChanged();
    }

    public DrillableNode getDrillableNode(String string) {
        for (int i = 0; i < this.dataObjects.size(); ++i) {
            DrillableNode drillableNode = (DrillableNode)this.dataObjects.get(i);
            if (!drillableNode.m_name.equals(string)) continue;
            return drillableNode;
        }
        return null;
    }

    public int getColumnCount() {
        return this.numCols;
    }

    public int getRowCount() {
        return this.numRows;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public Class getColumnClass(int n) {
        return null;
    }

    public Object getValueAt(int n, int n2) {
        return ((DrillableNode)this.dataObjects.get(n)).getValueAt(n2);
    }

    public void setValueAt(Object object, int n, int n2) {
    }

    public String getColumnName(int n) {
        return this.colNames[n];
    }

    public String[] getRowNames() {
        return this.rowNames;
    }

    public void addTableModelListener(TableModelListener tableModelListener) {
        this.m_listeners.add(tableModelListener);
    }

    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.m_listeners.remove(tableModelListener);
    }

    public Object getRoot() {
        if (this.m_root == null) {
            this.m_root = new DefaultMutableTreeNode();
        }
        return this.m_root;
    }

    public int getChildCount(Object object) {
        if (object == this.m_root || object == this) {
            return this.numRows;
        }
        return 0;
    }

    public boolean isLeaf(Object object) {
        if (object instanceof DrillableNode) {
            DrillableNode[] drillableNodeArray = ((DrillableNode)object).getChildren();
            return drillableNodeArray == null || drillableNodeArray.length == 0;
        }
        return false;
    }

    public void addTreeModelListener(TreeModelListener treeModelListener) {
        this.m_listeners.add(treeModelListener);
    }

    public void removeTreeModelListener(TreeModelListener treeModelListener) {
        this.m_listeners.remove(treeModelListener);
    }

    public Object getChild(Object object, int n) {
        Object object2;
        if (object == this) {
            return this.dataObjects.get(n);
        }
        if (object instanceof DefaultMutableTreeNode && (object2 = ((DefaultMutableTreeNode)object).getUserObject()) instanceof DrillableNode) {
            DrillableNode drillableNode = ((DrillableNode)object2).getChildren()[n];
            return drillableNode;
        }
        return null;
    }

    public int getIndexOfChild(Object object, Object object2) {
        Object object3;
        if (object2 instanceof DefaultMutableTreeNode && (object3 = ((DefaultMutableTreeNode)object2).getUserObject()) instanceof DrillableNode) {
            int n = Integer.parseInt(((DrillableNode)object3).m_position);
            return n;
        }
        return -1;
    }

    public void valueForPathChanged(TreePath treePath, Object object) {
    }

    public void nodeStructureChanged() {
        for (int i = 0; i < this.m_listeners.size(); ++i) {
            Object e = this.m_listeners.get(i);
            if (e instanceof TreeModelListener) {
                ((TreeModelListener)e).treeStructureChanged(new TreeModelEvent((Object)this, (TreePath)null));
                continue;
            }
            if (!(e instanceof TableModelListener)) continue;
            ((TableModelListener)e).tableChanged(new TableModelEvent(this));
        }
    }

    public class DrillableNode {
        private String m_name = null;
        private String m_class = null;
        private String m_mode = null;
        private String m_extent = null;
        private String m_size = null;
        private String m_date = null;
        private String m_position = null;
        private DrillableNode m_parent = null;
        private boolean m_noChildren = false;
        private boolean m_ignoreNames = false;
        private DrillableNode[] m_children = null;

        public DrillableNode(String string, String string2, String string3, String string4, String string5, String string6) {
            this.m_name = string;
            this.m_class = string2;
            this.m_mode = string3;
            this.m_extent = string4;
            this.m_size = string5;
            this.m_date = string6;
        }

        public DrillableNode(DrillableNode drillableNode, String string, String string2, String string3, boolean bl, boolean bl2) {
            this.m_position = string3;
            this.m_parent = drillableNode;
            this.m_class = string2;
            this.m_name = string;
            this.m_noChildren = bl;
            this.m_ignoreNames = bl2;
        }

        public String getClassType() {
            return this.m_class;
        }

        public String getMode() {
            return this.m_mode;
        }

        public String getExtent() {
            return this.m_extent;
        }

        public String getSize() {
            return this.m_size;
        }

        public String getDate() {
            return this.m_date;
        }

        public boolean isVector() {
            return this.m_noChildren;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(this.m_name);
            return stringBuffer.toString();
        }

        private boolean contains(String string, String string2) {
            return string != null && string2 != null && string2.indexOf(string) != -1;
        }

        public boolean isType(String string) {
            return this.contains(string, this.m_mode) || this.contains(string, this.m_class);
        }

        public boolean hasColumns() {
            return this.isType("data.frame") || this.isType("matrix");
        }

        public String getValueString() {
            if (this.m_parent == null) {
                return "get(\"" + this.m_name + "\")";
            }
            boolean bl = this.contains("matrix", this.m_parent.m_class);
            boolean bl2 = this.m_parent.hasColumns() || bl;
            boolean bl3 = this.m_parent.isType("vector");
            boolean bl4 = bl3 || bl2;
            StringBuffer stringBuffer = new StringBuffer(this.m_parent.getValueString());
            stringBuffer.append(bl4 ? "[" : "[[");
            if (bl2) {
                stringBuffer.append(",");
            }
            stringBuffer.append(this.m_position);
            stringBuffer.append(bl4 ? "]" : "]]");
            return stringBuffer.toString();
        }

        public DrillableNode getParent() {
            return this.m_parent;
        }

        public DrillableNode[] getChildren() {
            if (this.m_children == null && !this.m_noChildren) {
                String string = this.getValueString();
                SplusDataResult splusDataResult = null;
                try {
                    String string2 = this.m_ignoreNames ? "T" : "F";
                    String string3 = "eclipse.internal.objects(" + string + ", " + "ignoreNames=" + string2 + ", max=" + DrillableObjectsModel.getMaxChildren() + ")";
                    splusDataResult = SplusSystem.getEngineQueryHandler().processDataQuery(string3);
                    if (splusDataResult.getData() == null) {
                        string3 = "";
                    }
                    String[] stringArray = splusDataResult.getStringData();
                    int n = Integer.parseInt(stringArray[0]);
                    int n2 = 5;
                    int n3 = n2 + n;
                    boolean bl = stringArray[1].equals("TRUE");
                    boolean bl2 = stringArray[2].equals("TRUE");
                    boolean bl3 = stringArray[3].equals("TRUE");
                    boolean bl4 = stringArray[4].equals("TRUE");
                    Vector<DrillableNode> vector = new Vector<DrillableNode>();
                    int n4 = 0;
                    for (int i = 0; i < n; ++i) {
                        String string4 = bl && i == n - 1 ? "BODY" : stringArray[n3 + i];
                        String string5 = stringArray[n2 + i];
                        vector.add(new DrillableNode(this, string4, string5, Integer.toString(++n4), bl2 || this.m_ignoreNames, bl3 && !bl4));
                    }
                    this.m_children = new DrillableNode[vector.size()];
                    vector.toArray(this.m_children);
                }
                catch (SplusBadDataException splusBadDataException) {
                    splusBadDataException.printStackTrace();
                }
                splusDataResult = null;
            }
            return this.m_children;
        }

        public String getValueAt(int n) {
            switch (n) {
                case 1: {
                    return this.m_class;
                }
                case 2: {
                    return this.m_mode;
                }
                case 3: {
                    return this.m_extent;
                }
                case 4: {
                    return this.m_size;
                }
                case 5: {
                    return this.m_date;
                }
            }
            return this.m_name;
        }
    }
}

