/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor.actions;

import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.connection.DefaultConnection;
import com.insightful.splus.eclipse.connection.NoConnection;
import com.insightful.splus.eclipse.editors.spluseditor.SplusEditor;
import com.insightful.splus.eclipse.preferences.SplusPreferencePage;
import com.insightful.splus.eclipse.views.util.ConsoleHistoryDocument;
import java.util.Vector;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.EditorPluginAction;
import org.eclipse.ui.texteditor.ITextEditor;

public class SplusRunAction
implements IWorkbenchWindowActionDelegate,
IEditorActionDelegate {
    private static Vector g_actions = new Vector();
    private IAction m_action = null;
    private IWorkbenchWindow m_window;
    private IEditorPart m_editorPart;
    private static DefaultConnection m_dConn = null;

    public SplusRunAction() {
        g_actions.add(this);
    }

    public static void notifyActions(boolean bl) {
        for (int i = 0; i < g_actions.size(); ++i) {
            SplusRunAction splusRunAction = (SplusRunAction)g_actions.get(i);
            splusRunAction.doActionEnablement(null, bl);
        }
    }

    public static void notifyActions(Class clazz, boolean bl) {
        for (int i = 0; i < g_actions.size(); ++i) {
            SplusRunAction splusRunAction = (SplusRunAction)g_actions.get(i);
            if (!splusRunAction.getClass().equals(clazz)) continue;
            splusRunAction.doActionEnablement(null, bl);
        }
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow iWorkbenchWindow) {
        this.m_window = iWorkbenchWindow;
    }

    protected SplusEditor getActiveSplusEditor() throws NullPointerException {
        IEditorPart iEditorPart = null;
        iEditorPart = this.m_window != null && this.m_window.getActivePage() != null ? this.m_window.getActivePage().getActiveEditor() : this.m_editorPart;
        if (iEditorPart instanceof SplusEditor) {
            return (SplusEditor)iEditorPart;
        }
        return null;
    }

    protected static DefaultConnection getDefaultConnection() {
        if (m_dConn != null) {
            return m_dConn;
        }
        NoConnection noConnection = SplusEditorPlugin.getDefault().getConnection();
        if (noConnection instanceof DefaultConnection) {
            m_dConn = (DefaultConnection)noConnection;
        }
        return m_dConn;
    }

    public void run(IAction iAction) {
        boolean bl;
        SplusEditor splusEditor = this.getActiveSplusEditor();
        if (splusEditor == null) {
            return;
        }
        DefaultConnection defaultConnection = SplusRunAction.getDefaultConnection();
        boolean bl2 = bl = !defaultConnection.wantsInput();
        if (bl && defaultConnection.isEngineBusy()) {
            MessageDialog.openInformation(null, (String)"Engine Busy", (String)"Cannot execute command because the engine is currently busy.");
            return;
        }
        if (this.doActualRun(splusEditor, bl)) {
            this.activateView();
        }
    }

    protected boolean doActualRun(SplusEditor splusEditor, boolean bl) {
        boolean bl2 = SplusPreferencePage.getSendRunOutputToConsole();
        if (bl2) {
            String string = splusEditor.getSelectedText(true);
            ConsoleHistoryDocument.copyToConsole(string);
            return true;
        }
        return splusEditor.doRun(bl);
    }

    private void activateView() {
        IWorkbenchWindow iWorkbenchWindow = SplusEditorPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        boolean bl = SplusPreferencePage.getSendRunOutputToConsole();
        if (iWorkbenchWindow != null) {
            try {
                if (bl) {
                    iWorkbenchWindow.getActivePage().showView("org.eclipse.ui.console.ConsoleView");
                } else {
                    iWorkbenchWindow.getActivePage().showView("com.insightful.splus.eclipse.views.OutputView");
                }
            }
            catch (PartInitException partInitException) {
                partInitException.printStackTrace();
            }
        }
    }

    protected IAction getAction(IAction iAction) {
        if (this.m_action == null || iAction != null && this.m_action != iAction) {
            this.m_action = iAction;
        }
        return this.m_action;
    }

    public void selectionChanged(IAction iAction, ISelection iSelection) {
        IAction iAction2 = this.getAction(iAction);
        if (iAction2 != null) {
            this.doActionEnablement(iAction, this.isEngineBusy());
        }
    }

    protected boolean isEngineBusy() {
        DefaultConnection defaultConnection = SplusRunAction.getDefaultConnection();
        if (defaultConnection == null) {
            return false;
        }
        boolean bl = !defaultConnection.wantsInput();
        boolean bl2 = bl && defaultConnection.isEngineBusy();
        return bl2;
    }

    protected void doActionEnablement(IAction iAction, boolean bl) {
        IAction iAction2 = this.getAction(iAction);
        if (iAction2 != null) {
            iAction2.setEnabled(!bl && this.getActiveSplusEditor() != null);
        }
    }

    public void setActiveEditor(IAction iAction, IEditorPart iEditorPart) {
        this.getAction(iAction);
        this.m_editorPart = iEditorPart;
        if (iAction instanceof EditorPluginAction && iEditorPart instanceof ITextEditor) {
            iAction.setEnabled(iEditorPart != null);
        }
    }
}

