/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.editors.spluseditor.context;

import com.insightful.splus.eclipse.editors.spluseditor.SplusEditor;
import com.insightful.splus.eclipse.editors.spluseditor.context.SplusReferencesResult;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.SearchPreferencePage;
import org.eclipse.search.internal.ui.text.FileLabelProvider;
import org.eclipse.search.internal.ui.text.FileSearchPage;
import org.eclipse.search.internal.ui.text.IFileSearchContentProvider;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class SplusReferencesResultPage
extends AbstractTextSearchViewPage {
    private SplusReferencesTableContentProvider m_contentTableProvider;
    private SplusReferencesTreeContentProvider m_contentTreeProvider;

    public void clear() {
        this.m_contentTableProvider.clear();
        this.m_contentTreeProvider.clear();
    }

    protected void configureTableViewer(TableViewer tableViewer) {
        tableViewer.setUseHashlookup(true);
        FileLabelProvider fileLabelProvider = new FileLabelProvider((AbstractTextSearchViewPage)this, 0);
        tableViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)fileLabelProvider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        tableViewer.setContentProvider((IContentProvider)new SplusReferencesTableContentProvider(this));
        this.setComparatorSorter((StructuredViewer)tableViewer, fileLabelProvider);
        this.m_contentTableProvider = (SplusReferencesTableContentProvider)tableViewer.getContentProvider();
    }

    protected void configureTreeViewer(TreeViewer treeViewer) {
        treeViewer.setUseHashlookup(true);
        FileLabelProvider fileLabelProvider = new FileLabelProvider((AbstractTextSearchViewPage)this, 1);
        treeViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)fileLabelProvider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        treeViewer.setContentProvider((IContentProvider)new SplusReferencesTreeContentProvider((AbstractTreeViewer)treeViewer));
        this.setComparatorSorter((StructuredViewer)treeViewer, fileLabelProvider);
        this.m_contentTreeProvider = (SplusReferencesTreeContentProvider)treeViewer.getContentProvider();
    }

    private void setComparatorSorter(StructuredViewer structuredViewer, FileLabelProvider fileLabelProvider) {
        FileSearchPage.DecoratorIgnoringViewerSorter decoratorIgnoringViewerSorter = new FileSearchPage.DecoratorIgnoringViewerSorter((ILabelProvider)fileLabelProvider);
        try {
            Class<?> clazz = Class.forName("org.eclipse.jface.viewers.ViewerComparator");
            Method method = structuredViewer.getClass().getMethod("setComparator", clazz);
            method.invoke((Object)structuredViewer, decoratorIgnoringViewerSorter);
            return;
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
        try {
            Class<?> clazz = Class.forName("org.eclipse.jface.viewers.ViewerSorter");
            Method method = structuredViewer.getClass().getMethod("setSorter", clazz);
            method.invoke((Object)structuredViewer, decoratorIgnoringViewerSorter);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InvocationTargetException invocationTargetException) {
            invocationTargetException.printStackTrace();
        }
    }

    public void elementsChanged(Object[] objectArray) {
        if (this.m_contentTableProvider != null) {
            this.m_contentTableProvider.elementsChanged(objectArray);
        }
        if (this.m_contentTreeProvider != null) {
            this.m_contentTreeProvider.elementsChanged(objectArray);
        }
    }

    protected void showMatch(Match match, int n, int n2, boolean bl) throws PartInitException {
        IFile iFile;
        IWorkbenchPage iWorkbenchPage = SearchPlugin.getActivePage();
        IEditorPart iEditorPart = IDE.openEditor((IWorkbenchPage)iWorkbenchPage, (IFile)(iFile = (IFile)match.getElement()), (boolean)bl);
        if (iEditorPart instanceof SplusEditor) {
            SplusEditor splusEditor = (SplusEditor)iEditorPart;
            IDocument iDocument = splusEditor.getDocumentProvider().getDocument((Object)splusEditor.getEditorInput());
            SplusReferencesResult splusReferencesResult = (SplusReferencesResult)this.getInput();
            splusEditor.selectAndReveal(splusReferencesResult.getMatchStartPos(iDocument, match), splusReferencesResult.getMatchLength(iDocument, match));
        }
    }

    private class SplusReferencesTreeContentProvider
    implements ITreeContentProvider,
    IFileSearchContentProvider {
        private final Object[] EMPTY_ARR = new Object[0];
        private SplusReferencesResult fResult;
        private AbstractTreeViewer fTreeViewer;
        private Map fChildrenMap;

        public SplusReferencesTreeContentProvider(AbstractTreeViewer abstractTreeViewer) {
            this.fTreeViewer = abstractTreeViewer;
        }

        public Object[] getElements(Object object) {
            return this.getChildren(object);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            if (object2 instanceof SplusReferencesResult) {
                this.initialize((SplusReferencesResult)((Object)object2));
            }
        }

        protected synchronized void initialize(SplusReferencesResult splusReferencesResult) {
            this.fResult = splusReferencesResult;
            this.fChildrenMap = new HashMap();
            if (splusReferencesResult != null) {
                Object[] objectArray = splusReferencesResult.getElements();
                for (int i = 0; i < objectArray.length; ++i) {
                    this.insert(objectArray[i], false);
                }
            }
        }

        protected void insert(Object object, boolean bl) {
            Object object2 = this.getParent(object);
            while (object2 != null) {
                if (this.insertChild(object2, object)) {
                    if (bl) {
                        this.fTreeViewer.add(object2, object);
                    }
                } else {
                    if (bl) {
                        this.fTreeViewer.refresh(object2);
                    }
                    return;
                }
                object = object2;
                object2 = this.getParent(object);
            }
            if (this.insertChild((Object)this.fResult, object) && bl) {
                this.fTreeViewer.add((Object)this.fResult, object);
            }
        }

        private boolean insertChild(Object object, Object object2) {
            HashSet<Object> hashSet = (HashSet<Object>)this.fChildrenMap.get(object);
            if (hashSet == null) {
                hashSet = new HashSet<Object>();
                this.fChildrenMap.put(object, hashSet);
            }
            return hashSet.add(object2);
        }

        protected void remove(Object object, boolean bl) {
            if (this.hasChildren(object)) {
                if (bl) {
                    this.fTreeViewer.refresh(object);
                }
            } else if (this.fResult.getMatchCount(object) == 0) {
                this.fChildrenMap.remove(object);
                Object object2 = this.getParent(object);
                if (object2 != null) {
                    this.removeFromSiblings(object, object2);
                    this.remove(object2, bl);
                } else {
                    this.removeFromSiblings(object, (Object)this.fResult);
                    if (bl) {
                        this.fTreeViewer.refresh();
                    }
                }
            } else if (bl) {
                this.fTreeViewer.refresh(object);
            }
        }

        private void removeFromSiblings(Object object, Object object2) {
            Set set = (Set)this.fChildrenMap.get(object2);
            if (set != null) {
                set.remove(object);
            }
        }

        public Object[] getChildren(Object object) {
            Set set = (Set)this.fChildrenMap.get(object);
            if (set == null) {
                return this.EMPTY_ARR;
            }
            return set.toArray();
        }

        public boolean hasChildren(Object object) {
            return this.getChildren(object).length > 0;
        }

        public synchronized void elementsChanged(Object[] objectArray) {
            for (int i = 0; i < objectArray.length; ++i) {
                if (this.fResult.getMatchCount(objectArray[i]) > 0) {
                    this.insert(objectArray[i], true);
                    continue;
                }
                this.remove(objectArray[i], true);
            }
        }

        public void clear() {
            this.initialize(this.fResult);
            this.fTreeViewer.refresh();
        }

        public Object getParent(Object object) {
            if (object instanceof IProject) {
                return null;
            }
            if (object instanceof IResource) {
                IResource iResource = (IResource)object;
                return iResource.getParent();
            }
            return null;
        }
    }

    private class SplusReferencesTableContentProvider
    implements IStructuredContentProvider,
    IFileSearchContentProvider {
        private final Object[] EMPTY_ARR = new Object[0];
        private SplusReferencesResultPage fPage;
        private SplusReferencesResult fResult;

        public SplusReferencesTableContentProvider(SplusReferencesResultPage splusReferencesResultPage2) {
            this.fPage = splusReferencesResultPage2;
        }

        public void dispose() {
        }

        public Object[] getElements(Object object) {
            if (object instanceof SplusReferencesResult) {
                Object[] objectArray = ((SplusReferencesResult)((Object)object)).getElements();
                int n = SearchPreferencePage.getHistoryLimit();
                if (n > 0 && objectArray.length > n) {
                    Object[] objectArray2 = new Object[n];
                    System.arraycopy(objectArray, 0, objectArray2, 0, n);
                    return objectArray2;
                }
                return objectArray;
            }
            return this.EMPTY_ARR;
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
            if (object2 instanceof SplusReferencesResult) {
                this.fResult = (SplusReferencesResult)((Object)object2);
            }
        }

        public void elementsChanged(Object[] objectArray) {
            TableViewer tableViewer = this.getViewer();
            boolean bl = SearchPreferencePage.getHistoryLimit() > 0;
            for (int i = 0; i < objectArray.length; ++i) {
                if (this.fResult.getMatchCount(objectArray[i]) > 0) {
                    if (tableViewer.testFindItem(objectArray[i]) != null) {
                        tableViewer.update(objectArray[i], null);
                        continue;
                    }
                    if (bl && tableViewer.getTable().getItemCount() >= SearchPreferencePage.getHistoryLimit()) continue;
                    tableViewer.add(objectArray[i]);
                    continue;
                }
                tableViewer.remove(objectArray[i]);
            }
        }

        private TableViewer getViewer() {
            return (TableViewer)this.fPage.getViewer();
        }

        public void clear() {
            this.getViewer().refresh();
        }
    }
}

