/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.splus.eclipse.views.util;

import com.insightful.splus.SplusEngineBusyException;
import com.insightful.splus.eclipse.SplusEditorPlugin;
import com.insightful.splus.eclipse.connection.DefaultConnection;
import com.insightful.splus.eclipse.connection.NoConnection;
import com.insightful.splus.eclipse.parser.SplusParseTreeBuilder;
import com.insightful.splus.eclipse.preferences.SplusConsolePreferencePage;
import com.insightful.splus.eclipse.preferences.SplusPreferencePage;
import com.insightful.splus.eclipse.views.util.ConsolePluginImages;
import com.insightful.splus.eclipse.views.util.IHistoryListener;
import com.insightful.splus.eclipse.views.util.PromptAnnotation;
import com.insightful.splus.eclipse.views.util.SplusCommandHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.GapTextStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.ITextStore;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class ConsoleHistoryDocument
extends AbstractDocument
implements IDocumentListener,
IAnnotationModel {
    public static final int DEFAULT_MAXIMUM_LINES = 150000;
    public static final boolean DEFAULT_HISTORY_PERSISTANCE = false;
    public static final int MAXIMUM_LINES = SplusConsolePreferencePage.getLineRetention();
    public static final int RETAINED_LINES = (int)(0.8 * (double)MAXIMUM_LINES);
    public static final int INITIAL_TYPE = 0;
    public static final int CONTINUE_TYPE = 1;
    public static final int CONTINUE_STRING_TYPE = 2;
    public static final int OUTPUT_TYPE = 3;
    public static final String[] PREFIX = new String[]{"> ", "+ ", "Continue String: ", ""};
    public static ImageDescriptor[] MARKER_IMG_DESC = null;
    private int[] m_lineTypes;
    private int m_inputBlockCount;
    private int[] m_inputBlocks;
    private int m_inputStartLine;
    private int m_currentInputBlock;
    private int m_lastLineCount;
    private ArrayList m_historyListeners;
    private SplusCommandHandler m_splusCommandHandler;
    private List m_displayedHistoryLines;
    private List m_historyLines;
    public boolean m_promptIgnore = false;
    public static String g_lineDelimiter = System.getProperty("line.separator");
    public static int g_numLDChars = g_lineDelimiter.length();
    private boolean m_ctrlDown = false;
    private boolean m_sendToOutput = false;
    protected ConsoleAnnotationModel m_consolePromptModel = null;
    protected HashMap m_annotKeyMap = null;
    protected HashMap m_posKeyMap = null;

    protected void setPromptIcons() {
        MARKER_IMG_DESC = new ImageDescriptor[]{ConsolePluginImages.createManaged("init_mrk.gif"), ConsolePluginImages.createManaged("cont_mrk.gif"), ConsolePluginImages.createManaged("cstr_mrk.gif"), null};
    }

    public void pollForOutput() {
        if (this.getConnection() instanceof DefaultConnection) {
            this.pollForOutput((DefaultConnection)this.getConnection());
        }
    }

    public void pollForOutput(DefaultConnection defaultConnection) {
        this.m_splusCommandHandler.pollForOutput(defaultConnection);
    }

    public void executeSplusCommand(String string, DefaultConnection defaultConnection) {
        this.m_splusCommandHandler.pollForOutput(string, defaultConnection);
    }

    public void storeSplusOutput(String string) {
        this.m_splusCommandHandler.addStoredSplusOutput(string);
    }

    public void clearHistory() {
        this.m_historyLines = new Vector();
        this.m_displayedHistoryLines = new Vector();
    }

    public void initilizeHistory() {
        this.m_historyLines = new Vector();
        this.m_displayedHistoryLines = new Vector();
        if (!SplusConsolePreferencePage.getHistoryPersistance()) {
            return;
        }
        IPath iPath = SplusEditorPlugin.getDefault().getSplusStateLocation().append(".history");
        IPath iPath2 = iPath.append("historyLines");
        IPath iPath3 = iPath.append("displayedHistoryLines");
        try {
            int n;
            Properties properties = new Properties();
            if (iPath2.toFile().exists()) {
                properties.load(new FileInputStream(iPath2.toFile()));
                for (n = 0; n < properties.size(); ++n) {
                    this.m_historyLines.add(properties.getProperty(Integer.toString(n)));
                }
            }
            properties = new Properties();
            if (iPath3.toFile().exists()) {
                properties.load(new FileInputStream(iPath3.toFile()));
                for (n = 0; n < properties.size(); ++n) {
                    this.m_displayedHistoryLines.add(properties.getProperty(Integer.toString(n)));
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public void saveHistory() {
        if (!SplusConsolePreferencePage.getHistoryPersistance()) {
            return;
        }
        IPath iPath = SplusEditorPlugin.getDefault().getSplusStateLocation().append(".history");
        IPath iPath2 = iPath.append("historyLines");
        IPath iPath3 = iPath.append("displayedHistoryLines");
        try {
            int n;
            File file = iPath2.toFile();
            File file2 = iPath3.toFile();
            iPath.toFile().mkdirs();
            Properties properties = new Properties();
            for (n = 0; n < this.m_historyLines.size(); ++n) {
                properties.setProperty(Integer.toString(n), (String)this.m_historyLines.get(n));
            }
            properties.store(new FileOutputStream(file), null);
            properties = new Properties();
            for (n = 0; n < this.m_displayedHistoryLines.size(); ++n) {
                properties.setProperty(Integer.toString(n), (String)this.m_displayedHistoryLines.get(n));
            }
            properties.store(new FileOutputStream(file2), null);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public List getHistoryLines() {
        return this.m_historyLines;
    }

    public String getHistoryLine(int n) {
        return (String)this.m_historyLines.get(n);
    }

    public List getDisplayedHistoryLines() {
        return this.m_displayedHistoryLines;
    }

    public String getDisplayedHistoryLine(int n) {
        return (String)this.m_displayedHistoryLines.get(n);
    }

    public void addHistory(int n, int n2) {
        String string = this.getBlockCommands(n, n2, true);
        String string2 = this.getBlockCommands(n, n2);
        if (string2.trim().length() == 0) {
            return;
        }
        while (string2.endsWith("\r") || string2.endsWith("\n")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        int n3 = this.m_historyLines.size();
        if (n3 >= MAXIMUM_LINES) {
            int n4 = MAXIMUM_LINES - RETAINED_LINES;
            this.m_displayedHistoryLines = this.m_displayedHistoryLines.subList(n4, n3);
            this.m_historyLines = this.m_historyLines.subList(n4, n3);
            this.notifyDeleteChange();
        }
        this.m_displayedHistoryLines.add(string.replaceAll("\t", ""));
        this.m_historyLines.add(string2);
    }

    public void setCtrlDown(boolean bl) {
        this.m_ctrlDown = bl;
    }

    public boolean getCtrlDown() {
        return this.m_ctrlDown;
    }

    public ConsoleHistoryDocument() {
        this.initilizeHistory();
        this.m_splusCommandHandler = new SplusCommandHandler(this);
        this.setPromptIcons();
        this.setSelectedInputBlock(-1);
        this.m_lineTypes = new int[MAXIMUM_LINES + 1];
        this.m_inputBlocks = new int[MAXIMUM_LINES + 1];
        this.m_historyListeners = new ArrayList();
        this.setTextStore((ITextStore)new GapTextStore(50, 300));
        this.setLineTracker((ILineTracker)new DefaultLineTracker());
        this.completeInitialization();
        this.m_inputStartLine = 0;
        this.m_lineTypes[0] = 0;
        this.m_lastLineCount = 0;
        this.addDocumentListener(this);
        this.initConsolePromptModel();
        this.addPrompt(0);
    }

    private NoConnection getConnection() {
        return SplusEditorPlugin.getDefault().getConnection();
    }

    public int lineType(int n) {
        if (n < 0 || n > this.getNumberOfLines()) {
            throw new IllegalArgumentException("Line number " + n + " out of range 0-" + this.getNumberOfLines());
        }
        return this.m_lineTypes[n];
    }

    public int inputBlockCount() {
        return this.m_inputBlockCount;
    }

    public int currentInputBase() {
        return this.m_inputStartLine;
    }

    public synchronized String getLine(int n) {
        try {
            return this.get(this.getLineOffset(n), this.getLineLength(n));
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return "";
        }
    }

    public synchronized void clear() {
        int n = this.getSelectedInputBlock();
        this.setSelectedInputBlock(-1);
        this.m_inputBlockCount = 0;
        this.m_lastLineCount = 1;
        this.m_inputStartLine = 0;
        this.set("");
        this.notifyDeleteChange();
        if (n >= 0) {
            this.notifyHistoryChange();
        }
    }

    private synchronized void clipLines() throws BadLocationException {
        this.clipLines(0);
    }

    private synchronized void clipLines(int n) throws BadLocationException {
        int n2 = n + MAXIMUM_LINES - RETAINED_LINES;
        int n3 = -1;
        boolean bl = false;
        if (this.getSelectedInputBlock() >= 0) {
            n3 = this.m_inputBlocks[this.getSelectedInputBlock()];
            bl = true;
            this.setSelectedInputBlock(-1);
        }
        int n4 = MAXIMUM_LINES - n2;
        int n5 = this.getLineOffset(n2);
        n3 -= n5;
        this.m_inputBlockCount = 0;
        for (int i = 0; i < n4; ++i) {
            this.m_lineTypes[i] = this.m_lineTypes[i + n2];
            int n6 = this.m_lineTypes[i];
            if (n6 == 3 || this.m_lineTypes[i] != 0) continue;
            if (n3 == i) {
                this.setSelectedInputBlock(this.inputBlockCount());
            }
            this.m_inputBlocks[this.m_inputBlockCount++] = i;
        }
        if (this.m_inputStartLine > 0) {
            this.m_inputStartLine -= n2;
        }
        this.m_lastLineCount -= n2;
        this.replace(0, n5, "");
        this.notifyDeleteChange();
        if (bl) {
            this.notifyHistoryChange();
        }
    }

    public int getSelectedInputBlock() {
        return this.m_currentInputBlock;
    }

    public synchronized void setSelectedInputBlock(int n) {
        this.m_currentInputBlock = n;
    }

    public static void sendAndExecuteCommand(String string) {
        String string2 = string.endsWith(g_lineDelimiter) ? string : string + g_lineDelimiter;
        ConsoleHistoryDocument consoleHistoryDocument = SplusEditorPlugin.getDefault().getConsoleDocument();
        consoleHistoryDocument.clearInput();
        consoleHistoryDocument.appendInputLine(string2);
    }

    public boolean sendToOutput() {
        if (SplusPreferencePage.getSendRunOutputToConsole()) {
            return false;
        }
        return this.m_sendToOutput;
    }

    public void setSendToOutput(boolean bl) {
        this.m_sendToOutput = bl;
    }

    public static void runText(String string, boolean bl) {
        ConsoleHistoryDocument consoleHistoryDocument = SplusEditorPlugin.getDefault().getConsoleDocument();
        AbstractDocument abstractDocument = SplusEditorPlugin.getDefault().getOutputDocument();
        String string2 = System.getProperty("cummulative.output.view");
        if (string2 == null || !string2.equals("T")) {
            abstractDocument.set("");
        }
        NoConnection noConnection = consoleHistoryDocument.getConnection();
        if (SplusEditorPlugin.getDefault().getConsole() == null && noConnection instanceof DefaultConnection) {
            ((DefaultConnection)noConnection).getOutputHandler();
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            consoleHistoryDocument.getAndDisplayOutput();
        }
        consoleHistoryDocument.setSendToOutput(true);
        String string3 = string;
        if (bl) {
            string3 = "eval(parse(text = \"script.run(exprs.literal={\n" + noConnection.escapeSpecialCharacters(string) + "\n" + "})\n\"))";
        }
        noConnection.sendCmd(string3);
    }

    public void getAndDisplayOutput() {
        this.m_splusCommandHandler.getAndDisplayOutput();
    }

    public synchronized void addOutputLines(String[] stringArray) {
        int n = stringArray.length;
        int n2 = 0;
        if (n > MAXIMUM_LINES) {
            n2 = n - RETAINED_LINES;
        } else if (this.getNumberOfLines() + 1 >= MAXIMUM_LINES - n) {
            n2 = MAXIMUM_LINES - (this.getNumberOfLines() + n + 1);
        }
        try {
            int n3;
            StringBuffer stringBuffer = new StringBuffer();
            int n4 = 0;
            if (n2 > 0) {
                this.clear();
            } else if (n2 < 0) {
                stringBuffer = new StringBuffer();
                n4 = 0;
                n3 = 0;
                while (n3 < n + n2) {
                    stringBuffer.append(stringArray[n3]);
                    ++n3;
                    ++n4;
                }
                this.addOutputLines(stringBuffer.toString(), n4);
                n3 = Math.max(0, Math.abs(n2) - (MAXIMUM_LINES - RETAINED_LINES));
                this.clipLines(n3);
                n2 = n + n2;
            }
            stringBuffer = new StringBuffer();
            n4 = 0;
            n3 = n2;
            while (n3 < n) {
                stringBuffer.append(stringArray[n3]);
                ++n3;
                ++n4;
            }
            this.addOutputLines(stringBuffer.toString(), n4);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public synchronized void addOutputLine(String string) {
        try {
            if (this.getNumberOfLines() >= MAXIMUM_LINES - 1) {
                this.clipLines();
            }
            this.addOutputLines(string, 1);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    private synchronized void addOutputLines(String string, int n) {
        boolean bl = this.m_promptIgnore;
        this.m_promptIgnore = true;
        try {
            int n2 = this.m_inputStartLine;
            this.m_inputStartLine += n;
            int n3 = this.getLineOffset(n2);
            this.m_lastLineCount += n;
            int n4 = this.getNumberOfLines() - n2 + 1;
            System.arraycopy(this.m_lineTypes, n2, this.m_lineTypes, n2 + n, n4);
            for (int i = n2; i < n2 + n; ++i) {
                this.m_lineTypes[i] = 3;
            }
            this.replace(n3, 0, string);
            this.notifyAddedChange(n2);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.m_promptIgnore = bl;
    }

    public static void copyToConsole(final String string) {
        final SplusEditorPlugin splusEditorPlugin = SplusEditorPlugin.getDefault();
        final ConsoleHistoryDocument consoleHistoryDocument = splusEditorPlugin.getConsoleDocument();
        final DefaultConnection defaultConnection = (DefaultConnection)consoleHistoryDocument.getConnection();
        final Point point = splusEditorPlugin.getConsole().getTextViewer() != null ? splusEditorPlugin.getConsole().getTextViewer().getSelectedRange() : null;
        final Display display = Display.getDefault();
        new Thread("ConsoleHistoryDocument-copyToConsole"){

            public void run() {
                int n;
                String string6 = string;
                if (point != null) {
                    try {
                        int n2 = point.x;
                        n = point.y;
                        int n3 = consoleHistoryDocument.getLineOfOffset(n2);
                        int n4 = consoleHistoryDocument.getLineOffset(n3);
                        int n5 = consoleHistoryDocument.currentInputBase();
                        int n6 = consoleHistoryDocument.getLineOffset(n5);
                        if (n4 < n6) {
                            n4 = n6;
                            n3 = n5;
                        }
                        if (n2 < n6) {
                            if (n2 + n < n6) {
                                n = 0;
                            }
                            n2 = n6;
                        }
                        String string2 = consoleHistoryDocument.get(n6, n4 - n6 + (n2 - n4));
                        String string3 = consoleHistoryDocument.get(n2 + n, consoleHistoryDocument.getLength() - (n2 + n));
                        string6 = string2 + string + string3;
                    }
                    catch (BadLocationException badLocationException) {
                        badLocationException.printStackTrace();
                    }
                }
                if (!string6.equals(string)) {
                    display.syncExec((Runnable)new Thread("ConsoleHistoryDocument-evalExpression"){

                        public void run() {
                            consoleHistoryDocument.clearInput();
                        }
                    });
                }
                if (!SplusParseTreeBuilder.getInstance().isComplete(string6)) {
                    final String string4 = string6;
                    display.syncExec((Runnable)new Thread("ConsoleHistoryDocument-pasteIncompleteExpression"){

                        public void run() {
                            consoleHistoryDocument.appendInputLine(string4);
                        }
                    });
                    return;
                }
                String[] stringArray = SplusParseTreeBuilder.separateTopLevelExpressions(string6);
                for (n = 0; n < stringArray.length; ++n) {
                    final String string5 = n < stringArray.length - 1 || string.endsWith(g_lineDelimiter) ? stringArray[n] + g_lineDelimiter : stringArray[n];
                    display.syncExec((Runnable)new Thread("ConsoleHistoryDocument-evalExpression"){

                        public void run() {
                            int n = 0;
                            int n2 = g_lineDelimiter.length();
                            int n3 = string5.length();
                            int n4 = string5.indexOf(g_lineDelimiter);
                            consoleHistoryDocument.addPrompt(0);
                            if (n4 == -1) {
                                consoleHistoryDocument.appendInputLine(string5);
                            } else {
                                n4 += n2;
                                while (n < n3) {
                                    String string = string5.substring(n, n4);
                                    consoleHistoryDocument.appendInputLine(string);
                                    n = n4;
                                    n4 = string5.indexOf(g_lineDelimiter, n);
                                    if (n4 == -1 && n < n3) {
                                        consoleHistoryDocument.appendInputLine(string5.substring(n));
                                        n = n3;
                                    }
                                    n4 += n2;
                                }
                            }
                        }
                    });
                    do {
                        try {
                            Thread.sleep(30L);
                        }
                        catch (InterruptedException interruptedException) {
                            interruptedException.printStackTrace();
                        }
                    } while (defaultConnection.isEngineBusy());
                    display.syncExec((Runnable)new Thread("ConsoleHistoryDocument-evalExpression"){

                        public void run() {
                            consoleHistoryDocument.getAndDisplayOutput();
                        }
                    });
                    splusEditorPlugin.getConsole().showEnd();
                }
            }
        }.start();
    }

    public synchronized void appendInputLine(String string) {
        try {
            if (this.getNumberOfLines() >= MAXIMUM_LINES - 1) {
                this.clipLines();
            }
            int n = this.getNumberOfLines() - 1;
            int n2 = this.getLineOffset(n);
            int n3 = 1;
            String string2 = string.replaceAll("\r", "");
            int n4 = string2.indexOf("\n", 0);
            while (n4 != -1) {
                this.m_lineTypes[n + n3++] = 1;
                n4 = string2.indexOf("\n", n4 + 1);
            }
            this.replace(n2, 0, string);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public void addPrompt(int n) {
        int n2 = this.getNumberOfLines() - 1;
        this.updateLineType(n2, n);
    }

    private void updateLineType(int n, int n2) {
        try {
            this.m_lineTypes[n] = n2;
            if (n2 != 3) {
                int n3 = this.getLineOffset(n);
                Position position = new Position(n3);
                this.addAnnotation(this.getAnnotationForType(n2, n3), position);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            indexOutOfBoundsException.printStackTrace();
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public synchronized void clearInput() {
        boolean bl = this.m_promptIgnore;
        this.m_promptIgnore = true;
        try {
            int n = this.getLineOffset(this.m_inputStartLine);
            super.replace(n, this.getLength() - n, "");
            this.m_lastLineCount = this.m_inputStartLine;
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        this.m_promptIgnore = bl;
    }

    private synchronized void postCommandUpdate() {
        if (this.getSelectedInputBlock() >= 0) {
            this.setSelectedInputBlock(-1);
            this.notifyHistoryChange();
        }
        int n = this.m_inputStartLine;
        int n2 = this.getNumberOfLines() - 1;
        int n3 = n2 - n;
        this.m_inputBlocks[this.m_inputBlockCount++] = this.m_inputStartLine;
        this.m_inputStartLine = this.m_lastLineCount = n2;
        this.m_lineTypes[this.m_inputStartLine] = 3;
        this.addPrompt(3);
        this.notifyInputChange(n, n3);
    }

    public synchronized void addHistoryListener(IHistoryListener iHistoryListener) {
        if (!this.m_historyListeners.contains(iHistoryListener)) {
            this.m_historyListeners.add(iHistoryListener);
        }
    }

    public synchronized void removeHistoryListener(IHistoryListener iHistoryListener) {
        int n = this.m_historyListeners.indexOf(iHistoryListener);
        if (n >= 0) {
            this.m_historyListeners.remove(n);
        }
    }

    public void notifyHistoryChange() {
        for (int i = 0; i < this.m_historyListeners.size(); ++i) {
            ((IHistoryListener)this.m_historyListeners.get(i)).historySelectedBlockChanged(this);
        }
    }

    public void notifyHistoryUpDownChange(boolean bl) {
        int n;
        for (n = 0; n < this.m_historyListeners.size(); ++n) {
            ((IHistoryListener)this.m_historyListeners.get(n)).historySelectedBlockChanged(this, bl);
        }
        n = this.getNextSelectedInputBlock(bl);
        this.clearInput();
        if (n != -1) {
            String string = this.getHistoryLine(n);
            while (string.length() > 0 && string.endsWith(g_lineDelimiter)) {
                string = string.substring(0, string.length() - g_numLDChars);
            }
            this.appendInputLine(string);
        }
        this.setSelectedInputBlock(n);
    }

    public int getNextSelectedInputBlock(boolean bl) {
        int n = this.getSelectedInputBlock();
        if (bl) {
            if (n > 0) {
                --n;
            } else if (n < 0) {
                n = this.getHistoryLines().size() - 1;
            }
        } else {
            n = n >= 0 && n < this.getHistoryLines().size() - 1 ? ++n : -1;
        }
        return n;
    }

    private void notifyDeleteChange() {
        for (int i = 0; i < this.m_historyListeners.size(); ++i) {
            ((IHistoryListener)this.m_historyListeners.get(i)).historyRemoved(this);
        }
    }

    private void notifyAddedChange(int n) {
        for (int i = 0; i < this.m_historyListeners.size(); ++i) {
            ((IHistoryListener)this.m_historyListeners.get(i)).historyAdded(this, n);
        }
    }

    private void notifyInputChange(int n, int n2) {
        this.addHistory(n, n2);
        for (int i = 0; i < this.m_historyListeners.size(); ++i) {
            ((IHistoryListener)this.m_historyListeners.get(i)).historyInput(this, n, n2);
        }
    }

    public void documentAboutToBeChanged(DocumentEvent documentEvent) {
    }

    public synchronized void documentChanged(DocumentEvent documentEvent) {
        if (this.m_promptIgnore) {
            return;
        }
        try {
            if (this.getNumberOfLines() >= MAXIMUM_LINES) {
                this.clipLines();
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        if (this.m_lastLineCount >= this.getNumberOfLines()) {
            this.m_lastLineCount = this.getNumberOfLines() - 1;
        }
        int n = this.m_lastLineCount;
        if (this.getNumberOfLines() >= this.m_lastLineCount + 1) {
            try {
                String string = this.getLength() < g_numLDChars ? "" : this.get(this.getLength() - g_numLDChars, g_numLDChars);
                boolean bl = string.equals(g_lineDelimiter);
                boolean bl2 = false;
                if (bl) {
                    int n2 = this.m_inputStartLine;
                    int n3 = this.getNumberOfLines() - 1;
                    String string2 = this.getBlockCommands(n2, n3 - n2);
                    boolean bl3 = false;
                    boolean bl4 = false;
                    String string3 = "";
                    try {
                        string3 = this.splusParseTest(string2);
                    }
                    catch (SplusEngineBusyException splusEngineBusyException) {
                        string3 = "";
                    }
                    if (string3.length() == 0) {
                        bl3 = SplusParseTreeBuilder.getInstance().isComplete(string2);
                        boolean bl5 = bl4 = !SplusParseTreeBuilder.getInstance().isCompleteString(string2);
                    }
                    if (string3.equals(DefaultConnection.FAILED_EXPRESSION)) {
                        bl2 = true;
                    } else if (bl3 || string3.equals(DefaultConnection.COMPLETE_EXPRESSION)) {
                        this.executeCommand(string2);
                        this.postCommandUpdate();
                    } else if (bl4 || string3.equals(DefaultConnection.INCOMPLETE_STRING)) {
                        this.addPrompt(2);
                    } else if (!bl3 || string3.equals(DefaultConnection.INCOMPLETE_EXPRESSION)) {
                        this.addPrompt(1);
                    }
                    ++this.m_lastLineCount;
                    if (n < this.m_lastLineCount) {
                        this.notifyAddedChange(n);
                    }
                } else if (documentEvent.fText.indexOf(g_lineDelimiter) != -1) {
                    ++this.m_lastLineCount;
                }
                if (bl2) {
                    this.postCommandUpdate();
                    this.pollForOutput();
                    this.addPrompt(0);
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
        this.m_consolePromptModel.removeAllAnnotations();
        for (int i = 0; i < this.getNumberOfLines(); ++i) {
            this.updateLineType(i, this.m_lineTypes[i]);
        }
        this.refreshPrompts();
    }

    public synchronized void executeCommand(String string) {
        this.getConnection().sendCmd(string);
    }

    private synchronized String splusParseTest(String string) throws SplusEngineBusyException {
        DefaultConnection defaultConnection = (DefaultConnection)this.getConnection();
        if (defaultConnection.isEngineBusy()) {
            return "";
        }
        if (string.trim().startsWith("#")) {
            return DefaultConnection.COMPLETE_EXPRESSION;
        }
        String string2 = defaultConnection.parseSplusString(string);
        defaultConnection.eventOccurred(null);
        return string2;
    }

    public synchronized String getBlockCommands(int n, int n2) {
        return this.getBlockCommands(n, n2, false);
    }

    public synchronized String getBlockCommands(int n, int n2, boolean bl) {
        int n3;
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = n2;
        int n5 = n3 + n4;
        for (n3 = n; n3 < n5; ++n3) {
            String string = this.getLine(n3);
            int n6 = this.lineType(n3);
            if (n6 == 2) {
                if (stringBuffer.length() == 0) {
                    stringBuffer.append(string);
                }
                stringBuffer.setLength(stringBuffer.length() - g_numLDChars);
            }
            int n7 = this.lineType(n3 + 1);
            if (bl && (n7 == 1 || n7 == 2)) {
                return string.trim() + " ...";
            }
            if (n4 == 1) {
                return string.trim();
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public void replace(int n, int n2, String string) throws BadLocationException {
        if (!this.getCtrlDown() && string.equals(g_lineDelimiter)) {
            int n3;
            n = n3 = this.getLength();
        }
        super.replace(n, n2, string);
    }

    protected Annotation getAnnotationForType(int n, int n2) {
        return new PromptAnnotation(n, n2);
    }

    protected void initConsolePromptModel() {
        this.m_consolePromptModel = new ConsoleAnnotationModel();
        this.m_annotKeyMap = new HashMap();
        this.m_posKeyMap = new HashMap();
        this.m_consolePromptModel.connect((IDocument)this);
    }

    public void refreshPrompts() {
        if (this.m_consolePromptModel != null) {
            this.m_consolePromptModel.refresh();
        }
    }

    public void addAnnotationModelListener(IAnnotationModelListener iAnnotationModelListener) {
        this.m_consolePromptModel.addAnnotationModelListener(iAnnotationModelListener);
    }

    public void removeAnnotationModelListener(IAnnotationModelListener iAnnotationModelListener) {
        this.m_consolePromptModel.removeAnnotationModelListener(iAnnotationModelListener);
    }

    public void connect(IDocument iDocument) {
        this.m_consolePromptModel.connect(iDocument);
    }

    public void disconnect(IDocument iDocument) {
        this.m_consolePromptModel.disconnect(iDocument);
    }

    public void addAnnotation(Annotation annotation, Position position) {
        this.m_consolePromptModel.addAnnotation(annotation, position);
    }

    public void removeAnnotation(Annotation annotation) {
        this.m_consolePromptModel.removeAnnotation(annotation);
    }

    public Iterator getAnnotationIterator() {
        return this.m_consolePromptModel.getAnnotationIterator();
    }

    public Position getPosition(Annotation annotation) {
        return this.m_consolePromptModel.getPosition(annotation);
    }

    public static class ParseTestException
    extends Exception {
        public ParseTestException(String string) {
            super(string);
        }
    }

    public class ConsoleAnnotationModel
    extends AnnotationModel {
        public void addAnnotation(Annotation annotation, Position position) {
            try {
                this.addAnnotation(annotation, position, false);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public void refresh() {
            this.fireModelChanged();
        }
    }
}

