/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.DataCacheRowBuf;
import com.insightful.miner.EngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Vector;

public class AppendEngineNode
extends EngineNode {
    public static String MERGE_TYPE_ATTRIBUTE_TAG = "joinType";
    public static String FULL_TYPE_ATTRIBUTE_TAG = "full";
    public static String LEFT_TYPE_ATTRIBUTE_TAG = "left";
    public static String RIGHT_TYPE_ATTRIBUTE_TAG = "right";
    public static String INNER_TYPE_ATTRIBUTE_TAG = "inner";
    public static String MULTI_APPEND_UNMATCHED_ATTRIBUTE_TAG = "includeUnmatched";
    public static String MULTI_APPEND_NUM_INPUTS_ATTRIBUTE_TAG = "numInputs";
    private int[][] m_columnNums;
    private int m_intersection;
    private boolean[] m_isColumnCategorical;

    public boolean hasCNKProc() {
        return false;
    }

    public boolean hasDataCacheProc() {
        return true;
    }

    public boolean executeDataCacheProc() throws Exception {
        return this.multiAppend();
    }

    private void addDataField(XTMetaData inMD, XTMetaData outMD, String colName) {
        if (inMD.isCategoricalColumn(colName)) {
            Vector levels = inMD.getCategoricalDataFieldLevels(colName);
            outMD.appendCategoricalDataField(colName, levels);
        } else if (inMD.isStringColumn(colName)) {
            int stringWidth = inMD.getStringDataFieldWidth(colName);
            outMD.appendStringDataField(colName, stringWidth);
        } else if (inMD.isDateTimeColumn(colName)) {
            outMD.appendDateTimeDataField(colName);
        } else if (inMD.isBlobColumn(colName)) {
            outMD.appendBlobDataField(colName, inMD.getBlobDataFieldClassName(colName));
        } else {
            outMD.appendContinousDataField(colName);
        }
    }

    private void clearOutputVars() {
        this.m_columnNums = null;
        this.m_isColumnCategorical = null;
    }

    public XTMetaData calculateOutputMetaData(int outputNum) {
        XTMetaData md = null;
        try {
            md = this.recalculateOutputVarsForMulti(false);
            this.clearOutputVars();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return md;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean multiAppend() throws Exception {
        XTProps props = this.getNodeProperties();
        int numInputs = props.getInt(MULTI_APPEND_NUM_INPUTS_ATTRIBUTE_TAG, -1);
        boolean oldNotation = false;
        if (numInputs == -1) {
            if (props.getValue(MERGE_TYPE_ATTRIBUTE_TAG, "").length() == 0) {
                numInputs = this.getNumInputs();
            } else {
                oldNotation = true;
                numInputs = 2;
            }
        }
        XTMetaData[] inputMD = new XTMetaData[numInputs];
        boolean[] includeUnmatched = new boolean[numInputs];
        long[] rowCounts = new long[numInputs];
        int[] numColumns = new int[numInputs];
        String[] matchPath = new String[]{MULTI_APPEND_UNMATCHED_ATTRIBUTE_TAG, ""};
        long totalRowCount = 0L;
        for (int i = 0; i < numInputs; ++i) {
            inputMD[i] = this.getInputMetaData(i);
            matchPath[1] = Integer.toString(i);
            includeUnmatched[i] = props.getBoolean(matchPath, true);
            numColumns[i] = inputMD[i].getNumColumns();
            rowCounts[i] = inputMD[i].getNumRows();
            totalRowCount += rowCounts[i];
        }
        if (oldNotation) {
            String method = props.getValue(MERGE_TYPE_ATTRIBUTE_TAG, FULL_TYPE_ATTRIBUTE_TAG);
            boolean isFull = method.equals(FULL_TYPE_ATTRIBUTE_TAG);
            includeUnmatched[0] = isFull || method.equals(LEFT_TYPE_ATTRIBUTE_TAG);
            includeUnmatched[1] = isFull || method.equals(RIGHT_TYPE_ATTRIBUTE_TAG);
        }
        XTMetaData outputMetaData = this.recalculateOutputVarsForMulti(true);
        FileInputStream inFIS = null;
        BufferedInputStream inBIS = null;
        FilterInputStream inDIS = null;
        DataCacheRowBuf inBuf = null;
        RandomAccessFile inBlobFile = null;
        FileOutputStream mergedStream = new FileOutputStream(this.getOutputDataCacheFileName(0));
        BufferedOutputStream mergedBuffer = new BufferedOutputStream(mergedStream);
        DataOutputStream mergedOutputStream = new DataOutputStream(mergedBuffer);
        DataCacheRowBuf outputBuf = new DataCacheRowBuf(outputMetaData);
        BufferedOutputStream outBlobFile = null;
        if (outputBuf.containsBlobs()) {
            try {
                String outBlobFileName = this.getNetworkManager().getOutputDataBlobFileName(this.getNodeID(), 0);
                outBlobFile = new BufferedOutputStream(new FileOutputStream(outBlobFileName, false));
                outputBuf.setWriteBlobFile(outBlobFile);
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        try {
            Vector[][] origLevels = new Vector[numInputs][];
            for (int inputNum = 0; inputNum < numInputs; ++inputNum) {
                origLevels[inputNum] = new Vector[inputMD[inputNum].getNumColumns()];
                for (int cNum = 0; cNum < origLevels[inputNum].length; ++cNum) {
                    origLevels[inputNum][cNum] = null;
                }
            }
            int numOutputColumns = outputMetaData.getNumColumns();
            Vector[] newLevels = new Vector[numOutputColumns];
            for (int i = 0; i < newLevels.length; ++i) {
                newLevels[i] = null;
            }
            long curRow = 0L;
            for (int inputNum = 0; inputNum < numInputs; ++inputNum) {
                try {
                    if (inDIS != null) {
                        inDIS.close();
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                inDIS = null;
                try {
                    if (inBlobFile != null) {
                        inBlobFile.close();
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                inBlobFile = null;
                inFIS = new FileInputStream(this.getInputDataCacheFileName(inputNum));
                inBIS = new BufferedInputStream(inFIS);
                inDIS = new DataInputStream(inBIS);
                inBuf = new DataCacheRowBuf(inputMD[inputNum]);
                inBlobFile = null;
                if (inBuf.containsBlobs()) {
                    try {
                        String blobFileName = this.getNetworkManager().getInputDataBlobFileName(this.getNodeID(), inputNum);
                        inBlobFile = new RandomAccessFile(blobFileName, "r");
                        inBuf.setReadBlobFile(inBlobFile);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                for (curRow = 0L; curRow < rowCounts[inputNum]; ++curRow) {
                    inBuf.readRow((DataInput)((Object)inDIS));
                    for (int i = 0; i < numOutputColumns; ++i) {
                        int rightCol = this.m_columnNums[inputNum][i];
                        if (rightCol >= 0) {
                            if (inputNum != 0 && this.m_isColumnCategorical[i] && i < this.m_intersection) {
                                double NaNguard = inBuf.getDouble(rightCol);
                                if (Double.isNaN(NaNguard)) {
                                    outputBuf.setNA(i);
                                    continue;
                                }
                                String outColName = outputMetaData.ordinalToName(i);
                                if (origLevels[inputNum][rightCol] == null) {
                                    origLevels[inputNum][rightCol] = inputMD[inputNum].getCategoricalDataFieldLevels(outColName);
                                }
                                if (newLevels[i] == null) {
                                    newLevels[i] = outputMetaData.getCategoricalDataFieldLevels(outColName);
                                }
                                int outputLevelID = newLevels[i].indexOf(origLevels[inputNum][rightCol].get((int)NaNguard));
                                outputBuf.setDouble(i, outputLevelID);
                                continue;
                            }
                            outputBuf.copyColumn(i, rightCol, inBuf);
                            continue;
                        }
                        outputBuf.setNA(i);
                    }
                    outputBuf.writeRow(mergedOutputStream);
                    int tempPercentDone = (int)(100.0 * ((double)curRow / (double)totalRowCount));
                    if (this.updateProgressIndicator(tempPercentDone)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            outputMetaData.setNumRows(totalRowCount);
            this.setOutputMetaData(0, outputMetaData);
        }
        finally {
            this.clearOutputVars();
            try {
                if (inDIS != null) {
                    inDIS.close();
                }
            }
            catch (Exception ex) {}
            try {
                if (inBlobFile != null) {
                    inBlobFile.close();
                }
            }
            catch (Exception ex) {}
            mergedOutputStream.flush();
            mergedOutputStream.close();
            try {
                if (outBlobFile != null) {
                    ((OutputStream)outBlobFile).flush();
                }
                ((OutputStream)outBlobFile).close();
            }
            catch (Exception ex) {}
        }
        return true;
    }

    public static boolean[] getMultiIncludeUnmatched(XTProps props, int numInputs) {
        boolean[] includeUnmatched = new boolean[numInputs];
        String[] matchPath = new String[]{MULTI_APPEND_UNMATCHED_ATTRIBUTE_TAG, ""};
        for (int i = 0; i < numInputs; ++i) {
            matchPath[1] = Integer.toString(i);
            includeUnmatched[i] = props.getBoolean(matchPath, true);
        }
        if (numInputs == -1) {
            String method = props.getValue(MERGE_TYPE_ATTRIBUTE_TAG, FULL_TYPE_ATTRIBUTE_TAG);
            boolean isFull = method.equals(FULL_TYPE_ATTRIBUTE_TAG);
            includeUnmatched[0] = isFull || method.equals(LEFT_TYPE_ATTRIBUTE_TAG);
            includeUnmatched[1] = isFull || method.equals(RIGHT_TYPE_ATTRIBUTE_TAG);
        }
        return includeUnmatched;
    }

    private XTMetaData recalculateOutputVarsForMulti(boolean complete) throws Exception {
        int i;
        XTMetaData outputMetaData = new XTMetaData();
        XTProps props = this.getNodeProperties();
        int numInputs = props.getInt(MULTI_APPEND_NUM_INPUTS_ATTRIBUTE_TAG, -1);
        boolean oldNotation = false;
        if (numInputs == -1) {
            if (props.getValue(MERGE_TYPE_ATTRIBUTE_TAG, "").length() == 0) {
                numInputs = this.getNumInputs();
            } else {
                oldNotation = true;
                numInputs = 2;
            }
        }
        boolean[] includeUnmatched = AppendEngineNode.getMultiIncludeUnmatched(props, numInputs);
        XTMetaData[] inputMD = new XTMetaData[numInputs];
        int[] numColumns = new int[numInputs];
        for (int i2 = 0; i2 < numInputs; ++i2) {
            inputMD[i2] = this.getInputMetaData(i2);
            numColumns[i2] = inputMD[i2].getNumColumns();
        }
        int outputColumns = 0;
        int numIntersections = 0;
        int numCombinedCols = 0;
        HashMap<String, Vector> columnNames = new HashMap<String, Vector>();
        boolean collectMatchedColumns = true;
        for (i = 0; i < numInputs; ++i) {
            for (int col = 0; col < numColumns[i]; ++col) {
                String colName = inputMD[i].ordinalToName(col);
                if (i != 0 && outputMetaData.nameToOrdinal(colName) != -1) continue;
                String type = inputMD[i].getColumnType(col);
                boolean isCategorical = type.equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG);
                Vector levels = inputMD[i].getCategoricalDataFieldLevels(colName);
                int numInputsColumnIn = 1;
                for (int nextInput = i + 1; nextInput < numInputs; ++nextInput) {
                    if (inputMD[nextInput].nameToOrdinal(colName) == -1) continue;
                    ++numInputsColumnIn;
                    if (!inputMD[nextInput].getColumnType(colName).equals(type)) {
                        throw new RuntimeException(colName + " must be the same type in all inputs.");
                    }
                    if (!isCategorical) continue;
                    Vector newlevels = inputMD[nextInput].getCategoricalDataFieldLevels(colName);
                    for (int l = 0; l < newlevels.size(); ++l) {
                        String levStr = (String)newlevels.get(l);
                        if (levels.contains(levStr)) continue;
                        levels.add(levStr);
                    }
                }
                if (collectMatchedColumns && numInputsColumnIn == numInputs) {
                    ++numIntersections;
                    ++numCombinedCols;
                    ++outputColumns;
                    this.addDataField(inputMD[i], outputMetaData, colName);
                    columnNames.put(colName, levels);
                    continue;
                }
                if (collectMatchedColumns || !includeUnmatched[i]) continue;
                if (numInputsColumnIn > 1) {
                    ++numCombinedCols;
                }
                if (outputMetaData.nameToOrdinal(colName) == -1) {
                    ++outputColumns;
                    this.addDataField(inputMD[i], outputMetaData, colName);
                }
                columnNames.put(colName, levels);
            }
            if (!collectMatchedColumns) continue;
            collectMatchedColumns = false;
            --i;
        }
        if (complete && numIntersections == 0) {
            this.printlnWarning("No matching columns found in inputs.");
        }
        this.m_isColumnCategorical = new boolean[outputColumns];
        this.m_columnNums = new int[numInputs][outputColumns];
        for (i = 0; i < numInputs; ++i) {
            Vector inputColumnNames = inputMD[i].getColumnNames();
            for (int col = 0; col < inputColumnNames.size(); ++col) {
                String colName = (String)inputColumnNames.get(col);
                boolean updateStats = false;
                if (outputMetaData.nameToOrdinal(colName) == -1) {
                    if (includeUnmatched[i]) {
                        this.addDataField(inputMD[i], outputMetaData, colName);
                        updateStats = true;
                    }
                } else if (i == 0) {
                    updateStats = true;
                }
                if (updateStats) {
                    int oColNum = outputMetaData.nameToOrdinal(colName);
                    this.m_isColumnCategorical[oColNum] = inputMD[i].isCategoricalColumn(colName);
                }
                if (!outputMetaData.getColumnType(colName).equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG)) continue;
                Vector adjLevels = (Vector)columnNames.get(colName);
                outputMetaData.appendCategoricalDataField(colName, adjLevels);
            }
        }
        this.m_intersection = numIntersections;
        for (int out = 0; out < outputColumns; ++out) {
            String cName = outputMetaData.ordinalToName(out);
            for (int in = 0; in < numInputs; ++in) {
                this.m_columnNums[in][out] = inputMD[in].nameToOrdinal(cName);
            }
        }
        return outputMetaData;
    }
}

