/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKBlobClassHandler;
import com.insightful.cnkjava.CNKBuf;
import com.insightful.cnkjava.CNKObj;
import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcConvertDataFrame;
import com.insightful.cnkjava.CNKProcJavaTransform;
import com.insightful.cnkjava.CNKProcJavaTransformExec;
import com.insightful.cnkjava.CNKProcSplusTransform;
import com.insightful.controls.SplusWin32Tools;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.BDLList;
import com.insightful.miner.Base64;
import com.insightful.miner.BaseNodeArea;
import com.insightful.miner.ClassificationAgreementEngineNode;
import com.insightful.miner.ClassificationAgreementNodeModel;
import com.insightful.miner.CrosstabulateEngineNode;
import com.insightful.miner.DataCacheRowBuf;
import com.insightful.miner.EngineMessageHandler;
import com.insightful.miner.EngineNetworkManager;
import com.insightful.miner.EngineNode;
import com.insightful.miner.EngineStringConverter;
import com.insightful.miner.ExtensionManager;
import com.insightful.miner.GlobalObjectCache;
import com.insightful.miner.GuiMessageHandler;
import com.insightful.miner.MinerApp;
import com.insightful.miner.ModifiableViewerFrame;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.NodeViewer;
import com.insightful.miner.PredictNodeModel;
import com.insightful.miner.PredictableNodeModel;
import com.insightful.miner.RegressionAgreementEngineNode;
import com.insightful.miner.RegressionAgreementNodeModel;
import com.insightful.miner.SplusGraphEngineNode;
import com.insightful.miner.SplusScriptEngineNode;
import com.insightful.miner.TwoDimChartEngineNode;
import com.insightful.miner.TwoDimChartNodeModel;
import com.insightful.miner.UnivariateEngineNode;
import com.insightful.miner.Win32Tools;
import com.insightful.miner.WorksheetDocument;
import com.insightful.miner.WorksheetPropertiesManager;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XMLTreeNetwork;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTNetwork;
import com.insightful.miner.XTProps;
import com.insightful.miner.sql.BigDataCommandInterpreter;
import com.nwoods.jgo.JGoObject;
import java.awt.Dialog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.JDialog;

public class BDLManager
extends EngineNetworkManager {
    private static BDLManager m_mgr = null;
    private String m_wsd = null;
    private static final String[] m_cacheExtensions = new String[]{"dcf", "mdf", "dbf"};
    private boolean m_hooksOK = false;
    private boolean m_executingNode = false;
    public XMLTree m_savedModel = null;
    public static final String READ_ONLY_DIR_PREFIX = "READONLYDIR::";
    private Hashtable m_nodeToOutputMap = new Hashtable();
    private Hashtable m_cacheToBDOInfoMap = new Hashtable();
    private int m_bdoIDCounter = 100;
    private Vector m_errorMessages = new Vector();
    private Vector m_warningMessages = new Vector();
    public static final int SPLUS_TO_JAVA_EPOCH_DAYS = 3653;
    public static final int MS_PER_DAY = 86400000;
    private static Hashtable m_registeredDataHash = new Hashtable();
    private static String MEMREF_MAGIC_STRING = "!Z9a";
    private static boolean m_registerCheck = false;
    private Vector m_putValuesCacheList = new Vector();
    private Vector m_dbInfoList = new Vector();
    private Hashtable m_dbInfoHash = new Hashtable();
    public static CNKProc m_testbedCNKProc = null;
    private static String m_testbedCNKProcLibrary = null;
    private static String m_testbedCNKProcClass = null;
    private static final String SPLUS_LIST_BRACKET_START = "[[";
    private static final String SPLUS_LIST_BRACKET_END = "]]";
    private static final String SEPARATOR = ".";
    private static final String[] g_returnValueNames = new String[]{"engine.class", "gui.class", "node.props", "inputs", "modelInputs", "numOutputs", "output", "modelOutput", "label"};
    private static String m_progressBarDefaultViewer = "java";
    private static boolean m_progressBarWindowsSupported = false;
    private static boolean m_progressBarIsWindows = false;
    private static boolean m_progressBarEnabled = false;
    private static String m_progressBarLastMessage = "";
    public static boolean m_ESCCheckEnabled = false;
    public static long m_ESCCheckTime = 0L;
    private static File m_encodeTempFile = null;
    private static InputStream m_encodeInputStream = null;
    private static int m_encodeLineCount = 0;
    private static File m_decodeTempFile = null;
    private static OutputStream m_decodeOutputStream = null;
    private static Cache m_decodeCache = null;
    private static boolean m_tempOK = false;
    private static boolean m_decodeCacheOK = false;
    private XTProps m_BDLWorksheetProps = null;
    public static int m_maxCacheRefs = 0;
    private static double m_execNodeDoubleDateEpoch = -3.156192E11;
    private boolean m_initNativeConvertDoubleToString = false;
    private boolean m_enabledNativeConvertDoubleToString = false;

    public static int getVersion() {
        return 1001;
    }

    public BDLManager(String wsd, boolean hooksOK) throws Exception {
        super("dummy-worksheet-id", wsd, "dummy-imwPath", false);
        this.m_wsd = BDLManager.getBdoDir(wsd);
        this.m_hooksOK = hooksOK;
    }

    public boolean isSplusLicensed() {
        return true;
    }

    public boolean isProductionEdition() {
        return true;
    }

    public void writeXML(String fileName, XMLTree xml) throws Exception {
        if (fileName == null || fileName.endsWith("network.xml") || fileName.endsWith("state.xml")) {
            return;
        }
        super.writeXML(fileName, xml);
    }

    public static BDLManager getBDLManager() throws Exception {
        if (m_mgr == null) {
            throw new Exception("no BDLManager initialized");
        }
        return m_mgr;
    }

    public static void setSystemProperty(BDLList lst) {
        System.setProperty(lst.getValueString("prop.name"), lst.getValueString("prop.value"));
    }

    public static void initBDLManager(BDLList lst) throws Exception {
        boolean bdlIsMainApp;
        boolean hooksOK = lst.getValueInt("hooks.ok", 0) != 0;
        boolean bl = bdlIsMainApp = !MinerApp.isMainAppCreated();
        if (bdlIsMainApp) {
            try {
                ExtensionManager.setInitClassLoader(BDLManager.class.getClassLoader());
            }
            catch (Exception ex) {
                // empty catch block
            }
            BDLManager.setMessageSeverity(lst.getValueString("severity", "none"));
            System.setProperty("iminer.in.bdl", "TRUE");
            System.setProperty("sprime.work", lst.getValueString("iminer.work.dir", ""));
            System.setProperty("iminer.work", lst.getValueString("iminer.work.dir", ""));
            System.setProperty("sprime.home", lst.getValueString("iminer.dir", ""));
            System.setProperty("iminer.home", lst.getValueString("iminer.dir", ""));
            System.setProperty("sprime.logfile", "false");
            System.setProperty("iminer.logfile", "false");
            System.setProperty("sprime.batch", "");
            System.setProperty("iminer.batch", "");
            System.setProperty("sprime.temp", "");
            System.setProperty("iminer.temp", "");
            System.setProperty("user.dir", lst.getValueString("user.dir", ""));
            System.setProperty("user.home", lst.getValueString("iminer.work.dir", ""));
            MinerApp.init(false);
        }
        if (m_mgr != null) {
            System.out.println("initBDLManager: flushing old BDLManager");
        }
        m_mgr = new BDLManager(lst.getValueString("init.wsd"), hooksOK);
        m_mgr.setWorksheetProp("defaultFileDir", System.getProperty("user.dir", ""));
        m_mgr.setWorksheetProp("decimalSymbols", SEPARATOR);
        if (bdlIsMainApp && MinerApp.isWindowsOS()) {
            Win32Tools.loadWinLinkDLL();
        }
        EngineMessageHandler.m_worksheetMgr.registerEngineNetworkManager("bd.internal.worksheet.id", m_mgr);
        WorksheetDocument doc = new WorksheetDocument(true, "BDLWorksheet");
        XTProps props = doc.getWorksheetProperties();
        WorksheetPropertiesManager.copyBlankWorksheetPropsFromGlobalProps(props, MinerApp.getGlobalOptions());
        doc.setWorksheetProperties(props);
        doc.setWorksheetID("bd.internal.worksheet.id");
        if (bdlIsMainApp) {
            MinerApp.setCurrentDoc(doc);
        }
    }

    public static void closeBDLManager() throws Exception {
        try {
            ModifiableViewerFrame.closeViewers();
            BDLManager.getBDLManager().flushViewerRefCounts();
        }
        catch (Exception exception) {
            // empty catch block
        }
        m_progressBarEnabled = false;
        BDLManager.setESCCheckEnabled(false);
        m_mgr = null;
    }

    public static BDLList exec(BDLList lst) {
        if (lst == null) {
            return null;
        }
        String cmd = lst.getValueString("cmd");
        BDLList props = lst.getValueBDLList("args");
        Object obj = null;
        try {
            obj = lst.hasValue("classMethod") ? EngineMessageHandler.dispatchClassMessage(BDLManager.class, cmd, new Object[]{props}) : EngineMessageHandler.dispatchMessage(BDLManager.getBDLManager(), cmd, new Object[]{props});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (obj instanceof BDLList) {
            return (BDLList)obj;
        }
        return null;
    }

    public BDLList getSplusBigdataScriptInputs(BDLList lst) throws Exception {
        int numInputs = SplusScriptEngineNode.g_bigdataScriptInputs.length;
        BDLList inputList = new BDLList(numInputs);
        BDLList rolesList = new BDLList(numInputs);
        for (int i = 0; i < numInputs; ++i) {
            SplusScriptEngineNode.BigdataScriptCache scriptCache = SplusScriptEngineNode.g_bigdataScriptInputs[i];
            XTMetaData md = scriptCache.m_metaData;
            String dirName = READ_ONLY_DIR_PREFIX + scriptCache.m_dirName;
            String cacheName = new File(scriptCache.m_dcfFilename).getName();
            cacheName = cacheName.substring(0, cacheName.length() - 4);
            BDLList inputInfo = new BDLList(3);
            inputInfo.set(0, "cache", cacheName);
            inputInfo.set(1, "dir", dirName);
            BDLList mdLst = BDLList.translateFromXTMetaData(md);
            inputInfo.set(2, "meta.data", mdLst);
            inputList.set(i, null, inputInfo);
            int numColumns = md.getNumColumns();
            BDLList inputRoles = new BDLList(numColumns);
            for (int col = 0; col < numColumns; ++col) {
                inputRoles.set(col, md.ordinalToName(col), md.getColumnRole(col));
            }
            rolesList.set(i, null, inputRoles);
        }
        BDLList ret = new BDLList(2);
        ret.set(0, "inputs", inputList);
        ret.set(1, "roles", rolesList);
        return ret;
    }

    public BDLList setSplusBigdataScriptOutputs(BDLList lst) throws Exception {
        BDLList outputBDLList = lst.getValueBDLList("outputs");
        BDLList outputRolesBDLList = lst.getValueBDLList("output.roles");
        int numOutputs = SplusScriptEngineNode.g_bigdataScriptOutputs.length;
        if (numOutputs != outputBDLList.getLength()) {
            throw new Exception("wrong number outputs: got " + outputBDLList.getLength() + ", expected " + numOutputs);
        }
        String bdDir = this.getDBInfo().getDir();
        for (int i = 0; i < numOutputs; ++i) {
            Cache ca = new Cache(outputBDLList.getValueBDLList(i));
            boolean renameAllowed = true;
            if (ca.getDirName().startsWith(READ_ONLY_DIR_PREFIX)) {
                renameAllowed = false;
            } else if (!ca.getDirName().startsWith(bdDir)) {
                renameAllowed = false;
            } else {
                for (int i2 = i + 1; i2 < numOutputs; ++i2) {
                    Cache ca2 = new Cache(outputBDLList.getValueBDLList(i2));
                    if (!ca.getFilePathWithExt("dcf").equals(ca2.getFilePathWithExt("dcf")) && !ca.getFilePathWithExt("mdf").equals(ca2.getFilePathWithExt("mdf")) && !ca.getFilePathWithExt("dbf").equals(ca2.getFilePathWithExt("dbf"))) continue;
                    renameAllowed = false;
                    break;
                }
            }
            SplusScriptEngineNode.BigdataScriptCache scriptCache = SplusScriptEngineNode.g_bigdataScriptOutputs[i];
            this.renameOrCopyFile(ca.getFilePathWithExt("dcf"), scriptCache.m_dcfFilename, renameAllowed);
            this.renameOrCopyFile(ca.getFilePathWithExt("dbf"), scriptCache.m_dbfFilename, renameAllowed);
            String outputRolesListName = "out" + (i + 1) + ".column.roles";
            boolean copyMetaData = true;
            if (outputRolesBDLList.hasValue(outputRolesListName)) {
                try {
                    this.println("adding roles to meta-data file " + scriptCache.m_mdfFilename);
                    XTMetaData md = XTMetaData.readXTMetaDataFromFile(ca.getFilePathWithExt("mdf"));
                    int numColumns = md.getNumColumns();
                    BDLList roles = outputRolesBDLList.getValueBDLList(outputRolesListName);
                    int numRoles = roles.getLength();
                    for (int colNum = 0; colNum < numColumns && colNum < numRoles; ++colNum) {
                        String role = roles.getValueString(colNum);
                        if (role == null) continue;
                        md.setDataFieldRole(colNum, role);
                    }
                    md.saveToFile(scriptCache.m_mdfFilename);
                    copyMetaData = false;
                }
                catch (Exception ex) {
                    this.println("exception adding roles to meta-data file " + scriptCache.m_mdfFilename + ": " + ex);
                }
            }
            if (!copyMetaData) continue;
            this.renameOrCopyFile(ca.getFilePathWithExt("mdf"), scriptCache.m_mdfFilename, renameAllowed);
        }
        return null;
    }

    public void renameOrCopyFile(String fromFile, String toFile, boolean renameAllowed) {
        if (renameAllowed) {
            try {
                File from = new File(fromFile);
                File to = new File(toFile);
                boolean ok = from.renameTo(to);
                if (ok) {
                    return;
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.copyFile(fromFile, toFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BDLList execNode(BDLList props) throws Exception {
        String status = (String)EngineMessageHandler.sendMessageToApp("getStatusText", new Object[0]);
        if (this.m_executingNode) {
            BDLList ret = new BDLList(1);
            ret.set(0, "error", "Can't perform big data operations within S-PLUS function/expression argument to bd.block.apply, bd.by.group, bd.create.columns, etc.");
            EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{status});
            return ret;
        }
        try {
            this.m_executingNode = true;
            BDLList ret = this.setGlobalsExecNode(props);
            EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{status});
            BDLList bDLList = ret;
            Object var6_6 = null;
            this.m_executingNode = false;
            return bDLList;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.m_executingNode = false;
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BDLList setGlobalsExecNode(BDLList props) throws Exception {
        BDLList bDLList;
        long savedEpoch = CNKObj.getDoubleDateEpoch();
        boolean savedErrorOnLevelOverflow = CNKObj.getErrorOnLevelOverflow();
        boolean savedErrorOnStringTruncation = CNKObj.getErrorOnStringTruncation();
        try {
            CNKObj.setDoubleDateEpoch((long)BDLManager.getExecNodeDoubleDateEpoch());
            CNKObj.setErrorOnLevelOverflow(props.getValueBoolean("error.on.level.overflow", false));
            CNKObj.setErrorOnStringTruncation(props.getValueBoolean("error.on.string.truncation", false));
            this.setWorksheetProp("maxBufferMB", props.getValueInt("max.block.mb", this.getMaxBufferMB()));
            this.setWorksheetProp("maxStringSize", 1 + props.getValueInt("default.max.string.chars", this.getDefaultStringSize() - 1));
            this.setWorksheetProp("maxCategoricalLevels", props.getValueInt("max.levels", this.getMaxCategoricalLevels()));
            this.setWorksheetProp("dateParseString", props.getValueString("time.in.format", this.getWorksheetPropertiesManager().getDateParseString()));
            this.setWorksheetProp("dateFormatString", props.getValueString("time.out.format", this.getWorksheetPropertiesManager().getDateFormatString()));
            this.setWorksheetProp("dateCenturyCutoff", props.getValueInt("time.century", this.getWorksheetPropertiesManager().getCenturyCutoff()));
            bDLList = this.execNodeInEngine(props);
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            CNKObj.setDoubleDateEpoch(savedEpoch);
            CNKObj.setErrorOnLevelOverflow(savedErrorOnLevelOverflow);
            CNKObj.setErrorOnStringTruncation(savedErrorOnStringTruncation);
            throw throwable;
        }
        CNKObj.setDoubleDateEpoch(savedEpoch);
        CNKObj.setErrorOnLevelOverflow(savedErrorOnLevelOverflow);
        CNKObj.setErrorOnStringTruncation(savedErrorOnStringTruncation);
        return bDLList;
    }

    public BDLList execNodeInEngine(BDLList props) throws Exception {
        WorksheetDocument doc;
        BaseNodeArea viewerModelArea;
        int i;
        String engineClass = props.getValueString("engine.class", null);
        if (engineClass == null || engineClass.length() < 1) {
            return new BDLList(0);
        }
        BDLList nodeProps = props.getValueBDLList("node.props");
        BDLList inputSpecs = props.getValueBDLList("inputs");
        boolean preSetModel = props.getValueBoolean("pre.set.model", false);
        boolean preShowDialog = props.getValueBoolean("pre.show.dialog", false);
        boolean preShowDialogExec = props.getValueBoolean("pre.show.dialog.exec", false);
        boolean postGetModel = props.getValueBoolean("post.get.model", false);
        boolean postShowViewer = props.getValueBoolean("post.show.viewer", false);
        String viewerClass = props.getValueString("viewer.node.model.class");
        ActivityNodeModel viewerModel = null;
        String retError = "";
        String retCancel = "false";
        BDLList retDialogProps = new BDLList(0);
        BDLList retOutputs = new BDLList(0);
        boolean ok = true;
        Cache[] inputCaches = new Cache[inputSpecs.getLength()];
        for (int i2 = 0; i2 < inputCaches.length; ++i2) {
            inputCaches[i2] = new Cache(inputSpecs.getValueBDLList(i2));
        }
        int numOutputs = 0;
        if (props.hasValue("num.outputs")) {
            numOutputs = props.getValueInt("num.outputs", 0);
        } else if (props.hasValue("outputs")) {
            BDLList outputs = props.getValueBDLList("outputs");
            numOutputs = outputs.getLength();
        }
        Cache[] outputCaches = new Cache[numOutputs];
        for (i = 0; i < outputCaches.length; ++i) {
            outputCaches[i] = this.getDBInfo().getNewCache();
        }
        this.m_errorMessages.clear();
        this.m_warningMessages.clear();
        this.convertStringToDoubleSetErrorCount(0.0);
        this.createExecNode("0", inputCaches.length, outputCaches, engineClass, nodeProps);
        if (preSetModel) {
            this.getNode("0").setModel(this.m_savedModel);
            this.m_savedModel = null;
        }
        for (i = 0; i < inputCaches.length; ++i) {
            BDOInfo inputNodeInfo = this.getBDOInfo(inputCaches[i]);
            EngineNode inputNode = inputNodeInfo.getEngineNode();
            this.addLink(new XMLTreeNetwork.Link(inputNodeInfo.getNodeID(), 0, "0", i));
        }
        if (preShowDialog) {
            try {
                viewerModel = ActivityNodeModel.createActivityNodeModel(viewerClass, new XTNetwork.NodeInfo());
                XTProps dialogProps = BDLList.translateToXTProps(nodeProps);
                this.initNodeModel(viewerModel, 0, this.getNode("0").getNumInputs(), this.getNode("0").getNumOutputs(), dialogProps);
                viewerModel.showPropertiesDialog(true);
                if (NodeDialog.getDialogCancelled()) {
                    retCancel = "true";
                    ok = false;
                } else {
                    dialogProps = viewerModel.getXTProps();
                    this.setNodeProperties("0", dialogProps);
                    retDialogProps = BDLList.translateFromXTProps(dialogProps);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (!preShowDialogExec) {
                ok = false;
            }
        }
        if (ok) {
            this.m_interruptRequested = false;
            this.runToHereInThisThread("0");
        }
        if (this.m_errorMessages.size() > 0) {
            StringBuffer buf = new StringBuffer();
            for (int i3 = 0; i3 < this.m_errorMessages.size(); ++i3) {
                if (i3 > 0) {
                    buf.append("\n");
                }
                buf.append(this.m_errorMessages.get(i3));
            }
            retError = buf.toString();
            ok = false;
        }
        if (ok) {
            retOutputs = new BDLList(outputCaches.length);
            for (int output = 0; output < outputCaches.length; ++output) {
                BDLList outputInfo = new BDLList(3);
                outputInfo.set(0, "cache", outputCaches[output].getCacheName());
                outputInfo.set(1, "dir", outputCaches[output].getDirName());
                BDLList mdLst = BDLList.translateFromXTMetaData(this.getOutputMetaData("0", output));
                outputInfo.set(2, "meta.data", mdLst);
                retOutputs.set(output, null, outputInfo);
            }
        }
        if (ok && postGetModel) {
            this.m_savedModel = this.getNode("0").getModel();
        }
        if (ok && postShowViewer) {
            try {
                viewerModel = ActivityNodeModel.createActivityNodeModel(viewerClass, new XTNetwork.NodeInfo());
                this.initNodeModel(viewerModel, 0, this.getNode("0").getNumInputs(), this.getNode("0").getNumOutputs(), BDLList.translateToXTProps(nodeProps));
                viewerModel.showView(MinerApp.getMainFrame());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (viewerModel != null && (viewerModelArea = (doc = MinerApp.getCurrentDoc()).findNodeByID(0)) != null) {
            doc.removeObject((JGoObject)viewerModelArea);
            doc.resetEngineNetworkDirty();
        }
        this.unmapOutputFiles("0");
        this.removeNode("0");
        for (int i4 = 0; i4 < inputCaches.length; ++i4) {
            this.flushBDOInfo(inputCaches[i4]);
        }
        double convertErrorCount = this.convertStringToDoubleSetErrorCount(-1.0);
        if (convertErrorCount > 0.0) {
            this.m_warningMessages.add(Long.toString((long)convertErrorCount) + " missing values generated coercing from character to numeric");
        }
        BDLList retWarnings = new BDLList(this.m_warningMessages.size());
        for (int i5 = 0; i5 < this.m_warningMessages.size(); ++i5) {
            retWarnings.set(i5, Integer.toString(i5), (String)this.m_warningMessages.get(i5));
        }
        BDLList ret = new BDLList(5);
        ret.set(0, "error", retError);
        ret.set(1, "warnings", retWarnings);
        ret.set(2, "cancel", retCancel);
        ret.set(3, "outputs", retOutputs);
        ret.set(4, "dialog.props", retDialogProps);
        return ret;
    }

    public static void testEncodeCache(String cacheName, String fileName) throws Exception {
        Cache cache = new Cache(cacheName, BDLManager.getBDLManager().m_wsd);
        cache.writeToASCIIFile(fileName);
    }

    public static void testDecodeCache(String cacheName, String fileName) throws Exception {
        Cache cache = new Cache(cacheName, BDLManager.getBDLManager().m_wsd);
        cache.readFromASCIIFile(fileName);
    }

    public String getOutputFileName(String nodeID, int outputNum, String ext) {
        Cache[] outputCaches = (Cache[])this.m_nodeToOutputMap.get(nodeID);
        if (outputCaches == null || outputNum < 0 || outputNum >= outputCaches.length) {
            return super.getOutputFileName(nodeID, outputNum, ext);
        }
        return outputCaches[outputNum].getFilePathWithExt(ext);
    }

    public void unmapOutputFiles(String nodeName) {
        this.m_nodeToOutputMap.remove(nodeName);
    }

    public void createExecNode(String nodeName, int numInputs, Cache[] outputCaches, String engineNodeClass, BDLList lst) throws Exception {
        this.m_nodeToOutputMap.put(nodeName, outputCaches);
        XTProps nodeProps = BDLList.translateToXTProps(lst);
        String fullNodeName = engineNodeClass;
        int lastPeriodIndex = fullNodeName.lastIndexOf(SEPARATOR);
        if (lastPeriodIndex >= 0) {
            fullNodeName = fullNodeName.substring(lastPeriodIndex + 1);
        }
        this.createNode(nodeName, engineNodeClass, numInputs, outputCaches.length, nodeProps, fullNodeName, null, null, null);
    }

    public void createValidCacheNode(String nodeID, Cache outputCache) throws Exception {
        this.createExecNode(nodeID, 0, new Cache[]{outputCache}, PseudoNode.class.getName(), null);
        this.setNodeValid(nodeID, true);
        String outMDF = this.getOutputMetaDataFileName(nodeID, 0);
        try {
            XTMetaData md = XTMetaData.readXTMetaDataFromFile(outMDF);
            this.setOutputMetaData(nodeID, 0, md);
            this.getNodeInfo(nodeID).clearOutputMetaDataChanged(0);
        }
        catch (Exception ex) {
            this.println("exception reading meta-data file " + outMDF + ": " + BDLManager.getExceptionMessage(ex));
        }
        this.setHasOutputSummary(nodeID, 0, true);
        this.setHasOutputDCF(nodeID, 0, true);
    }

    public void showDataViewer(BDLList lst) throws Exception {
        if (System.getProperty("splus.session.id") != null) {
            throw new RuntimeException("Bigdata viewer cannot be displayed remotely.");
        }
        BDLList bdoSpec = lst.getValueBDLList("bdo");
        if (bdoSpec == null) {
            bdoSpec = lst.getValueBDLList(0);
        }
        Cache cache = new Cache(bdoSpec);
        String title = lst.getValueString("title", "data");
        this.getDBInfo(cache).addViewerCache(cache.getCacheName());
        BDOInfo bdo = this.getBDOInfo(cache);
        ActivityNodeModel model = bdo.getNodeModel();
        XTMetaData md = bdo.getEngineNode().getOutputMetaData(0);
        NodeViewer viewer = new NodeViewer(title, bdo.m_id, model, new XTMetaData[]{md}, false, 0);
        viewer.show();
    }

    public void flushViewerRefCounts() {
        try {
            ArrayList bdoCaches = Collections.list(this.m_cacheToBDOInfoMap.keys());
            for (int i = 0; i < bdoCaches.size(); ++i) {
                Cache cache = (Cache)bdoCaches.get(i);
                BDOInfo info = this.getBDOInfo(cache);
                String cacheName = cache.getCacheName();
                DBInfo db = this.getDBInfo(cache);
                while (db.m_cacheRefCounts.getViewerCacheRefCount(cacheName) > 0) {
                    db.m_cacheRefCounts.decrViewerCacheRefCount(cacheName);
                }
                info.m_model = null;
                this.flushBDOInfo(cache);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public BDOInfo getBDOInfoFromNodeID(String nodeID) {
        Enumeration e = this.m_cacheToBDOInfoMap.elements();
        while (e.hasMoreElements()) {
            BDOInfo info = (BDOInfo)e.nextElement();
            if (!nodeID.equals(info.getNodeID())) continue;
            return info;
        }
        return null;
    }

    public void nodeCloseDataViewerFiles(String nodeID) {
        try {
            EngineNode node = this.getNode(nodeID);
            if (node == null) {
                return;
            }
            node.closeDataViewerFiles();
            BDOInfo info = this.getBDOInfoFromNodeID(nodeID);
            if (info == null) {
                return;
            }
            Cache cache = info.m_cache;
            String cacheName = cache.getCacheName();
            DBInfo db = this.getDBInfo(cache);
            if (db.m_cacheRefCounts.getViewerCacheRefCount(cacheName) > 0) {
                db.m_cacheRefCounts.decrViewerCacheRefCount(cacheName);
                if (db.m_cacheRefCounts.getViewerCacheRefCount(cacheName) < 1) {
                    info.m_model = null;
                    this.flushBDOInfo(cache);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void removeDataViewer(BDLList lst) throws Exception {
        Cache cache = new Cache(lst.getValueBDLList(0));
        this.getDBInfo(cache).removeViewerCache(cache.getCacheName());
    }

    private int getNewNodeID() {
        return this.m_bdoIDCounter++;
    }

    public void initNodeModel(ActivityNodeModel model, int id) {
        this.initNodeModel(model, id, 0, 1, null);
    }

    public void initNodeModel(ActivityNodeModel model, int id, int numInputs, int numOutputs, XTProps props) {
        WorksheetDocument doc = MinerApp.getCurrentDoc();
        model.setID(id);
        model.setNumPorts(numInputs, numOutputs);
        model.setLabelText("Data Viewer");
        if (props != null) {
            model.setXTProps(props);
        }
        model.setDocument(doc);
        doc.resetEngineNetworkDirty();
    }

    public BDOInfo getBDOInfo(Cache cache) throws Exception {
        BDOInfo info = (BDOInfo)this.m_cacheToBDOInfoMap.get(cache);
        if (info == null) {
            info = new BDOInfo(cache);
            this.m_cacheToBDOInfoMap.put(cache, info);
        }
        return info;
    }

    public void flushBDOInfo(Cache cache) throws Exception {
        BDOInfo info = (BDOInfo)this.m_cacheToBDOInfoMap.get(cache);
        if (info == null) {
            return;
        }
        if (info.m_model != null) {
            return;
        }
        this.m_cacheToBDOInfoMap.remove(cache);
        this.unmapOutputFiles(info.getNodeID());
        this.removeNode(info.getNodeID());
    }

    public void printDebugInfo(BDLList lst) throws Exception {
        String guiXML = MinerApp.getCurrentDoc().getXTNetwork().writeToString();
        this.println("gui network:\n" + guiXML + "\n");
        Object[] nodes = this.getEngineNodes().toArray();
        this.println("engine network node count: " + nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            String node = (String)nodes[i];
            this.println("node " + i + ": " + node);
        }
        XMLTreeNetwork.Link[] links = this.getEngineLinks().toArray(new XMLTreeNetwork.Link[0]);
        this.println("engine network link count: " + links.length);
        for (int i = 0; i < links.length; ++i) {
            XMLTreeNetwork.Link link = links[i];
            this.println("link " + i + ": " + link);
        }
        this.println("m_cacheToBDOInfoMap=" + this.m_cacheToBDOInfoMap);
        this.println("m_nodeToOutputMap=" + this.m_nodeToOutputMap);
    }

    public void outputText(String msg, int severity, boolean addNewLine) {
        int sendSeverity = severity > 1 ? 1 : severity;
        BDLManager.sendMessageOutputText(this.getWorksheetID(), "BDL[" + severity + "] " + msg, sendSeverity, addNewLine);
        if (msg != null && msg.length() > 0) {
            if (severity == 3) {
                this.m_warningMessages.add(msg);
            } else if (severity >= 4) {
                this.m_errorMessages.add(msg);
            }
        }
    }

    public void println(String msg) {
        this.outputText(msg, 0, true);
    }

    public static void setMessageSeverity(BDLList lst) {
        String level = lst.getValueString("severity");
        BDLManager.setMessageSeverity(level);
    }

    public static void setMessageSeverity(String level) {
        if (level == null) {
            return;
        }
        level = level.toLowerCase();
        int msgSeverity = 0;
        if (level.equals("debug") || level.equals("all")) {
            msgSeverity = 0;
        } else if (level.equals("info")) {
            msgSeverity = 2;
        } else if (level.equals("warning")) {
            msgSeverity = 3;
        } else if (level.equals("error")) {
            msgSeverity = 4;
        } else if (level.equals("none")) {
            msgSeverity = 5;
        } else {
            return;
        }
        MinerApp.setLogMessageSeverity(msgSeverity);
        MinerApp.setMessageSeverity(msgSeverity);
    }

    public static int getCacheBytesPerRowStatic(String bdlCache, String bdlDir, int[] colNums) {
        try {
            return BDLManager.getBDLManager().getCacheBytesPerRow(new Cache(bdlCache, bdlDir), colNums);
        }
        catch (Exception exception) {
            return 0;
        }
    }

    public int getCacheBytesPerRow(Cache cache, int[] colNums) throws Exception {
        BDOInfo info = this.getBDOInfo(cache);
        if (info == null) {
            return 0;
        }
        String cacheNodeID = info.getNodeID();
        XTMetaData md = this.getOutputMetaData(cacheNodeID, 0);
        int bytesPerRow = DataCacheRowBuf.getDCFBytesPerRow(md, colNums);
        return bytesPerRow;
    }

    public static Object[] getOriginalDataStatic(String bdlCache, String bdlDir, int[] colNums, double fromRow, double toRow) {
        try {
            return BDLManager.getBDLManager().getOriginalData(new Cache(bdlCache, bdlDir), colNums, (long)fromRow, (long)toRow);
        }
        catch (Exception ex) {
            return new Object[0];
        }
    }

    public Object[] getOriginalData(Cache cache, int[] colNums, long fromRow, long toRow) throws Exception {
        int numRows = (int)(toRow - fromRow + 1L);
        BDOInfo info = this.getBDOInfo(cache);
        if (info == null) {
            return new Object[0];
        }
        String cacheNodeID = info.getNodeID();
        XTMetaData md = this.getOutputMetaData(cacheNodeID, 0);
        EngineNetworkManager.m_statBigToSmallBytes += (long)numRows * (long)DataCacheRowBuf.getDCFBytesPerRow(md, colNums);
        int numCols = colNums.length;
        Object[] data = this.getNode(cacheNodeID).getOriginalData(colNums, fromRow, numRows, 0, false);
        this.flushBDOInfo(cache);
        for (int col = 0; col < data.length; ++col) {
            Object[] transColumnData;
            Object columnData = data[col];
            if (columnData == null) continue;
            if (columnData instanceof String[]) {
                transColumnData = (String[])columnData;
                boolean isCategoricalColumn = md.isCategoricalColumn(colNums[col]);
                for (int row = 0; row < numRows; ++row) {
                    String str = transColumnData[row];
                    if (isCategoricalColumn && "NA".equals(str)) {
                        transColumnData[row] = "BDLManager.getOriginalData.NA.string";
                        continue;
                    }
                    if (!CNKObj.isStringNA(str)) continue;
                    transColumnData[row] = "NA";
                }
                continue;
            }
            if (!(columnData instanceof long[])) continue;
            transColumnData = (long[])columnData;
            int[] julianDays = new int[transColumnData.length];
            int[] msecs = new int[transColumnData.length];
            data[col] = new Object[]{julianDays, msecs};
            for (int row = 0; row < numRows; ++row) {
                String oneVal = transColumnData[row];
                if (CNKObj.isTimeDateNA((long)oneVal)) {
                    julianDays[row] = -1;
                    msecs[row] = -1;
                    continue;
                }
                julianDays[row] = (int)(oneVal / 86400000L) + 3653;
                msecs[row] = (int)(oneVal % 86400000L);
                if (msecs[row] >= 0) continue;
                int n = row;
                msecs[n] = msecs[n] + 86400000;
                int n2 = row;
                julianDays[n2] = julianDays[n2] - 1;
            }
        }
        return data;
    }

    public void closeDataViewerFiles(BDLList lst) {
        this.closeDataViewerFiles();
    }

    public static BDLList getUnivariateResults(BDLList arguments) {
        String key = (String)arguments.getValue("key");
        Object obj = GlobalObjectCache.get(key);
        if (obj instanceof BDLList) {
            return (BDLList)obj;
        }
        return new BDLList(0);
    }

    public static BDLList getCrosstabulateResults(BDLList arguments) {
        String key = (String)arguments.getValue("key");
        Object obj = GlobalObjectCache.get(key);
        if (obj instanceof BDLList) {
            return (BDLList)obj;
        }
        return new BDLList(0);
    }

    public static BDLList getClassificationAgreementResults(BDLList arguments) {
        String key = (String)arguments.getValue("key");
        Object obj = GlobalObjectCache.get(key);
        if (obj instanceof BDLList) {
            return (BDLList)obj;
        }
        return new BDLList(0);
    }

    public static BDLList getRegressionAgreementResults(BDLList arguments) {
        String key = (String)arguments.getValue("key");
        Object obj = GlobalObjectCache.get(key);
        if (obj instanceof BDLList) {
            return (BDLList)obj;
        }
        return new BDLList(0);
    }

    public static void testParseXML(String filename, int numRepeats, boolean asMDF, boolean printProgress) {
        for (int i = 0; i < numRepeats; ++i) {
            try {
                if (asMDF) {
                    XTMetaData md = XTMetaData.readXTMetaDataFromFile(filename);
                } else {
                    XMLTree tr = XMLTree.readFromFile(filename);
                }
                if (!printProgress) continue;
                System.out.print("<" + i + "/" + numRepeats + ">");
                continue;
            }
            catch (Exception ex) {
                System.out.println("exception: " + ex);
            }
        }
    }

    public static double getTotalMemory() {
        return Runtime.getRuntime().totalMemory();
    }

    public static double getFreeMemory() {
        return Runtime.getRuntime().freeMemory();
    }

    public static XTMetaData selectColumnsMetaData(XTMetaData inputMD, int[] inputColumnNums, Vector outputColumnNames) {
        XTMetaData md = null;
        try {
            if (inputMD == null) {
                inputMD = new XTMetaData();
            }
            md = new XTMetaData();
            for (int i = 0; i < inputColumnNums.length; ++i) {
                String newDatatype;
                String newRole;
                String specName;
                int colNum = inputColumnNums[i];
                if (colNum < 0) continue;
                String newName = inputMD.ordinalToName(colNum);
                if (!(outputColumnNames == null || i >= outputColumnNames.size() || (specName = (String)outputColumnNames.get(i)) == null && specName.equals(""))) {
                    newName = specName;
                }
                if ("".equals(newRole = inputMD.getColumnRole(colNum))) {
                    newRole = XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG;
                }
                if ("".equals(newDatatype = inputMD.getColumnType(colNum))) {
                    newDatatype = XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG;
                }
                if (newDatatype.equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG)) {
                    md.appendCategoricalDataField(newName, new String[0]);
                } else if (newDatatype.equals(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG)) {
                    int newStringWidth = inputMD.getStringDataFieldWidth(colNum);
                    md.appendStringDataField(newName, newStringWidth);
                } else if (newDatatype.equals(XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG)) {
                    md.appendDateTimeDataField(newName);
                } else if (newDatatype.equals(XTMetaData.BLOB_TYPE_ATTRIBUTE_TAG)) {
                    md.appendBlobDataField(newName, inputMD.getBlobDataFieldClassName(colNum));
                } else {
                    md.appendContinousDataField(newName);
                }
                md.setDataFieldRole(newName, newRole);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return md;
    }

    public static String callReadValuesHook(String cacheName, String oldDir, String newDir) {
        String val = null;
        try {
            val = BDLManager.getBDLManager().readValuesHook(cacheName, oldDir, newDir);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return val;
    }

    public static String callPutValuesHook(String cacheName, String oldDir, String newDir) {
        String val = null;
        try {
            val = BDLManager.getBDLManager().putValuesHook(cacheName, oldDir, newDir);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return val;
    }

    public static void callPutInDirHook(String varFileName, String dbDir) {
        try {
            BDLManager.getBDLManager().putInDirHook(varFileName, dbDir);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void callDoRmHook(String varFileName, String dbDir) {
        try {
            BDLManager.getBDLManager().doRmHook(varFileName, dbDir);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void callCommitAssignsHook(int error) {
        try {
            BDLManager.getBDLManager().commitAssignsHook(error);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static boolean callIsRegisteredMemref(long dataPtr) {
        boolean isReg = m_registeredDataHash.containsKey(new Long(dataPtr));
        return isReg;
    }

    private static String[] parseMemrefStrings(byte[] dataBytes) throws Exception {
        int numStrings = 0;
        int[] zeroIndex = new int[3];
        for (int i = 0; i < dataBytes.length && numStrings < 3; ++i) {
            if (dataBytes[i] != 0) continue;
            zeroIndex[numStrings++] = i;
        }
        if (numStrings < 3) {
            return null;
        }
        String s1 = new String(dataBytes, 0, zeroIndex[0], "UTF-8");
        if (!s1.equals(MEMREF_MAGIC_STRING)) {
            return null;
        }
        String cacheName = new String(dataBytes, zeroIndex[0] + 1, zeroIndex[1] - zeroIndex[0] - 1, "UTF-8");
        String dirName = new String(dataBytes, zeroIndex[1] + 1, zeroIndex[2] - zeroIndex[1] - 1, "UTF-8");
        return new String[]{cacheName, dirName};
    }

    public static boolean getRegisterCheck() {
        return m_registerCheck;
    }

    public static void setRegisterCheck(boolean val) {
        m_registerCheck = val;
    }

    public static void callRegisterMemref(byte[] dataBytes, long dataPtr) {
        try {
            if (BDLManager.callIsRegisteredMemref(dataPtr)) {
                if (m_registerCheck) {
                    System.out.println("callRegisterMemref: already registered: " + dataPtr);
                }
                return;
            }
            String[] memrefStrings = BDLManager.parseMemrefStrings(dataBytes);
            if (memrefStrings == null) {
                if (m_registerCheck) {
                    System.out.println("callRegisterMemref: bad databytes, dataPtr=" + dataPtr);
                }
                return;
            }
            Cache cache = new Cache(memrefStrings[0], memrefStrings[1]);
            m_registeredDataHash.put(new Long(dataPtr), cache);
            DBInfo db = BDLManager.getBDLManager().getDBInfo(cache);
            db.addMemref(cache.getCacheName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void callUnregisterMemref(byte[] dataBytes, long dataPtr) {
        try {
            Long key = new Long(dataPtr);
            Cache cache = (Cache)m_registeredDataHash.get(key);
            if (cache != null) {
                DBInfo db = BDLManager.getBDLManager().getDBInfo(cache);
                m_registeredDataHash.remove(key);
                db.removeMemref(cache.getCacheName());
                if (m_registerCheck) {
                    if (dataBytes == null) {
                        System.out.println("callUnregisterMemref: null databytes, dataPtr=" + dataPtr);
                    } else {
                        String[] memrefStrings = BDLManager.parseMemrefStrings(dataBytes);
                        if (memrefStrings == null) {
                            System.out.println("callUnregisterMemref: bad databytes, dataPtr=" + dataPtr);
                        } else {
                            Cache dataBytesCache = new Cache(memrefStrings[0], memrefStrings[1]);
                            if (!dataBytesCache.equals(cache)) {
                                System.out.println("callUnregisterMemref: bad databytes match: dataptr=" + dataPtr + ", databytes cache=" + dataBytesCache.getCacheName() + "," + dataBytesCache.getDirName() + ", registered cache=" + cache.getCacheName() + "," + cache.getDirName());
                            }
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static byte[] callCreateMemrefHook(String cacheName, String dbName) {
        byte[] ret = null;
        try {
            byte[] b1 = MEMREF_MAGIC_STRING.getBytes("UTF-8");
            byte[] b2 = cacheName.getBytes("UTF-8");
            byte[] b3 = dbName.getBytes("UTF-8");
            byte[] concatBytes = new byte[b1.length + 1 + b2.length + 1 + b3.length + 1];
            System.arraycopy(b1, 0, concatBytes, 0, b1.length);
            System.arraycopy(b2, 0, concatBytes, b1.length + 1, b2.length);
            System.arraycopy(b3, 0, concatBytes, b1.length + 1 + b2.length + 1, b3.length);
            ret = concatBytes;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ret;
    }

    public String readValuesHook(String cacheName, String oldDir, String newDir) {
        DBInfo newDirInfo;
        DBInfo oldDirInfo = this.getDBInfo(oldDir);
        DBInfo dBInfo = newDirInfo = newDir == null ? oldDirInfo : this.getDBInfo(newDir);
        if (oldDirInfo == newDirInfo) {
            return null;
        }
        return BDLManager.getBdoDir(newDir);
    }

    public String putValuesHook(String cacheName, String oldDir, String newDir) {
        DBInfo newDirInfo;
        DBInfo oldDirInfo = this.getDBInfo(oldDir);
        DBInfo dBInfo = newDirInfo = newDir == null ? oldDirInfo : this.getDBInfo(newDir);
        if (oldDirInfo == newDirInfo) {
            this.m_putValuesCacheList.add(cacheName);
            return null;
        }
        String newCacheName = newDirInfo.copyCache(cacheName, oldDirInfo);
        this.m_putValuesCacheList.add(newCacheName);
        return newCacheName;
    }

    public void putInDirHook(String varFileName, String dbDir) {
        this.doRmHook(varFileName, dbDir);
        if (!this.m_putValuesCacheList.isEmpty()) {
            this.getDBInfo(dbDir).setVarCaches(varFileName, new Vector(this.m_putValuesCacheList));
            this.m_putValuesCacheList.clear();
        }
    }

    public void doRmHook(String varFileName, String dbDir) {
        this.getDBInfo(dbDir).removeVarCaches(varFileName);
    }

    public void commitAssignsHook(int error) {
        if (error == 0) {
            for (int i = 0; i < this.m_dbInfoList.size(); ++i) {
                DBInfo dbi = (DBInfo)this.m_dbInfoList.get(i);
                dbi.commitAssigns();
            }
        }
    }

    private DBInfo getDBInfo() {
        return this.getDBInfo(this.m_wsd);
    }

    private DBInfo getDBInfo(Cache cache) {
        return this.getDBInfo(cache.getDirName());
    }

    private DBInfo getCachedDBInfo(String dbDir) {
        return (DBInfo)this.m_dbInfoHash.get(dbDir);
    }

    private void setCachedDBInfo(String dbDir, DBInfo dbi) {
        if (dbDir == null) {
            this.m_dbInfoHash.remove(dbDir);
        } else {
            this.m_dbInfoHash.put(dbDir, dbi);
        }
    }

    private DBInfo getDBInfo(String dbDir) {
        DBInfo dbi = this.getCachedDBInfo(dbDir);
        if (dbi != null) {
            return dbi;
        }
        String bdoDir = BDLManager.getBdoDir(dbDir);
        dbi = this.getCachedDBInfo(bdoDir);
        if (dbi != null) {
            this.setCachedDBInfo(dbDir, dbi);
            this.println("registering DBInfo for " + dbDir + " -> " + bdoDir);
            return dbi;
        }
        dbi = bdoDir.startsWith(READ_ONLY_DIR_PREFIX) ? new ReadOnlyDBInfo(bdoDir) : new DBInfo(bdoDir);
        this.println("creating new DBInfo for " + bdoDir);
        this.setCachedDBInfo(bdoDir, dbi);
        this.m_dbInfoList.add(dbi);
        this.println("registering DBInfo for " + dbDir + " -> " + bdoDir);
        this.setCachedDBInfo(dbDir, dbi);
        return dbi;
    }

    static String getBdoDir(String dbDir) {
        if (dbDir.startsWith(READ_ONLY_DIR_PREFIX)) {
            return dbDir;
        }
        File f = new File(dbDir);
        if (!f.getName().equals("__bdo")) {
            f = new File(f, "__bdo");
        }
        return f.getAbsolutePath();
    }

    public static void copyDataBytes(DataInputStream in, DataOutputStream out) throws Exception {
        int len;
        byte[] buf = new byte[32768];
        while ((len = in.read(buf)) >= 0) {
            out.write(buf, 0, len);
        }
    }

    public static String getSavedXMLTreeAsString() {
        try {
            BDLManager mgr = BDLManager.getBDLManager();
            XMLTree tree = mgr.m_savedModel;
            mgr.m_savedModel = null;
            return tree.writeToString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static boolean writeSavedXMLTreeToFile(String filename) {
        boolean ok = false;
        try {
            BDLManager mgr = BDLManager.getBDLManager();
            XMLTree tree = mgr.m_savedModel;
            mgr.m_savedModel = null;
            tree.saveToFile(filename);
            ok = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ok;
    }

    public static void viewPredictModel() {
        try {
            BDLManager mgr = BDLManager.getBDLManager();
            XMLTree tree = mgr.m_savedModel;
            mgr.m_savedModel = null;
            if (tree == null) {
                mgr.println("viewPredictModel: null saved model");
                return;
            }
            ModelViewerNodeModel nodeModel = new ModelViewerNodeModel();
            nodeModel.setFittedModel(tree);
            int newID = mgr.getNewNodeID();
            mgr.initNodeModel(nodeModel, newID);
            nodeModel.showView(MinerApp.getMainFrame());
            WorksheetDocument doc = MinerApp.getCurrentDoc();
            BaseNodeArea viewerModelArea = doc.findNodeByID(newID);
            if (viewerModelArea != null) {
                doc.removeObject((JGoObject)viewerModelArea);
                doc.resetEngineNetworkDirty();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void testbedCreateProc(String libraryFile, String classname) {
        m_testbedCNKProcClass = classname;
        m_testbedCNKProcLibrary = libraryFile;
        m_testbedCNKProc = new CNKProc(){

            public void createPeerObject() {
                this.createCNKObject(m_testbedCNKProcLibrary, new String[]{m_testbedCNKProcClass, "CNKProc", "CNKObj"});
            }
        };
    }

    public static void testbedDestroyProc() {
        if (m_testbedCNKProc != null) {
            m_testbedCNKProc.destroyCNKObj();
            m_testbedCNKProc = null;
        }
    }

    public static void testbedSetProperty(String propname, String arg1, String arg2, String arg3) throws Exception {
        if (m_testbedCNKProc == null) {
            throw new Exception("no testbed object");
        }
        m_testbedCNKProc.setProp(propname, new Object[]{arg1, arg2, arg3});
    }

    public static String testbedGetProperty(String propname, String arg1, String arg2, String arg3) throws Exception {
        if (m_testbedCNKProc != null) {
            return m_testbedCNKProc.getStringProp(propname, new Object[]{arg1, arg2, arg3});
        }
        throw new Exception("no testbed object");
    }

    public static void putDialogOnTop(final JDialog dlg) {
        if (!MinerApp.getMainFrame().isVisible() && MinerApp.isWindowsOS()) {
            Thread visThread = new Thread(){

                public void run() {
                    do {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    } while (!dlg.isVisible());
                    SplusWin32Tools.setForegroundWindow((Dialog)dlg);
                }
            };
            visThread.start();
        }
    }

    public static BDLList getIMWInfo(BDLList arguments) {
        try {
            String modelPrefix;
            String imwFileName = (String)arguments.getValue("imwFilename");
            String varPrefix = (String)arguments.getValue("varPrefix");
            if (varPrefix == null) {
                varPrefix = "var.bdo";
            }
            if ((modelPrefix = (String)arguments.getValue("modelPrefix")) == null) {
                modelPrefix = "model.bdo";
            }
            File imwFile = new File(imwFileName);
            XTNetwork network = XTNetwork.readXTNetworkFromFile(imwFileName);
            if (network == null) {
                throw new Exception("failed to read file");
            }
            WorksheetDocument doc = WorksheetDocument.open(imwFile);
            if (doc == null) {
                throw new Exception("document could not be created");
            }
            doc.setWorksheetID("");
            doc.setLocation("");
            String worksheetID = MinerApp.getCurrentWorksheetID(doc);
            MinerApp.saveGuiNetworkToEngine(doc);
            Object obj = GuiMessageHandler.sendMessageToEngine(worksheetID, null, "getSortedNodes", null);
            if (obj == null || !(obj instanceof List)) {
                throw new Exception("sort failed");
            }
            List list = (List)obj;
            BDLList retList = new BDLList(list.size());
            for (int i = 0; i < list.size(); ++i) {
                String id = (String)list.get(i);
                BDLList nodeInfo = BDLManager.getFunctionInfo(id, varPrefix, modelPrefix, network);
                retList.set(i, id, nodeInfo);
            }
            MinerApp.closeDocWorksheet(doc);
            return retList;
        }
        catch (Exception e) {
            BDLList error = new BDLList(1);
            error.set(0, "error", e.getMessage());
            return error;
        }
    }

    public static BDLList getFunctionInfo(String nodeID, String varPrefix, String modelPrefix, XTNetwork network) {
        BDLList emptyList = new BDLList(0);
        try {
            XTNetwork.NodeInfo nodeInfo = network.getNodeInfo(nodeID);
            if (nodeInfo == null) {
                return emptyList;
            }
            String outputVarName = "";
            if (nodeInfo != null && nodeInfo.numOutputs > 0) {
                outputVarName = varPrefix + SEPARATOR + nodeID;
            }
            String outputModelVarName = "";
            try {
                Class<?> cl = Class.forName(nodeInfo.guiClass);
                Class<?> superClass = cl.getSuperclass();
                while (!superClass.equals(Object.class)) {
                    if (superClass.equals(PredictableNodeModel.class)) {
                        outputModelVarName = modelPrefix + SEPARATOR + nodeID;
                        break;
                    }
                    superClass = superClass.getSuperclass();
                }
            }
            catch (ClassNotFoundException cnfe) {
                outputModelVarName = "";
            }
            int i = 0;
            BDLList retVal = new BDLList(g_returnValueNames.length);
            retVal.set(i, g_returnValueNames[i++], nodeInfo.engineClass);
            retVal.set(i, g_returnValueNames[i++], nodeInfo.guiClass);
            retVal.set(i, g_returnValueNames[i++], BDLList.translateFromXTProps(nodeInfo.properties));
            retVal.set(i, g_returnValueNames[i++], BDLManager.getFunctionInputs(nodeID, varPrefix, network));
            retVal.set(i, g_returnValueNames[i++], BDLManager.getFunctionModelInput(nodeID, modelPrefix, network));
            retVal.set(i, g_returnValueNames[i++], Integer.toString(nodeInfo.numOutputs));
            retVal.set(i, g_returnValueNames[i++], outputVarName);
            retVal.set(i, g_returnValueNames[i++], outputModelVarName);
            retVal.set(i, g_returnValueNames[i++], nodeInfo.labelText);
            return retVal;
        }
        catch (Exception e) {
            e.printStackTrace();
            return emptyList;
        }
    }

    static BDLList getFunctionModelInput(String nodeID, String modelPrefix, XTNetwork network) {
        try {
            XTNetwork.NodeInfo nodeInfo = network.getNodeInfo(nodeID);
            if (nodeInfo.model != null && nodeInfo.model.modelString != null) {
                BDLList outputList = new BDLList(2);
                outputList.set(0, "modelVar", modelPrefix + SEPARATOR + nodeID);
                outputList.set(1, "modelString", nodeInfo.model.modelString.replaceAll("\"", "\\\\\""));
                return outputList;
            }
            if (nodeInfo.modelParent != null) {
                BDLList outputList = new BDLList(2);
                outputList.set(0, "modelVar", modelPrefix + SEPARATOR + nodeID);
                outputList.set(1, "modelSource", modelPrefix + SEPARATOR + nodeInfo.modelParent);
                return outputList;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new BDLList(0);
    }

    static BDLList getFunctionInputs(String nodeID, String varPrefix, XTNetwork network) {
        try {
            BDLList emptyBDLList = new BDLList(0);
            if (network == null) {
                return emptyBDLList;
            }
            XTNetwork.NodeInfo nodeInfo = network.getNodeInfo(nodeID);
            Vector links = network.getFlatLinks();
            int numInputs = nodeInfo.numInputs;
            if (numInputs == -1) {
                numInputs = 0;
                for (int i = 0; i < links.size(); ++i) {
                    XTNetwork.LinkInfo linkInfo = (XTNetwork.LinkInfo)links.get(i);
                    if (!nodeID.equals(linkInfo.m_toNode)) continue;
                    ++numInputs;
                }
            }
            BDLList retList = new BDLList(numInputs);
            boolean hasContents = false;
            int inputs = 0;
            for (int i = 0; i < links.size(); ++i) {
                int toPort;
                XTNetwork.LinkInfo linkInfo = (XTNetwork.LinkInfo)links.get(i);
                if (!nodeID.equals(linkInfo.m_toNode)) continue;
                XTNetwork.NodeInfo fromNI = network.getNodeInfo(linkInfo.m_fromNode);
                String inputName = varPrefix + SEPARATOR + linkInfo.m_fromNode;
                if (fromNI.numOutputs > 1) {
                    inputName = inputName + SPLUS_LIST_BRACKET_START + (linkInfo.m_fromPort + 1) + SPLUS_LIST_BRACKET_END;
                }
                if ((toPort = linkInfo.m_toPort) == -1) {
                    toPort = inputs;
                }
                retList.set(toPort, inputName, inputName);
                ++inputs;
            }
            if (inputs == retList.getLength()) {
                return retList;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new BDLList(0);
    }

    public static BDLList getSplusGraphCode(BDLList arguments) {
        try {
            XTProps props = BDLList.translateToXTProps((BDLList)arguments.getValue("graph.args"));
            String code = SplusGraphEngineNode.getTransformFunctionBody(props, BDLManager.getBDLManager());
            BDLList retVal = new BDLList(1);
            retVal.set(0, "splus.code", code);
            return retVal;
        }
        catch (Exception e) {
            BDLList error = new BDLList(1);
            error.set(0, "error", e.getMessage());
            return error;
        }
    }

    public static BDLList parseSQL(BDLList arguments) {
        try {
            BDLList sqlList = (BDLList)arguments.getValue("sql");
            BDLList mdList = (BDLList)arguments.getValue("md");
            BigDataCommandInterpreter sqlInterp = new BigDataCommandInterpreter();
            Hashtable<String, XTMetaData> mdMap = new Hashtable<String, XTMetaData>(mdList.getLength());
            for (int i = 0; i < mdList.getLength(); ++i) {
                BDLList md = mdList.getValueBDLList(i);
                String mdName = mdList.getName(i);
                mdMap.put(mdName, BDLList.translateToXTMetaData(md));
            }
            BDLList result = new BDLList(sqlList.getLength());
            for (int i = 0; i < sqlList.getLength(); ++i) {
                String sql = sqlList.getValueString(i);
                result.set(i, sql, sqlInterp.execute(sql, mdMap));
            }
            return result;
        }
        catch (Exception exception) {
            return BigDataCommandInterpreter.noResult;
        }
    }

    public static void setProgressBarDefaults(String viewer, boolean windowsSupported) {
        m_progressBarDefaultViewer = viewer;
        m_progressBarWindowsSupported = windowsSupported;
    }

    public static void showProgressBar(boolean show, String viewer) {
        boolean wantWindowsViewer;
        String string = viewer = viewer == null ? "" : viewer.toLowerCase();
        if (!viewer.equals("java") && !viewer.equals("windows")) {
            viewer = m_progressBarDefaultViewer;
        }
        boolean bl = wantWindowsViewer = viewer.equals("windows") && m_progressBarWindowsSupported;
        if (m_progressBarEnabled && (!show || wantWindowsViewer != m_progressBarIsWindows)) {
            if (m_progressBarIsWindows) {
                BDLManager.windowsProgressBarEnd();
            } else {
                EngineMessageHandler.sendMessageToApp("showBDLProgress", new Object[]{new Boolean(false)});
            }
            m_progressBarEnabled = false;
        }
        if (show && !m_progressBarEnabled) {
            if (wantWindowsViewer) {
                BDLManager.windowsProgressBarStart("", 0);
            } else {
                EngineMessageHandler.sendMessageToApp("showBDLProgress", new Object[]{new Boolean(true)});
            }
            m_progressBarIsWindows = wantWindowsViewer;
            m_progressBarEnabled = true;
            m_progressBarLastMessage = "";
        }
    }

    public static void setProgressBarMessage(String msg) {
        if (m_progressBarEnabled) {
            if (m_progressBarIsWindows) {
                BDLManager.windowsProgressBarSetMessage(msg);
            } else {
                EngineMessageHandler.sendMessageToApp("setStatusText", new Object[]{msg});
            }
        }
    }

    public native void nativeWindowsProgressBarStart(String var1, int var2);

    public native void nativeWindowsProgressBarSetMessage(String var1);

    public native void nativeWindowsProgressBarSetPos(int var1);

    public native void nativeWindowsProgressBarAdvance();

    public native void nativeWindowsProgressBarEnd();

    public static boolean windowsProgressBarEnabled() {
        return m_progressBarEnabled && m_progressBarIsWindows;
    }

    public static void windowsProgressBarStart(String msg, int pos) {
        m_progressBarLastMessage = msg;
        try {
            if (!m_progressBarEnabled && m_progressBarWindowsSupported) {
                BDLManager.getBDLManager().nativeWindowsProgressBarStart(msg, pos);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void windowsProgressBarEnd() {
        try {
            if (m_progressBarEnabled && m_progressBarWindowsSupported) {
                BDLManager.getBDLManager().nativeWindowsProgressBarEnd();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String windowsProgressBarGetMessage() {
        return m_progressBarLastMessage;
    }

    public static void windowsProgressBarSetMessage(String msg) {
        m_progressBarLastMessage = msg;
        try {
            if (m_progressBarEnabled && m_progressBarWindowsSupported) {
                BDLManager.getBDLManager().nativeWindowsProgressBarSetMessage(msg);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void windowsProgressBarSetPos(int percent) {
        try {
            if (m_progressBarEnabled && m_progressBarWindowsSupported) {
                BDLManager.getBDLManager().nativeWindowsProgressBarSetPos(percent);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void windowsProgressBarSameDone() {
    }

    public void setStatusExecuting(List subgraph) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < subgraph.size(); ++i) {
            if (i > 0) {
                buf.append(",");
            }
            String nodeID = (String)subgraph.get(i);
            buf.append(this.getSimpleNodeName(nodeID));
        }
        BDLManager.setProgressBarMessage(buf.toString());
    }

    public void setStatusExecuting(String nodeID) {
        BDLManager.setProgressBarMessage(this.getSimpleNodeName(nodeID));
    }

    private String getSimpleNodeName(String nodeID) {
        int i;
        EngineNetworkManager.NodeInfo info = this.getNodeInfo(nodeID);
        String nm = info.m_engineNodeClassName;
        if (nm == null) {
            nm = "";
        }
        if ((i = nm.toLowerCase().indexOf("enginenode")) >= 0) {
            nm = nm.substring(0, i);
        }
        if ((i = nm.lastIndexOf(SEPARATOR)) >= 0) {
            nm = nm.substring(i + 1);
        }
        if (nm.startsWith("BDLManager$")) {
            nm = nm.substring(nm.indexOf("$") + 1);
        }
        return nm;
    }

    public native boolean nativeWindowsIsBreakOn();

    public static void setESCCheckEnabled(boolean val) {
        m_ESCCheckEnabled = val;
    }

    public void clearInterruptRequested() {
        this.m_interruptRequested = false;
    }

    public boolean isInterruptRequested() {
        long now;
        if (this.m_interruptRequested) {
            return true;
        }
        if (m_ESCCheckEnabled && (now = System.currentTimeMillis()) - m_ESCCheckTime > 300L) {
            m_ESCCheckTime = now;
            try {
                if (BDLManager.getBDLManager().nativeWindowsIsBreakOn()) {
                    this.m_interruptRequested = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.m_interruptRequested;
    }

    public static boolean encodeCacheStart(String cacheName, String dirName) {
        boolean ok = false;
        try {
            BDLManager.getBDLManager().clearInterruptRequested();
            Cache dataCache = new Cache(cacheName, dirName);
            m_encodeTempFile = dataCache.getTempFile("enc", "txt");
            boolean encode_ok = dataCache.writeToASCIIFile(m_encodeTempFile);
            if (!encode_ok) {
                throw new Exception("bad encoding");
            }
            m_encodeInputStream = new BufferedInputStream(new FileInputStream(m_encodeTempFile));
            ok = true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (!ok) {
            BDLManager.encodeCacheEnd();
        }
        return ok;
    }

    public static String encodeCacheGetNextString() {
        try {
            if (m_encodeLineCount < 1000) {
                ++m_encodeLineCount;
            } else {
                m_encodeLineCount = 0;
                if (BDLManager.getBDLManager().isInterruptRequested()) {
                    throw new Exception("interrupt");
                }
            }
            if (m_encodeInputStream != null) {
                return Cache.readLine(m_encodeInputStream);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        BDLManager.encodeCacheEnd();
        return null;
    }

    public static boolean encodeCacheEnd() {
        boolean ok;
        boolean bl = ok = m_encodeInputStream != null && m_encodeTempFile != null;
        if (m_encodeInputStream != null) {
            try {
                m_encodeInputStream.close();
                m_encodeInputStream = null;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (m_encodeTempFile != null) {
            try {
                m_encodeTempFile.delete();
                m_encodeTempFile = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ok;
    }

    public static boolean decodeCacheStart() {
        try {
            m_tempOK = false;
            m_decodeCacheOK = false;
            BDLManager.getBDLManager().clearInterruptRequested();
            m_decodeCache = BDLManager.getBDLManager().getDBInfo().getNewCache();
            m_decodeTempFile = m_decodeCache.getTempFile("dec", "txt");
            m_decodeOutputStream = new BufferedOutputStream(new FileOutputStream(m_decodeTempFile));
            m_tempOK = true;
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            m_tempOK = false;
            BDLManager.decodeCacheEnd();
            return false;
        }
    }

    public static boolean decodeCachePutNextString(String str) {
        if (!m_tempOK) {
            return false;
        }
        try {
            if (m_decodeOutputStream != null && str != null) {
                if (m_encodeLineCount < 1000) {
                    ++m_encodeLineCount;
                } else {
                    m_encodeLineCount = 0;
                    if (BDLManager.getBDLManager().isInterruptRequested()) {
                        throw new Exception("interrupt");
                    }
                }
                Cache.writeLine(BDLManager.m_decodeOutputStream, str);
                return !Cache.equalLine(str, Cache.END_CACHE_TAG);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        m_tempOK = false;
        BDLManager.decodeCacheEnd();
        return false;
    }

    public static void decodeCacheEnd() {
        if (m_decodeOutputStream != null) {
            try {
                m_decodeOutputStream.flush();
                m_decodeOutputStream.close();
                m_decodeOutputStream = null;
            }
            catch (Exception ex) {
                m_tempOK = false;
            }
        }
        if (!m_decodeCacheOK && m_decodeTempFile != null) {
            try {
                m_decodeCacheOK = m_decodeCache.readFromASCIIFile(m_decodeTempFile);
            }
            catch (Exception ex) {
                m_decodeCacheOK = false;
            }
        }
        if (m_decodeTempFile != null) {
            try {
                m_decodeTempFile.delete();
                m_decodeTempFile = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String decodeCacheGetCache() {
        BDLManager.decodeCacheEnd();
        return m_decodeCacheOK && m_decodeCache != null ? m_decodeCache.getCacheName() : null;
    }

    public static String decodeCacheGetDir() {
        BDLManager.decodeCacheEnd();
        return m_decodeCacheOK && m_decodeCache != null ? m_decodeCache.getDirName() : null;
    }

    private XTProps getBDLWorksheetProps() {
        try {
            if (this.m_BDLWorksheetProps == null) {
                this.m_BDLWorksheetProps = new XTProps();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.m_BDLWorksheetProps;
    }

    public void setWorksheetProp(String propName, int val) {
        XTProps props = this.getBDLWorksheetProps();
        if (props.getInt(propName, val + 1) != val) {
            props.set(propName, val);
            this.storeWorksheetProperties(props);
        }
    }

    public void setWorksheetProp(String propName, String val) {
        XTProps props = this.getBDLWorksheetProps();
        if (val == null) {
            val = "";
        }
        if (!val.equals(props.getValue(propName, null))) {
            props.set(propName, val);
            this.storeWorksheetProperties(props);
        }
    }

    public void setWorksheetProp(String propName, boolean val) {
        XTProps props = this.getBDLWorksheetProps();
        if (val != props.getBoolean(propName, !val)) {
            props.set(propName, val);
            this.storeWorksheetProperties(props);
        }
    }

    public static void clearMaxCacheRefs() {
        m_maxCacheRefs = 0;
    }

    public static int getMaxCacheRefs() {
        return m_maxCacheRefs;
    }

    private static String[] getStringArray(List lst) {
        String[] ret = new String[lst.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = String.valueOf(lst.get(i));
        }
        return ret;
    }

    public static Object[] getCacheRefInfo(String dir) {
        try {
            DBInfo db = BDLManager.getBDLManager().getDBInfo(dir);
            Hashtable cacheToRefCounts = db.m_cacheRefCounts.m_cacheToRefCounts;
            ArrayList knownCaches = Collections.list(cacheToRefCounts.keys());
            Collections.sort(knownCaches);
            String[] knownCachesArray = BDLManager.getStringArray(knownCaches);
            int[] fileRefs = new int[knownCachesArray.length];
            int[] memRefs = new int[knownCachesArray.length];
            int[] viewRefs = new int[knownCachesArray.length];
            for (int i = 0; i < knownCachesArray.length; ++i) {
                String cache = (String)knownCaches.get(i);
                int[] box = (int[])cacheToRefCounts.get(cache);
                fileRefs[i] = box[0];
                memRefs[i] = box[1];
                viewRefs[i] = box[2];
            }
            ArrayList newCaches = new ArrayList(db.m_newCacheSet);
            Collections.sort(newCaches);
            String[] newCachesArray = BDLManager.getStringArray(newCaches);
            Vector<Long> dataLocs = new Vector<Long>();
            Enumeration e = m_registeredDataHash.keys();
            while (e.hasMoreElements()) {
                Long dataPtr = (Long)e.nextElement();
                Cache cache = (Cache)m_registeredDataHash.get(dataPtr);
                if (!cache.getDirName().equals(db.getDir())) continue;
                dataLocs.add(dataPtr);
            }
            Collections.sort(dataLocs, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Cache c1 = (Cache)m_registeredDataHash.get(o1);
                    Cache c2 = (Cache)m_registeredDataHash.get(o2);
                    return c1.getCacheName().compareTo(c2.getCacheName());
                }
            });
            double[] dataLocArray = new double[dataLocs.size()];
            String[] dataCacheArray = new String[dataLocs.size()];
            for (int i = 0; i < dataLocs.size(); ++i) {
                Long dataLoc = (Long)dataLocs.get(i);
                dataLocArray[i] = dataLoc.longValue();
                Cache c = (Cache)m_registeredDataHash.get(dataLoc);
                dataCacheArray[i] = c.getCacheName();
            }
            return new Object[]{knownCachesArray, fileRefs, memRefs, viewRefs, newCachesArray, dataCacheArray, dataLocArray};
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static void printCacheRefCounts() {
        try {
            int i;
            Object[] values = BDLManager.getCacheRefInfo(BDLManager.getBDLManager().getDBInfo().getDir());
            if (values == null) {
                System.out.println("no values to print");
                return;
            }
            String[] knownCaches = (String[])values[0];
            int[] fileRefs = (int[])values[1];
            int[] memRefs = (int[])values[2];
            int[] viewRefs = (int[])values[3];
            String[] newCaches = (String[])values[4];
            String[] dataCacheArray = (String[])values[5];
            double[] dataLocArray = (double[])values[6];
            int[] boxSums = new int[3];
            System.out.println("known caches: " + knownCaches.length);
            for (i = 0; i < knownCaches.length; ++i) {
                if (i < 20) {
                    System.out.println("cache: " + knownCaches[i] + ": refs=" + fileRefs[i] + "," + memRefs[i] + "," + viewRefs[i]);
                }
                boxSums[0] = boxSums[0] + fileRefs[i];
                boxSums[1] = boxSums[1] + memRefs[i];
                boxSums[2] = boxSums[2] + viewRefs[i];
            }
            System.out.println("ref sums=" + boxSums[0] + "," + boxSums[1] + "," + boxSums[2]);
            System.out.println("new cache size: " + newCaches.length);
            for (i = 0; i < newCaches.length; ++i) {
                if (i >= 20) continue;
                System.out.println("new cache: " + newCaches[i]);
            }
            System.out.println("registered data objs: " + dataCacheArray.length);
            for (i = 0; i < dataCacheArray.length; ++i) {
                if (i >= 20) continue;
                System.out.println("dataLoc: " + dataLocArray[i] + ", cache=" + dataCacheArray[i]);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void clearRegisteredDataObjects() {
        try {
            ArrayList dataPtrs = Collections.list(m_registeredDataHash.keys());
            for (int i = 0; i < dataPtrs.size(); ++i) {
                Long dataPtr = (Long)dataPtrs.get(i);
                BDLManager.callUnregisterMemref(null, dataPtr);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void setExecNodeDoubleDateEpoch(double val) {
        m_execNodeDoubleDateEpoch = val;
    }

    public static double getExecNodeDoubleDateEpoch() {
        return m_execNodeDoubleDateEpoch;
    }

    public EngineStringConverter getEngineStringConverter(String parserString, String formatterString) {
        return new BDLEngineStringConverter(this.getWorksheetPropertiesManager(), parserString, formatterString);
    }

    private boolean isNativeConvertEnabled() {
        if (!this.m_initNativeConvertDoubleToString) {
            this.m_enabledNativeConvertDoubleToString = false;
            try {
                this.nativeConvertStringToDoubleSetErrorCount(0.0);
                this.nativeConvertDoubleToString(5.0);
                this.nativeConvertStringToDouble("5.0");
                this.m_enabledNativeConvertDoubleToString = true;
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
            this.m_initNativeConvertDoubleToString = true;
        }
        return this.m_enabledNativeConvertDoubleToString;
    }

    public double convertStringToDoubleSetErrorCount(double val) {
        if (this.isNativeConvertEnabled()) {
            return this.nativeConvertStringToDoubleSetErrorCount(val);
        }
        return 0.0;
    }

    public native String nativeConvertDoubleToString(double var1);

    public native double nativeConvertStringToDouble(String var1);

    public native double nativeConvertStringToDoubleSetErrorCount(double var1);

    public CNKProcSplusTransform createSplusProc() throws Exception {
        CNKProcSplusTransform proc = new CNKProcSplusTransform();
        proc.setMangleColumnNames(false);
        return proc;
    }

    public static String setWorksheetDirPath(String dir) throws Exception {
        BDLManager mgr = BDLManager.getBDLManager();
        String oldDir = mgr.m_wsd;
        if (dir != null && dir.length() > 0) {
            File newDir = new File(dir);
            if (!newDir.getName().equals("__bdo")) {
                if (!newDir.getName().equals(".Data") && new File(newDir, ".Data").isDirectory()) {
                    newDir = new File(newDir, ".Data");
                }
                newDir = new File(newDir, "__bdo");
            }
            String newDirString = newDir.getAbsolutePath();
            if (!newDir.isDirectory() && !newDir.mkdirs()) {
                throw new Exception("Unable to create directory: " + newDirString);
            }
            mgr.m_wsd = newDirString;
            mgr.m_worksheetDirPath = newDirString;
        }
        return oldDir;
    }

    public class BDLEngineStringConverter
    extends EngineStringConverter {
        public BDLEngineStringConverter(WorksheetPropertiesManager wpm, String parserString, String formatterString) {
            super(wpm, parserString, formatterString);
        }

        public String convertDoubleToString(double val) {
            if (Double.isNaN(val)) {
                return "NA";
            }
            if (Double.isInfinite(val)) {
                return val > 0.0 ? "Inf" : "-Inf";
            }
            if (val == 0.0) {
                return "0";
            }
            if (BDLManager.this.isNativeConvertEnabled()) {
                return BDLManager.this.nativeConvertDoubleToString(val);
            }
            return super.convertDoubleToString(val);
        }

        public double convertStringToDouble(String val) {
            if (CNKObj.isStringNA(val)) {
                return CNKObj.getDoubleNA();
            }
            if (BDLManager.this.isNativeConvertEnabled()) {
                return BDLManager.this.nativeConvertStringToDouble(val);
            }
            return super.convertStringToDouble(val);
        }
    }

    public static class RecodeFactorsEngineNode
    extends EngineNode
    implements CNKProcJavaTransformExec {
        static String[][] m_newLevels = null;

        public static void clearNewLevels() {
            m_newLevels = null;
        }

        public static void initNewLevels(int num) {
            m_newLevels = new String[num][];
        }

        public static void setNewLevels(int colNum, String[] newLevels) {
            if (m_newLevels != null && colNum >= 0 && colNum < m_newLevels.length) {
                RecodeFactorsEngineNode.m_newLevels[colNum] = newLevels;
            }
        }

        public CNKProc procCreate() throws Exception {
            return new CNKProcJavaTransform(this);
        }

        public XTMetaData calculateOutputMetaData(int outputNum) {
            XTMetaData md = null;
            try {
                md = (XTMetaData)this.getInputMetaData(0).clone();
                int numColumns = md.getNumColumns();
                for (int i = 0; i < numColumns; ++i) {
                    if (!md.isCategoricalColumn(i) || m_newLevels == null || i >= m_newLevels.length || m_newLevels[i] == null) continue;
                    String colName = md.ordinalToName(i);
                    md.setCategoricalLevels(colName, m_newLevels[i]);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return md;
        }

        public void execute(CNKProcJavaTransform proc) {
            int inputRows = proc.getChunkInputRows(0);
            if (inputRows > 0) {
                proc.copyData(0, 0, 0, 0, 0, 0, inputRows, this.getInputMetaData(0).getNumColumns());
            }
        }

        public EngineNode.InputRequirements getInputRequirements(int inputNum) {
            return EngineNode.InputRequirements.getMinRequirements();
        }
    }

    public static class ReadDataFrameEngineNode
    extends EngineNode {
        private static String m_dataAddr;
        private static int m_dataFrameNumber;
        private static int[] m_colNums;
        private static long m_fromRow;
        private static long m_toRow;

        public static void initDataFrame(String dataAddr, int dataFrameNumber, int[] colNums, double fromRow, double toRow) {
            m_dataAddr = dataAddr;
            m_dataFrameNumber = dataFrameNumber;
            m_colNums = colNums;
            m_fromRow = (long)fromRow;
            m_toRow = (long)toRow;
        }

        public boolean hasCNKProc() {
            return true;
        }

        public boolean hasDataCacheProc() {
            return false;
        }

        public CNKProc procCreate() throws Exception {
            if (m_dataAddr == null || m_toRow < m_fromRow || m_colNums == null) {
                throw new Exception("ReadDataFrameEngineNode: bad specs");
            }
            CNKProcConvertDataFrame proc = new CNKProcConvertDataFrame();
            proc.setDataAddress(m_dataAddr);
            proc.setDataFrameNumber(m_dataFrameNumber);
            proc.setWrite(false);
            proc.setSelectedRows(m_fromRow, m_toRow);
            proc.setSelectedColumns(m_colNums);
            return proc;
        }

        public EngineNode.InputRequirements getInputRequirements(int inputNum) {
            return EngineNode.InputRequirements.getMinRequirements();
        }
    }

    public static class WriteDataFrameEngineNode
    extends EngineNode {
        private static int m_dfNumRows;
        private static int m_dfNumCols;
        private static String[] m_dfColNames;
        private static String[] m_dfColTypes;
        private static int[] m_dfStringWidths;
        private static String m_dataAddr;

        public static void initDataFrame(String dataAddr, int numRows, int numCols, String[] colNames, String[] colTypes, int[] colStringWidths) {
            m_dfNumRows = numRows;
            m_dfNumCols = numCols;
            m_dfColNames = colNames;
            m_dfColTypes = colTypes;
            m_dfStringWidths = colStringWidths;
            m_dataAddr = dataAddr;
        }

        public boolean hasCNKProc() {
            return true;
        }

        public boolean hasDataCacheProc() {
            return false;
        }

        public CNKProc procCreate() throws Exception {
            if (m_dfNumRows < 0 || m_dfNumCols < 0 || m_dfColNames == null || m_dfColTypes == null || m_dfStringWidths == null || m_dfColNames.length != m_dfNumCols || m_dfColTypes.length != m_dfNumCols || m_dfStringWidths.length != m_dfNumCols) {
                throw new Exception("WriteDataFrameEngineNode: bad specs");
            }
            CNKProcConvertDataFrame proc = new CNKProcConvertDataFrame();
            proc.setDataAddress(m_dataAddr);
            proc.setDataFrameNumber(-1);
            proc.setWrite(true);
            proc.setTotalRows(m_dfNumRows);
            return proc;
        }

        public void procExtractResults(CNKProc proc) {
            CNKBuf buf = proc.getOutbuf();
            int bytesPerRow = buf.calcBytesPerRow();
            EngineNetworkManager.m_statSmallToBigBytes += (long)m_dfNumRows * (long)bytesPerRow;
        }

        public XTMetaData calculateOutputMetaData(int outputNum) {
            XTMetaData md = null;
            int defaultStringSize = this.getNetworkManager().getDefaultStringSize();
            try {
                md = new XTMetaData();
                for (int col = 0; col < m_dfNumCols; ++col) {
                    String cName = m_dfColNames[col];
                    String cType = m_dfColTypes[col];
                    int strWidth = Math.max(m_dfStringWidths[col] + 2, defaultStringSize);
                    if (cName == null || cType == null) continue;
                    if (cType.equals("string")) {
                        md.appendStringDataField(cName, strWidth);
                        continue;
                    }
                    if (cType.equals("continuous")) {
                        md.appendContinousDataField(cName);
                        continue;
                    }
                    if (cType.equals("date")) {
                        md.appendDateTimeDataField(cName);
                        continue;
                    }
                    if (!cType.equals("categorical")) continue;
                    md.appendCategoricalDataField(cName, new String[0]);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            return md;
        }

        public EngineNode.InputRequirements getInputRequirements(int inputNum) {
            return EngineNode.InputRequirements.getMinRequirements();
        }
    }

    public static class FileBlob
    extends EngineNode
    implements CNKProcJavaTransformExec {
        private String getFileName() {
            return this.getNodeProperties().getValue("filename", null);
        }

        private boolean getRead() {
            return this.getNodeProperties().getBoolean("read", true);
        }

        private String getBlobClassName() {
            return this.getNodeProperties().getValue("blobclass", "FileBlob");
        }

        public CNKProc procCreate() throws Exception {
            if (this.getFileName() == null) {
                throw new Exception("FileBlob: null filename");
            }
            if (this.getRead()) {
                if (this.getNumInputs() != 1 && this.getNumOutputs() != 0) {
                    throw new Exception("FileBlob: needs 1 input and 0 outputs for read");
                }
                XTMetaData md = this.getInputMetaData(0);
                if (md.getNumRows() < 1L) {
                    throw new Exception("FileBlob: bad input meta-data - getNumRows() == " + md.getNumRows());
                }
                if (md.getNumColumns() < 1) {
                    throw new Exception("FileBlob: bad input meta-data - getNumColumns() == " + md.getNumColumns());
                }
                if (!md.isBlobColumn(0)) {
                    throw new Exception("FileBlob: bad input meta-data - isBlobColumn(0) == " + md.isBlobColumn(0));
                }
            } else {
                if (this.getNumInputs() != 0 && this.getNumOutputs() != 1) {
                    throw new Exception("FileBlob: needs 0 inputs and 1 output for write");
                }
                XTMetaData md = this.getOutputMetaData(0);
                if (md.getNumColumns() < 1 || !md.isBlobColumn(0)) {
                    throw new Exception("FileBlob: bad output meta-data");
                }
            }
            return new CNKProcJavaTransform(this);
        }

        public XTMetaData calculateOutputMetaData(int outputNum) {
            XTMetaData md = null;
            try {
                md = new XTMetaData();
                md.appendBlobDataField("obj", this.getBlobClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return md;
        }

        private boolean copyData(InputStream in, OutputStream out) {
            boolean ok = false;
            try {
                int len;
                byte[] buf = new byte[32768];
                while ((len = in.read(buf)) >= 0) {
                    out.write(buf, 0, len);
                }
                in.close();
                out.flush();
                out.close();
                ok = true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return ok;
        }

        public void execute(CNKProcJavaTransform proc) {
            boolean ok = false;
            String filename = this.getFileName();
            try {
                if (this.getRead()) {
                    InputStream blobis = proc.openReadBlobStream(0, 0, 0);
                    if (blobis == null) {
                        throw new Exception("can't open blob for read");
                    }
                    BufferedInputStream bis = new BufferedInputStream(blobis);
                    ok = this.copyData(bis, new BufferedOutputStream(new FileOutputStream(filename)));
                    if (!(ok |= proc.closeReadBlobStream())) {
                        proc.addError("FileBlob error reading " + filename);
                    }
                } else {
                    OutputStream blobos = proc.openWriteBlobStream(0, 0, 0);
                    if (blobos == null) {
                        throw new Exception("can't open blob for write");
                    }
                    BufferedOutputStream bos = new BufferedOutputStream(blobos);
                    ok = this.copyData(new BufferedInputStream(new FileInputStream(filename)), blobos);
                    proc.setChunkOutputReleaseRows(0, 1);
                    if (!(ok |= proc.closeWriteBlobStream())) {
                        proc.addError("FileBlob error writing " + filename);
                    }
                }
            }
            catch (Exception ex) {
                proc.addError("FileBlob exception " + ex);
            }
            proc.setChunkDone(true);
        }

        public static CNKBlobClassHandler getBlobClassHandler(String className) {
            return new CNKBlobClassHandler(className){

                public String getDisplayClassName() {
                    return "FileBlob";
                }

                public Object readBlobObject(InputStream in) throws IOException, ClassNotFoundException {
                    return null;
                }

                public void writeBlobObject(OutputStream out, Object obj) throws IOException {
                }
            };
        }
    }

    public static class SplusDataBlob
    extends EngineNode
    implements CNKProcJavaTransformExec {
        private String getFileName() {
            return this.getNodeProperties().getValue("filename", null);
        }

        private boolean getRead() {
            return this.getNodeProperties().getBoolean("read", true);
        }

        public CNKProc procCreate() throws Exception {
            if (this.getFileName() == null) {
                throw new Exception("SplusDataBlob: null filename");
            }
            if (this.getRead()) {
                if (this.getNumInputs() != 1 && this.getNumOutputs() != 0) {
                    throw new Exception("SplusDataBlob: needs 1 input and 0 outputs for read");
                }
                XTMetaData md = this.getInputMetaData(0);
                if (md.getNumRows() < 1L || md.getNumColumns() < 1 || !md.isBlobColumn(0) || !this.getClass().getName().equals(md.getBlobDataFieldClassName(0))) {
                    throw new Exception("SplusDataBlob: bad input meta-data");
                }
            } else {
                if (this.getNumInputs() != 0 && this.getNumOutputs() != 1) {
                    throw new Exception("SplusDataBlob: needs 0 inputs and 1 output for write");
                }
                XTMetaData md = this.getOutputMetaData(0);
                if (md.getNumColumns() < 1 || !md.isBlobColumn(0) || !this.getClass().getName().equals(md.getBlobDataFieldClassName(0))) {
                    throw new Exception("SplusDataBlob: bad output meta-data");
                }
            }
            return new CNKProcJavaTransform(this);
        }

        public XTMetaData calculateOutputMetaData(int outputNum) {
            XTMetaData md = null;
            try {
                md = new XTMetaData();
                md.appendBlobDataField("obj", this.getClass().getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            return md;
        }

        private boolean copyData(InputStream in, OutputStream out) {
            boolean ok = false;
            try {
                int len;
                byte[] buf = new byte[32768];
                while ((len = in.read(buf)) >= 0) {
                    out.write(buf, 0, len);
                }
                in.close();
                out.flush();
                out.close();
                ok = true;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return ok;
        }

        public void execute(CNKProcJavaTransform proc) {
            boolean ok = false;
            String filename = this.getFileName();
            try {
                if (this.getRead()) {
                    InputStream blobis = proc.openReadBlobStream(0, 0, 0);
                    if (blobis == null) {
                        throw new Exception("can't open blob for read");
                    }
                    BufferedInputStream bis = new BufferedInputStream(blobis);
                    GZIPInputStream gzis = new GZIPInputStream(bis);
                    ok = this.copyData(gzis, new BufferedOutputStream(new FileOutputStream(filename)));
                    if (!(ok |= proc.closeReadBlobStream())) {
                        proc.addError("SplusDataBlob error reading " + filename);
                    }
                } else {
                    OutputStream blobos = proc.openWriteBlobStream(0, 0, 0);
                    if (blobos == null) {
                        throw new Exception("can't open blob for write");
                    }
                    BufferedOutputStream bos = new BufferedOutputStream(blobos);
                    GZIPOutputStream gzos = new GZIPOutputStream(bos);
                    ok = this.copyData(new BufferedInputStream(new FileInputStream(filename)), gzos);
                    proc.setChunkOutputReleaseRows(0, 1);
                    if (!(ok |= proc.closeWriteBlobStream())) {
                        proc.addError("SplusDataBlob error writing " + filename);
                    }
                }
            }
            catch (Exception ex) {
                proc.addError("SplusDataBlob exception " + ex);
            }
            proc.setChunkDone(true);
        }

        public static CNKBlobClassHandler getBlobClassHandler(String className) {
            return new CNKBlobClassHandler(className){

                public String getDisplayClassName() {
                    return "SplusDataBlob";
                }

                public Object readBlobObject(InputStream in) throws IOException, ClassNotFoundException {
                    return null;
                }

                public void writeBlobObject(OutputStream out, Object obj) throws IOException {
                }
            };
        }
    }

    public static class testbedEngineNode
    extends EngineNode {
        public CNKProc procCreate() throws Exception {
            if (m_testbedCNKProc != null) {
                return m_testbedCNKProc;
            }
            throw new Exception("no testbed object to execute");
        }

        public void procDelete(CNKProc proc) {
        }

        public XTMetaData calculateOutputMetaData(int outputNum) {
            String outputTag;
            String[] path;
            XTProps props = this.getNodeProperties();
            if (!props.isPathValid(path = new String[]{"output.md", outputTag = "output" + (outputNum + 1)})) {
                return this.getInputMetaData(0);
            }
            XTMetaData md = null;
            try {
                md = new XTMetaData();
                Vector columnNames = props.getSubProperties(path);
                Vector columnTypes = props.getSubPropertyValues(path);
                for (int i = 0; i < columnNames.size() && i < columnTypes.size(); ++i) {
                    String colName = (String)columnNames.get(i);
                    Object colType = columnTypes.get(i);
                    if ("categorical".equals(colType)) {
                        md.appendCategoricalDataField(colName, new String[0]);
                        continue;
                    }
                    if ("string".equals(colType)) {
                        md.appendStringDataField(colName, 33);
                        continue;
                    }
                    if ("date".equals(colType)) {
                        md.appendDateTimeDataField(colName);
                        continue;
                    }
                    md.appendContinousDataField(colName);
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            return md;
        }
    }

    public static class ModelViewerNodeModel
    extends PredictNodeModel {
        public XMLTree m_fittedModel = null;

        public ModelViewerNodeModel() {
            super(new XTNetwork.NodeInfo());
        }

        public XMLTree getFittedModel() {
            return this.m_fittedModel;
        }

        public void setFittedModel(XMLTree tree) {
            this.m_fittedModel = tree;
        }

        public XTMetaData getInputMetaData(int input) throws Exception {
            XTMetaData md = null;
            try {
                md = new XTMetaData();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return md;
        }
    }

    public static class XMLTreeBlob {
        public XMLTree m_tree = null;
        public String m_xmlString = null;
        public File m_xmlFile = null;

        public XMLTreeBlob(XMLTree tree) {
            this.m_tree = tree;
        }

        public XMLTreeBlob(String xmlString) {
            this.m_xmlString = xmlString;
        }

        public XMLTreeBlob(File xmlFile) {
            this.m_xmlFile = xmlFile;
        }

        public String toString() {
            return "<XMLTree>";
        }

        public static CNKBlobClassHandler getBlobClassHandler(String className) {
            return new CNKBlobClassHandler(className){

                public String getDisplayClassName() {
                    return "XMLTree Blob";
                }

                public Object readBlobObject(InputStream in) throws IOException, ClassNotFoundException {
                    try {
                        XMLTree tree = XMLTree.readFromFile(in);
                        return new XMLTreeBlob(tree);
                    }
                    catch (Exception ex) {
                        System.out.println("XMLTreeBlob: readBlobObject err:" + ex);
                        return null;
                    }
                }

                public void writeBlobObject(OutputStream out, Object obj) throws IOException {
                    if (obj == null) {
                        return;
                    }
                    XMLTreeBlob blob = (XMLTreeBlob)obj;
                    if (blob.m_tree != null) {
                        blob.m_tree.saveToFile(out);
                    } else if (blob.m_xmlString != null) {
                        PrintWriter pw = new PrintWriter(out);
                        pw.write(blob.m_xmlString);
                        pw.flush();
                    } else if (blob.m_xmlFile != null) {
                        try {
                            FileInputStream fin = new FileInputStream(blob.m_xmlFile);
                            BufferedInputStream bin = new BufferedInputStream(fin);
                            DataInputStream din = new DataInputStream(bin);
                            BDLManager.copyDataBytes(din, new DataOutputStream(out));
                            din.close();
                        }
                        catch (Exception ex) {
                            System.out.println("XMLTreeBlob: writeBlobObject err:" + ex);
                        }
                    }
                }
            };
        }
    }

    public static class readXMLTreeFromBDO
    extends EngineNode
    implements CNKProcJavaTransformExec {
        private BDLManager m_mgr = null;

        public CNKProc procCreate() throws Exception {
            this.m_mgr = BDLManager.getBDLManager();
            return new CNKProcJavaTransform(this);
        }

        public XTMetaData calculateOutputMetaData(int outputNum) {
            XTMetaData md = null;
            try {
                md = new XTMetaData();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return md;
        }

        public void execute(CNKProcJavaTransform proc) {
            Object[] blobs = proc.getChunkInputColumnBlobs(0, 0);
            XMLTreeBlob treeBlob = (XMLTreeBlob)blobs[0];
            this.m_mgr.m_savedModel = treeBlob == null ? null : treeBlob.m_tree;
            proc.setChunkDone(true);
        }
    }

    public static class writeXMLTreeToBDO
    extends EngineNode
    implements CNKProcJavaTransformExec {
        private BDLManager m_mgr = null;

        public CNKProc procCreate() throws Exception {
            this.m_mgr = BDLManager.getBDLManager();
            return new CNKProcJavaTransform(this);
        }

        public XTMetaData calculateOutputMetaData(int outputNum) {
            XTMetaData md = null;
            try {
                md = new XTMetaData();
                md.appendBlobDataField("model", "com.insightful.miner.BDLManager$XMLTreeBlob");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return md;
        }

        public void execute(CNKProcJavaTransform proc) {
            XTProps props = this.getNodeProperties();
            String source = props.getValue("source", "unknown");
            Object[] blobs = proc.getChunkOutputColumnBlobs(0, 0);
            if (source.equals("saved.model")) {
                blobs[0] = new XMLTreeBlob(this.m_mgr.m_savedModel);
                this.m_mgr.m_savedModel = null;
            } else if (source.equals("string")) {
                blobs[0] = new XMLTreeBlob(props.getValue("xml.string", ""));
            } else if (source.equals("file")) {
                blobs[0] = new XMLTreeBlob(new File(props.getValue("xml.file", "")));
            } else {
                this.m_mgr.println("writeXMLTreeToBDO: unknown data source: " + source);
            }
            proc.setChunkOutputReleaseRows(0, 1);
            proc.setChunkDone(true);
        }
    }

    private class ReadOnlyDBInfo
    extends DBInfo {
        ReadOnlyDBInfo(String bdoDir) {
            this.m_bdoDir = bdoDir;
        }

        Cache getNewCache() throws Exception {
            throw new Exception("Can't create new cache in ReadOnlyDBInfo");
        }

        String getNewCacheName() {
            return "ReadOnlyDBInfo-FILE";
        }

        void addViewerCache(String cacheName) {
        }

        void removeViewerCache(String cacheName) {
        }

        void setVarCaches(String varFileName, List cacheList) {
        }

        void removeVarCaches(String varFileName) {
        }

        void commitAssigns() {
        }

        void addMemref(String cacheName) {
        }

        void removeMemref(String cacheName) {
        }

        List readVarToCacheFile(File vtc) {
            return new Vector();
        }

        void writeVarToCacheFile(File vtc, List cacheList) {
        }

        void deleteCacheOnZeroRefCount(String cacheName) {
        }

        void deleteCache(String cacheName) {
        }

        String copyCache(String cacheName, DBInfo oldDirInfo) {
            return "ReadOnlyDBInfo-FILE";
        }

        void checkBdoDir() {
        }
    }

    private class DBInfo {
        protected String m_bdoDir = null;
        private Set m_newCacheSet = null;
        private Hashtable m_varToCacheList = null;
        private Set m_varChangedSet = null;
        private CacheRefCounts m_cacheRefCounts = null;
        private long m_cacheNameNumber = -1L;
        private boolean m_bdoDirChecked = false;

        protected DBInfo() {
        }

        DBInfo(String bdoDir) {
            this.m_bdoDir = BDLManager.getBdoDir(bdoDir);
            this.m_newCacheSet = new HashSet();
            this.m_varToCacheList = new Hashtable();
            this.m_varChangedSet = new LinkedHashSet();
            this.m_cacheRefCounts = new CacheRefCounts();
            this.m_cacheRefCounts.readRefCountFile(this.m_bdoDir);
        }

        String getDir() {
            return this.m_bdoDir;
        }

        Cache getNewCache() throws Exception {
            return new Cache(this.getNewCacheName(), this.m_bdoDir);
        }

        String getNewCacheName() {
            this.checkBdoDir();
            if (this.m_cacheNameNumber < 0L) {
                this.m_cacheNameNumber = this.getStartingCount();
                BDLManager.this.println("setting starting cache number: " + this.m_cacheNameNumber + " for " + this.m_bdoDir);
            }
            String cacheName = this.getCacheName(this.m_cacheNameNumber);
            ++this.m_cacheNameNumber;
            BDLManager.this.println("add new cache: " + cacheName);
            if (BDLManager.this.m_hooksOK) {
                this.m_newCacheSet.add(cacheName);
                this.m_cacheRefCounts.incrMemCacheRefCount(cacheName);
            }
            return cacheName;
        }

        void addViewerCache(String cacheName) {
            BDLManager.this.println("add viewer cache: " + cacheName);
            this.m_cacheRefCounts.incrViewerCacheRefCount(cacheName);
        }

        void removeViewerCache(String cacheName) {
            BDLManager.this.println("remove viewer cache: " + cacheName);
            this.m_cacheRefCounts.decrViewerCacheRefCount(cacheName);
        }

        void setVarCaches(String varFileName, List cacheList) {
            BDLManager.this.println("set new caches: " + varFileName + ", " + cacheList.size() + " caches");
            this.removeVarCaches(varFileName);
            this.m_varToCacheList.put(varFileName, cacheList);
            int numCaches = cacheList.size();
            for (int i = 0; i < numCaches; ++i) {
                String cacheName = (String)cacheList.get(i);
                this.m_cacheRefCounts.incrFileCacheRefCount(cacheName);
                BDLManager.this.println("incr refcount: " + varFileName + ", " + cacheName + " cnt=" + this.m_cacheRefCounts.getCacheRefCount(cacheName));
            }
        }

        void removeVarCaches(String varFileName) {
            this.m_varChangedSet.add(varFileName);
            List cacheList = (Vector)this.m_varToCacheList.get(varFileName);
            if (cacheList == null) {
                File vtc = this.getVarToCacheFile(varFileName);
                cacheList = vtc.exists() ? this.readVarToCacheFile(vtc) : new Vector();
                this.m_varToCacheList.put(varFileName, cacheList);
            }
            int numCaches = cacheList.size();
            for (int i = 0; i < numCaches; ++i) {
                String cacheName = (String)cacheList.get(i);
                this.m_cacheRefCounts.decrFileCacheRefCount(cacheName);
                BDLManager.this.println("decr refcount: " + varFileName + ", " + cacheName + " cnt=" + this.m_cacheRefCounts.getCacheRefCount(cacheName));
            }
            cacheList.clear();
        }

        void commitAssigns() {
            for (String cacheName : this.m_newCacheSet) {
                this.m_cacheRefCounts.decrMemCacheRefCount(cacheName);
            }
            this.m_newCacheSet.clear();
            for (String varName : this.m_varChangedSet) {
                List cacheList = (List)this.m_varToCacheList.get(varName);
                File vtc = this.getVarToCacheFile(varName);
                if (cacheList == null || cacheList.isEmpty()) {
                    vtc.delete();
                    this.m_varToCacheList.remove(varName);
                    continue;
                }
                this.writeVarToCacheFile(vtc, cacheList);
            }
            this.m_varChangedSet.clear();
            if (this.m_cacheRefCounts.anyFileRefCountsChanged()) {
                this.m_cacheRefCounts.writeRefCountFile(this.m_bdoDir);
                this.m_cacheRefCounts.clearAnyFileRefCountsChanged();
            }
        }

        void addMemref(String cacheName) {
            this.m_cacheRefCounts.incrMemCacheRefCount(cacheName);
            if (this.m_newCacheSet.contains(cacheName)) {
                this.m_cacheRefCounts.decrMemCacheRefCount(cacheName);
                this.m_newCacheSet.remove(cacheName);
            }
        }

        void removeMemref(String cacheName) {
            this.m_cacheRefCounts.decrMemCacheRefCount(cacheName);
        }

        File getVarToCacheFile(String varFileName) {
            return new File(this.m_bdoDir, varFileName + ".vtc");
        }

        List readVarToCacheFile(File vtc) {
            BDLManager.this.println("reading var-to-cache file: " + vtc.getAbsolutePath());
            Vector<String> ret = new Vector<String>();
            BufferedReader in = null;
            try {
                String ln;
                in = new BufferedReader(new FileReader(vtc));
                while ((ln = in.readLine()) != null) {
                    if ((ln = ln.trim()).length() <= 0) continue;
                    ret.add(ln);
                }
            }
            catch (Exception ex) {
                BDLManager.this.println("exception reading var-to-cache file: " + ex);
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            return ret;
        }

        void writeVarToCacheFile(File vtc, List cacheList) {
            this.checkBdoDir();
            BDLManager.this.println("writing var-to-cache file: " + vtc.getAbsolutePath());
            BufferedWriter out = null;
            try {
                out = new BufferedWriter(new FileWriter(vtc));
                int numCaches = cacheList.size();
                for (int i = 0; i < numCaches; ++i) {
                    out.write((String)cacheList.get(i));
                    out.write("\n");
                }
            }
            catch (Exception ex) {
                BDLManager.this.println("exception writing var-to-cache file: " + ex);
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
        }

        void deleteCacheOnZeroRefCount(String cacheName) {
            if (this.m_cacheRefCounts.getCacheRefCount(cacheName) < 1) {
                BDLManager.this.println("deleting cache: " + cacheName + ", dir: " + this.m_bdoDir);
                this.deleteCache(cacheName);
                this.m_cacheRefCounts.removeRefcounts(cacheName);
            }
        }

        void deleteCache(String cacheName) {
            for (int i = 0; i < m_cacheExtensions.length; ++i) {
                File f = new File(this.m_bdoDir, cacheName + BDLManager.SEPARATOR + m_cacheExtensions[i]);
                f.delete();
            }
        }

        String getCacheName(long num) {
            if (num < 0L) {
                return "cn" + -num;
            }
            if (num < 10L) {
                return "ca000" + num;
            }
            if (num < 100L) {
                return "ca00" + num;
            }
            if (num < 1000L) {
                return "ca0" + num;
            }
            if (num < 10000L) {
                return "ca" + num;
            }
            if (num < 100000L) {
                return "cb" + num;
            }
            if (num < 1000000L) {
                return "cc" + num;
            }
            if (num < 10000000L) {
                return "cd" + num;
            }
            if (num < 100000000L) {
                return "ce" + num;
            }
            return "cf" + num;
        }

        long getStartingCount() {
            String[] files = new File(this.m_bdoDir).list();
            if (files == null) {
                BDLManager.this.println("getStartingCount: can't read files in " + this.m_bdoDir);
                return 0L;
            }
            long num = 0L;
            for (int i = 0; i < files.length; ++i) {
                String f = files[i];
                if (!f.startsWith("c") || !f.endsWith(".dcf")) continue;
                long newNum = -1L;
                try {
                    newNum = Long.parseLong(f.substring(2, f.length() - 4));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (newNum < num) continue;
                num = newNum + 1L;
            }
            return num;
        }

        String copyCache(String cacheName, DBInfo oldDirInfo) {
            String newCacheName = this.getNewCacheName();
            for (int i = 0; i < m_cacheExtensions.length; ++i) {
                try {
                    Cache fromCache = new Cache(cacheName, oldDirInfo.m_bdoDir);
                    Cache toCache = new Cache(newCacheName, this.m_bdoDir);
                    String fromFileName = fromCache.getFilePathWithExt(m_cacheExtensions[i]);
                    String toFileName = toCache.getFilePathWithExt(m_cacheExtensions[i]);
                    BDLManager.this.println("copying " + fromFileName + " to " + toFileName);
                    BDLManager.this.copyFile(fromFileName, toFileName);
                    BDLManager.this.incrementCopyCacheBytes(EngineNetworkManager.getFileBytes(fromFileName));
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            return newCacheName;
        }

        void checkBdoDir() {
            if (!this.m_bdoDirChecked) {
                File f = new File(this.m_bdoDir);
                if (!f.exists()) {
                    boolean ok = new File(this.m_bdoDir).mkdirs();
                    if (!f.exists()) {
                        BDLManager.this.println("problem creating directory " + f.getAbsolutePath());
                    }
                }
                this.m_bdoDirChecked = true;
            }
        }

        class CacheRefCounts {
            private boolean m_anyFileRefCountsChanged = false;
            private Hashtable m_cacheToRefCounts = new Hashtable();

            CacheRefCounts() {
            }

            private boolean hasRefBox(String cacheName) {
                return this.m_cacheToRefCounts.containsKey(cacheName);
            }

            private int[] getRefBox(String cacheName) {
                int[] refBox = (int[])this.m_cacheToRefCounts.get(cacheName);
                if (refBox == null) {
                    refBox = new int[]{0, 0, 0};
                    this.m_cacheToRefCounts.put(cacheName, refBox);
                    if (this.m_cacheToRefCounts.size() > m_maxCacheRefs) {
                        m_maxCacheRefs = this.m_cacheToRefCounts.size();
                    }
                }
                return refBox;
            }

            void removeRefcounts(String cacheName) {
                this.m_cacheToRefCounts.remove(cacheName);
            }

            File getRefcountFile(String bdoDir) {
                return new File(bdoDir, "refcnt.txt");
            }

            void readRefCountFile(String bdoDir) {
                BDLManager.this.println("reading refcount file: " + this.getRefcountFile(bdoDir));
                this.m_cacheToRefCounts.clear();
                BufferedReader in = null;
                try {
                    String ln;
                    in = new BufferedReader(new FileReader(this.getRefcountFile(bdoDir)));
                    while ((ln = in.readLine()) != null) {
                        String cacheName;
                        int brk = ln.indexOf(": ");
                        if (brk < 0 || (cacheName = ln.substring(0, brk).trim()).length() < 1) continue;
                        int cnt = Integer.parseInt(ln.substring(brk + 2));
                        this.setFileCacheRefCount(cacheName, cnt);
                    }
                }
                catch (Exception ex) {
                    BDLManager.this.println("exception reading refcount file: " + ex);
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.clearAnyFileRefCountsChanged();
            }

            void writeRefCountFile(String bdoDir) {
                DBInfo.this.checkBdoDir();
                BDLManager.this.println("writing refcount file: " + this.getRefcountFile(bdoDir));
                BufferedWriter out = null;
                try {
                    out = new BufferedWriter(new FileWriter(this.getRefcountFile(bdoDir)));
                    for (String cacheName : this.m_cacheToRefCounts.keySet()) {
                        int cnt = this.getFileCacheRefCount(cacheName);
                        if (cnt <= 0) continue;
                        out.write(cacheName + ": " + cnt + "\n");
                    }
                }
                catch (Exception ex) {
                    BDLManager.this.println("exception writing refcount file: " + ex);
                }
                try {
                    if (out != null) {
                        out.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }

            int getFileCacheRefCount(String cacheName) {
                return this.hasRefBox(cacheName) ? this.getRefBox(cacheName)[0] : 0;
            }

            void setFileCacheRefCount(String cacheName, int refcnt) {
                int[] refBox = this.getRefBox(cacheName);
                refBox[0] = refcnt;
                this.m_anyFileRefCountsChanged = true;
            }

            void incrFileCacheRefCount(String cacheName) {
                int[] refBox = this.getRefBox(cacheName);
                refBox[0] = refBox[0] + 1;
                this.m_anyFileRefCountsChanged = true;
            }

            void decrFileCacheRefCount(String cacheName) {
                int[] refBox = this.getRefBox(cacheName);
                if (refBox[0] > 0) {
                    refBox[0] = refBox[0] - 1;
                }
                DBInfo.this.deleteCacheOnZeroRefCount(cacheName);
                this.m_anyFileRefCountsChanged = true;
            }

            int getMemCacheRefCount(String cacheName) {
                return this.hasRefBox(cacheName) ? this.getRefBox(cacheName)[1] : 0;
            }

            void incrMemCacheRefCount(String cacheName) {
                int[] refBox = this.getRefBox(cacheName);
                refBox[1] = refBox[1] + 1;
            }

            void decrMemCacheRefCount(String cacheName) {
                int[] refBox = this.getRefBox(cacheName);
                if (refBox[1] > 0) {
                    refBox[1] = refBox[1] - 1;
                }
                DBInfo.this.deleteCacheOnZeroRefCount(cacheName);
            }

            int getViewerCacheRefCount(String cacheName) {
                return this.hasRefBox(cacheName) ? this.getRefBox(cacheName)[2] : 0;
            }

            void incrViewerCacheRefCount(String cacheName) {
                int[] refBox = this.getRefBox(cacheName);
                refBox[2] = refBox[2] + 1;
            }

            void decrViewerCacheRefCount(String cacheName) {
                int[] refBox = this.getRefBox(cacheName);
                if (refBox[2] > 0) {
                    refBox[2] = refBox[2] - 1;
                }
                DBInfo.this.deleteCacheOnZeroRefCount(cacheName);
            }

            int getCacheRefCount(String cacheName) {
                if (!this.hasRefBox(cacheName)) {
                    return 0;
                }
                int[] refBox = this.getRefBox(cacheName);
                return refBox[0] + refBox[1] + refBox[2];
            }

            boolean anyFileRefCountsChanged() {
                return this.m_anyFileRefCountsChanged;
            }

            void clearAnyFileRefCountsChanged() {
                this.m_anyFileRefCountsChanged = false;
            }
        }
    }

    public static class SelectData
    extends EngineNode
    implements CNKProcJavaTransformExec {
        public static String FROM_ROW_ATTRIBUTE_TAG = "from.row";
        public static String TO_ROW_ATTRIBUTE_TAG = "to.row";
        public static String COL_NUMS_ATTRIBUTE_TAG = "select.column.nums";
        public static String COL_NAMES_ATTRIBUTE_TAG = "output.column.names";
        private long m_fromRow;
        protected long m_toRow;
        private int[] m_selectedColumns;

        public boolean hasCNKProc() {
            return true;
        }

        public boolean hasDataCacheProc() {
            return false;
        }

        public CNKProc procCreate() {
            return new CNKProcJavaTransform(this);
        }

        public int[] getSelectedColumnNums() {
            XTProps props = this.getNodeProperties();
            XTMetaData inputMD = this.getInputMetaData(0);
            Vector selColumns = props.getSubPropertyValues(COL_NUMS_ATTRIBUTE_TAG);
            int[] colNums = new int[selColumns.size()];
            for (int i = 0; i < colNums.length; ++i) {
                colNums[i] = -1;
                String inputColNumStr = (String)selColumns.get(i);
                try {
                    colNums[i] = Integer.parseInt(inputColNumStr) - 1;
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            return colNums;
        }

        public Vector getOutputColumnNames() {
            XTProps props = this.getNodeProperties();
            XTMetaData inputMD = this.getInputMetaData(0);
            return props.getSubPropertyValues(COL_NAMES_ATTRIBUTE_TAG);
        }

        public void procSetProperties(CNKProc proc) throws Exception {
            XTProps props = this.getNodeProperties();
            XTMetaData inputMD = this.getInputMetaData(0);
            this.m_fromRow = props.getLong(FROM_ROW_ATTRIBUTE_TAG, 0L) - 1L;
            this.m_toRow = props.getLong(TO_ROW_ATTRIBUTE_TAG, 0L) - 1L;
            this.m_selectedColumns = this.getSelectedColumnNums();
        }

        public void execute(CNKProcJavaTransform proc) {
            long pos = proc.getChunkInputPosition(0);
            if (pos < this.m_fromRow) {
                proc.setChunkNextInputPosition(0, this.m_fromRow);
                proc.setChunkOutputReleaseRows(0, 0);
                proc.setChunkDone(false);
                return;
            }
            if (pos > this.m_toRow) {
                proc.setChunkOutputReleaseRows(0, 0);
                proc.setChunkDone(true);
                return;
            }
            long rowsLeft = this.m_toRow - pos + 1L;
            int rowsToCopy = Math.min(proc.getChunkInputRows(0), proc.getChunkOutputRows(0));
            if (rowsLeft < (long)rowsToCopy) {
                rowsToCopy = (int)rowsLeft;
            }
            int outputCol = 0;
            for (int i = 0; i < this.m_selectedColumns.length; ++i) {
                int inputColNum = this.m_selectedColumns[i];
                if (inputColNum < 0) continue;
                proc.copyColumnData(0, outputCol, 0, 0, inputColNum, 0, rowsToCopy);
                ++outputCol;
            }
            proc.setChunkInputReleaseRows(0, rowsToCopy);
            proc.setChunkOutputReleaseRows(0, rowsToCopy);
            proc.setChunkDone(false);
        }

        public XTMetaData calculateOutputMetaData(int outputNum) {
            XTProps props = this.getNodeProperties();
            XTMetaData inputMD = this.getInputMetaData(0);
            XTMetaData md = BDLManager.selectColumnsMetaData(inputMD, this.getSelectedColumnNums(), this.getOutputColumnNames());
            return md;
        }

        public EngineNode.InputRequirements getInputRequirements(int inputNum) {
            return EngineNode.InputRequirements.getMinRequirements();
        }
    }

    public static class BDLSplusScriptEngineNode
    extends SplusScriptEngineNode {
        public void doCallback(CNKProc proc) {
        }

        public String getInitDeviceString() {
            return "";
        }
    }

    public static class GatherRegressionAgreementData
    extends RegressionAgreementEngineNode {
        private static String m_key = null;

        public static String getDataKey() {
            return m_key;
        }

        public void procExtractResults(CNKProc proc) {
            String key;
            super.procExtractResults(proc);
            XTProps cache = this.getNodeCacheXTProps(RegressionAgreementEngineNode.REGRESSION_AGREEMENT_CACHE);
            XTProps results = RegressionAgreementNodeModel.getBDLOutput(cache);
            BDLList data = BDLList.translateFromXTProps(results);
            m_key = key = GlobalObjectCache.put(data);
        }
    }

    public static class GatherClassificationAgreementData
    extends ClassificationAgreementEngineNode {
        private static String m_key = null;

        public static String getDataKey() {
            return m_key;
        }

        public void procExtractResults(CNKProc proc) {
            String key;
            super.procExtractResults(proc);
            XTProps cache = this.getNodeCacheXTProps(ClassificationAgreementEngineNode.CLASSIFICATION_AGREEMENT_CACHE);
            int nInputs = this.getNumInputs();
            XTMetaData[] mds = new XTMetaData[nInputs];
            for (int i = 0; i < nInputs; ++i) {
                mds[i] = this.getInputMetaData(i);
            }
            XTProps listResults = ClassificationAgreementNodeModel.getBDLOutput(this.getNodeProperties(), cache, mds);
            BDLList data = BDLList.translateFromXTProps(listResults);
            m_key = key = GlobalObjectCache.put(data);
        }
    }

    public static class GatherCrosstabulateData
    extends CrosstabulateEngineNode {
        private static String m_key = null;

        public static String getDataKey() {
            return m_key;
        }

        protected XTProps createNodeCache(String filename, XTProps dialogProps, XTMetaData inputMD, XTMetaData outputMD) throws Exception {
            String key;
            XTProps results = super.createBDLNodeCache(filename, dialogProps, inputMD, outputMD);
            BDLList data = BDLList.translateFromXTProps(results);
            m_key = key = GlobalObjectCache.put(data);
            return results;
        }
    }

    public static class GatherUnivariateData
    extends UnivariateEngineNode {
        private static String m_key = null;

        public static String getDataKey() {
            return m_key;
        }

        public void procExtractResults() {
            String key;
            super.procExtractResults();
            XTProps results = this.getNodeCacheXTProps("univariate");
            BDLList data = BDLList.translateFromXTProps(results);
            m_key = key = GlobalObjectCache.put(data);
        }
    }

    public static class GatherChartData
    extends TwoDimChartEngineNode {
        private static String m_key = null;

        public void execute(CNKProcJavaTransform proc) {
            this.gatherInfoForChunk(proc);
        }

        public void procExtractResults(CNKProc proc) {
            String key;
            super.procExtractResults(proc);
            XTProps chartStats = this.getNodeCacheXTProps(TwoDimChartEngineNode.BIN_COUNT_CACHE_FILENAME);
            Object[] data = TwoDimChartNodeModel.getHexBinDataFrame(this.getNodeProperties(), this.getInputMetaData(0), chartStats);
            m_key = key = GlobalObjectCache.put(data);
        }

        public static String getDataKey() {
            return m_key;
        }
    }

    private class BDOInfo {
        public Cache m_cache = null;
        public int m_id = 1;
        public ActivityNodeModel m_model = null;

        public BDOInfo(Cache cache) throws Exception {
            this.m_cache = cache;
            this.m_id = BDLManager.this.getNewNodeID();
            BDLManager.this.createValidCacheNode(this.getNodeID(), this.m_cache);
        }

        public String getNodeID() {
            return String.valueOf(this.m_id);
        }

        public EngineNode getEngineNode() {
            return BDLManager.this.getNode(this.getNodeID());
        }

        public ActivityNodeModel getNodeModel() {
            if (this.m_model == null) {
                this.m_model = new ActivityNodeModel();
                BDLManager.this.initNodeModel(this.m_model, this.m_id);
            }
            return this.m_model;
        }
    }

    public static class PseudoNode
    extends EngineNode {
        public CNKProc procCreate() throws Exception {
            throw new Exception("BDL pseudo-node should never be executed: nodeID=" + this.getNodeID());
        }
    }

    private static class Cache {
        String m_cacheName;
        String m_dir;
        private static String BEGIN_CACHE_TAG = "begin.big.data.cache";
        private static String END_CACHE_TAG = "end.big.data.cache";

        Cache(String cacheName, String dir) throws Exception {
            if (cacheName == null || dir == null || cacheName.equals("") || dir.equals("")) {
                throw new Exception("bad cache: " + dir + ", " + cacheName);
            }
            this.m_cacheName = cacheName;
            this.m_dir = BDLManager.getBdoDir(dir);
        }

        Cache(BDLList spec) throws Exception {
            this(spec.getValueString("cache"), spec.getValueString("dir"));
        }

        String getCacheName() {
            return this.m_cacheName;
        }

        String getDirName() {
            return this.m_dir;
        }

        String getFilePathWithExt(String ext) {
            String realDir = this.m_dir.startsWith(BDLManager.READ_ONLY_DIR_PREFIX) ? this.m_dir.substring(BDLManager.READ_ONLY_DIR_PREFIX.length()) : this.m_dir;
            return new File(realDir, this.m_cacheName + BDLManager.SEPARATOR + ext).getAbsolutePath();
        }

        public int hashCode() {
            return this.m_cacheName.hashCode() + this.m_dir.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Cache)) {
                return false;
            }
            Cache c = (Cache)obj;
            return this.m_cacheName.equals(c.m_cacheName) && this.m_dir.equals(c.m_dir);
        }

        public String toString() {
            return "cache[" + this.m_cacheName + ", " + this.m_dir + "]";
        }

        public static String readLine(InputStream in) throws Exception {
            StringBuffer buf = new StringBuffer();
            while (buf.length() < 200) {
                int ch = in.read();
                if (ch < 0) {
                    return buf.length() < 1 ? null : buf.toString();
                }
                if (ch == 10) {
                    return buf.toString();
                }
                if (ch == 13) continue;
                buf.append((char)(ch & 0x7F));
            }
            return null;
        }

        private static void writeLine(OutputStream out, String str) throws Exception {
            int len = str == null ? 0 : str.length();
            for (int i = 0; i < len; ++i) {
                char ch = str.charAt(i);
                out.write((byte)(ch & 0x7F));
            }
            out.write(10);
        }

        private static boolean equalLine(String line, String pattern) {
            return line != null && line.indexOf(pattern) >= 0 && line.trim().equals(pattern);
        }

        public boolean readFromASCIIFile(String filename) {
            return this.readFromASCIIFile(new File(filename));
        }

        public boolean readFromASCIIFile(File asciiFile) {
            boolean ok;
            block7: {
                ok = false;
                FileInputStream fis = null;
                try {
                    String cmd;
                    fis = new FileInputStream(asciiFile);
                    BufferedInputStream bis = new BufferedInputStream(fis);
                    while ((cmd = Cache.readLine(bis)) != null) {
                        if (cmd.equals("") || Cache.equalLine(cmd, BEGIN_CACHE_TAG)) continue;
                        if (Cache.equalLine(cmd, END_CACHE_TAG)) break;
                        if (cmd.startsWith("=")) continue;
                        int dotPos = cmd.indexOf(BDLManager.SEPARATOR);
                        String ext = dotPos < 0 ? "" : cmd.substring(0, dotPos);
                        String suffix = dotPos < 0 ? "" : cmd.substring(dotPos);
                        String goodExt = null;
                        for (int i = 0; i < m_cacheExtensions.length; ++i) {
                            if (!ext.equalsIgnoreCase(m_cacheExtensions[i])) continue;
                            goodExt = m_cacheExtensions[i];
                        }
                        if (goodExt == null || !suffix.equalsIgnoreCase(".gz.base64")) {
                            throw new Exception("unknown bigdata encoded cache command: " + cmd);
                        }
                        File f = new File(this.getFilePathWithExt(goodExt));
                        this.readFromASCIIFile(f, bis);
                    }
                    bis.close();
                    ok = true;
                }
                catch (Exception ex) {
                    ok = false;
                    ex.printStackTrace();
                    if (fis == null) break block7;
                    try {
                        fis.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            return ok;
        }

        public boolean writeToASCIIFile(String filename) {
            return this.writeToASCIIFile(new File(filename));
        }

        public boolean writeToASCIIFile(File asciiFile) {
            boolean ok;
            block5: {
                ok = false;
                FileOutputStream fos = null;
                try {
                    fos = new FileOutputStream(asciiFile);
                    BufferedOutputStream out = new BufferedOutputStream(fos);
                    Cache.writeLine(out, BEGIN_CACHE_TAG);
                    Cache.writeLine(out, "===big.data.cache===");
                    for (int i = 0; i < m_cacheExtensions.length; ++i) {
                        File f = new File(this.getFilePathWithExt(m_cacheExtensions[i]));
                        Cache.writeLine(out, m_cacheExtensions[i] + ".gz.base64");
                        this.writeToASCIIFile(f, out);
                        Cache.writeLine(out, "\n=========");
                    }
                    Cache.writeLine(out, END_CACHE_TAG);
                    out.flush();
                    out.close();
                    ok = true;
                }
                catch (Exception ex) {
                    ok = false;
                    ex.printStackTrace();
                    if (fos == null) break block5;
                    try {
                        fos.close();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            return ok;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void writeToASCIIFile(File cacheFile, OutputStream out) throws Exception {
            FileInputStream fis = null;
            BufferedInputStream bis = null;
            try {
                Base64.OutputStream bos = new Base64.OutputStream(out);
                GZIPOutputStream gzos = new GZIPOutputStream(bos);
                if (cacheFile.exists()) {
                    int numRead;
                    fis = new FileInputStream(cacheFile);
                    bis = new BufferedInputStream(fis);
                    byte[] buf = new byte[32768];
                    while ((numRead = bis.read(buf)) >= 0) {
                        gzos.write(buf, 0, numRead);
                        if (!BDLManager.getBDLManager().isInterruptRequested()) continue;
                        throw new Exception("interrupt");
                    }
                    bis.close();
                    fis = null;
                }
                gzos.finish();
                bos.flushBase64();
                Object var10_9 = null;
                if (fis == null) return;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (fis == null) throw throwable;
                fis.close();
                throw throwable;
            }
            fis.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void readFromASCIIFile(File cacheFile, InputStream in) throws Exception {
            FileOutputStream fos = null;
            try {
                int numRead;
                fos = new FileOutputStream(cacheFile);
                BufferedOutputStream bos = new BufferedOutputStream(fos);
                Base64.InputStream bis = new Base64.InputStream(in);
                GZIPInputStream gzis = new GZIPInputStream(bis);
                byte[] buf = new byte[32768];
                while ((numRead = gzis.read(buf)) >= 0) {
                    bos.write(buf, 0, numRead);
                    if (!BDLManager.getBDLManager().isInterruptRequested()) continue;
                    throw new Exception("interrupt");
                }
                bos.flush();
                bos.close();
                return;
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                if (fos == null) throw throwable;
                fos.close();
                throw throwable;
            }
        }

        public File getTempFile(String prefix, String suffix) throws Exception {
            File tempDir = new File(this.getDirName());
            if (!(tempDir.exists() && tempDir.isDirectory())) {
                tempDir = null;
            }
            File tempFile = File.createTempFile(prefix, suffix, tempDir);
            return tempFile;
        }
    }
}

