/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ChartBuilder;
import com.insightful.miner.ChartPanel;
import com.insightful.miner.ClusterFrame_AboutBox;
import com.insightful.miner.ColumnHeaderPanel;
import com.insightful.miner.DataPanel;
import com.insightful.miner.DynamicGridBagConstraints;
import com.insightful.miner.DynamicGridBagLayout;
import com.insightful.miner.MinerApp;
import com.insightful.miner.ModifiableViewerFrame;
import com.insightful.miner.tree.gui.ColorBroker;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ClusterFrame
extends ModifiableViewerFrame
implements ClipboardOwner {
    private ChartBuilder chartBuilder = null;
    public ClusterFrame thisClusterFrame = null;
    private JPanel leftPanel = null;
    public JScrollPane leftLabelScrollPane = null;
    private JScrollPane topLabelScrollPane = null;
    private JScrollPane chartScrollPane = null;
    private JViewport chartViewport = null;
    private Number[] maxBarChartVals = null;
    private int categoricalChartType = 0;
    private int continuousChartType = 0;
    private String currentLabel = "";
    private Dimension screenSize = null;
    private JPanel topLabelPanel = null;
    private JPanel leftLabelPanel = null;
    private Vector leftLabelVector = null;
    private Vector topPanelVector = null;
    public DataPanel firstSelectedChart = null;
    private int correctLabelWidth = 0;
    private int numCharts = 0;
    private ChartPanel chartPanel = null;
    private Cursor oldCursor = null;
    private boolean showCountsByPercent = false;
    private int INITIAL_FRAME_WIDTH = 0;
    private int INITIAL_FRAME_HEIGHT = 0;
    private final int LEFT_LABEL_WIDTH = 100;
    private final int HORIZONTAL_GAP_BETWEEN_CHARTS = 1;
    private final int VERTICAL_GAP_BETWEEN_CHARTS = 1;
    private int[] leftLabelColumnWidths = null;
    public static final int TOP_LABEL_HEIGHT = 23;
    public static final int VERTICAL_HEIGHT_BUFFER = 85;
    public static final int HORIZONTAL_WIDTH_BUFFER = 35;
    private JMenuBar menuBar = new JMenuBar();
    private JMenu fileMenu = new JMenu();
    private JMenuItem fileMenuExit = new JMenuItem();
    private JMenuItem fileMenuPrint = new JMenuItem();
    private JMenuItem fileMenuPrintPreview = new JMenuItem();
    private JMenuItem fileMenuSave = new JMenuItem();
    private JMenuItem fileMenuCopy = new JMenuItem();
    private JMenu helpMenu = new JMenu();
    private JMenuItem helpMenuUserGuide = new JMenuItem();
    private JMenuItem helpMenuAbout = new JMenuItem();
    private JMenu viewMenu = new JMenu();
    public JMenuItem viewChartsMenuItem = new JMenuItem();
    private JMenuItem viewChartProps = new JMenuItem();
    private JCheckBoxMenuItem showHideStatistics = null;
    public static Font topLabelFont = MinerApp.getFont(1, 12);
    public static Font sideLabelFont = MinerApp.getFont(1, 12);
    public static Font pieFont = MinerApp.getFont(0, 12);
    public static Font smallTitleFont = MinerApp.getFont(1, 12);

    public ClusterFrame(ChartBuilder cBuilder, Vector groupedByCols, Vector displayCols, int catChartType, int contChartType, boolean showPercent) throws OutOfMemoryError {
        this.thisClusterFrame = this;
        this.chartBuilder = cBuilder;
        this.categoricalChartType = catChartType;
        this.continuousChartType = contChartType;
        this.showCountsByPercent = showPercent;
        this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.INITIAL_FRAME_WIDTH = this.screenSize.width - 100;
        this.INITIAL_FRAME_HEIGHT = this.screenSize.height - 100;
        try {
            this.jbInit(groupedByCols, displayCols);
        }
        catch (OutOfMemoryError e) {
            this.clearMemory();
            this.dispose();
            throw e;
        }
        ActionListener cancelListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClusterFrame.this.thisClusterFrame.setVisible(false);
                ClusterFrame.this.clearMemory();
                ClusterFrame.this.thisClusterFrame.dispose();
            }
        };
        this.getJMenuBar().registerKeyboardAction(cancelListener, KeyStroke.getKeyStroke("ESCAPE"), 2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                if (ClusterFrame.this.thisClusterFrame != null) {
                    ClusterFrame.this.thisClusterFrame.setVisible(false);
                }
                ClusterFrame.this.clearMemory();
                if (ClusterFrame.this.thisClusterFrame != null) {
                    ClusterFrame.this.thisClusterFrame.dispose();
                }
            }
        });
    }

    private void jbInit(Vector groupCols, Vector displayCols) throws OutOfMemoryError {
        Hashtable[] conditionTables = null;
        if (!this.chartBuilder.noConditionBys) {
            conditionTables = this.chartBuilder.getConditions(groupCols);
            this.correctLabelWidth = this.setLeftPanelWidth(conditionTables, groupCols);
            if (this.correctLabelWidth < 100) {
                this.correctLabelWidth = 100;
            }
        }
        int numRows = 0;
        this.numCharts = displayCols.size();
        if (this.chartBuilder.noConditionBys) {
            numRows = 1;
        } else {
            numRows = conditionTables.length;
            this.numCharts *= conditionTables.length;
        }
        this.setTitle(ChartBuilder.getText("clusterFrame_frame_title"));
        this.setIconImage(MinerApp.getResourceManager().getImage("minerapp.gif"));
        String filemenu = ChartBuilder.getText("clusterFrame_filemenu");
        this.fileMenu.setText(filemenu);
        this.fileMenu.setMnemonic(70);
        String fileexit = ChartBuilder.getText("clusterFrame_fileexit");
        this.fileMenuExit.setText(fileexit);
        this.fileMenuExit.setMnemonic(88);
        this.fileMenuExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClusterFrame.this.setVisible(false);
                ClusterFrame.this.clearMemory();
                ClusterFrame.this.thisClusterFrame.dispose();
            }
        });
        String fileprint = ChartBuilder.getText("clusterFrame_fileprint");
        this.fileMenuPrint.setText(fileprint);
        this.fileMenuPrint.setMnemonic(80);
        this.fileMenuPrint.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.fileMenuPrint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClusterFrame.this.printCharts();
            }
        });
        String fileprintpreview = ChartBuilder.getText("clusterFrame_fileprintpreview");
        this.fileMenuPrintPreview.setText(fileprintpreview);
        this.fileMenuPrintPreview.setMnemonic(82);
        this.fileMenuPrintPreview.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.fileMenuPrintPreview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClusterFrame.this.chartBuilder.getSingleSelectedChart().printPreview();
            }
        });
        String filesave = ChartBuilder.getText("clusterFrame_filesave");
        this.fileMenuSave.setText(filesave);
        this.fileMenuSave.setMnemonic(83);
        this.fileMenuSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.fileMenuSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClusterFrame.this.saveChartsAs();
            }
        });
        String filecopy = ChartBuilder.getText("clusterFrame_filecopy");
        this.fileMenuCopy.setText(filecopy);
        this.fileMenuCopy.setMnemonic(83);
        this.fileMenuCopy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.fileMenuCopy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClusterFrame.this.copy();
            }
        });
        String help = ChartBuilder.getText("clusterFrame_help");
        this.helpMenu.setText(help);
        this.helpMenu.setMnemonic(72);
        String helpsystem = ChartBuilder.getText("clusterFrame_helpsystem");
        this.helpMenuUserGuide.setText(helpsystem);
        this.helpMenuUserGuide.setMnemonic(67);
        this.helpMenuUserGuide.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.helpMenuUserGuide.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClusterFrame.this.handleHelp();
            }
        });
        String helpabout = ChartBuilder.getText("clusterFrame_helpabout");
        this.helpMenuAbout.setText(helpabout);
        this.helpMenuAbout.setMnemonic(65);
        this.helpMenuAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClusterFrame.this.handleAboutBox();
            }
        });
        String viewmenu = ChartBuilder.getText("clusterFrame_viewmenu");
        this.viewMenu.setText(viewmenu);
        this.viewMenu.setMnemonic(86);
        String viewcharts = ChartBuilder.getText("clusterFrame_viewchart");
        this.viewChartsMenuItem.setText(viewcharts);
        this.viewChartsMenuItem.setMnemonic(67);
        this.viewChartsMenuItem.setAccelerator(KeyStroke.getKeyStroke(69, 2));
        this.viewChartsMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClusterFrame.this.chartBuilder.showDrillDownCharts();
            }
        });
        String view_chart_props = ChartBuilder.getText("clusterFrame_viewchartprops");
        this.viewChartProps.setText(view_chart_props);
        this.viewChartProps.setMnemonic(87);
        this.viewChartProps.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.viewChartProps.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClusterFrame.this.chartBuilder.showChartProperties();
            }
        });
        String show_stats = ChartBuilder.getText("clusterFrame_showstats");
        this.showHideStatistics = new JCheckBoxMenuItem(show_stats, this.chartBuilder.statsVisible());
        this.showHideStatistics.setText(show_stats);
        this.showHideStatistics.setMnemonic(83);
        this.showHideStatistics.setAccelerator(KeyStroke.getKeyStroke(84, 2));
        this.showHideStatistics.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClusterFrame.this.chartBuilder.showStats(!ClusterFrame.this.chartBuilder.statsVisible());
            }
        });
        JCheckBoxMenuItem toggleLegend = new JCheckBoxMenuItem(new AbstractAction(ChartBuilder.getText("clusterFrame_showLegend")){

            public void actionPerformed(ActionEvent e) {
                ClusterFrame.this.chartBuilder.showLegend(!ClusterFrame.this.chartBuilder.legendVisible());
            }
        });
        toggleLegend.setSelected(true);
        toggleLegend.setMnemonic(76);
        toggleLegend.setAccelerator(KeyStroke.getKeyStroke(76, 2));
        this.fileMenu.add(this.fileMenuSave);
        this.fileMenu.add(this.fileMenuCopy);
        this.fileMenu.add(this.fileMenuPrint);
        this.fileMenu.add(this.fileMenuPrintPreview);
        this.fileMenu.add(this.fileMenuExit);
        this.viewMenu.add(this.showHideStatistics);
        this.viewMenu.add(toggleLegend);
        this.viewMenu.add(this.viewChartsMenuItem);
        this.viewMenu.add(this.viewChartProps);
        this.helpMenu.add(this.helpMenuUserGuide);
        this.helpMenu.add(this.helpMenuAbout);
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.viewMenu);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        DynamicGridBagLayout gridbaglayout = new DynamicGridBagLayout();
        ColorPanel backgroundPanel = new ColorPanel(gridbaglayout, "chartLabelBackgroundColor");
        backgroundPanel.setOpaque(true);
        DynamicGridBagConstraints c = new DynamicGridBagConstraints();
        c.anchor = 18;
        c.fill = 1;
        c.gridy = 0;
        c.gridx = 0;
        c.weighty = 1.0;
        c.weightx = 1.0;
        if (!this.chartBuilder.noConditionBys) {
            backgroundPanel.add((Component)this.createGroupByPanel(conditionTables, displayCols, groupCols), c);
        } else {
            backgroundPanel.add((Component)this.createChartPanel(conditionTables, displayCols, groupCols), c);
        }
        Container container = this.getContentPane();
        container.setLayout(new DynamicGridBagLayout());
        DynamicGridBagConstraints gbc = new DynamicGridBagConstraints();
        gbc.anchor = 18;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        gbc.fill = 1;
        container.add((Component)backgroundPanel, gbc);
    }

    private JPanel createGroupByPanel(Hashtable[] conditionTables, Vector displayCols, Vector groupCols) throws OutOfMemoryError {
        ColorPanel groupByPanel = new ColorPanel(new DynamicGridBagLayout(), "chartLabelBackgroundColor");
        JLabel groupByLabel = new JLabel(ChartBuilder.getText("clusterFrame_conditionedby"));
        groupByLabel.setFont(topLabelFont);
        groupByLabel.setForeground(ColorBroker.getColor("chartLabelConditionedByColor"));
        ColorPanel groupByLabelPanel = new ColorPanel(new GridLayout(1, 1), "chartLabelBackgroundColor");
        groupByLabelPanel.add(groupByLabel);
        groupByLabelPanel.setPreferredSize(new Dimension(this.correctLabelWidth, 23));
        groupByLabelPanel.setMinimumSize(new Dimension(this.correctLabelWidth, 23));
        JViewport v = null;
        this.leftLabelPanel = this.createLeftLabels(conditionTables, groupCols);
        this.leftLabelPanel.setRequestFocusEnabled(false);
        this.leftLabelScrollPane = new JScrollPane();
        this.leftLabelScrollPane.setMinimumSize(new Dimension(this.correctLabelWidth, this.leftLabelPanel.getHeight()));
        v = this.leftLabelScrollPane.getViewport();
        v.setScrollMode(2);
        v.add(this.leftLabelPanel);
        v.setBackground(ColorBroker.getColor("chartLabelBackgroundColor"));
        v.setMinimumSize(new Dimension(this.correctLabelWidth, this.leftLabelPanel.getHeight() + 2));
        v.setPreferredSize(new Dimension(this.correctLabelWidth, this.leftLabelPanel.getHeight() + 2));
        this.leftLabelScrollPane.setMinimumSize(new Dimension(this.correctLabelWidth, this.leftLabelPanel.getHeight() + 2));
        this.leftLabelScrollPane.setPreferredSize(new Dimension(this.correctLabelWidth, this.leftLabelPanel.getHeight() + 2));
        this.leftLabelScrollPane.setVerticalScrollBarPolicy(21);
        this.leftLabelScrollPane.setHorizontalScrollBarPolicy(31);
        this.topLabelPanel = this.createTopLabels(displayCols);
        this.topLabelPanel.setRequestFocusEnabled(false);
        this.topLabelPanel.setOpaque(true);
        this.topLabelScrollPane = new JScrollPane();
        v = this.topLabelScrollPane.getViewport();
        v.setMinimumSize(new Dimension(this.topLabelPanel.getWidth(), 13));
        v.setScrollMode(2);
        v.add(this.topLabelPanel);
        v.setBackground(ColorBroker.getColor("chartLabelBackgroundColor"));
        this.topLabelScrollPane.setVerticalScrollBarPolicy(21);
        this.topLabelScrollPane.setHorizontalScrollBarPolicy(31);
        JPanel newChartsPanel = this.createChartPanel(conditionTables, displayCols, groupCols);
        DynamicGridBagConstraints gbc = new DynamicGridBagConstraints();
        gbc.insets = new Insets(5, 10, 2, 0);
        gbc.anchor = 18;
        gbc.fill = 0;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        groupByPanel.add((Component)groupByLabelPanel, gbc);
        gbc.insets = new Insets(1, 5, 3, 0);
        gbc.fill = 1;
        ++gbc.gridy;
        gbc.weighty = 1.0;
        groupByPanel.add((Component)this.leftLabelScrollPane, gbc);
        gbc.fill = 2;
        gbc.insets = new Insets(2, 0, 0, 0);
        ++gbc.gridx;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        groupByPanel.add((Component)this.topLabelScrollPane, gbc);
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        ++gbc.gridy;
        groupByPanel.add((Component)newChartsPanel, gbc);
        return groupByPanel;
    }

    private JPanel createChartPanel(Hashtable[] conditionTables, Vector displayCols, Vector groupCols) {
        this.chartPanel = new ChartPanel(this.chartBuilder.statsVisible());
        this.chartPanel.setOpaque(true);
        this.chartPanel.setBackground(ColorBroker.getColor("chartBackgroundColor"));
        this.chartPanel.setRequestFocusEnabled(true);
        int numRows = this.chartBuilder.noConditionBys ? 1 : conditionTables.length;
        GridLayout layout = new GridLayout(numRows, 1);
        layout.setVgap(1);
        this.chartPanel.setLayout(layout);
        if (this.chartBuilder.noConditionBys) {
            JPanel panel = this.getPanelForGroup(displayCols, null);
            this.setSize(panel.getSize());
            this.chartPanel.add(panel);
        } else {
            for (int i = 0; i < numRows; ++i) {
                this.chartPanel.add(this.getPanelForGroup(displayCols, conditionTables[i]));
            }
            int frameWidth = displayCols.size() * 104 + this.correctLabelWidth + 35;
            int height = this.chartBuilder.statsVisible() ? 160 : 100;
            int frameHeight = numRows * height + 23 + 85;
            if (frameHeight > this.INITIAL_FRAME_HEIGHT) {
                frameHeight = this.INITIAL_FRAME_HEIGHT;
            }
            if (frameWidth > this.INITIAL_FRAME_WIDTH) {
                frameWidth = this.INITIAL_FRAME_WIDTH;
            }
            this.setSize(frameWidth, frameHeight);
        }
        this.chartScrollPane = new JScrollPane();
        this.chartScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.chartViewport = this.chartScrollPane.getViewport();
        this.chartViewport.setScrollMode(2);
        this.chartViewport.setBackground(ColorBroker.getColor("chartBackgroundColor"));
        this.chartViewport.add(this.chartPanel);
        this.chartViewport.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                ClusterFrame.this.setLeftLabelPanelScrollPos(((ClusterFrame)ClusterFrame.this).chartViewport.getViewPosition().y);
                ClusterFrame.this.setTopLabelPanelScrollPos(((ClusterFrame)ClusterFrame.this).chartViewport.getViewPosition().x);
            }
        });
        this.chartScrollPane.setVerticalScrollBarPolicy(20);
        this.chartScrollPane.setHorizontalScrollBarPolicy(30);
        JPanel newChartsPanel = new JPanel(new BorderLayout());
        newChartsPanel.add((Component)this.chartScrollPane, "Center");
        return newChartsPanel;
    }

    public void copy() {
        Toolkit toolkit = this.getToolkit();
        Clipboard clipboard = toolkit.getSystemClipboard();
        ClusterFrame.copyToClipboard(clipboard, this, this.chartBuilder.getSelectedChart());
    }

    public static void copyToClipboard(Clipboard clipboard, ClipboardOwner owner, Component compToCopy) {
        try {
            if (owner instanceof ClusterFrame) {
                ((ClusterFrame)owner).chartBuilder.removeSelectedBorders();
            } else if (owner instanceof DataPanel) {
                ((DataPanel)owner).clearSelectedBorders();
            }
            JPEGTransferable image = new JPEGTransferable(compToCopy);
            clipboard.setContents(image, owner);
            if (owner instanceof ClusterFrame) {
                ((ClusterFrame)owner).chartBuilder.paintSelectedBorders();
            } else if (owner instanceof DataPanel) {
                ((DataPanel)owner).paintSelectedBorders();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void clearMemory() {
        this.chartBuilder.setFrameClosed();
        System.gc();
        for (int i = 0; i < this.chartBuilder.displayedCharts.size(); ++i) {
            DataPanel dp = (DataPanel)this.chartBuilder.displayedCharts.elementAt(i);
            dp.clearMemory();
            dp = null;
        }
        this.chartPanel = null;
        this.chartBuilder.displayedCharts.removeAllElements();
        ColumnHeaderPanel chp = null;
        if (this.leftLabelVector != null) {
            for (int i = 0; i < this.leftLabelVector.size(); ++i) {
                chp = (ColumnHeaderPanel)this.leftLabelVector.elementAt(i);
                chp = null;
            }
        }
        this.leftLabelPanel = null;
        if (this.leftLabelVector != null) {
            this.leftLabelVector.removeAllElements();
        }
        if (this.topLabelPanel != null) {
            for (int i = 0; i < this.topPanelVector.size(); ++i) {
                chp = (ColumnHeaderPanel)this.topPanelVector.elementAt(i);
                chp = null;
            }
        }
        this.topLabelPanel = null;
        if (this.topPanelVector != null) {
            this.topPanelVector.removeAllElements();
        }
        System.gc();
    }

    protected void handleAboutBox() {
        ClusterFrame_AboutBox cfab = new ClusterFrame_AboutBox();
        Dimension cfabSize = cfab.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        cfab.setLocation((frmSize.width - cfabSize.width) / 2 + loc.x, (frmSize.height - cfabSize.height) / 2 + loc.y);
        cfab.setModal(true);
        cfab.show();
    }

    protected void handleHelp() {
    }

    public void disableViewChartProps() {
        this.viewChartProps.setEnabled(false);
    }

    public void enableViewChartProps() {
        this.viewChartProps.setEnabled(true);
    }

    public void disableSaveMenu() {
        this.fileMenuSave.setEnabled(false);
    }

    public void enableSaveMenu() {
        this.fileMenuSave.setEnabled(true);
    }

    public void setEnableCopyMenu(boolean b) {
        this.fileMenuCopy.setEnabled(b);
    }

    public void disablePrintMenu() {
        this.fileMenuPrint.setEnabled(false);
        this.fileMenuPrintPreview.setEnabled(false);
    }

    public void enablePrintMenu() {
        this.fileMenuPrint.setEnabled(true);
        this.fileMenuPrintPreview.setEnabled(true);
    }

    public JPanel createTopLabels(Vector displayCols) {
        TopLabelPanel labelPanel = new TopLabelPanel(this.chartBuilder.statsVisible());
        labelPanel.setBackground(ColorBroker.getColor("chartLabelBackgroundColor"));
        labelPanel.setRequestFocusEnabled(true);
        labelPanel.setLayout(new DynamicGridBagLayout());
        DynamicGridBagConstraints c = new DynamicGridBagConstraints();
        this.topPanelVector = new Vector(displayCols.size());
        c.fill = 2;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridy = 0;
        int i = 0;
        while (i < displayCols.size()) {
            c.insets = new Insets(3, 1, 1, 1);
            ColumnHeaderPanel panel = this.chartBuilder.createColumnHeaderPanel();
            this.topPanelVector.add(panel);
            panel.setSelectedColumn((String)displayCols.elementAt(i));
            JLabel label = new JLabel("  " + (String)displayCols.elementAt(i));
            label.setFont(topLabelFont);
            panel.add((Component)label, "Center");
            panel.setBorder(BorderFactory.createLineBorder(ColorBroker.getColor("chartLabelBorderColor"), 1));
            panel.setPreferredSize(new Dimension(99, 23));
            panel.setMinimumSize(new Dimension(99, 23));
            panel.setBackground(ColorBroker.getColor("chartLabelBackgroundColor"));
            c.gridx = i++;
            labelPanel.add((Component)panel, c);
        }
        return labelPanel;
    }

    public JPanel createLeftLabels(Hashtable[] conditionTables, Vector groupCols) {
        LeftLabelPanel labelPanel = new LeftLabelPanel(this.chartBuilder.statsVisible());
        labelPanel.setRequestFocusEnabled(true);
        labelPanel.setBackground(ColorBroker.getColor("chartLabelBackgroundColor"));
        labelPanel.setLayout(new DynamicGridBagLayout());
        DynamicGridBagConstraints innerGBC = new DynamicGridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 11, 1, new Insets(5, 5, 5, 5), 0, 0);
        DynamicGridBagConstraints labelPanelConstraints = new DynamicGridBagConstraints();
        labelPanelConstraints.insets = new Insets(1, 1, 1, 1);
        labelPanelConstraints.fill = 1;
        labelPanelConstraints.gridwidth = 1;
        labelPanelConstraints.weightx = 1.0;
        labelPanelConstraints.weighty = 1.0;
        int finalNumRows = conditionTables.length;
        this.leftLabelVector = new Vector(conditionTables.length);
        int numRows = 1;
        int numGroupBy = groupCols.size();
        for (int i = 0; i < numGroupBy; ++i) {
            int inc;
            String curGroupCol = (String)groupCols.elementAt(i);
            labelPanelConstraints.gridheight = inc = finalNumRows / (numRows *= this.chartBuilder.getLevels(curGroupCol).size());
            int j = 0;
            int table = 0;
            while (j < numRows) {
                Hashtable condTable = conditionTables[table];
                String[] levels = (String[])condTable.get("levels");
                ColorPanel innerpanel = new ColorPanel(new GridLayout(2, 1), "chartLabelBackgroundColor");
                String variable = " " + (String)groupCols.elementAt(i);
                JLabel left = new JLabel(variable + ":");
                left.setFont(sideLabelFont);
                left.setForeground(ColorBroker.getColor("chartLabelConditionedByColor"));
                innerpanel.add(left);
                JLabel right = new JLabel(" " + levels[i]);
                right.setFont(sideLabelFont);
                innerpanel.add(right);
                ColumnHeaderPanel outerpanel = this.chartBuilder.createColumnHeaderPanel();
                outerpanel.setRowSpecifier(condTable, i);
                outerpanel.setBackground(ColorBroker.getColor("chartLabelBackgroundColor"));
                outerpanel.setVariableWidthBorder(ColorBroker.getColor("chartLabelBorderColor"), numGroupBy - i);
                int height = this.chartBuilder.statsVisible() ? 160 : 100;
                --height;
                int width = this.leftLabelColumnWidths[i];
                if (numGroupBy == 1 && width < 100) {
                    width = this.correctLabelWidth - 3;
                } else if (numGroupBy == 2 && this.leftLabelColumnWidths[0] + this.leftLabelColumnWidths[1] < 100) {
                    width = this.leftLabelColumnWidths[i] > this.correctLabelWidth / 2 - 2 ? this.leftLabelColumnWidths[i] : this.correctLabelWidth / 2 - 2;
                } else if (numGroupBy == 3 && this.leftLabelColumnWidths[0] + this.leftLabelColumnWidths[1] + this.leftLabelColumnWidths[2] < 100) {
                    width = this.leftLabelColumnWidths[i] > this.correctLabelWidth / 3 - 1 ? this.leftLabelColumnWidths[i] : this.correctLabelWidth / 3 - 1;
                }
                outerpanel.setPreferredSize(new Dimension(width, height));
                outerpanel.setLayout(new DynamicGridBagLayout());
                outerpanel.add((Component)innerpanel, innerGBC);
                this.leftLabelVector.add(outerpanel);
                labelPanelConstraints.gridx = i;
                labelPanelConstraints.gridy = table;
                labelPanel.add((Component)outerpanel, labelPanelConstraints);
                ++j;
                table += inc;
            }
        }
        return labelPanel;
    }

    public void resizeLeftLabels(int height) {
        for (int i = 0; i < this.leftLabelVector.size(); ++i) {
            ColumnHeaderPanel innermostPanel = (ColumnHeaderPanel)this.leftLabelVector.elementAt(i);
            Dimension dim = new Dimension(innermostPanel.getWidth(), height - 1);
            innermostPanel.setPreferredSize(dim);
            innermostPanel.setMinimumSize(dim);
            innermostPanel.setSize(dim);
            innermostPanel.repaint();
        }
    }

    public void setLeftLabelPanelScrollPos(int vpos) {
        if (this.leftLabelScrollPane != null && vpos >= 0) {
            this.leftLabelScrollPane.getViewport().setViewPosition(new Point(0, vpos));
        }
    }

    public void setTopLabelPanelScrollPos(int hpos) {
        if (this.topLabelScrollPane != null && hpos >= 0) {
            this.topLabelScrollPane.getViewport().setViewPosition(new Point(hpos, 0));
        }
    }

    private int setLeftPanelWidth(Hashtable[] conditionTables, Vector groupCols) {
        if (groupCols.size() == 0) {
            return 0;
        }
        this.leftLabelColumnWidths = new int[groupCols.size()];
        for (int a = 0; a < this.leftLabelColumnWidths.length; ++a) {
            this.leftLabelColumnWidths[a] = 0;
        }
        for (int i = 0; i < conditionTables.length; ++i) {
            Hashtable conditions = conditionTables[i];
            String[] byCols = (String[])conditions.get("bycols");
            String[] levels = (String[])conditions.get("levels");
            for (int j = 0; j < byCols.length; ++j) {
                int stringlength = Math.max(byCols[j].length() + 2, levels[j].length()) + 1;
                if (this.leftLabelColumnWidths[j] >= (stringlength *= 8)) continue;
                this.leftLabelColumnWidths[j] = stringlength;
            }
        }
        int colsize = 0;
        for (int k = 0; k < this.leftLabelColumnWidths.length; ++k) {
            colsize += this.leftLabelColumnWidths[k];
            colsize += 2;
        }
        return colsize;
    }

    private JPanel getPanelForGroup(Vector displayCols, Hashtable conditions) throws OutOfMemoryError {
        boolean anyGroupBy = conditions != null;
        int numColumns = anyGroupBy ? displayCols.size() : Math.min(displayCols.size(), 5);
        int numRows = anyGroupBy ? 1 : (int)Math.ceil((double)displayCols.size() / (double)numColumns);
        int frameWidth = numColumns * 104 + this.correctLabelWidth + 35;
        int height = this.chartBuilder.statsVisible() ? 160 : 100;
        int frameHeight = numRows * height + 23 + 85;
        if (frameHeight > this.INITIAL_FRAME_HEIGHT) {
            frameHeight = this.INITIAL_FRAME_HEIGHT;
        }
        if (frameWidth > this.INITIAL_FRAME_WIDTH) {
            frameWidth = this.INITIAL_FRAME_WIDTH;
        }
        GridLayout gl = new GridLayout(numRows, numColumns);
        ColorPanel chartRowPanel = new ColorPanel(gl, "chartBackgroundColor");
        chartRowPanel.setRequestFocusEnabled(true);
        gl.setHgap(1);
        chartRowPanel.setLayout(gl);
        for (int i = 0; i < displayCols.size(); ++i) {
            String colName = (String)displayCols.elementAt(i);
            boolean isContinuous = this.chartBuilder.isContinuous(colName) || this.chartBuilder.isDate(colName);
            int chartType = isContinuous ? this.continuousChartType : this.categoricalChartType;
            chartRowPanel.add(this.getPanelForCol(conditions, colName, chartType, i, this.showCountsByPercent));
        }
        chartRowPanel.setSize(frameWidth, frameHeight);
        return chartRowPanel;
    }

    private DataPanel getPanelForCol(Hashtable conditions, String colName, int chartType, int currentChart, boolean showCountPercents) throws OutOfMemoryError {
        DataPanel panel = new DataPanel(colName, conditions, this.chartBuilder, chartType, currentChart, true, showCountPercents);
        if (this.chartBuilder.getLevels(colName).size() > 20) {
            panel.showLegend(false);
        }
        if (this.chartBuilder.statsVisible()) {
            panel.showStatsPanel();
        } else {
            panel.hideStatsPanel();
        }
        this.chartBuilder.addChart(panel);
        if (this.firstSelectedChart == null) {
            this.firstSelectedChart = panel;
        }
        return panel;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    private void printCharts() {
        this.chartBuilder.printSelectedChart();
    }

    private void saveChartsAs() {
        this.chartBuilder.saveSelectedChart();
    }

    public void lostOwnership(Clipboard c, Transferable t) {
    }

    public class ColorPanel
    extends JPanel {
        public ColorPanel(LayoutManager layout, String bkgrd) {
            super(layout);
            this.setBackground(ColorBroker.getColor(bkgrd));
        }
    }

    public static class JPEGTransferable
    implements Transferable {
        private DataFlavor jpegFlavor = DataFlavor.imageFlavor;
        private Component comp;
        private DataFlavor[] flavorArray = null;

        public JPEGTransferable(Component c) {
            this.comp = c;
            this.flavorArray = new DataFlavor[]{this.jpegFlavor};
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this.flavorArray;
        }

        public boolean isDataFlavorSupported(DataFlavor f) {
            return f.equals(this.jpegFlavor);
        }

        public Object getTransferData(DataFlavor f) throws UnsupportedFlavorException, IOException {
            if (f.equals(DataFlavor.imageFlavor)) {
                return MinerApp.getAsJPEG(this.comp);
            }
            throw new UnsupportedFlavorException(f);
        }
    }

    private class LeftLabelPanel
    extends ChartPanel {
        private ClusterFrame cf;

        public LeftLabelPanel(boolean b) {
            super(b);
            this.cf = ClusterFrame.this;
        }
    }

    private class TopLabelPanel
    extends ChartPanel {
        public TopLabelPanel(boolean b) {
            super(b);
        }
    }
}

