/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcJavaTransform;
import com.insightful.cnkjava.CNKProcJavaTransformExec;
import com.insightful.miner.EngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import com.insightful.miner.expression.ExpressionEvaluator;
import java.util.Hashtable;
import java.util.Random;
import java.util.Vector;

public class CreateColumnsEngineNode
extends EngineNode
implements CNKProcJavaTransformExec {
    public static String NEW_COLUMNS_ATTRIBUTE_TAG = "newColumns";
    public static String NAME_ATTRIBUTE_TAG = "name";
    public static String TYPE_ATTRIBUTE_TAG = "type";
    public static String EXPRESSION_ATTRIBUTE_TAG = "expression";
    public static String STRING_SIZE_ATTRIBUTE_TAG = "stringSize";
    public static String COPY_FIRST_INPUT_COLUMNS_ATTRIBUTE_TAG = "copyFirstInputColumns";
    private boolean m_parseOK = false;
    private int m_numCopyColumns = 0;
    private Random m_random = null;
    private int m_numModifiedColumns = 0;
    private boolean[] m_isColumnModified = null;
    private boolean m_copyInput = true;
    private String[] m_newColumnNames;
    private int[] m_newColumnOutputColumns;
    private int[] m_newColumnTypes;
    private int[] m_newColumnEstimateMaxStringWidth;
    private Object[] m_newColumnOutputVectors;
    private ExpressionEvaluator[] m_newColumnExpressionEvaluators;
    private String m_parseErrorString;
    private int m_maxNext = 0;
    private int[] m_newColumnExecutionOrder;

    public CNKProc procCreate() throws Exception {
        CNKProcJavaTransform proc = new CNKProcJavaTransform();
        proc.setExecObject(this);
        this.printColumnInfo();
        return proc;
    }

    protected void printColumnInfo() {
        String colName;
        int i;
        XTProps props = this.getNodeProperties();
        XTMetaData inputMD = this.getInputMetaData(0);
        Vector newColumnNames = this.getCalcColumnNames(props);
        Vector modifiedColumns = this.getCalcModifiedColumnNames(props, inputMD);
        newColumnNames.removeAll(modifiedColumns);
        StringBuffer buf = new StringBuffer();
        if (newColumnNames.size() > 0) {
            buf.setLength(0);
            buf.append("Creating new columns: ");
            for (i = 0; i < newColumnNames.size(); ++i) {
                colName = (String)newColumnNames.get(i);
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(colName + " [" + this.getCalcColumnType(props, colName) + "]");
            }
            this.printlnInformation(buf.toString());
        }
        if (modifiedColumns.size() > 0) {
            buf.setLength(0);
            buf.append("Modifying columns: ");
            for (i = 0; i < modifiedColumns.size(); ++i) {
                colName = (String)modifiedColumns.get(i);
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append(colName + " [" + this.getCalcColumnType(props, colName) + "]");
            }
            this.printlnInformation(buf.toString());
        }
    }

    public void procDelete(CNKProc proc) {
        this.cleanupEvaluators();
        super.procDelete(proc);
    }

    public void invalidateNodeState() {
        this.cleanupEvaluators();
    }

    private void cleanupEvaluators() {
        if (this.m_newColumnExpressionEvaluators != null) {
            for (int i = 0; i < this.m_newColumnExpressionEvaluators.length; ++i) {
                if (this.m_newColumnExpressionEvaluators[i] == null) continue;
                this.m_newColumnExpressionEvaluators[i].cleanup();
            }
        }
        this.m_newColumnExpressionEvaluators = null;
    }

    public void procSetProperties(CNKProc proc) {
        int i;
        XTProps props = this.getNodeProperties();
        XTMetaData outputMD = this.getOutputMetaData(0);
        this.m_random = this.getRandomGenerator();
        this.m_parseOK = this.parseExpressions();
        this.m_copyInput = this.getCopyFirstInputColumns(props);
        if (this.m_copyInput) {
            XTMetaData inputMD = this.getInputMetaData(0);
            this.m_numCopyColumns = inputMD.getNumColumns();
            Vector modifiedColumns = this.getCalcModifiedColumnNames(props, inputMD);
            this.m_numModifiedColumns = modifiedColumns.size();
            if (this.m_numModifiedColumns > 0) {
                this.m_isColumnModified = new boolean[this.m_numCopyColumns];
                for (int i2 = 0; i2 < this.m_numCopyColumns; ++i2) {
                    this.m_isColumnModified[i2] = modifiedColumns.contains(inputMD.ordinalToName(i2));
                }
            }
        }
        if (!this.m_parseOK) {
            return;
        }
        this.m_maxNext = 0;
        for (i = 0; i < this.m_newColumnExpressionEvaluators.length; ++i) {
            this.m_newColumnExpressionEvaluators[i].beginEval((CNKProcJavaTransform)proc, this.m_random);
            this.m_maxNext = Math.max(this.m_maxNext, this.m_newColumnExpressionEvaluators[i].getMaxNext());
        }
        this.m_newColumnOutputColumns = new int[this.m_newColumnNames.length];
        for (i = 0; i < this.m_newColumnNames.length; ++i) {
            int newColumnNum;
            String colName = this.m_newColumnNames[i];
            this.m_newColumnOutputColumns[i] = newColumnNum = outputMD.nameToOrdinal(colName);
        }
    }

    public void execute(CNKProcJavaTransform proc) {
        int i;
        int inputRowsAvailable = proc.getChunkInputRows(0);
        if (inputRowsAvailable < 1) {
            if (proc.getChunkInputLast(0)) {
                proc.setChunkDone(true);
            }
            return;
        }
        if (!this.m_parseOK) {
            proc.addError("error parsing expressions\n" + this.m_parseErrorString);
            return;
        }
        int inputRows = inputRowsAvailable;
        if (inputRows > 0 && !proc.getChunkInputLast(0)) {
            if (this.m_maxNext >= inputRows) {
                proc.addError("can't look ahead " + this.m_maxNext + " rows with a block size of " + inputRows + " rows");
                return;
            }
            inputRows -= this.m_maxNext;
        }
        if (this.m_copyInput) {
            if (this.m_numModifiedColumns < 1) {
                proc.copyData(0, 0, 0, 0, 0, 0, inputRows, this.m_numCopyColumns);
            } else {
                for (int colNum = 0; colNum < this.m_numCopyColumns; ++colNum) {
                    if (this.m_isColumnModified[colNum]) continue;
                    proc.copyColumnData(0, colNum, 0, 0, colNum, 0, inputRows);
                }
            }
        }
        int numNewColumns = this.m_newColumnExpressionEvaluators.length;
        long inputPosition = proc.getChunkInputPosition(0);
        for (i = 0; i < numNewColumns; ++i) {
            int outputCol = this.m_newColumnOutputColumns[i];
            switch (this.m_newColumnTypes[i]) {
                case 0: {
                    this.m_newColumnOutputVectors[i] = proc.getChunkOutputColumnDoubles(0, outputCol);
                    break;
                }
                case 1: {
                    this.m_newColumnOutputVectors[i] = proc.getChunkOutputColumnStrings(0, outputCol);
                    break;
                }
                case 2: {
                    this.m_newColumnOutputVectors[i] = proc.getChunkOutputColumnDateTimes(0, outputCol);
                }
            }
            this.m_newColumnExpressionEvaluators[i].beginChunk(inputPosition, inputRows);
        }
        for (int row = 0; row < inputRows; ++row) {
            block13: for (i = 0; i < numNewColumns; ++i) {
                int exprNum = this.m_newColumnExecutionOrder[i];
                this.m_newColumnExpressionEvaluators[exprNum].setDataSourceRow(row);
                this.m_newColumnExpressionEvaluators[exprNum].updatePrevData(row, inputRows, inputRowsAvailable);
                switch (this.m_newColumnTypes[exprNum]) {
                    case 0: {
                        ((double[])this.m_newColumnOutputVectors[exprNum])[row] = this.m_newColumnExpressionEvaluators[exprNum].evalToDouble();
                        continue block13;
                    }
                    case 1: {
                        ((String[])this.m_newColumnOutputVectors[exprNum])[row] = this.m_newColumnExpressionEvaluators[exprNum].evalToString();
                        continue block13;
                    }
                    case 2: {
                        ((long[])this.m_newColumnOutputVectors[exprNum])[row] = this.m_newColumnExpressionEvaluators[exprNum].evalToDateTime();
                    }
                }
            }
        }
        for (i = 0; i < numNewColumns; ++i) {
            this.m_newColumnOutputVectors[i] = null;
            this.m_newColumnExpressionEvaluators[i].endChunk();
            if (!this.m_newColumnExpressionEvaluators[i].hasEvalErrors()) continue;
            String colName = this.m_newColumnNames[i];
            Vector errVec = this.m_newColumnExpressionEvaluators[i].getEvalErrors();
            for (int errNum = 0; errNum < errVec.size(); ++errNum) {
                String errStr = (String)errVec.get(errNum);
                proc.addError("computing " + colName + ": " + errStr);
            }
        }
        int numInputs = proc.getNumInbufs();
        for (i = 0; i < numInputs; ++i) {
            proc.setChunkInputReleaseRows(i, inputRows);
        }
        proc.setChunkOutputReleaseRows(0, inputRows);
    }

    private boolean anyExpressionNeedsDataSummary() {
        boolean parseOK = this.parseExpressions();
        if (!parseOK) {
            return false;
        }
        int numNewColumns = this.m_newColumnExpressionEvaluators.length;
        for (int i = 0; i < numNewColumns; ++i) {
            if (!this.m_newColumnExpressionEvaluators[i].needsDataSummary()) continue;
            return true;
        }
        return false;
    }

    private boolean parseExpressions() {
        XTProps props = this.getNodeProperties();
        return this.parseExpressions(props, this.getAllInputMetaData());
    }

    public String getParseErrors(XTProps props) {
        boolean ok = false;
        try {
            ok = this.parseExpressions(props, this.getAllInputMetaData());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return ok ? "" : this.m_parseErrorString;
    }

    protected boolean getCopyFirstInputColumns(XTProps props) {
        boolean copyColumns = props.getBoolean(COPY_FIRST_INPUT_COLUMNS_ATTRIBUTE_TAG, true);
        return copyColumns;
    }

    protected Vector getCalcColumnNames(XTProps props) {
        Vector newColumnNames = props.getSubProperties(NEW_COLUMNS_ATTRIBUTE_TAG);
        return newColumnNames;
    }

    protected Vector getCalcModifiedColumnNames(XTProps props, XTMetaData inputMD) {
        Vector newColumnNames = this.getCalcColumnNames(props);
        Vector<String> modifiedColumnNames = new Vector<String>();
        int numOldColumns = inputMD.getNumColumns();
        for (int colNum = 0; colNum < numOldColumns; ++colNum) {
            if (!newColumnNames.contains(inputMD.ordinalToName(colNum))) continue;
            modifiedColumnNames.add(inputMD.ordinalToName(colNum));
        }
        return modifiedColumnNames;
    }

    protected Vector getCalcExpressions(XTProps props) {
        Vector newColumnNames = this.getCalcColumnNames(props);
        Vector<String> newExpressions = new Vector<String>();
        for (int i = 0; i < newColumnNames.size(); ++i) {
            String colName = (String)newColumnNames.get(i);
            String exprString = props.getValue(new String[]{NEW_COLUMNS_ATTRIBUTE_TAG, colName, EXPRESSION_ATTRIBUTE_TAG}, "");
            newExpressions.add(exprString);
        }
        return newExpressions;
    }

    protected String getCalcColumnType(XTProps props, String colName) {
        String colType = props.getValue(new String[]{NEW_COLUMNS_ATTRIBUTE_TAG, colName, TYPE_ATTRIBUTE_TAG}, "").trim();
        return colType;
    }

    protected int getCalcColumnStringWidth(XTProps props, String colName) {
        int stringWidth = props.getInt(new String[]{NEW_COLUMNS_ATTRIBUTE_TAG, colName, STRING_SIZE_ATTRIBUTE_TAG}, -1);
        if (stringWidth > 0) {
            return stringWidth;
        }
        stringWidth = props.getInt(STRING_SIZE_ATTRIBUTE_TAG, -1);
        if (stringWidth > 0) {
            return stringWidth;
        }
        stringWidth = this.getWorksheetPropertiesManager().getDefaultStringSize();
        if (this.m_newColumnNames != null && this.m_newColumnEstimateMaxStringWidth != null && this.m_newColumnNames.length == this.m_newColumnEstimateMaxStringWidth.length) {
            for (int i = 0; i < this.m_newColumnNames.length; ++i) {
                if (this.m_newColumnNames[i] == null || !this.m_newColumnNames[i].equals(colName)) continue;
                int newVal = this.m_newColumnEstimateMaxStringWidth[i] + 1;
                stringWidth = Math.max(stringWidth, newVal);
                break;
            }
        }
        return stringWidth;
    }

    private boolean parseExpressions(XTProps props, XTMetaData[] inputMD) {
        Vector newColumnNames = this.getCalcColumnNames(props);
        Vector newExpressions = this.getCalcExpressions(props);
        int numColumns = newColumnNames.size();
        this.m_newColumnNames = new String[numColumns];
        this.m_newColumnTypes = new int[numColumns];
        this.m_newColumnEstimateMaxStringWidth = new int[numColumns];
        this.m_newColumnOutputVectors = new Object[numColumns];
        this.m_newColumnExpressionEvaluators = new ExpressionEvaluator[numColumns];
        this.m_parseErrorString = "";
        StringBuffer parseErrorBuf = new StringBuffer();
        Hashtable<String, Integer> calcNameToType = new Hashtable<String, Integer>();
        Hashtable<String, Integer> calcNameToNum = new Hashtable<String, Integer>();
        Hashtable<String, ExpressionEvaluator> calcNameToExpr = new Hashtable<String, ExpressionEvaluator>();
        for (int i = 0; i < newColumnNames.size(); ++i) {
            String colName;
            this.m_newColumnNames[i] = colName = (String)newColumnNames.get(i);
            String newColumnType = this.getCalcColumnType(props, colName);
            this.m_newColumnTypes[i] = newColumnType.equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG) || newColumnType.equals(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG) ? 1 : (newColumnType.equals(XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG) ? 2 : 0);
            calcNameToType.put(colName, new Integer(this.m_newColumnTypes[i]));
            calcNameToNum.put(colName, new Integer(i));
        }
        boolean allParseOK = true;
        for (int i = 0; i < newColumnNames.size(); ++i) {
            ExpressionEvaluator exprEval;
            String colName = this.m_newColumnNames[i];
            String exprString = (String)newExpressions.get(i);
            exprString = this.getNetworkManager().substituteParaeters(exprString);
            this.m_newColumnExpressionEvaluators[i] = exprEval = new ExpressionEvaluator();
            exprEval.setExpressionString(exprString);
            exprEval.setExpressionType(this.m_newColumnTypes[i]);
            exprEval.setDataSourceMetaData(inputMD);
            exprEval.setNewColumnHash(calcNameToType);
            exprEval.setWorksheetPropertiesManager(this.getNetworkManager().getWorksheetPropertiesManager());
            calcNameToExpr.put(colName, exprEval);
            boolean ok = exprEval.constructParseTree();
            if (!ok) {
                allParseOK = false;
            } else {
                ok = exprEval.constructEvalTree();
                if (!ok) {
                    allParseOK = false;
                }
            }
            if (ok) continue;
            if (parseErrorBuf.length() > 0) {
                parseErrorBuf.append("\n");
            }
            parseErrorBuf.append("error parsing expression to compute " + colName + "\n   " + exprEval.getFormattedError());
        }
        if (allParseOK) {
            int i;
            Vector orderVec = new Vector();
            Vector processedVector = new Vector();
            for (i = numColumns - 1; i >= 0; --i) {
                String err = this.scheduleOutputColumn(i, orderVec, processedVector, calcNameToNum);
                if (err == null) continue;
                parseErrorBuf.append(err);
                allParseOK = false;
                break;
            }
            if (allParseOK) {
                this.m_newColumnExecutionOrder = new int[numColumns];
                for (i = 0; i < numColumns && i < orderVec.size(); ++i) {
                    int exprNum;
                    this.m_newColumnExecutionOrder[i] = exprNum = ((Integer)orderVec.get(i)).intValue();
                    this.m_newColumnExpressionEvaluators[i].setNewColumnHash(calcNameToExpr);
                }
            }
        }
        if (allParseOK) {
            for (int i = 0; i < numColumns; ++i) {
                int exprNum = this.m_newColumnExecutionOrder[i];
                this.m_newColumnEstimateMaxStringWidth[exprNum] = this.m_newColumnExpressionEvaluators[exprNum].estimateMaxStringWidth();
            }
        }
        this.m_parseErrorString = parseErrorBuf.toString();
        return allParseOK;
    }

    private String scheduleOutputColumn(int exprNum, Vector orderVec, Vector processedVec, Hashtable calcNameToNum) {
        Integer exprNumKey = new Integer(exprNum);
        if (orderVec.contains(exprNumKey)) {
            return null;
        }
        if (processedVec.contains(exprNumKey)) {
            return "Error: expression to compute " + this.m_newColumnNames[exprNum] + " references its own new value with getNew()";
        }
        processedVec.add(exprNumKey);
        ExpressionEvaluator exprEval = this.m_newColumnExpressionEvaluators[exprNum];
        Vector refNames = exprEval.getReferencedNames();
        for (int i = 0; i < refNames.size(); ++i) {
            String refName = (String)refNames.get(i);
            int refNum = (Integer)calcNameToNum.get(refName);
            String err = this.scheduleOutputColumn(refNum, orderVec, processedVec, calcNameToNum);
            if (err == null) continue;
            return err;
        }
        orderVec.add(exprNumKey);
        return null;
    }

    public XTMetaData calculateOutputMetaData(int outputNum) {
        XTProps props = this.getNodeProperties();
        XTMetaData md = this.getInputMetaData(0);
        this.parseExpressions();
        return this.calculateOutputMetaData(props, md);
    }

    private XTMetaData calculateOutputMetaData(XTProps props, XTMetaData inputMD) {
        XTMetaData md = null;
        boolean copyInput = this.getCopyFirstInputColumns(props);
        Vector newColumnNames = this.getCalcColumnNames(props);
        Vector modifiedColumns = copyInput ? this.getCalcModifiedColumnNames(props, inputMD) : null;
        try {
            if (!copyInput) {
                md = new XTMetaData();
            } else if (modifiedColumns.size() < 1) {
                md = (XTMetaData)inputMD.clone();
            } else {
                md = new XTMetaData();
                int numInputColumns = inputMD.getNumColumns();
                for (int colNum = 0; colNum < numInputColumns; ++colNum) {
                    String colName = inputMD.ordinalToName(colNum);
                    if (modifiedColumns.contains(colName)) {
                        this.addNewColumnInfo(md, colName, props);
                    } else if (inputMD.isContinuousColumn(colNum)) {
                        md.appendContinousDataField(colName);
                    } else if (inputMD.isCategoricalColumn(colNum)) {
                        md.appendCategoricalDataField(colName, new String[0]);
                    } else if (inputMD.isDateTimeColumn(colNum)) {
                        md.appendDateTimeDataField(colName);
                    } else if (inputMD.isBlobColumn(colNum)) {
                        md.appendBlobDataField(colName, inputMD.getBlobDataFieldClassName(colNum));
                    } else if (inputMD.isStringColumn(colNum)) {
                        md.appendStringDataField(colName, inputMD.getStringDataFieldWidth(colNum));
                    }
                    md.setDataFieldRole(colNum, inputMD.getColumnRole(colNum));
                }
            }
            for (int newCol = 0; newCol < newColumnNames.size(); ++newCol) {
                String newColName = (String)newColumnNames.get(newCol);
                if (copyInput && modifiedColumns.contains(newColName)) continue;
                this.addNewColumnInfo(md, newColName, props);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return md;
    }

    private void addNewColumnInfo(XTMetaData md, String colName, XTProps props) {
        String colType = this.getCalcColumnType(props, colName);
        if (XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG.equals(colType)) {
            md.appendCategoricalDataField(colName, new String[0]);
        } else if (XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG.equals(colType)) {
            md.appendContinousDataField(colName);
        } else if (XTMetaData.STRING_TYPE_ATTRIBUTE_TAG.equals(colType)) {
            md.appendStringDataField(colName, this.getCalcColumnStringWidth(props, colName));
        } else if (XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG.equals(colType)) {
            md.appendDateTimeDataField(colName);
        } else {
            throw new RuntimeException("Column type of '" + colType + "' not recognized.");
        }
    }

    public EngineNode.InputRequirements getInputRequirements(int inputNum) {
        if (this.anyExpressionNeedsDataSummary()) {
            return new EngineNode.InputRequirements(false, false, false, true, true, false);
        }
        return EngineNode.InputRequirements.getMinRequirements();
    }
}

