/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.ActivityNodeArea;
import com.insightful.miner.BaseNodePort;
import com.insightful.miner.MinerApp;
import com.insightful.miner.MinerFrame;
import com.nwoods.jgo.JGoPort;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;

public class CreateLinkDialog
extends JDialog {
    private JComboBox m_fromANM = null;
    private JComboBox m_fromPort = null;
    private JComboBox m_toANM = null;
    private JComboBox m_toPort = null;
    private JRadioButton m_modelLink = null;
    public boolean success = false;
    private Vector m_fromANMs = null;
    private Vector m_toANMs = null;
    private Vector m_fromPMMLs = null;
    private Vector m_toPMMLs = null;
    private static String MODEL_PORT_STRING = MinerApp.getText("CreateLinkDialog_modelPort");

    public CreateLinkDialog(MinerFrame mf, Vector fromANMs, Vector fromPMMLs, Vector toANMs, Vector toPMMLs) {
        super(mf, MinerApp.getText("CreateLinkDialog_createNewLink"), true);
        this.setLocationRelativeTo(mf);
        this.m_fromANMs = fromANMs;
        this.m_fromPMMLs = fromPMMLs;
        this.m_toANMs = toANMs;
        this.m_toPMMLs = toPMMLs;
        boolean normalLinkPossible = fromANMs.size() > 0 && toANMs.size() > 0;
        boolean modelLinkPossible = fromPMMLs.size() > 0 && toPMMLs.size() > 0;
        JRadioButton link = new JRadioButton(MinerApp.getText("CreateLinkDialog_normal"));
        link.setMnemonic(MinerApp.getText("CreateLinkDialog_normalHotkey").charAt(0));
        link.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateLinkDialog.this.m_fromANM.setModel(new DefaultComboBoxModel(CreateLinkDialog.this.m_fromANMs));
                CreateLinkDialog.this.m_toANM.setModel(new DefaultComboBoxModel(CreateLinkDialog.this.m_toANMs));
                CreateLinkDialog.this.m_fromANM.setRenderer(new ModelCellRenderer());
                CreateLinkDialog.this.m_toANM.setRenderer(new ModelCellRenderer());
                CreateLinkDialog.this.m_fromANM.setSelectedIndex(-1);
                CreateLinkDialog.this.m_toANM.setSelectedIndex(-1);
            }
        });
        this.m_modelLink = new JRadioButton(MinerApp.getText("CreateLinkDialog_model"));
        this.m_modelLink.setMnemonic(MinerApp.getText("CreateLinkDialog_modelHotkey").charAt(0));
        this.m_modelLink.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateLinkDialog.this.m_fromANM.setModel(new DefaultComboBoxModel(CreateLinkDialog.this.m_fromPMMLs));
                CreateLinkDialog.this.m_toANM.setModel(new DefaultComboBoxModel(CreateLinkDialog.this.m_toPMMLs));
                CreateLinkDialog.this.m_fromANM.setRenderer(new ModelCellRenderer());
                CreateLinkDialog.this.m_toANM.setRenderer(new ModelCellRenderer());
                CreateLinkDialog.this.m_fromANM.setSelectedIndex(-1);
                CreateLinkDialog.this.m_toANM.setSelectedIndex(-1);
            }
        });
        JComboBox testcb = new JComboBox(this.m_fromANMs);
        Dimension dim = new Dimension(testcb.getPreferredSize());
        testcb.setModel(new DefaultComboBoxModel(this.m_fromPMMLs));
        Dimension tDim = new Dimension(testcb.getPreferredSize());
        if (tDim.width > dim.width) {
            dim = tDim;
        }
        testcb.setModel(new DefaultComboBoxModel(this.m_toANMs));
        tDim = new Dimension(testcb.getPreferredSize());
        if (tDim.width > dim.width) {
            dim = tDim;
        }
        testcb.setModel(new DefaultComboBoxModel(this.m_toPMMLs));
        tDim = new Dimension(testcb.getPreferredSize());
        if (tDim.width > dim.width) {
            dim = tDim;
        }
        testcb = null;
        JLabel fromLabel = new JLabel(MinerApp.getText("CreateLinkDialog_fromNode"));
        this.m_fromANM = new JComboBox(fromANMs);
        this.m_fromANM.setRenderer(new ModelCellRenderer());
        fromLabel.setLabelFor(this.m_fromANM);
        fromLabel.setDisplayedMnemonic(MinerApp.getText("CreateLinkDialog_fromNodeHotkey").charAt(0));
        this.m_fromANM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateLinkDialog.this.cbAction(true);
            }
        });
        this.m_fromANM.setPreferredSize(dim);
        JLabel fromPort = new JLabel(MinerApp.getText("CreateLinkDialog_port"));
        this.m_fromPort = new JComboBox();
        fromPort.setLabelFor(this.m_fromPort);
        fromPort.setDisplayedMnemonic(MinerApp.getText("CreateLinkDialog_portHotkey").charAt(0));
        this.m_fromPort.setPreferredSize(dim);
        this.m_fromPort.setEnabled(false);
        JLabel toLabel = new JLabel(MinerApp.getText("CreateLinkDialog_toNode"));
        this.m_toANM = new JComboBox(toANMs);
        this.m_toANM.setRenderer(new ModelCellRenderer());
        toLabel.setLabelFor(this.m_toANM);
        toLabel.setDisplayedMnemonic(MinerApp.getText("CreateLinkDialog_toNodeHotkey").charAt(0));
        this.m_toANM.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateLinkDialog.this.cbAction(false);
            }
        });
        this.m_toANM.setPreferredSize(dim);
        JLabel toPort = new JLabel(MinerApp.getText("CreateLinkDialog_port"));
        this.m_toPort = new JComboBox();
        toPort.setLabelFor(this.m_toPort);
        toPort.setDisplayedMnemonic(MinerApp.getText("CreateLinkDialog_portHotkey").charAt(1));
        this.m_toPort.setPreferredSize(dim);
        this.m_toPort.setEnabled(false);
        JButton cancel = new JButton(MinerApp.getText("NodeDialog_cancel"));
        cancel.setMnemonic(MinerApp.getText("NodeDialog_cancelHotkey").charAt(0));
        ActionListener cancelListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                CreateLinkDialog.this.success = false;
                CreateLinkDialog.this.dispose();
            }
        };
        cancel.addActionListener(cancelListener);
        cancel.registerKeyboardAction(cancelListener, KeyStroke.getKeyStroke("ESCAPE"), 2);
        JButton ok = new JButton(MinerApp.getText("NodeDialog_ok"));
        ok.setMnemonic(MinerApp.getText("NodeDialog_okHotkey").charAt(0));
        ok.setPreferredSize(cancel.getPreferredSize());
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    JGoPort fP = CreateLinkDialog.this.getFromPort();
                    JGoPort tP = CreateLinkDialog.this.getToPort();
                    if (fP == null || tP == null) {
                        AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), MinerApp.getText("CreateLinkDialog_message_unabletoFindnode"));
                    } else if (!fP.validLink(tP)) {
                        AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), MinerApp.getText("CreateLinkDialog_message_invalidLink"));
                    } else {
                        CreateLinkDialog.this.success = true;
                        CreateLinkDialog.this.dispose();
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        ButtonGroup bg = new ButtonGroup();
        bg.add(link);
        bg.add(this.m_modelLink);
        if (normalLinkPossible) {
            link.doClick();
        } else if (modelLinkPossible) {
            this.m_modelLink.doClick();
        }
        link.setEnabled(normalLinkPossible);
        this.m_modelLink.setEnabled(modelLinkPossible);
        this.m_fromANM.setSelectedIndex(-1);
        this.m_toANM.setSelectedIndex(-1);
        Container container = this.getContentPane();
        container.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        Insets unindent = new Insets(5, 5, 5, 5);
        constraints.anchor = 18;
        constraints.fill = 2;
        constraints.gridy = 0;
        constraints.gridx = 0;
        JPanel linkTypePanel = new JPanel();
        linkTypePanel.setLayout(new BoxLayout(linkTypePanel, 0));
        linkTypePanel.add(new JLabel(MinerApp.getText("CreateLinkDialog_linkType")));
        linkTypePanel.add(link);
        linkTypePanel.add(Box.createHorizontalStrut(5));
        linkTypePanel.add(this.m_modelLink);
        linkTypePanel.add(Box.createHorizontalGlue());
        constraints.weightx = 1.0;
        constraints.gridwidth = 0;
        container.add((Component)linkTypePanel, constraints);
        ++constraints.gridy;
        constraints.gridwidth = 1;
        constraints.weightx = 0.0;
        constraints.insets = unindent;
        container.add((Component)fromLabel, constraints);
        ++constraints.gridx;
        constraints.insets = unindent;
        container.add((Component)this.m_fromANM, constraints);
        ++constraints.gridx;
        constraints.insets = unindent;
        container.add((Component)toLabel, constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        constraints.insets = unindent;
        container.add((Component)this.m_toANM, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.weightx = 0.0;
        constraints.insets = unindent;
        container.add((Component)fromPort, constraints);
        ++constraints.gridx;
        constraints.insets = unindent;
        container.add((Component)this.m_fromPort, constraints);
        ++constraints.gridx;
        constraints.insets = unindent;
        container.add((Component)toPort, constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        constraints.insets = unindent;
        container.add((Component)this.m_toPort, constraints);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(ok);
        buttonPanel.add(Box.createHorizontalStrut(5));
        buttonPanel.add(cancel);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.gridwidth = 0;
        container.add((Component)buttonPanel, constraints);
        this.pack();
        Rectangle rect = this.getBounds();
        int newX = rect.x - rect.width / 2;
        int newY = rect.y - rect.height / 2;
        this.setBounds(newX, newY, rect.width, rect.height);
    }

    public ActivityNodeArea getFromNode() {
        return (ActivityNodeArea)this.m_fromANM.getSelectedItem();
    }

    public ActivityNodeArea getToNode() {
        return (ActivityNodeArea)this.m_toANM.getSelectedItem();
    }

    public JGoPort getFromPort() {
        BaseNodePort fromPort = null;
        try {
            if (this.m_modelLink.isSelected()) {
                return ((ActivityNodeArea)this.m_fromANM.getSelectedItem()).getModelLinkOutputPort();
            }
            int fromPortIndex = (Integer)this.m_fromPort.getSelectedItem();
            fromPort = (BaseNodePort)((Object)((ActivityNodeArea)this.m_fromANM.getSelectedItem()).getOutputPorts().get(fromPortIndex - 1));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fromPort;
    }

    public JGoPort getToPort() {
        BaseNodePort toPort = null;
        try {
            if (this.m_modelLink.isSelected()) {
                return ((ActivityNodeArea)this.m_toANM.getSelectedItem()).getModelLinkInputPort();
            }
            int toPortIndex = (Integer)this.m_toPort.getSelectedItem();
            toPort = (BaseNodePort)((Object)((ActivityNodeArea)this.m_toANM.getSelectedItem()).getInputPorts().get(toPortIndex - 1));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toPort;
    }

    private void cbAction(boolean from) {
        try {
            boolean model = this.m_modelLink.isSelected();
            if (from) {
                ActivityNodeArea area = (ActivityNodeArea)this.m_fromANM.getSelectedItem();
                this.m_fromPort.setEnabled(area != null);
                this.m_fromPort.removeAllItems();
                if (area != null && model) {
                    this.m_fromPort.addItem(MODEL_PORT_STRING);
                    this.m_fromPort.setSelectedIndex(0);
                    return;
                }
                if (area == null) {
                    return;
                }
                int newNumPorts = area.getOutputPorts().size();
                for (int i = 0; i < newNumPorts; ++i) {
                    this.m_fromPort.addItem(new Integer(i + 1));
                }
                if (newNumPorts > 0) {
                    this.m_fromPort.setSelectedIndex(0);
                }
            } else {
                ActivityNodeArea area = (ActivityNodeArea)this.m_toANM.getSelectedItem();
                this.m_toPort.setEnabled(area != null);
                this.m_toPort.removeAllItems();
                if (area != null && model) {
                    this.m_toPort.addItem(MODEL_PORT_STRING);
                    this.m_toPort.setSelectedIndex(0);
                    return;
                }
                if (area == null) {
                    return;
                }
                Vector inputPorts = area.getInputPorts();
                int newNumPorts = inputPorts.size();
                for (int i = 0; i < newNumPorts; ++i) {
                    BaseNodePort port = (BaseNodePort)((Object)inputPorts.get(i));
                    if (!port.hasNoLinks() && port.isSingle()) continue;
                    this.m_toPort.addItem(new Integer(i + 1));
                }
                if (newNumPorts > 0) {
                    this.m_toPort.setSelectedIndex(0);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private class ModelCellRenderer
    extends DefaultListCellRenderer {
        private ModelCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object val, int row, boolean sel, boolean focus) {
            if (val == null) {
                return super.getListCellRendererComponent((JList<?>)list, val, row, sel, focus);
            }
            String obj = ((ActivityNodeArea)val).toString().replaceAll("\n", "");
            return super.getListCellRendererComponent((JList<?>)list, obj, row, sel, focus);
        }
    }
}

