/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.DescriptiveStatisticsEngineNode;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class DescriptiveStatisticsDialog
extends NodeDialog {
    private NodeDialog.SortingScrollPane availableScrollPane;
    private NodeDialog.SortingScrollPane groupbyScrollPane;
    private NodeDialog.SortingScrollPane displayScrollPane;
    private NodeDialog.DNDList availableList;
    private NodeDialog.DNDList displayList;
    private NodeDialog.DNDListModel availableListModel;
    private NodeDialog.DNDListModel displayListModel;
    private JRadioButton histogramRadioButton;
    private JRadioButton boxplotRadioButton;
    private JRadioButton dotchartRadioButton;
    private JRadioButton barchartRadioButton;
    private JRadioButton piechartRadioButton;
    private JTextField quantileTextField;
    private JTextField kValueTextField;
    private XTMetaData metaData = null;
    private AbstractAction addDisplayAction;
    private AbstractAction removeDisplayAction;
    private static DescriptiveStatisticsDialog instance = null;

    public static DescriptiveStatisticsDialog getInstance() {
        if (instance == null) {
            instance = new DescriptiveStatisticsDialog();
        }
        return instance;
    }

    private DescriptiveStatisticsDialog() {
        this.setResizable(true);
        this.setSize(475, 445);
        this.setMinimumSize(new Dimension(475, 445));
    }

    public void restoreProperties() {
        super.restoreProperties();
        this.availableListModel.removeAllElements();
        this.displayListModel.removeAllElements();
        XTProps props = this.getNodeModel().getXTProps();
        try {
            this.metaData = this.getNodeModel().getInputMetaData(0);
        }
        catch (Exception e) {
            AcceleratorOptionPane.showOKDialog(this, MinerApp.getText("NodeDialog_cannotRestoreProperties"), MinerApp.getText("NodeDialog_propertiesNotRestored"), 0);
            e.printStackTrace();
            return;
        }
        Vector names = this.metaData.getColumnNames();
        Vector types = this.metaData.getColumnTypes();
        Vector roles = this.metaData.getColumnRoles();
        Vector propDisplay = props.getSubProperties(DescriptiveStatisticsEngineNode.DISPLAY_ATTRIBUTE_TAG);
        int length = names.size();
        for (int i = 0; i < length; ++i) {
            String name = (String)names.get(i);
            String role = (String)roles.get(i);
            String type = (String)types.get(i);
            if (type.equals(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG) || type.equals(XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG) || type.equals(XTMetaData.BLOB_TYPE_ATTRIBUTE_TAG)) continue;
            NodeDialog.ColumnInformationObject info = new NodeDialog.ColumnInformationObject(name, type, role, false, i);
            if (propDisplay.contains(name)) {
                this.displayListModel.addElement(info);
                propDisplay.remove(name);
                continue;
            }
            this.availableListModel.addElement(info);
        }
    }

    public void saveProperties() throws NodeDialog.DialogException {
        super.saveProperties();
        XTProps props = this.getNodeModel().getXTProps();
        props.removeProperty(new String[]{DescriptiveStatisticsEngineNode.DISPLAY_ATTRIBUTE_TAG});
        Enumeration availables = this.displayListModel.elements();
        while (availables.hasMoreElements()) {
            NodeDialog.ColumnInformationObject object = (NodeDialog.ColumnInformationObject)availables.nextElement();
            props.set(DescriptiveStatisticsEngineNode.DISPLAY_ATTRIBUTE_TAG, object.getText(), "");
        }
        availables = null;
    }

    public void createActions() {
        super.createActions();
        this.addDisplayAction = new AbstractAction(">>"){

            public void actionPerformed(ActionEvent e) {
                if (!DescriptiveStatisticsDialog.this.availableList.isSelectionEmpty()) {
                    Object[] values = DescriptiveStatisticsDialog.this.availableList.getSelectedValues();
                    int[] indices = DescriptiveStatisticsDialog.this.availableList.getSelectedIndices();
                    DescriptiveStatisticsDialog.this.availableList.getSelectionModel().clearSelection();
                    DescriptiveStatisticsDialog.this.availableListModel.removeListDataListeners();
                    DescriptiveStatisticsDialog.this.displayListModel.removeListDataListeners();
                    for (int i = 0; i < values.length; ++i) {
                        DescriptiveStatisticsDialog.this.availableListModel.removeElementAt(indices[i] - i);
                        DescriptiveStatisticsDialog.this.displayListModel.addElement(values[i]);
                    }
                    DescriptiveStatisticsDialog.this.availableListModel.undoRemoveListDataListeners();
                    DescriptiveStatisticsDialog.this.displayListModel.undoRemoveListDataListeners();
                    DescriptiveStatisticsDialog.this.displayScrollPane.sort();
                    DescriptiveStatisticsDialog.this.availableListModel.listContentsChanged();
                    DescriptiveStatisticsDialog.this.displayListModel.listContentsChanged();
                    indices = null;
                    Object var2_2 = null;
                }
            }
        };
        this.removeDisplayAction = new AbstractAction("<<"){

            public void actionPerformed(ActionEvent e) {
                if (!DescriptiveStatisticsDialog.this.displayList.isSelectionEmpty()) {
                    Object[] values = DescriptiveStatisticsDialog.this.displayList.getSelectedValues();
                    int[] indices = DescriptiveStatisticsDialog.this.displayList.getSelectedIndices();
                    DescriptiveStatisticsDialog.this.displayList.getSelectionModel().clearSelection();
                    DescriptiveStatisticsDialog.this.availableListModel.removeListDataListeners();
                    DescriptiveStatisticsDialog.this.displayListModel.removeListDataListeners();
                    for (int i = 0; i < values.length; ++i) {
                        DescriptiveStatisticsDialog.this.displayListModel.removeElementAt(indices[i] - i);
                        DescriptiveStatisticsDialog.this.availableListModel.addElement(values[i]);
                    }
                    DescriptiveStatisticsDialog.this.availableListModel.undoRemoveListDataListeners();
                    DescriptiveStatisticsDialog.this.displayListModel.undoRemoveListDataListeners();
                    DescriptiveStatisticsDialog.this.availableListModel.listContentsChanged();
                    DescriptiveStatisticsDialog.this.displayListModel.listContentsChanged();
                    DescriptiveStatisticsDialog.this.availableScrollPane.sort();
                    indices = null;
                    Object var2_2 = null;
                }
            }
        };
    }

    public JPanel createOptionsPanel() {
        JPanel selectColumnsPanel = new JPanel(new GridBagLayout());
        selectColumnsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("DescriptiveStatisticsDialog_selectColumns")), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        Dimension listDim = new Dimension(100, 200);
        JLabel availableLabel = new JLabel(MinerApp.getText("SelectColumnsPanel_availableColumns") + ":");
        availableLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
        this.availableListModel = new NodeDialog.DNDListModel();
        this.availableList = new NodeDialog.DNDList(this.availableListModel);
        NodeDialog.ColumnInformationRenderer renderer = new NodeDialog.ColumnInformationRenderer();
        this.availableList.setCellRenderer(renderer);
        this.availableList.setSelectionMode(2);
        this.availableScrollPane = new NodeDialog.SortingScrollPane(this.availableList);
        this.availableScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.availableScrollPane.setPreferredSize(listDim);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        selectColumnsPanel.add((Component)availableLabel, constraints);
        constraints.gridy = 1;
        constraints.weighty = 1.0;
        constraints.weightx = 0.5;
        constraints.fill = 1;
        constraints.gridheight = 0;
        selectColumnsPanel.add((Component)this.availableScrollPane, constraints);
        JButton addDisplayButton = new JButton(this.addDisplayAction);
        JButton removeButton = new JButton(this.removeDisplayAction);
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridheight = 1;
        constraints.insets = new Insets(5, 10, 5, 10);
        constraints.fill = 2;
        selectColumnsPanel.add((Component)addDisplayButton, constraints);
        constraints.gridy = 2;
        selectColumnsPanel.add((Component)removeButton, constraints);
        JLabel displayLabel = new JLabel(MinerApp.getText("ChartDialog_display"));
        displayLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        this.displayListModel = new NodeDialog.DNDListModel();
        this.displayList = new NodeDialog.DNDList(this.displayListModel);
        this.displayList.setCellRenderer(renderer);
        this.displayScrollPane = new NodeDialog.SortingScrollPane(this.displayList);
        this.displayScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        this.displayScrollPane.setPreferredSize(listDim);
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.insets = new Insets(0, 0, 0, 0);
        selectColumnsPanel.add((Component)displayLabel, constraints);
        constraints.gridy = 1;
        constraints.weightx = 0.5;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        constraints.gridheight = 0;
        selectColumnsPanel.add((Component)this.displayScrollPane, constraints);
        return selectColumnsPanel;
    }
}

