/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKBlobClassHandler;
import com.insightful.cnkjava.CNKObj;
import com.insightful.miner.DragAndDropTree;
import com.insightful.miner.ExplorerPane;
import com.insightful.miner.MinerApp;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTProps;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Vector;

public class ExtensionManager {
    private static ClassLoader m_extensionClassLoader = null;
    public static final String SYSTEM_EXTENSION_TYPE = "system";
    public static final String USER_EXTENSION_TYPE = "user";
    public static final String EXTENSIONS_DIRECTORY_NAME = "extensions";
    public static final String EXTENSIONS_XML_FILE = "extension.xml";
    public static final String DEFAULT_JAR_FILE = "extension.jar";
    public static final String DEFAULT_LIBRARY_FILE = "extension";
    public static final String DEFAULT_IML_FILE = "extension.iml";
    public static final String JAVA_CLASSPATH_PROP = "jarFile";
    public static final String JNI_DIRECTORY_PROP = "jniDirectory";
    public static final String IMAGE_DIRECTORY_PROP = "imageDirectory";
    public static final String C_LIBRARY_PROP = "libraryFile";
    public static final String IML_FILE_PROP = "explorerFile";
    public static final String DEPENDENCY_PROP = "dependency";
    public static final String INIT_CLASS_PROP = "initExtensionClass";
    public static final String INIT_METHOD = "initExtension";

    public static void init() {
        ExtensionManager.loadExtensions(SYSTEM_EXTENSION_TYPE, MinerApp.getSprimeHome());
        ExtensionManager.loadExtensions(USER_EXTENSION_TYPE, MinerApp.getWorkDir());
    }

    private static void loadExtensions(String extensionType, String dirName) {
        File extensionDir = new File(dirName, EXTENSIONS_DIRECTORY_NAME);
        if (dirName == null || !extensionDir.isDirectory()) {
            return;
        }
        String[] subDirNames = extensionDir.list();
        for (int i = 0; i < subDirNames.length; ++i) {
            ExtensionManager.loadExtension(extensionType, subDirNames[i], new File(extensionDir, subDirNames[i]));
        }
    }

    private static File newFileInDirectory(String parent, String child) {
        File childFile = new File(child);
        if (childFile.isAbsolute()) {
            return childFile;
        }
        return new File(parent, child);
    }

    private static File newFileInDirectory(File parent, String child) {
        File childFile = new File(child);
        if (childFile.isAbsolute()) {
            return childFile;
        }
        return new File(parent, child);
    }

    private static void loadExtension(String extensionType, String extensionName, File dir) {
        String[] noStrings;
        if (!dir.isDirectory()) {
            return;
        }
        ExtensionManager.printlnDebug("loading " + extensionType + " extension " + extensionName + " from " + dir.getPath());
        String[] javaNames = noStrings = new String[0];
        String[] jniDirNames = noStrings;
        String[] imageDirNames = noStrings;
        String[] libraryNames = noStrings;
        String[] imlNames = noStrings;
        String[] dependencyNames = noStrings;
        String[] initNames = noStrings;
        File xmlFile = new File(dir, EXTENSIONS_XML_FILE);
        String xmlFilename = xmlFile.getPath();
        if (xmlFile.isFile()) {
            try {
                ExtensionManager.printlnDebug("processing XML file: " + xmlFilename);
                XTProps props = new XTProps(XMLTree.readFromFile(xmlFilename));
                javaNames = ExtensionManager.getValueArray(props, JAVA_CLASSPATH_PROP);
                jniDirNames = ExtensionManager.getValueArray(props, JNI_DIRECTORY_PROP);
                imageDirNames = ExtensionManager.getValueArray(props, IMAGE_DIRECTORY_PROP);
                libraryNames = ExtensionManager.getValueArray(props, C_LIBRARY_PROP);
                imlNames = ExtensionManager.getValueArray(props, IML_FILE_PROP);
                dependencyNames = ExtensionManager.getValueArray(props, DEPENDENCY_PROP);
                initNames = ExtensionManager.getValueArray(props, INIT_CLASS_PROP);
            }
            catch (Exception ex) {
                ExtensionManager.printlnExtensionLoadError(extensionType, extensionName, "can't load extension: error processing " + xmlFilename + ": " + ex);
                return;
            }
        } else {
            String[] stringArray;
            String[] stringArray2;
            String[] stringArray3;
            File jarFile = new File(dir, DEFAULT_JAR_FILE);
            File libFile = new File(dir, System.mapLibraryName(DEFAULT_LIBRARY_FILE));
            File imlFile = new File(dir, DEFAULT_IML_FILE);
            if (jarFile.isFile()) {
                String[] stringArray4 = new String[1];
                stringArray3 = stringArray4;
                stringArray4[0] = jarFile.getName();
            } else {
                stringArray3 = noStrings;
            }
            javaNames = stringArray3;
            jniDirNames = new String[]{"."};
            imageDirNames = new String[]{"."};
            if (libFile.isFile()) {
                String[] stringArray5 = new String[1];
                stringArray2 = stringArray5;
                stringArray5[0] = libFile.getName();
            } else {
                stringArray2 = libraryNames = noStrings;
            }
            if (imlFile.isFile()) {
                String[] stringArray6 = new String[1];
                stringArray = stringArray6;
                stringArray6[0] = imlFile.getName();
            } else {
                stringArray = noStrings;
            }
            imlNames = stringArray;
        }
        ExtensionManager.addLibraries(extensionType, extensionName, dir, libraryNames);
        ExtensionManager.addImageDirectories(extensionType, extensionName, dir, imageDirNames);
        ExtensionManager.addJavaFiles(extensionType, extensionName, dir, javaNames, jniDirNames);
        ExtensionManager.addIML(extensionType, extensionName, dir, imlNames);
        ExtensionManager.executeInit(extensionType, extensionName, dir, initNames);
        ExtensionManager.printlnDebug("done loading " + extensionType + " extension " + extensionName + " from " + dir.getPath());
    }

    public static String[] getValueArray(XTProps props, String propName) {
        Vector<String> vec = new Vector<String>();
        String val = props.getValue(propName, null);
        if (val != null && !val.equals("")) {
            vec.add(val);
        }
        Vector subNames = props.getSubProperties(propName);
        for (int i = 0; i < subNames.size(); ++i) {
            val = (String)subNames.get(i);
            if (val == null || val.equals("")) continue;
            vec.add(val);
        }
        String[] ret = new String[vec.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (String)vec.get(i);
        }
        return ret;
    }

    public static void printlnExtensionLoadError(String extensionType, String extensionName, String msg) {
        ExtensionManager.printlnError("loading " + extensionType + " extension " + extensionName + ": " + msg);
    }

    public static void printlnError(String msg) {
        MinerApp.outputText(msg, 4, true);
    }

    public static void printlnInformation(String msg) {
        MinerApp.outputText(msg, 2, true);
    }

    public static void printlnDebug(String msg) {
        MinerApp.outputText(msg, 0, true);
    }

    public static void addJavaFiles(String extensionType, String extensionName, String extensionDir, String[] javaNames, String[] jniDirNames) {
        ExtensionManager.addJavaFiles(extensionType, extensionName, new File(extensionDir), javaNames, jniDirNames);
    }

    public static void addJavaFiles(String extensionType, String extensionName, File extensionDir, String[] javaNames, String[] jniDirNames) {
        int i;
        File[] javaFiles = ExtensionManager.stringsToFiles(javaNames, extensionDir.getPath());
        File[] jniDirFiles = ExtensionManager.stringsToFiles(jniDirNames, extensionDir.getPath());
        for (i = 0; i < javaFiles.length; ++i) {
            ExtensionManager.printlnDebug("adding extension jar file: " + javaFiles[i].getPath());
            if (javaFiles[i].exists()) continue;
            ExtensionManager.printlnExtensionLoadError(extensionType, extensionName, "java jar or directory doesn't exist: " + javaFiles[i].getPath());
        }
        for (i = 0; i < jniDirFiles.length; ++i) {
            ExtensionManager.printlnDebug("adding extension jni directory: " + jniDirFiles[i].getPath());
            if (jniDirFiles[i].isDirectory()) continue;
            ExtensionManager.printlnExtensionLoadError(extensionType, extensionName, "java jni directory doesn't exist: " + jniDirFiles[i].getPath());
        }
        try {
            URL[] urlList = ExtensionManager.filesToURLs(javaFiles);
            if (urlList.length < 1 && jniDirFiles.length < 1) {
                return;
            }
            URLJNILoader loader = m_extensionClassLoader == null ? new URLJNILoader(urlList, jniDirFiles) : new URLJNILoader(urlList, m_extensionClassLoader, jniDirFiles);
            ExtensionManager.setClassLoader(loader);
        }
        catch (Exception ex) {
            ExtensionManager.printlnExtensionLoadError(extensionType, extensionName, "error adding jar files: " + ex);
            ex.printStackTrace();
        }
    }

    public static void setInitClassLoader(ClassLoader loader) {
        if (m_extensionClassLoader != null) {
            throw new RuntimeException("ExtensionManager.setInitClassLoader: loader already set");
        }
        ExtensionManager.setClassLoader(loader);
    }

    private static void setClassLoader(ClassLoader loader) {
        m_extensionClassLoader = loader;
        CNKBlobClassHandler.setClassLoader(loader);
    }

    public static void addImageDirectories(String extensionType, String extensionName, File extensionDir, String[] imageDirNames) {
        File[] imageDirFiles = ExtensionManager.stringsToFiles(imageDirNames, extensionDir.getPath());
        for (int i = 0; i < imageDirFiles.length; ++i) {
            String imagePath = imageDirFiles[i].getPath();
            ExtensionManager.printlnDebug("adding extension image directory: " + imagePath);
            if (!imageDirFiles[i].isDirectory()) {
                ExtensionManager.printlnExtensionLoadError(extensionType, extensionName, "image directory doesn't exist: " + imagePath);
                continue;
            }
            MinerApp.getResourceManager().addSearchPath(imagePath);
        }
    }

    public static File[] stringsToFiles(String[] filenames, String extensionDirectory) {
        if (filenames == null) {
            return new File[0];
        }
        Vector<File> vec = new Vector<File>();
        for (int i = 0; i < filenames.length; ++i) {
            if (filenames[i] == null) continue;
            if (filenames[i].equals(".")) {
                vec.add(new File(extensionDirectory));
                continue;
            }
            vec.add(ExtensionManager.newFileInDirectory(extensionDirectory, filenames[i]));
        }
        File[] files = new File[vec.size()];
        for (int i = 0; i < files.length; ++i) {
            files[i] = (File)vec.get(i);
        }
        return files;
    }

    public static URL[] filesToURLs(File[] files) throws Exception {
        if (files == null) {
            return new URL[0];
        }
        URL[] urls = new URL[files.length];
        for (int i = 0; i < files.length; ++i) {
            urls[i] = files[i].toURI().toURL();
        }
        return urls;
    }

    public static void addLibraries(String extensionType, String extensionName, File extensionDir, String[] libraryNames) {
        if (libraryNames.length < 1) {
            return;
        }
        if (!CNKObj.getInitialLibrariesLoaded()) {
            ExtensionManager.printlnExtensionLoadError(extensionType, extensionName, "can't load libraries: " + CNKObj.getInitialLibrariesStatus());
            return;
        }
        for (int fileNum = 0; fileNum < libraryNames.length; ++fileNum) {
            File libraryFile = ExtensionManager.newFileInDirectory(extensionDir, libraryNames[fileNum]);
            String libraryFilePath = libraryFile.getPath();
            ExtensionManager.printlnDebug("adding extension library file: " + libraryFilePath);
            try {
                if (!libraryFile.isFile()) {
                    ExtensionManager.printlnExtensionLoadError(extensionType, extensionName, "can't load " + libraryFilePath + ": file doesn't exit");
                    continue;
                }
                CNKObj.registerLibrary(libraryFilePath);
                if (CNKObj.getRegisterLibraryOK(libraryFilePath)) continue;
                ExtensionManager.printlnExtensionLoadError(extensionType, extensionName, "can't load " + libraryFilePath + ": " + CNKObj.getRegisterLibraryStatus(libraryFilePath));
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void addIML(String extensionType, String extensionName, File extensionDir, String[] imlFilenames) {
        ExplorerPane expPane = MinerApp.getMainFrame().getExplorerPane();
        String[] libPath = new String[]{"ExplorerPage", ""};
        XTProps globalProps = MinerApp.getGlobalOptions();
        for (int fileNum = 0; fileNum < imlFilenames.length; ++fileNum) {
            File imlFile = ExtensionManager.newFileInDirectory(extensionDir, imlFilenames[fileNum]);
            String imlFilePath = imlFile.getPath();
            ExtensionManager.printlnDebug("adding extension iml file: " + imlFilePath);
            try {
                if (!imlFile.isFile()) {
                    ExtensionManager.printlnExtensionLoadError(extensionType, extensionName, "can't add iml file " + imlFilePath + ": file doesn't exit");
                    continue;
                }
                String imlName = imlFile.getName();
                String lc = imlName.toLowerCase();
                if (lc.endsWith(".xml") || lc.endsWith(".iml")) {
                    imlName = imlName.substring(0, imlName.length() - 4);
                }
                if (imlName.indexOf(".") >= 0) {
                    StringBuffer buf = new StringBuffer(imlName);
                    for (int i = 0; i < buf.length(); ++i) {
                        if (buf.charAt(i) != '.') continue;
                        buf.setCharAt(i, '_');
                    }
                    imlName = buf.toString();
                }
                libPath[1] = imlName = "extension_" + extensionType + "_" + extensionName + "_" + imlName + ".iml";
                if (globalProps.isPathValid(libPath)) continue;
                DragAndDropTree tree = ExplorerPane.getLibrary(imlName, imlFilePath);
                expPane.externalAdd(tree, imlName, true);
                continue;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void executeInit(String extensionType, String extensionName, File extensionDir, String[] initNames) {
        for (int classNum = 0; classNum < initNames.length; ++classNum) {
            String initClassName = initNames[classNum];
            ExtensionManager.printlnDebug("executing initExtension for init class: " + initClassName);
            try {
                Class initClass = ExtensionManager.getClassForName(initClassName);
                Method methodToCall = initClass.getMethod(INIT_METHOD, String.class, String.class);
                methodToCall.invoke(null, extensionName, extensionDir.getPath());
                continue;
            }
            catch (ClassNotFoundException ex) {
                ExtensionManager.printlnExtensionLoadError(extensionType, extensionName, "can't execute initExtension for class " + initClassName + ": class not found");
                continue;
            }
            catch (NoSuchMethodException ex) {
                ExtensionManager.printlnExtensionLoadError(extensionType, extensionName, "can't execute initExtension for class " + initClassName + ": public static method " + INIT_METHOD + "(String,String) not found");
                continue;
            }
            catch (Exception ex) {
                ExtensionManager.printlnExtensionLoadError(extensionType, extensionName, "can't execute initExtension for class " + initClassName + ": " + ex);
            }
        }
    }

    public static Class getClassForName(String name) throws ClassNotFoundException {
        if (m_extensionClassLoader == null) {
            return Class.forName(name);
        }
        return Class.forName(name, true, m_extensionClassLoader);
    }

    public static class URLJNILoader
    extends URLClassLoader {
        File[] m_jniDirs = null;

        public URLJNILoader(URL[] javaCodeURLs, ClassLoader parent, File[] jniDirs) {
            super(javaCodeURLs, parent);
            this.m_jniDirs = jniDirs;
        }

        public URLJNILoader(URL[] javaCodeURLs, File[] jniDirs) {
            super(javaCodeURLs);
            this.m_jniDirs = jniDirs;
        }

        protected String findLibrary(String libname) {
            if (this.m_jniDirs == null) {
                return null;
            }
            String fullLibName = System.mapLibraryName(libname);
            for (int i = 0; i < this.m_jniDirs.length; ++i) {
                File libFile = new File(this.m_jniDirs[i], fullLibName);
                if (!libFile.isFile()) continue;
                return libFile.getPath();
            }
            return null;
        }
    }
}

