/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.AppAction;
import com.insightful.miner.BevelArrowIcon;
import com.insightful.miner.GridViewerModel;
import com.insightful.miner.GridViewerRowNumberModel;
import com.insightful.miner.GridViewerRowNumberSorter;
import com.insightful.miner.GridViewerSorter;
import com.insightful.miner.GridViewerTable;
import com.insightful.miner.LongScrollBar;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.Retrievable;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.Clipboard;
import java.awt.event.ActionEvent;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.TransferHandler;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;

public class GridViewerComposite
extends JPanel {
    public static int CELL_HEIGHT = (int)((double)new JLabel((String)"1").getPreferredSize().height * 1.25);
    public static BevelArrowIcon downIcon = new BevelArrowIcon(1, false, true);
    public static BevelArrowIcon upIcon = new BevelArrowIcon(0, false, true);
    protected GridViewerRowNumberModel gridViewerRowNumberModel = null;
    protected JTable gridViewerRowNumberTable = null;
    protected GridViewerModel gridViewerModel = null;
    protected GridViewerTable gridViewerTable = null;
    protected LongScrollBar horizontalScrollBar = null;
    protected LongScrollBar verticalScrollBar = null;
    protected boolean showRowNumbers = true;
    protected boolean showSecondHeader = true;
    protected long m_totalRows = 0L;
    private int rowHeaderWidth = -1;

    public GridViewerComposite(Retrievable dataSource, int width, int height) throws NullPointerException {
        if (dataSource == null) {
            throw new NullPointerException("Data Source was not provided.");
        }
        this.setLayout(null);
        this.setSize(width, height);
        this.verticalScrollBar = new LongScrollBar(1);
        this.horizontalScrollBar = new LongScrollBar(0);
        this.verticalScrollBar.addAdjustmentListener(new ScrollBarAdjustmentListener());
        this.horizontalScrollBar.addAdjustmentListener(new ScrollBarAdjustmentListener());
        this.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                int curVal = GridViewerComposite.this.verticalScrollBar.getValue();
                int inc = e.getUnitsToScroll();
                int unit = GridViewerComposite.this.verticalScrollBar.getUnitIncrement();
                GridViewerComposite.this.verticalScrollBar.setValue(curVal + inc * unit);
            }
        });
        int tableWidth = width - 17;
        int tableHeight = height - (CELL_HEIGHT + 1);
        int visibleRows = tableHeight / CELL_HEIGHT;
        int visibleCols = tableWidth / 50;
        visibleCols = Math.min(visibleCols, dataSource.getTotalColumns());
        visibleRows = (int)Math.min((long)visibleRows, dataSource.getTotalRows());
        this.m_totalRows = dataSource.getTotalRows();
        if (dataSource.isSortable()) {
            this.gridViewerModel = new GridViewerSorter((int)dataSource.getTotalRows(), dataSource.getTotalColumns(), dataSource);
            this.gridViewerTable = new GridViewerTable(this.gridViewerModel);
            ButtonHeaderRenderer renderer = new ButtonHeaderRenderer();
            this.gridViewerTable.getTableHeader().setDefaultRenderer(renderer);
            JTableHeader header = this.gridViewerTable.getTableHeader();
            header.addMouseListener(new HeaderListener(header, renderer, (GridViewerSorter)this.gridViewerModel));
            this.gridViewerRowNumberModel = new GridViewerRowNumberSorter((int)dataSource.getTotalRows(), dataSource.getTotalColumns(), dataSource, (GridViewerSorter)this.gridViewerModel);
            this.gridViewerModel.addTableModelListener((GridViewerRowNumberSorter)this.gridViewerRowNumberModel);
        } else {
            this.gridViewerModel = new GridViewerModel(visibleRows, visibleCols, dataSource);
            this.gridViewerTable = this.createGridViewerTable(this.gridViewerModel);
            this.gridViewerRowNumberModel = new GridViewerRowNumberModel(visibleRows, visibleCols, dataSource);
        }
        this.gridViewerTable.setRowHeight(CELL_HEIGHT);
        this.gridViewerRowNumberTable = new JTable(this.gridViewerRowNumberModel);
        this.gridViewerRowNumberTable.getColumnModel().getColumn(0).setCellRenderer(new RowNumberRenderer());
        this.gridViewerRowNumberTable.setRowHeight(this.gridViewerTable.getRowHeight());
        this.rowHeaderWidth = dataSource.getRowLabelWidth();
        this.gridViewerTable.addKeyListener(new GridViewerKeyAdapter());
        this.gridViewerModel.setTableCellRenderer(this.gridViewerTable);
        this.gridViewerTable.getActionMap().getParent().remove("cancel");
        this.gridViewerRowNumberTable.getActionMap().getParent().remove("cancel");
        this.add(this.verticalScrollBar);
        this.add(this.horizontalScrollBar);
        this.add(this.gridViewerTable.getPrimaryTableHeader());
        this.add(this.gridViewerTable.getSecondaryTableHeader());
        this.add(this.gridViewerTable);
        this.add(this.gridViewerRowNumberTable);
        this.resize(width, height);
    }

    protected GridViewerTable createGridViewerTable(GridViewerModel model) {
        return new GridViewerTable(model);
    }

    public void forceRefresh() {
        this.gridViewerModel.changeGridViewerModel(this.gridViewerTable, 0, 0L, 0, 0);
        this.gridViewerScrollableAdjustment(this.horizontalScrollBar.getValue(), this.verticalScrollBar.getValue());
    }

    public void showRowNumbers(boolean flag) {
        this.showRowNumbers = flag;
        this.doLayout();
    }

    public void showSecondHeader(boolean flag) {
        this.showSecondHeader = flag;
        this.doLayout();
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.resize(width, height);
        super.doLayout();
    }

    public void resize(int width, int height) {
        boolean vSBVisible;
        int rowNumWidth = this.rowHeaderWidth;
        int headerHeight = CELL_HEIGHT + 1;
        int cellHeight = CELL_HEIGHT;
        int verticalScrollbarWidth = 17;
        int horizontalScrollbarHeight = 17;
        boolean hSBVisible = this.horizontalScrollBar != null && this.horizontalScrollBar.isVisible();
        boolean bl = vSBVisible = this.verticalScrollBar != null && this.verticalScrollBar.isVisible();
        if (this.horizontalScrollBar != null && !this.horizontalScrollBar.isVisible()) {
            horizontalScrollbarHeight = 0;
        }
        if (this.verticalScrollBar != null && !this.verticalScrollBar.isVisible()) {
            verticalScrollbarWidth = 0;
        }
        int tableWidth = width - (rowNumWidth + verticalScrollbarWidth);
        int tableHeight = height - (2 * headerHeight + horizontalScrollbarHeight);
        int tableStartY = 2 * headerHeight;
        if (!this.showRowNumbers) {
            tableWidth += rowNumWidth;
            rowNumWidth = 0;
        }
        if (!this.showSecondHeader) {
            tableStartY -= headerHeight;
            tableHeight += headerHeight;
        }
        int extra = tableHeight % cellHeight;
        tableHeight -= extra;
        if (this.horizontalScrollBar != null) {
            this.horizontalScrollBar.setBounds(rowNumWidth, height - horizontalScrollbarHeight - extra, tableWidth, horizontalScrollbarHeight);
        }
        if (this.verticalScrollBar != null) {
            this.verticalScrollBar.setBounds(width - verticalScrollbarWidth, tableStartY, verticalScrollbarWidth, tableHeight);
        }
        if (this.gridViewerTable != null) {
            this.gridViewerTable.getPrimaryTableHeader().setBounds(rowNumWidth, 0, tableWidth, headerHeight);
            if (this.showSecondHeader) {
                this.gridViewerTable.getSecondaryTableHeader().setVisible(true);
                this.gridViewerTable.getSecondaryTableHeader().setBounds(rowNumWidth, headerHeight, tableWidth, headerHeight);
            } else {
                this.gridViewerTable.getSecondaryTableHeader().setVisible(false);
            }
            tableHeight = (int)Math.min(this.gridViewerModel.getTotalRowCount() * (long)cellHeight, (long)tableHeight);
            this.gridViewerTable.setBounds(rowNumWidth, tableStartY, tableWidth, tableHeight);
        }
        if (this.gridViewerRowNumberTable != null) {
            if (this.showRowNumbers) {
                this.gridViewerRowNumberTable.setVisible(true);
                this.gridViewerRowNumberTable.setBounds(0, tableStartY, rowNumWidth, tableHeight);
            } else {
                this.gridViewerRowNumberTable.setVisible(false);
            }
        }
        if (this.horizontalScrollBar != null && this.verticalScrollBar != null) {
            this.gridViewerScrollableAdjustment(this.horizontalScrollBar.getValue(), this.verticalScrollBar.getValue());
        }
        if (hSBVisible != (this.horizontalScrollBar != null && this.horizontalScrollBar.isVisible()) || vSBVisible != (this.verticalScrollBar != null && this.verticalScrollBar.isVisible())) {
            this.resize(width, height);
        }
    }

    public AppAction getSelectAllAction() {
        AppAction selAll = new AppAction(MinerApp.getText("MinerApp_menu_item_selectall")){

            public void actionPerformed(ActionEvent e) {
                GridViewerTable.GridViewerListSelectionModel selModel = (GridViewerTable.GridViewerListSelectionModel)GridViewerComposite.this.gridViewerTable.getSelectionModel();
                selModel.selectAll();
                GridViewerComposite.this.gridViewerTable.updateUI();
            }
        };
        return selAll;
    }

    public AppAction getCopyAction() {
        AppAction copy = new AppAction(MinerApp.getText("NodeViewer_copy_selection")){

            public void actionPerformed(ActionEvent e) {
                TransferHandler th = GridViewerComposite.this.gridViewerTable.getTransferHandler();
                Clipboard clipboard = GridViewerComposite.this.gridViewerTable.getToolkit().getSystemClipboard();
                if (clipboard != null) {
                    th.exportToClipboard(GridViewerComposite.this.gridViewerTable, clipboard, 1);
                }
                if ((clipboard = GridViewerComposite.this.gridViewerTable.getToolkit().getSystemSelection()) != null) {
                    th.exportToClipboard(GridViewerComposite.this.gridViewerTable, clipboard, 1);
                }
            }
        };
        return copy;
    }

    public AppAction getScrollToCellAction(JFrame frame) {
        final JFrame f = frame;
        AppAction scrollTo = new AppAction(MinerApp.getText("ScrollToCellDialog_scrollToCell")){

            public void actionPerformed(ActionEvent e) {
                Vector<String> columnNames = new Vector<String>();
                for (int i = 0; i < GridViewerComposite.this.gridViewerModel.getTotalColCount(); ++i) {
                    columnNames.add(GridViewerComposite.this.gridViewerModel.getAbsoluteColumnName(i));
                }
                long totalRows = GridViewerComposite.this.gridViewerModel.getTotalRowCount();
                ScrollToCellDialog scrollToCell = new ScrollToCellDialog(f, columnNames, totalRows);
                scrollToCell.setLocationRelativeTo(f);
                scrollToCell.show();
                if (scrollToCell.success) {
                    int desColPos = scrollToCell.colNum;
                    long desRowPos = scrollToCell.rowNum - 1L;
                    GridViewerComposite.this.horizontalScrollBar.setValue(desColPos);
                    GridViewerComposite.this.verticalScrollBar.setLongValue(desRowPos);
                    int absColPos = GridViewerComposite.this.gridViewerModel.getAbsoluteColPos();
                    long absRowPos = GridViewerComposite.this.gridViewerModel.getAbsoluteRowPos();
                    int actRowPos = (int)(desRowPos - absRowPos);
                    GridViewerComposite.this.gridViewerTable.getSelectionModel().setAnchorSelectionIndex(actRowPos);
                    GridViewerComposite.this.gridViewerTable.setRowSelectionInterval(actRowPos, actRowPos);
                    GridViewerComposite.this.gridViewerTable.setColumnSelectionInterval(desColPos - absColPos, desColPos - absColPos);
                }
            }
        };
        return scrollTo;
    }

    protected void gridViewerScrollableAdjustment(int actualDataLocX, int actualDataLocY) {
        this.gridViewerModel.gridViewerAdjustment(this.gridViewerTable, this.gridViewerRowNumberModel, this.gridViewerRowNumberTable, this.horizontalScrollBar, this.verticalScrollBar, actualDataLocX, actualDataLocY);
    }

    protected class GridViewerKeyAdapter
    extends KeyAdapter {
        private ListSelectionModel selModel = null;

        protected GridViewerKeyAdapter() {
        }

        public void keyPressed(KeyEvent e) {
            if (this.selModel == null) {
                this.selModel = GridViewerComposite.this.gridViewerTable.getSelectionModel();
            }
            int previousRow = Math.max(this.selModel.getLeadSelectionIndex(), 0);
            int previousCol = Math.max(GridViewerComposite.this.gridViewerTable.getSelectedColumn(), 0);
            int bottomRow = GridViewerComposite.this.gridViewerTable.getRowCount() - 1;
            int rightmostCol = GridViewerComposite.this.gridViewerTable.getColumnCount() - 1;
            int keyCode = e.getKeyCode();
            int newLoc = 0;
            switch (keyCode) {
                case 38: {
                    int up = previousRow;
                    if (previousRow == 0) {
                        newLoc = GridViewerComposite.this.verticalScrollBar.getValue() - GridViewerComposite.this.verticalScrollBar.getUnitIncrement(1);
                        GridViewerComposite.this.verticalScrollBar.setValue(newLoc);
                        up = 0;
                    }
                    if (e.isShiftDown()) {
                        this.selModel.setLeadSelectionIndex(up);
                        break;
                    }
                    this.selModel.setAnchorSelectionIndex(up);
                    this.selModel.setSelectionInterval(up, up);
                    break;
                }
                case 40: {
                    int down = previousRow;
                    if (previousRow == bottomRow) {
                        newLoc = GridViewerComposite.this.verticalScrollBar.getValue() + GridViewerComposite.this.verticalScrollBar.getUnitIncrement(1);
                        GridViewerComposite.this.verticalScrollBar.setValue(newLoc);
                        down = bottomRow;
                    }
                    if (e.isShiftDown()) {
                        this.selModel.setLeadSelectionIndex(down);
                        break;
                    }
                    this.selModel.setAnchorSelectionIndex(down);
                    this.selModel.setSelectionInterval(down, down);
                    break;
                }
                case 37: {
                    if (previousCol != 0) break;
                    newLoc = GridViewerComposite.this.horizontalScrollBar.getValue() - GridViewerComposite.this.horizontalScrollBar.getUnitIncrement(0);
                    GridViewerComposite.this.horizontalScrollBar.setValue(newLoc);
                    GridViewerComposite.this.gridViewerTable.addColumnSelectionInterval(0, 1);
                    break;
                }
                case 39: {
                    if (previousCol != rightmostCol) break;
                    newLoc = GridViewerComposite.this.horizontalScrollBar.getValue() + GridViewerComposite.this.horizontalScrollBar.getUnitIncrement(0);
                    GridViewerComposite.this.horizontalScrollBar.setValue(newLoc);
                    rightmostCol = GridViewerComposite.this.gridViewerTable.getColumnCount() - 1;
                    GridViewerComposite.this.gridViewerTable.addColumnSelectionInterval(rightmostCol - 1, rightmostCol);
                    break;
                }
                case 33: {
                    newLoc = GridViewerComposite.this.verticalScrollBar.getValue() - GridViewerComposite.this.verticalScrollBar.getBlockIncrement(1);
                    GridViewerComposite.this.verticalScrollBar.setValue(newLoc);
                    if (e.isShiftDown()) {
                        this.selModel.setLeadSelectionIndex(previousRow);
                        break;
                    }
                    this.selModel.setAnchorSelectionIndex(previousRow);
                    this.selModel.setSelectionInterval(previousRow, previousRow);
                    break;
                }
                case 34: {
                    newLoc = GridViewerComposite.this.verticalScrollBar.getValue() + GridViewerComposite.this.verticalScrollBar.getBlockIncrement(1);
                    GridViewerComposite.this.verticalScrollBar.setValue(newLoc);
                    if (e.isShiftDown()) {
                        this.selModel.setLeadSelectionIndex(previousRow);
                        break;
                    }
                    this.selModel.setAnchorSelectionIndex(previousRow);
                    this.selModel.setSelectionInterval(previousRow, previousRow);
                    break;
                }
                case 36: {
                    if (e.isControlDown()) {
                        GridViewerComposite.this.horizontalScrollBar.setValue(0);
                    }
                    GridViewerComposite.this.verticalScrollBar.setValue(0);
                    if (e.isShiftDown()) {
                        this.selModel.setLeadSelectionIndex(0);
                        break;
                    }
                    this.selModel.setAnchorSelectionIndex(0);
                    this.selModel.setSelectionInterval(0, 0);
                    break;
                }
                case 35: {
                    if (e.isControlDown()) {
                        newLoc = GridViewerComposite.this.horizontalScrollBar.getMaximum();
                        GridViewerComposite.this.horizontalScrollBar.setValue(newLoc);
                    }
                    newLoc = GridViewerComposite.this.verticalScrollBar.getMaximum();
                    GridViewerComposite.this.verticalScrollBar.setValue(newLoc);
                    if (e.isShiftDown()) {
                        this.selModel.setLeadSelectionIndex(bottomRow);
                        break;
                    }
                    this.selModel.setAnchorSelectionIndex(bottomRow);
                    this.selModel.setSelectionInterval(bottomRow, bottomRow);
                }
            }
        }
    }

    class ButtonHeaderRenderer
    extends JButton
    implements TableCellRenderer {
        private boolean ascending;
        private int ascendingColumn = -1;
        private int pushedColumn = -1;

        public ButtonHeaderRenderer() {
            this.setMargin(new Insets(0, 0, 0, 0));
            this.ascending = true;
        }

        public void toggleAscending(int column) {
            if (column == this.ascendingColumn) {
                this.ascending = !this.ascending;
            } else {
                this.ascendingColumn = column;
                this.ascending = false;
            }
        }

        public boolean getAscending() {
            return this.ascending;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setHorizontalAlignment(4);
            String valueStr = value == null ? "" : value.toString();
            this.setText(valueStr);
            if (table.getModel() instanceof GridViewerRowNumberSorter) {
                this.getModel().setPressed(false);
                this.getModel().setArmed(false);
                this.setIcon(null);
                return this;
            }
            boolean isPressed = column == this.pushedColumn;
            this.getModel().setPressed(isPressed);
            this.getModel().setArmed(isPressed);
            int absoluteCol = column + ((GridViewerModel)table.getModel()).absoluteColPos;
            if (this.ascendingColumn == absoluteCol) {
                if (this.ascending) {
                    this.setIcon(upIcon);
                } else {
                    this.setIcon(downIcon);
                }
            } else {
                this.setIcon(null);
            }
            return this;
        }

        public void setPressedColumn(int col) {
            this.pushedColumn = col;
        }
    }

    class HeaderListener
    extends MouseAdapter {
        private JTableHeader header;
        private ButtonHeaderRenderer renderer;
        private GridViewerSorter sorter;

        HeaderListener(JTableHeader header, ButtonHeaderRenderer renderer, GridViewerSorter sorter) {
            this.header = header;
            this.renderer = renderer;
            this.sorter = sorter;
        }

        public void mousePressed(MouseEvent e) {
            int col = this.header.columnAtPoint(e.getPoint());
            if (this.header.getResizingColumn() != null) {
                return;
            }
            int absoluteCol = col + ((GridViewerModel)this.header.getTable().getModel()).absoluteColPos;
            this.renderer.setPressedColumn(absoluteCol);
            this.header.repaint();
            int column = this.header.getTable().convertColumnIndexToModel(col);
            if (column != -1) {
                this.renderer.toggleAscending(absoluteCol);
                this.sorter.sortByColumn(column, this.renderer.getAscending());
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.renderer.setPressedColumn(-1);
            this.header.repaint();
        }
    }

    class RowNumberRenderer
    extends JButton
    implements TableCellRenderer {
        public RowNumberRenderer() {
            this.setMargin(new Insets(0, 0, 0, 0));
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(value == null ? "" : value.toString());
            return this;
        }
    }

    protected class ScrollBarAdjustmentListener
    implements AdjustmentListener {
        protected ScrollBarAdjustmentListener() {
        }

        public void adjustmentValueChanged(AdjustmentEvent e) {
            GridViewerComposite.this.gridViewerScrollableAdjustment(GridViewerComposite.this.horizontalScrollBar.getValue(), GridViewerComposite.this.verticalScrollBar.getValue());
        }
    }

    public class ScrollToCellDialog
    extends JDialog {
        public long rowNum;
        public int colNum;
        public boolean success;
        private long maxVal;
        private JTextField rowNumberTF;
        private JComboBox columnNamesCB;

        public ScrollToCellDialog(JFrame frame, Vector columnNames, long maxRowValue) {
            super(frame, MinerApp.getText("ScrollToCellDialog_scrollToCell"), true);
            this.rowNum = 0L;
            this.colNum = 0;
            this.success = false;
            this.maxVal = -1L;
            this.rowNumberTF = null;
            this.columnNamesCB = null;
            this.maxVal = maxRowValue;
            JLabel columnNamesL = new JLabel(MinerApp.getText("ScrollToCellDialog_desiredColumn"));
            JLabel rowNumberL = new JLabel(MinerApp.getText("ScrollToCellDialog_desiredRow") + " (1-" + maxRowValue + "):");
            this.columnNamesCB = new JComboBox(columnNames);
            columnNamesL.setLabelFor(this.columnNamesCB);
            this.rowNumberTF = new JTextField(15);
            rowNumberL.setLabelFor(this.rowNumberTF);
            this.rowNumberTF.setDocument(new NodeDialog.InputIntegerDoc());
            JButton ok = new JButton(new AppAction(MinerApp.getText("NodeDialog_ok")){

                public void actionPerformed(ActionEvent e) {
                    ScrollToCellDialog.this.rowNum = Long.parseLong(ScrollToCellDialog.this.rowNumberTF.getText());
                    ScrollToCellDialog.this.colNum = ScrollToCellDialog.this.columnNamesCB.getSelectedIndex();
                    if (ScrollToCellDialog.this.rowNum < 1L || ScrollToCellDialog.this.rowNum > ScrollToCellDialog.this.maxVal) {
                        String msg = MinerApp.getText("GridViewerComposite_msg_rowMustbeBetween") + " " + Long.toString(ScrollToCellDialog.this.maxVal);
                        AcceleratorOptionPane.showOKDialog(ScrollToCellDialog.this, msg, MinerApp.getText("GridViewerComposite_msg_invalidRow"), 0);
                        return;
                    }
                    if (ScrollToCellDialog.this.colNum < 0) {
                        String msg = MinerApp.getText("GridViewerComposite_msg_columnMustbeValid");
                        AcceleratorOptionPane.showOKDialog(ScrollToCellDialog.this, msg, MinerApp.getText("GridViewerComposite_invalidColumn"), 0);
                        return;
                    }
                    ScrollToCellDialog.this.success = true;
                    ScrollToCellDialog.this.dispose();
                }
            });
            ok.setPreferredSize(new JTextField(12).getPreferredSize());
            ok.setMnemonic(MinerApp.getText("NodeDialog_okHotkey").charAt(0));
            JButton cancel = new JButton(new AppAction(MinerApp.getText("NodeDialog_cancel")){

                public void actionPerformed(ActionEvent e) {
                    ScrollToCellDialog.this.dispose();
                }
            });
            cancel.setPreferredSize(new JTextField(12).getPreferredSize());
            cancel.setMnemonic(MinerApp.getText("NodeDialog_cancelHotkey").charAt(0));
            Container centerPanel = this.getContentPane();
            centerPanel.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            Insets labels = new Insets(3, 0, 0, 0);
            Insets enters = new Insets(0, 8, 0, 20);
            constraints.anchor = 18;
            constraints.weightx = 0.0;
            constraints.gridy = 0;
            constraints.gridx = 0;
            constraints.insets = labels;
            constraints.fill = 0;
            centerPanel.add((Component)rowNumberL, constraints);
            constraints.weightx = 1.0;
            constraints.gridx = 1;
            constraints.insets = enters;
            constraints.fill = 2;
            centerPanel.add((Component)this.rowNumberTF, constraints);
            constraints.weightx = 0.0;
            constraints.gridy = 1;
            constraints.gridx = 0;
            constraints.insets = labels;
            constraints.fill = 0;
            centerPanel.add((Component)columnNamesL, constraints);
            constraints.weightx = 1.0;
            constraints.gridx = 1;
            constraints.insets = enters;
            constraints.fill = 2;
            centerPanel.add((Component)this.columnNamesCB, constraints);
            JPanel buttonsPanel = new JPanel();
            buttonsPanel.add(ok);
            buttonsPanel.add(cancel);
            constraints.gridy = 2;
            constraints.gridx = 0;
            constraints.gridwidth = 2;
            constraints.insets = new Insets(10, 0, 5, 0);
            centerPanel.add((Component)buttonsPanel, constraints);
            this.pack();
        }
    }
}

