/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.GridViewerModel;
import com.insightful.miner.Retrievable;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;

public class GridViewerSorter
extends GridViewerModel
implements TableModelListener {
    public int[] indexes;
    private Vector sortingColumns = new Vector();
    private boolean ascending = true;
    private int compares;

    public GridViewerSorter() {
        this.indexes = new int[0];
    }

    public GridViewerSorter(GridViewerModel model) {
        this.setModel(model);
    }

    public GridViewerSorter(int visibleRows, int visibleCols, Retrievable getDataFrom) {
        super(visibleRows, visibleCols, getDataFrom);
        this.reallocateIndexes();
    }

    public void setModel(GridViewerModel model) {
        super.addTableModelListener(this);
        this.reallocateIndexes();
    }

    public int getRelativeColumnWidth(int column) {
        return super.getRelativeColumnWidth(column);
    }

    public int compareRowsByColumn(int row1, int row2, int column) {
        boolean rounding = this.dataSource.isRounding();
        this.dataSource.setRounding(false);
        Object o1 = this.dataSource.getData(row1, column);
        Object o2 = this.dataSource.getData(row2, column);
        this.dataSource.setRounding(rounding);
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        try {
            double d2;
            String str1 = (String)o1;
            String str2 = (String)o2;
            double d1 = str1.equals("NA") || str1.equals("NaN") ? Double.NaN : Double.parseDouble(str1);
            double d = d2 = str2.equals("NA") || str2.equals("NaN") ? Double.NaN : Double.parseDouble(str2);
            if (Double.isNaN(d1)) {
                if (Double.isNaN(d2)) {
                    return 0;
                }
                return -1;
            }
            if (Double.isNaN(d2)) {
                return 1;
            }
            if (d1 < d2) {
                return -1;
            }
            if (d1 > d2) {
                return 1;
            }
            return 0;
        }
        catch (Exception e) {
            String str1 = o1.toString();
            String str2 = o2.toString();
            int result = str1.compareTo(str2);
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }
    }

    public int compare(int row1, int row2) {
        ++this.compares;
        for (int level = 0; level < this.sortingColumns.size(); ++level) {
            Integer column = (Integer)this.sortingColumns.elementAt(level);
            int result = this.compareRowsByColumn(row1, row2, column);
            if (result == 0) continue;
            return this.ascending ? result : -result;
        }
        return 0;
    }

    public void reallocateIndexes() {
        int rowCount = (int)this.getTotalRowCount();
        this.indexes = new int[rowCount];
        for (int row = 0; row < rowCount; ++row) {
            this.indexes[row] = row;
        }
    }

    public void tableChanged(TableModelEvent e) {
        this.reallocateIndexes();
        this.fireTableChanged(e);
    }

    public void checkModel() {
        if ((long)this.indexes.length != this.getTotalRowCount()) {
            System.err.println("Sorter not informed of a change in model.");
        }
    }

    public void sort(Object sender) {
        this.checkModel();
        this.shuttlesort((int[])this.indexes.clone(), this.indexes, 0, this.indexes.length);
    }

    public void n2sort() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = i + 1; j < this.getRowCount(); ++j) {
                if (this.compare(this.indexes[i], this.indexes[j]) != -1) continue;
                this.swap(i, j);
            }
        }
    }

    public void shuttlesort(int[] from, int[] to, int low, int high) {
        if (high - low < 2) {
            return;
        }
        int middle = (low + high) / 2;
        this.shuttlesort(to, from, low, middle);
        this.shuttlesort(to, from, middle, high);
        int p = low;
        int q = middle;
        if (high - low >= 4 && this.compare(from[middle - 1], from[middle]) <= 0) {
            for (int i = low; i < high; ++i) {
                to[i] = from[i];
            }
            return;
        }
        for (int i = low; i < high; ++i) {
            to[i] = q >= high || p < middle && this.compare(from[p], from[q]) <= 0 ? from[p++] : from[q++];
        }
    }

    public void swap(int i, int j) {
        int tmp = this.indexes[i];
        this.indexes[i] = this.indexes[j];
        this.indexes[j] = tmp;
    }

    public int getRowCount() {
        return super.getRowCount();
    }

    public int getColumnCount() {
        return super.getColumnCount();
    }

    public String getColumnName(int aColumn) {
        return super.getColumnName(aColumn);
    }

    public Class getColumnClass(int aColumn) {
        return super.getColumnClass(aColumn);
    }

    public boolean isCellEditable(int row, int column) {
        return super.isCellEditable(row, column);
    }

    public Object getValueAt(int aRow, int aColumn) {
        return this.dataSource.getData(this.indexes[aRow + (int)this.absoluteRowPos], aColumn + this.absoluteColPos);
    }

    public void setValueAt(Object aValue, int aRow, int aColumn) {
        this.checkModel();
        super.setValueAt(aValue, this.indexes[aRow], aColumn);
    }

    public void sortByColumn(int column) {
        this.sortByColumn(column, true);
    }

    public void sortByColumn(int column, boolean ascending) {
        int actualColumn = column + this.absoluteColPos;
        this.ascending = ascending;
        this.sortingColumns.removeAllElements();
        this.sortingColumns.addElement(new Integer(actualColumn));
        this.sort(this);
        this.fireTableChanged(new TableModelEvent(this));
    }
}

