/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.GridViewerModel;
import com.insightful.miner.GridViewerTable;
import com.insightful.miner.MinerApp;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import javax.swing.plaf.UIResource;

public class GridViewerTransferHandler
extends TransferHandler {
    private GridViewerTable.GridViewerListSelectionModel selModel = null;

    public GridViewerTransferHandler(GridViewerTable.GridViewerListSelectionModel selModel) {
        this.selModel = selModel;
    }

    public GridViewerTransferHandler(String property) {
        super(property);
    }

    public void exportToClipboard(JComponent comp, Clipboard clip, int action) {
        boolean exportSuccess = false;
        Transferable t = null;
        int clipboardAction = this.getSourceActions(comp) & action;
        if (clipboardAction != 0) {
            try {
                t = this.createTransferable(comp);
                if (t != null) {
                    clip.setContents(t, null);
                    exportSuccess = true;
                }
            }
            catch (OutOfMemoryError oom) {
                oom.printStackTrace();
                AcceleratorOptionPane.showOKDialog(comp, MinerApp.getText("GridViewerTransferHandler_msg_chunkTooLarge"), MinerApp.getText("GridViewerTransferHandler_msg_outofMemory"), 0);
                exportSuccess = false;
                clip = null;
                t = null;
            }
        }
        if (exportSuccess) {
            this.exportDone(comp, t, clipboardAction);
        } else {
            this.exportDone(comp, null, 0);
        }
    }

    protected Transferable createTransferable(JComponent c) {
        if (c instanceof JTable) {
            JTable table = (JTable)c;
            long[] rows = this.getSelectedRows();
            return new TableTransferable(table, rows);
        }
        return null;
    }

    public long[] getSelectedRows() {
        long lMin = this.selModel.getMinimum();
        long lMax = this.selModel.getMaximum();
        int length = (int)(lMax - lMin);
        if ((double)length != (double)(lMax - lMin)) {
            length = 0x7FFFFFFE;
        }
        if (lMin == -1L || lMax == -1L) {
            return new long[0];
        }
        long[] rvTmp = new long[length + 1];
        int n = 0;
        for (long i = lMin; i <= lMax; ++i) {
            if (!this.selModel.isSelectedIndex(i)) continue;
            rvTmp[n++] = i;
        }
        long[] rv = new long[n];
        System.arraycopy(rvTmp, 0, rv, 0, n);
        return rv;
    }

    public int getSourceActions(JComponent c) {
        return 1;
    }

    class TableTransferable
    implements Transferable,
    UIResource {
        private DataFlavor[] htmlFlavors = this.createHTMLFlavors();
        private DataFlavor[] stringFlavors = this.createStringFlavors();
        private DataFlavor[] plainFlavors = this.createPlainFlavors();
        private long[] rows;
        private JTable table;
        private GridViewerModel model;

        private DataFlavor[] createHTMLFlavors() {
            return new DataFlavor[0];
        }

        private DataFlavor[] createStringFlavors() {
            return new DataFlavor[0];
        }

        private DataFlavor[] createPlainFlavors() {
            try {
                return new DataFlavor[]{new DataFlavor("text/plain;class=java.lang.String")};
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }

        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] richerFlavors = this.getRicherFlavors();
            int nRicher = richerFlavors != null ? richerFlavors.length : 0;
            int nHTML = this.isHTMLSupported() ? this.htmlFlavors.length : 0;
            int nPlain = this.isPlainSupported() ? this.plainFlavors.length : 0;
            int nString = this.isPlainSupported() ? this.stringFlavors.length : 0;
            int nFlavors = nRicher + nHTML + nPlain + nString;
            DataFlavor[] flavors = new DataFlavor[nFlavors];
            int nDone = 0;
            if (nRicher > 0) {
                System.arraycopy(richerFlavors, 0, flavors, nDone, nRicher);
                nDone += nRicher;
            }
            if (nHTML > 0) {
                System.arraycopy(this.htmlFlavors, 0, flavors, nDone, nHTML);
                nDone += nHTML;
            }
            if (nPlain > 0) {
                System.arraycopy(this.plainFlavors, 0, flavors, nDone, nPlain);
                nDone += nPlain;
            }
            if (nString > 0) {
                System.arraycopy(this.stringFlavors, 0, flavors, nDone, nString);
                nDone += nString;
            }
            return flavors;
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            DataFlavor[] flavors = this.getTransferDataFlavors();
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (this.isRicherFlavor(flavor)) {
                return this.getRicherData(flavor);
            }
            if (this.isHTMLFlavor(flavor)) {
                String data = this.getHTMLData();
                String string = data = data == null ? "" : data;
                if (String.class.equals(flavor.getRepresentationClass())) {
                    return data;
                }
                if (Reader.class.equals(flavor.getRepresentationClass())) {
                    return new StringReader(data);
                }
                if (InputStream.class.equals(flavor.getRepresentationClass())) {
                    return new StringBufferInputStream(data);
                }
            } else if (this.isPlainFlavor(flavor)) {
                String data = this.getPlainData();
                String string = data = data == null ? "" : data;
                if (String.class.equals(flavor.getRepresentationClass())) {
                    return data;
                }
                if (Reader.class.equals(flavor.getRepresentationClass())) {
                    return new StringReader(data);
                }
                if (InputStream.class.equals(flavor.getRepresentationClass())) {
                    return new StringBufferInputStream(data);
                }
            } else if (this.isStringFlavor(flavor)) {
                String data = this.getPlainData();
                data = data == null ? "" : data;
                return data;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        protected boolean isRicherFlavor(DataFlavor flavor) {
            DataFlavor[] richerFlavors = this.getRicherFlavors();
            int nFlavors = richerFlavors != null ? richerFlavors.length : 0;
            for (int i = 0; i < nFlavors; ++i) {
                if (!richerFlavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        protected DataFlavor[] getRicherFlavors() {
            return null;
        }

        protected Object getRicherData(DataFlavor flavor) throws UnsupportedFlavorException {
            return null;
        }

        protected boolean isHTMLFlavor(DataFlavor flavor) {
            DataFlavor[] flavors = this.htmlFlavors;
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        protected boolean isPlainFlavor(DataFlavor flavor) {
            DataFlavor[] flavors = this.plainFlavors;
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        protected boolean isStringFlavor(DataFlavor flavor) {
            DataFlavor[] flavors = this.stringFlavors;
            for (int i = 0; i < flavors.length; ++i) {
                if (!flavors[i].equals(flavor)) continue;
                return true;
            }
            return false;
        }

        TableTransferable(JTable table, long[] rows) {
            this.rows = rows;
            this.table = table;
            this.model = (GridViewerModel)table.getModel();
        }

        protected boolean isPlainSupported() {
            return this.isValid();
        }

        protected String getPlainData() {
            if (!this.isValid()) {
                return "";
            }
            StringBuffer result = new StringBuffer();
            int numColumns = this.model.getTotalColCount();
            for (int colCounter = 0; colCounter < numColumns; ++colCounter) {
                if (colCounter > 0) {
                    result.append("\t");
                }
                result.append(this.model.getAbsoluteColumnName(colCounter));
            }
            result.append("\n");
            for (int rowCounter = 0; rowCounter < this.rows.length; ++rowCounter) {
                for (int colCounter = 0; colCounter < numColumns; ++colCounter) {
                    Object value;
                    if (colCounter > 0) {
                        result.append("\t");
                    }
                    value = (value = this.model.getAbsoluteValueAt(this.rows[rowCounter], colCounter)) == null ? "" : value.toString();
                    result.append(value);
                }
                result.append("\n");
            }
            return result.toString();
        }

        protected boolean isHTMLSupported() {
            return this.isValid();
        }

        protected String getHTMLData() {
            if (!this.isValid()) {
                return "";
            }
            StringBuffer buf = new StringBuffer();
            buf.append("<html>\n<table>");
            buf.append("\n<tr>");
            int numColumns = this.model.getTotalColCount();
            for (int j = 0; j < numColumns; ++j) {
                buf.append("\n  <th id=" + j + ">" + this.model.getAbsoluteColumnName(j));
            }
            for (int i = 0; i < this.rows.length; ++i) {
                buf.append("\n<tr id=" + this.rows[i] + ">");
                for (int j = 0; j < numColumns; ++j) {
                    Object value = this.model.getAbsoluteValueAt(this.rows[i], j);
                    buf.append("\n  <td>" + value.toString());
                }
            }
            buf.append("\n</table>\n</html>");
            return buf.toString();
        }

        private boolean isValid() {
            if (this.rows != null) {
                long rowCount = this.model.getTotalRowCount();
                for (int counter = 0; counter < this.rows.length; ++counter) {
                    if (this.rows[counter] < rowCount) continue;
                    this.rows = null;
                    break;
                }
            }
            return this.rows != null;
        }
    }
}

