/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import javax.swing.JScrollBar;

public class LongScrollBar
extends JScrollBar {
    protected boolean longToIntConversionRequired;
    protected double jScrollBarConversionFactor;

    public LongScrollBar() {
    }

    public LongScrollBar(int orientation) {
        super(orientation);
    }

    public void initialize(long longValue) {
        if (longValue > Integer.MAX_VALUE) {
            this.jScrollBarConversionFactor = longValue / Integer.MAX_VALUE;
            this.longToIntConversionRequired = true;
        } else {
            this.longToIntConversionRequired = false;
        }
        this.jScrollBarConversionFactor = longValue / Integer.MAX_VALUE;
    }

    public void setLongMaximum(long longValue) {
        if (this.longToIntConversionRequired) {
            this.setMaximum(this.convertLongToInt(longValue));
        } else {
            this.setMaximum((int)longValue);
        }
    }

    public long getLongValue() {
        int intValue = this.getValue();
        if (this.longToIntConversionRequired) {
            return this.convertIntToLong(intValue);
        }
        return intValue;
    }

    public void setLongValue(long longValue) {
        if (this.longToIntConversionRequired) {
            this.setValue(this.convertLongToInt(longValue));
        } else {
            this.setValue((int)longValue);
        }
    }

    public int convertLongToInt(long longValue) {
        int intValue = (int)((double)longValue / this.jScrollBarConversionFactor);
        return intValue;
    }

    public long convertIntToLong(int intValue) {
        long longValue = (long)((double)intValue * this.jScrollBarConversionFactor);
        return longValue;
    }
}

