/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.MinerApp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;

public class MinerExtensionFileFilter
extends FileFilter {
    String[] extList;
    String description;
    private static int fileChooserReturnValue = 1;

    public MinerExtensionFileFilter(String ext, String descr) {
        this.extList = new String[]{ext};
        this.description = descr;
    }

    public MinerExtensionFileFilter(String[] ext, String descr) {
        this.extList = ext;
        this.description = descr;
    }

    public boolean accept(File file) {
        boolean status = true;
        boolean bl = status = file.isDirectory() || this.extList[0].equals("");
        if (!status) {
            String fileName = file.getName().toLowerCase();
            for (int i = 0; i < this.extList.length; ++i) {
                status = status || fileName.endsWith(this.extList[i]);
            }
        }
        return status;
    }

    public String getDescription() {
        return this.description;
    }

    public static int showWideFileChooserDialog(JFileChooser fileChooser, int width) {
        String title = fileChooser.getDialogTitle();
        if (title == null) {
            title = "Select File";
        }
        if (fileChooser.getApproveButtonText() == null) {
            fileChooser.setApproveButtonText("OK");
        }
        final JDialog fileChooserDialog = new JDialog(MinerApp.getMainFrame(), title, true);
        Container contentPane = fileChooserDialog.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)fileChooser, "Center");
        fileChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                String commandString = ae.getActionCommand();
                if (commandString.equals("ApproveSelection")) {
                    fileChooserReturnValue = 0;
                } else if (commandString.equals("CancelSelection")) {
                    fileChooserReturnValue = 1;
                } else {
                    fileChooserReturnValue = -1;
                }
                if (fileChooserDialog != null) {
                    fileChooserDialog.setVisible(false);
                }
            }
        });
        fileChooser.rescanCurrentDirectory();
        fileChooserDialog.pack();
        fileChooserDialog.setSize(new Dimension(width, fileChooserDialog.getSize().height));
        fileChooserDialog.setLocationRelativeTo(MinerApp.getMainFrame());
        fileChooserDialog.show();
        return fileChooserReturnValue;
    }
}

