/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcCoxRegPredict;
import com.insightful.cnkjava.CNKProcGLMFit;
import com.insightful.cnkjava.CNKProcJavaTransform;
import com.insightful.cnkjava.CNKProcKMeansPredict;
import com.insightful.cnkjava.CNKProcNNetPredict;
import com.insightful.cnkjava.CNKProcPredict;
import com.insightful.cnkjava.CNKProcPrinCompPredict;
import com.insightful.miner.ColumnDefinitions;
import com.insightful.miner.EngineNode;
import com.insightful.miner.NaiveBayesEngineNode;
import com.insightful.miner.PredictNodeModel;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import com.insightful.miner.tree.model.NaiveBayesPredictor;
import com.insightful.miner.tree.model.TreeCollection;
import com.insightful.miner.tree.model.TreePredictor;
import com.insightful.splus.util.XMLTransformUtilities;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PredictEngineNode
extends EngineNode {
    public static final String NEW_COLUMNS_ATTRIBUTE_TAG = "newColumns";
    public static final String COPY_INPUT_COLUMNS_ATTRIBUTE_TAG = "copyInputColumns";
    public static final String INDEPENDENT_ATTRIBUTE_TAG = "independent";
    public static final String DEPENDENT_ATTRIBUTE_TAG = "dependent";
    public static final String OTHER_ATTRIBUTE_TAG = "other";
    public static final String CLUSTER_COLUMNS_ATTRIBUTE_TAG = "clusterColumns";
    public static final String CLUSTER_OTHER_ATTRIBUTE_TAG = "clusterOther";
    public static final String REGRESSION_FITTED_VALUES_ATTRIBUTE_TAG = "fittedValues";
    public static final String REGRESSION_RESIDUALS_ATTRIBUTE_TAG = "residuals";
    public static final String REGRESSION_WEIGHTS_ATTRIBUTE_TAG = "weights";
    public static final String REGRESSION_ETA_ATTRIBUTE_TAG = "eta";
    public static final String CLASSIFICATION_PROBABILITY_ATTRIBUTE_TAG = "probability";
    public static final String CLASSIFICATION_CLASSIFICATION_ATTRIBUTE_TAG = "classification";
    public static final String CLASSIFICATION_AGREEMENT_ATTRIBUTE_TAG = "agreement";
    public static final String CLUSTER_MEMBERSHIP_ATTRIBUTE_TAG = "clusterMembership";
    public static final String CLUSTER_DISTANCE_TO_CENTER_ATTRIBUTE_TAG = "distanceToCenter";
    public static final String SCORES_ATTRIBUTE_TAG = "scores";
    public static final String FEATURE_VARIABLES_ATTRIBUTE_TAG = "featureVariables";
    public static final String SURVIVAL_RISK_ATTRIBUTE_TAG = "risk";
    public static final String SURVIVAL_RISK_SE_ATTRIBUTE_TAG = "riskSE";
    public static final String SURVIVAL_ATTRIBUTE_TAG = "survival";
    public static final String SURVIVAL_TYPE_ATTRIBUTE_TAG = "survivalType";
    public static final String SURVIVAL_TIME_ATTRIBUTE_TAG = "survivalTime";
    public static final String SURVIVAL_TIME_COLUMN_ATTRIBUTE_TAG = "survivalTimeColumn";
    public static final String MODEL_TYPE_PROPERTY_TAG = "modelType";
    public static final String TREE_MODEL_NODE_TAG = "TreeModel";
    public static final String TREE_LIST_NODE_TAG = "TreeList";
    public static final String GENERAL_REGRESSION_MODEL_NODE_TAG = "GeneralRegressionModel";
    public static final String FOR_SPECIFIED_CATEGORY_ATTRIBUTE_TAG = "forSpecifiedCategory";
    public static final String PROBABILITY_FOR_ATTRIBUTE_TAG = "probabilityFor";
    public static final String FOR_LAST_CATEGORY_ATTRIBUTE_TAG = "forLastCategory";
    public static final String SPECIFIED_CATEGORY_ATTRIBUTE_TAG = "specifiedCategory";
    public static final String ALL_CATEGORIES_ATTRIBUTE_TAG = "allCategories";
    public static final String NONE_ATTRIBUTE_TAG = "none";
    public static final String COLUMN_ATTRIBUTE_TAG = "column";
    public static final String TIME_ATTRIBUTE_TAG = "time";
    public static final String MODEL_OUTPUT_TYPE_PROPERTY_TAG = "modelOutputType";
    public static final String MODEL_ALGORITHM_PROPERTY_TAG = "modelAlgorithm";
    public static final String MODEL_DEPENDENT_VARIABLE_PROPERTY_TAG = "modelDependentVar";
    public static final String MODEL_INDEPENDENT_VARIABLE_PROPERTY_TAG = "modelIndependentVar";
    public static final String CLASSIFICATION_MODEL_OUTPUT_TYPE = "classification";
    public static final String REGRESSION_MODEL_OUTPUT_TYPE = "regression";
    public static final String CLUSTER_MODEL_OUTPUT_TYPE = "cluster";
    public static final String DIMENSION_REDUCTION_MODEL_OUTPUT_TYPE = "dimensionReduction";
    public static final String SURVIVAL_MODEL_OUTPUT_TYPE = "survival";
    public static final String GLM_MODEL_ALGORITHM = "glm";
    public static final String NNET_MODEL_ALGORITHM = "NNet";
    public static final String TREE_MODEL_ALGORITHM = "tree";
    public static final String NAIVE_BAYES_MODEL_ALGORITHM = "naiveBayes";
    public static final String CLUSTER_MODEL_ALGORITHM = "cluster";
    public static final String PRINCIPLE_COMPONENT_MODEL_ALGORITHM = "principleComponent";
    public static final String COXREGRESSION_MODEL_ALGORITHM = "coxRegression";
    public static final String SPLUS_MODEL_ALGORITHM = "splus";
    public static final String PREDICT_PROB_COLUMN_NAME = "PREDICT.prob";
    public static final String PREDICT_FIT_COLUMN_NAME = "PREDICT.fit";
    public static final String PREDICT_CLASS_COLUMN_NAME = "PREDICT.class";
    public static final String PREDICT_AGREEMENT_COLUMN_NAME = "PREDICT.agreement";
    public static final String PREDICT_RESIDUALS_COLUMN_NAME = "PREDICT.residuals";
    public static final String PREDICT_WEIGHTS_COLUMN_NAME = "PREDICT.weights";
    public static final String PREDICT_ETA_COLUMN_NAME = "PREDICT.eta";
    public static final String PREDICT_RISK_COLUMN_NAME = "PREDICT.risk";
    public static final String PREDICT_RISK_SE_COLUMN_NAME = "PREDICT.risk.se";
    public static final String PREDICT_SURVIVAL_COLUMN_NAME = "PREDICT.survival";
    public static final String PREDICT_MEMBERSHIP_COLUMN_NAME = "PREDICT.membership";
    public static final String PREDICT_DISTANCE_COLUMN_NAME = "PREDICT.distance";
    public static final String UNKNOWN_LEVEL_SUBSTITUTION_ATTRIBUTE_TAG = "unknownLevelSubs";
    public static final String UNKNOWN_LEVEL_GENERATE_ERROR_VALUE = "unknownLevelGenerateError";
    public static final String UNKNOWN_LEVEL_NAN_VALUE = "unknownLevelNAN";

    public EngineNode.InputRequirements getInputRequirements(int inputNum) {
        return EngineNode.InputRequirements.getMinRequirements();
    }

    public Vector getOutputSpecs() {
        Vector depVars = new Vector();
        XTProps props = this.getNodeProperties();
        if (this.isSurvivalModel()) {
            depVars = props.getSubProperties(MODEL_DEPENDENT_VARIABLE_PROPERTY_TAG);
        } else {
            depVars.add(props.getValue(MODEL_DEPENDENT_VARIABLE_PROPERTY_TAG));
        }
        Vector indepVars = props.getSubProperties(MODEL_INDEPENDENT_VARIABLE_PROPERTY_TAG);
        Vector outputSpecs = PredictEngineNode.getOutputSpecs(this.getInputMetaData(0), props, depVars, indepVars);
        return outputSpecs;
    }

    public Vector getOutputSpecsForPredictor() {
        XTProps props = this.getNodeProperties();
        Vector outputSpecs = null;
        try {
            String modType;
            XTMetaData modelMD;
            XMLTree testModel;
            XMLTree model = testModel = this.getModel();
            if (this.isModelType(PredictNodeModel.getModelAlgorithm(testModel), NAIVE_BAYES_MODEL_ALGORITHM)) {
                model = new XTProps(testModel);
            }
            if ((modelMD = PredictNodeModel.getFittedModelMetaData(testModel)) == null) {
                modelMD = this.getInputMetaData(0);
            }
            String depVar = PredictEngineNode.getFirstDependentVar(props, modelMD);
            Vector indepVars = PredictEngineNode.getIndependentVars(props, modelMD);
            XTMetaData inMD = this.getInputMetaData(0);
            if (depVar != null && depVar.length() > 0 && inMD.nameToOrdinal(depVar) < 0) {
                if (PredictEngineNode.propIsTrue(COPY_INPUT_COLUMNS_ATTRIBUTE_TAG, DEPENDENT_ATTRIBUTE_TAG, props)) {
                    this.printlnWarning("Column " + depVar + " is not in the input buffer. Cannot copy it to the output buffer.");
                }
                if (PredictEngineNode.propIsTrue(NEW_COLUMNS_ATTRIBUTE_TAG, CLASSIFICATION_AGREEMENT_ATTRIBUTE_TAG, props)) {
                    this.printlnWarning("Column " + depVar + " is not in the input buffer. Cannot compute agreement.");
                }
                if (PredictEngineNode.propIsTrue(NEW_COLUMNS_ATTRIBUTE_TAG, REGRESSION_RESIDUALS_ATTRIBUTE_TAG, props)) {
                    this.printlnWarning("Column " + depVar + " is not in the input buffer. Cannot compute residuals.");
                }
            }
            String string = modType = testModel != null ? PredictNodeModel.getModelAlgorithm(testModel) : "";
            if (modType.length() == 0) {
                modType = props.getValue(MODEL_ALGORITHM_PROPERTY_TAG);
            }
            if (this.isModelType(modType, "cluster")) {
                outputSpecs = PredictEngineNode.getClusterOutputSpecs(inMD, props, testModel);
            } else if (this.isModelType(modType, PRINCIPLE_COMPONENT_MODEL_ALGORITHM)) {
                outputSpecs = PredictEngineNode.getDimensionReductionOutputSpecs(inMD, props, testModel);
            } else if (this.isModelType(modType, COXREGRESSION_MODEL_ALGORITHM)) {
                Vector depVars = PredictEngineNode.getDependentVars(props, modelMD);
                outputSpecs = PredictEngineNode.getOutputSpecsForPredictor(inMD, testModel, props, depVars, indepVars);
            } else if (this.isModelType(modType, NAIVE_BAYES_MODEL_ALGORITHM)) {
                XTProps propsModel = new XTProps(testModel);
                outputSpecs = PredictEngineNode.getOutputSpecsForPredictor(inMD, (XMLTree)propsModel, props, depVar, indepVars);
            } else {
                outputSpecs = PredictEngineNode.getOutputSpecsForPredictor(inMD, testModel, props, depVar, indepVars);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return outputSpecs;
    }

    public boolean isModelType(String model, String type) {
        return model.equals(type);
    }

    public CNKProc procCreate() throws Exception {
        XTMetaData md = this.getInputMetaData(0);
        XTProps props = this.getNodeProperties();
        XMLTree model = this.getModel();
        if (model == null) {
            throw new RuntimeException("No model found.  Check for previous errors.");
        }
        XTMetaData modelMD = PredictNodeModel.getFittedModelMetaData(model);
        String depVar = PredictEngineNode.getFirstDependentVar(props, modelMD);
        Vector indepVars = PredictEngineNode.getIndependentVars(props, modelMD);
        String modType = PredictNodeModel.getModelAlgorithm(model);
        if (modType.length() == 0) {
            modType = props.getValue(MODEL_ALGORITHM_PROPERTY_TAG);
        }
        if (this.isModelType(modType, GLM_MODEL_ALGORITHM)) {
            Vector outputSpecs = PredictEngineNode.getOutputSpecsForPredictor(md, model, props, depVar, indepVars);
            PredictEngineNode.isConflictingIO(outputSpecs, this);
            CNKProcGLMFit proc = new CNKProcGLMFit(PredictEngineNode.asString(model));
            this.setUnknownLevelMap(proc, props, md);
            PredictEngineNode.defineOutputsFromSpecs(proc, outputSpecs);
            return proc;
        }
        if (this.isModelType(modType, TREE_MODEL_ALGORITHM)) {
            Vector outputSpecs = PredictEngineNode.getOutputSpecsForPredictor(md, model, props, depVar, indepVars);
            PredictEngineNode.isConflictingIO(outputSpecs, this);
            TreeCollection treeColl = new TreeCollection(model, null, Integer.parseInt(this.getNodeID()), this.getNetworkManager().getWorksheetID());
            TreePredictor treePredictor = new TreePredictor(treeColl);
            treePredictor.setOutputSpecs(outputSpecs);
            treePredictor.setUnknownLevelBehaviors(PredictEngineNode.getUnknownLevelBehaviors(props));
            treePredictor.initExecute();
            CNKProcJavaTransform proc = new CNKProcJavaTransform(treePredictor);
            return proc;
        }
        if (this.isModelType(modType, NAIVE_BAYES_MODEL_ALGORITHM)) {
            XTProps naiveBayesProps = new XTProps(model);
            Vector outputSpecs = PredictEngineNode.getOutputSpecsForPredictor(md, (XMLTree)naiveBayesProps, props, depVar, indepVars);
            PredictEngineNode.isConflictingIO(outputSpecs, this);
            NaiveBayesPredictor naiveBayesPredictor = new NaiveBayesPredictor(naiveBayesProps, this.getInputMetaData(0), this);
            naiveBayesPredictor.setOutputSpecs(outputSpecs);
            naiveBayesPredictor.setUnknownLevelBehaviors(PredictEngineNode.getUnknownLevelBehaviors(props));
            CNKProcJavaTransform proc = new CNKProcJavaTransform(naiveBayesPredictor);
            return proc;
        }
        if (this.isModelType(modType, NNET_MODEL_ALGORITHM)) {
            Vector outputSpecs = PredictEngineNode.getOutputSpecsForPredictor(md, model, props, depVar, indepVars);
            PredictEngineNode.isConflictingIO(outputSpecs, this);
            CNKProcNNetPredict proc = new CNKProcNNetPredict(PredictEngineNode.asString(model));
            this.setUnknownLevelMap(proc, props, md);
            PredictEngineNode.defineOutputsFromSpecs(proc, outputSpecs);
            return proc;
        }
        if (this.isModelType(modType, "cluster")) {
            Vector outputSpecs = PredictEngineNode.getClusterOutputSpecs(md, props, model);
            PredictEngineNode.isConflictingIO(outputSpecs, this);
            CNKProcKMeansPredict proc = new CNKProcKMeansPredict(PredictEngineNode.asString(model));
            this.setUnknownLevelMap(proc, props, md);
            PredictEngineNode.defineOutputsFromSpecs(proc, outputSpecs);
            return proc;
        }
        if (this.isModelType(modType, PRINCIPLE_COMPONENT_MODEL_ALGORITHM)) {
            Vector outputSpecs = PredictEngineNode.getDimensionReductionOutputSpecs(md, props, model);
            PredictEngineNode.isConflictingIO(outputSpecs, this);
            CNKProcPrinCompPredict proc = new CNKProcPrinCompPredict(PredictEngineNode.asString(model));
            this.setUnknownLevelMap(proc, props, md);
            PredictEngineNode.defineOutputsFromSpecs(proc, outputSpecs);
            return proc;
        }
        if (this.isModelType(modType, COXREGRESSION_MODEL_ALGORITHM)) {
            Vector depVars = PredictEngineNode.getDependentVars(props, modelMD);
            Vector outputSpecs = PredictEngineNode.getOutputSpecsForPredictor(md, model, props, depVars, indepVars);
            PredictEngineNode.isConflictingIO(outputSpecs, this);
            CNKProcCoxRegPredict proc = new CNKProcCoxRegPredict(PredictEngineNode.asString(model));
            this.setUnknownLevelMap(proc, props, md);
            PredictEngineNode.defineOutputsFromSpecs(proc, outputSpecs);
            String val = props.getValue(new String[]{NEW_COLUMNS_ATTRIBUTE_TAG, "survival"}, NONE_ATTRIBUTE_TAG);
            val = props.getValue(new String[]{NEW_COLUMNS_ATTRIBUTE_TAG, SURVIVAL_TYPE_ATTRIBUTE_TAG}, val);
            if (!val.equals(NONE_ATTRIBUTE_TAG)) {
                String[] path = new String[3];
                path[0] = NEW_COLUMNS_ATTRIBUTE_TAG;
                path[1] = "survival";
                if (val.equals(COLUMN_ATTRIBUTE_TAG)) {
                    path[2] = SURVIVAL_TIME_COLUMN_ATTRIBUTE_TAG;
                    val = props.getValue(path, "");
                    if (val.length() == 0) {
                        throw new Exception("no time column specified for computing survival probabilities");
                    }
                    proc.setSurvivalTimeColumn(val);
                } else {
                    path[2] = SURVIVAL_TIME_ATTRIBUTE_TAG;
                    double dval = props.getDouble(path, Double.NaN);
                    if (Double.isNaN(dval)) {
                        throw new Exception("no time specified for computing survival probabilities");
                    }
                    proc.setSurvivalTime(dval);
                }
            }
            return proc;
        }
        throw new Exception("unknown model type " + props.getValue(MODEL_ALGORITHM_PROPERTY_TAG, "?"));
    }

    public void procSetProperties(CNKProc proc) {
    }

    private String getModelAsString() {
        return PredictEngineNode.asString(this.getModel());
    }

    public XTMetaData calculateOutputMetaData(int outputNum) {
        if (outputNum == 0) {
            String modType = PredictNodeModel.getModelAlgorithm(this.getModel());
            if (modType.length() == 0) {
                modType = this.getNodeProperties().getValue(MODEL_ALGORITHM_PROPERTY_TAG, "");
            }
            if (this.isModelType(modType, GLM_MODEL_ALGORITHM) || this.isModelType(modType, NAIVE_BAYES_MODEL_ALGORITHM) || this.isModelType(modType, "cluster") || this.isModelType(modType, TREE_MODEL_ALGORITHM) || this.isModelType(modType, NNET_MODEL_ALGORITHM) || this.isModelType(modType, PRINCIPLE_COMPONENT_MODEL_ALGORITHM) || this.isModelType(modType, COXREGRESSION_MODEL_ALGORITHM)) {
                return PredictEngineNode.calculateOutputMetaDataFromOutputSpecs(this.getOutputSpecsForPredictor());
            }
            return PredictEngineNode.calculateOutputMetaDataFromOutputSpecs(this.getOutputSpecs());
        }
        return null;
    }

    public boolean isTreeModel() {
        return this.getNodeProperties().getValue(MODEL_ALGORITHM_PROPERTY_TAG).equals(TREE_MODEL_ALGORITHM);
    }

    public boolean isNaiveBayesModel() {
        return this.getNodeProperties().getValue(MODEL_ALGORITHM_PROPERTY_TAG).equals(NAIVE_BAYES_MODEL_ALGORITHM);
    }

    public boolean isGLMModel() {
        return this.getNodeProperties().getValue(MODEL_ALGORITHM_PROPERTY_TAG).equals(GLM_MODEL_ALGORITHM);
    }

    public boolean isNNetModel() {
        return this.getNodeProperties().getValue(MODEL_ALGORITHM_PROPERTY_TAG).equals(NNET_MODEL_ALGORITHM);
    }

    public boolean isClusterModel() {
        return this.getNodeProperties().getValue(MODEL_ALGORITHM_PROPERTY_TAG).equals("cluster");
    }

    public boolean isPrincipleComponentModel() {
        return this.getNodeProperties().getValue(MODEL_ALGORITHM_PROPERTY_TAG).equals(PRINCIPLE_COMPONENT_MODEL_ALGORITHM);
    }

    public boolean isClassificationModel() {
        return this.getNodeProperties().getValue(MODEL_OUTPUT_TYPE_PROPERTY_TAG).equals("classification");
    }

    public boolean isRegressionModel() {
        return this.getNodeProperties().getValue(MODEL_OUTPUT_TYPE_PROPERTY_TAG).equals(REGRESSION_MODEL_OUTPUT_TYPE);
    }

    public boolean isSurvivalModel() {
        return this.getNodeProperties().getValue(MODEL_OUTPUT_TYPE_PROPERTY_TAG).equals("survival");
    }

    public void setUnknownLevelMap(CNKProcPredict proc, XTProps props, XTMetaData md) {
        proc.clearUnknownLevelMap();
        Vector colNames = props.getSubProperties(UNKNOWN_LEVEL_SUBSTITUTION_ATTRIBUTE_TAG);
        int numCols = colNames.size();
        String[] path = new String[]{UNKNOWN_LEVEL_SUBSTITUTION_ATTRIBUTE_TAG, ""};
        for (int i = 0; i < numCols; ++i) {
            int colNum;
            String colName;
            path[1] = colName = (String)colNames.get(i);
            String mapLevel = props.getValue(path, null);
            if (mapLevel == null || mapLevel.equals("") || mapLevel.equals(UNKNOWN_LEVEL_NAN_VALUE)) continue;
            if (mapLevel.equals(UNKNOWN_LEVEL_GENERATE_ERROR_VALUE)) {
                mapLevel = "";
            }
            if ((colNum = md.nameToOrdinal(colName)) < 0) continue;
            proc.addUnknownLevelMap(colNum, mapLevel);
        }
    }

    public static Hashtable getUnknownLevelBehaviors(XTProps props) {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        Vector colNames = props.getSubProperties(UNKNOWN_LEVEL_SUBSTITUTION_ATTRIBUTE_TAG);
        int numCols = colNames.size();
        String[] path = new String[]{UNKNOWN_LEVEL_SUBSTITUTION_ATTRIBUTE_TAG, ""};
        for (int i = 0; i < numCols; ++i) {
            String colName;
            path[1] = colName = (String)colNames.get(i);
            String mapLevel = props.getValue(path, null);
            if (mapLevel == null || mapLevel.equals("") || mapLevel.equals(UNKNOWN_LEVEL_NAN_VALUE)) continue;
            if (mapLevel.equals(UNKNOWN_LEVEL_GENERATE_ERROR_VALUE)) {
                mapLevel = "";
            }
            hash.put(colName, mapLevel);
        }
        return hash;
    }

    public static String asString(XMLTree tree) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Class<?> outputFormatClass = null;
            Class<?> xmlFormatterClass = null;
            try {
                outputFormatClass = Class.forName("com.sun.org.apache.xml.internal.serialize.OutputFormat");
                xmlFormatterClass = Class.forName("com.sun.org.apache.xml.internal.serialize.XMLSerializer");
            }
            catch (ClassNotFoundException e) {
                outputFormatClass = Class.forName("org.apache.xml.serialize.OutputFormat");
                xmlFormatterClass = Class.forName("org.apache.xml.serialize.XMLSerializer");
            }
            Object of = outputFormatClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            outputFormatClass.getMethod("setEncoding", String.class).invoke(of, "UTF-8");
            outputFormatClass.getMethod("setIndenting", Boolean.TYPE).invoke(of, new Boolean(true));
            outputFormatClass.getMethod("setOmitXMLDeclaration", Boolean.TYPE).invoke(of, new Boolean(false));
            outputFormatClass.getMethod("setPreserveSpace", Boolean.TYPE).invoke(of, new Boolean(true));
            Document xmldoc = null;
            if (tree.getXML() == tree.getDocument().getFirstChild()) {
                xmldoc = tree.getDocument();
            } else {
                xmldoc = XMLTransformUtilities.getBuilder().newDocument();
                Element xmlNode = (Element)tree.getXML().cloneNode(true);
                xmldoc.appendChild(xmldoc.importNode(xmlNode, true));
            }
            Object slz = xmlFormatterClass.getConstructor(OutputStream.class, outputFormatClass).newInstance(out, of);
            xmlFormatterClass.getMethod("serialize", Document.class).invoke(slz, xmldoc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            return out.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return out.toString();
        }
    }

    public static boolean isConflictingIO(Vector outputSpecs, EngineNode eNode) throws Exception {
        XTMetaData inputMD = eNode.getInputMetaData(0);
        int numSpecs = outputSpecs.size();
        boolean conflict = false;
        for (int i = 0; i < numSpecs; ++i) {
            OutputSpec spec = (OutputSpec)outputSpecs.get(i);
            boolean isCopy = spec.m_glmTag.equals("copy");
            if (isCopy || inputMD.nameToOrdinal(spec.m_colName) == -1) continue;
            eNode.printlnError("Attempting to create an output column name (" + spec.m_colName + ") that already exists in the input.");
            conflict = true;
        }
        return conflict;
    }

    public static XTMetaData calculateOutputMetaDataFromOutputSpecs(Vector outputSpecs) {
        XTMetaData md = null;
        try {
            md = new XTMetaData();
            for (int i = 0; i < outputSpecs.size(); ++i) {
                OutputSpec spec = (OutputSpec)outputSpecs.get(i);
                if (spec.m_glmTag.equals("copy")) {
                    if (spec.m_inputVarType.equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG)) {
                        md.appendCategoricalDataField(spec.m_colName, new String[0]);
                    } else if (spec.m_inputVarType.equals(XTMetaData.STRING_TYPE_ATTRIBUTE_TAG)) {
                        md.appendStringDataField(spec.m_colName, spec.m_inputVarStringBytes);
                    } else if (spec.m_inputVarType.equals(XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG)) {
                        md.appendDateTimeDataField(spec.m_colName);
                    } else if (spec.m_inputVarType.equals(XTMetaData.BLOB_TYPE_ATTRIBUTE_TAG)) {
                        md.appendBlobDataField(spec.m_colName, spec.m_inputVarBlobClassName);
                    } else {
                        md.appendContinousDataField(spec.m_colName);
                    }
                } else if (spec.m_isFactor) {
                    md.appendCategoricalDataField(spec.m_colName, new String[0]);
                } else {
                    md.appendContinousDataField(spec.m_colName);
                }
                md.setDataFieldRole(spec.m_colName, spec.m_role);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return md;
    }

    public static Vector getOutputSpecs(XTMetaData inMD, XTProps props, String depVar, Vector indepVars) {
        Vector<String> depVars = new Vector<String>();
        if (depVar != null) {
            depVars.add(depVar);
        }
        return PredictEngineNode.getOutputSpecs(inMD, props, depVars, indepVars);
    }

    public static Vector getOutputSpecs(XTMetaData inMD, XTProps props, Vector depVars, Vector indepVars) {
        Vector<OutputSpec> v = new Vector<OutputSpec>();
        boolean copyDep = PredictEngineNode.propIsTrue(COPY_INPUT_COLUMNS_ATTRIBUTE_TAG, DEPENDENT_ATTRIBUTE_TAG, props);
        boolean copyIndep = PredictEngineNode.propIsTrue(COPY_INPUT_COLUMNS_ATTRIBUTE_TAG, INDEPENDENT_ATTRIBUTE_TAG, props);
        boolean copyOther = PredictEngineNode.propIsTrue(COPY_INPUT_COLUMNS_ATTRIBUTE_TAG, OTHER_ATTRIBUTE_TAG, props);
        String depVar = "";
        if (depVars.size() > 0) {
            depVar = (String)depVars.get(0);
        }
        int depColumnNum = inMD.nameToOrdinal(depVar);
        if (copyDep || copyIndep || copyOther) {
            Vector inputNames = inMD.getColumnNames();
            for (int i = 0; i < inputNames.size(); ++i) {
                String inputName = (String)inputNames.get(i);
                if (depVars.contains(inputName)) {
                    if (!copyDep) continue;
                    v.add(OutputSpec.getCopyInputSpec(inMD, i, XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG));
                    continue;
                }
                if (indepVars.contains(inputName)) {
                    if (!copyIndep) continue;
                    v.add(OutputSpec.getCopyInputSpec(inMD, i, XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG));
                    continue;
                }
                if (!copyOther) continue;
                v.add(OutputSpec.getCopyInputSpec(inMD, i, XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG));
            }
        }
        if (PredictEngineNode.propIsTrue(NEW_COLUMNS_ATTRIBUTE_TAG, CLASSIFICATION_PROBABILITY_ATTRIBUTE_TAG, props)) {
            String[] path;
            String inputType = null;
            String varName = depVar;
            boolean isFactor = false;
            boolean error = false;
            if (depColumnNum >= 0) {
                inputType = inMD.getColumnType(depColumnNum);
                isFactor = inputType.equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG);
            }
            if (isFactor) {
                try {
                    Vector levels = PredictEngineNode.getSpecifiedOutputCategories(props, inMD.getCategoricalDataFieldLevels(depVar));
                    varName = (String)levels.get(0);
                }
                catch (Exception e) {
                    error = true;
                }
            }
            String newColName = PREDICT_PROB_COLUMN_NAME;
            if (!error && props.getValue(path = new String[]{NEW_COLUMNS_ATTRIBUTE_TAG, PROBABILITY_FOR_ATTRIBUTE_TAG}).equals(FOR_SPECIFIED_CATEGORY_ATTRIBUTE_TAG)) {
                path[1] = SPECIFIED_CATEGORY_ATTRIBUTE_TAG;
                String desired = props.getValue(path);
                if (desired.length() > 0) {
                    newColName = "Pr(" + desired + ")";
                }
            }
            v.add(new OutputSpec(PredictEngineNode.getNewName(newColName, v), false, XTMetaData.PREDICTION_ROLE_ATTRIBUTE_TAG, depColumnNum, varName, CLASSIFICATION_PROBABILITY_ATTRIBUTE_TAG));
        }
        if (PredictEngineNode.propIsTrue(NEW_COLUMNS_ATTRIBUTE_TAG, REGRESSION_FITTED_VALUES_ATTRIBUTE_TAG, props)) {
            v.add(new OutputSpec(PredictEngineNode.getNewName(PREDICT_FIT_COLUMN_NAME, v), false, XTMetaData.PREDICTION_ROLE_ATTRIBUTE_TAG, depColumnNum, depVar, "fitted.value"));
        }
        if (PredictEngineNode.propIsTrue(NEW_COLUMNS_ATTRIBUTE_TAG, "classification", props)) {
            v.add(new OutputSpec(PredictEngineNode.getNewName(PREDICT_CLASS_COLUMN_NAME, v), true, XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG, depColumnNum, depVar, "category"));
        }
        if (PredictEngineNode.propIsTrue(NEW_COLUMNS_ATTRIBUTE_TAG, CLASSIFICATION_AGREEMENT_ATTRIBUTE_TAG, props) && depColumnNum >= 0) {
            v.add(new OutputSpec(PredictEngineNode.getNewName(PREDICT_AGREEMENT_COLUMN_NAME, v), false, XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG, depColumnNum, depVar, CLASSIFICATION_AGREEMENT_ATTRIBUTE_TAG));
        }
        if (PredictEngineNode.propIsTrue(NEW_COLUMNS_ATTRIBUTE_TAG, REGRESSION_RESIDUALS_ATTRIBUTE_TAG, props) && depColumnNum >= 0) {
            v.add(new OutputSpec(PredictEngineNode.getNewName(PREDICT_RESIDUALS_COLUMN_NAME, v), false, XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG, depColumnNum, depVar, "residual"));
        }
        if (PredictEngineNode.propIsTrue(NEW_COLUMNS_ATTRIBUTE_TAG, REGRESSION_WEIGHTS_ATTRIBUTE_TAG, props) && depColumnNum >= 0) {
            v.add(new OutputSpec(PredictEngineNode.getNewName(PREDICT_WEIGHTS_COLUMN_NAME, v), false, XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG, depColumnNum, depVar, "weight"));
        }
        if (PredictEngineNode.propIsTrue(NEW_COLUMNS_ATTRIBUTE_TAG, REGRESSION_ETA_ATTRIBUTE_TAG, props) && depColumnNum >= 0) {
            v.add(new OutputSpec(PredictEngineNode.getNewName(PREDICT_ETA_COLUMN_NAME, v), false, XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG, depColumnNum, depVar, REGRESSION_ETA_ATTRIBUTE_TAG));
        }
        if (PredictEngineNode.propIsTrue(NEW_COLUMNS_ATTRIBUTE_TAG, SURVIVAL_RISK_ATTRIBUTE_TAG, props)) {
            v.add(new OutputSpec(PredictEngineNode.getNewName(PREDICT_RISK_COLUMN_NAME, v), false, XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG, depColumnNum, depVar, SURVIVAL_RISK_ATTRIBUTE_TAG));
            v.add(new OutputSpec(PredictEngineNode.getNewName(PREDICT_RISK_SE_COLUMN_NAME, v), false, XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG, depColumnNum, depVar, SURVIVAL_RISK_SE_ATTRIBUTE_TAG));
        }
        String val = props.getValue(new String[]{NEW_COLUMNS_ATTRIBUTE_TAG, "survival"}, NONE_ATTRIBUTE_TAG);
        if (!(val = props.getValue(new String[]{NEW_COLUMNS_ATTRIBUTE_TAG, SURVIVAL_TYPE_ATTRIBUTE_TAG}, val)).equals(NONE_ATTRIBUTE_TAG)) {
            String[] path;
            if (val.equals(COLUMN_ATTRIBUTE_TAG) && (val = props.getValue(path = new String[]{NEW_COLUMNS_ATTRIBUTE_TAG, "survival", SURVIVAL_TIME_COLUMN_ATTRIBUTE_TAG}, "")).length() > 0) {
                int i;
                int n = v.size();
                for (i = 0; i < n && !val.equals(((OutputSpec)v.get((int)i)).m_colName); ++i) {
                }
                if (i >= n) {
                    OutputSpec spec = new OutputSpec(PredictEngineNode.getNewName(val, v), false, XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG, inMD.nameToOrdinal(val), val, "copy");
                    spec.m_inputVarType = inMD.getColumnType(val);
                    v.add(spec);
                }
            }
            v.add(new OutputSpec(PredictEngineNode.getNewName(PREDICT_SURVIVAL_COLUMN_NAME, v), false, XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG, depColumnNum, depVar, "survival"));
        }
        return v;
    }

    public static Vector getClusterOutputSpecs(XTMetaData inMD, XTProps props) throws Exception {
        return PredictEngineNode.getClusterOutputSpecs(inMD, props, null);
    }

    public static Vector getClusterOutputSpecs(XTMetaData inMD, XTProps props, XMLTree model) throws Exception {
        Vector<OutputSpec> v = new Vector<OutputSpec>();
        boolean copyIndep = PredictEngineNode.propIsTrue(COPY_INPUT_COLUMNS_ATTRIBUTE_TAG, CLUSTER_COLUMNS_ATTRIBUTE_TAG, props);
        boolean copyOther = PredictEngineNode.propIsTrue(COPY_INPUT_COLUMNS_ATTRIBUTE_TAG, CLUSTER_OTHER_ATTRIBUTE_TAG, props);
        if (copyIndep || copyOther) {
            XTMetaData modelMD;
            Vector inputNames = inMD.getColumnNames();
            Vector indepColumns = props.getSubProperties("outgoingColumns");
            if (model != null && (modelMD = PredictNodeModel.getFittedModelMetaData(model)) != null) {
                indepColumns = PredictEngineNode.getIndependentVars(props, modelMD);
            }
            for (int i = 0; i < inputNames.size(); ++i) {
                boolean isColIndep = indepColumns.contains(inputNames.get(i));
                if (copyIndep && isColIndep) {
                    v.add(OutputSpec.getCopyInputSpec(inMD, i, XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG));
                    continue;
                }
                if (!copyOther || isColIndep) continue;
                v.add(OutputSpec.getCopyInputSpec(inMD, i, XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG));
            }
        }
        if (PredictEngineNode.propIsTrue(NEW_COLUMNS_ATTRIBUTE_TAG, CLUSTER_MEMBERSHIP_ATTRIBUTE_TAG, props, true)) {
            v.add(new OutputSpec(PredictEngineNode.getNewName(PREDICT_MEMBERSHIP_COLUMN_NAME, v), true, XTMetaData.PREDICTION_ROLE_ATTRIBUTE_TAG, -1, "", CLUSTER_MEMBERSHIP_ATTRIBUTE_TAG));
        }
        if (PredictEngineNode.propIsTrue(NEW_COLUMNS_ATTRIBUTE_TAG, CLUSTER_DISTANCE_TO_CENTER_ATTRIBUTE_TAG, props, true)) {
            v.add(new OutputSpec(PredictEngineNode.getNewName(PREDICT_DISTANCE_COLUMN_NAME, v), false, XTMetaData.PREDICTION_ROLE_ATTRIBUTE_TAG, -1, "", CLUSTER_DISTANCE_TO_CENTER_ATTRIBUTE_TAG));
        }
        return v;
    }

    public static Vector getDimensionReductionOutputSpecs(XTMetaData inMD, XTProps props, XMLTree model) throws Exception {
        Element xml;
        NodeList components;
        Vector<OutputSpec> v = new Vector<OutputSpec>();
        boolean copyVars = PredictEngineNode.propIsTrue(COPY_INPUT_COLUMNS_ATTRIBUTE_TAG, FEATURE_VARIABLES_ATTRIBUTE_TAG, props);
        boolean copyOther = PredictEngineNode.propIsTrue(COPY_INPUT_COLUMNS_ATTRIBUTE_TAG, OTHER_ATTRIBUTE_TAG, props);
        Vector vars = props.getSubProperties(FEATURE_VARIABLES_ATTRIBUTE_TAG);
        if (copyVars || copyOther) {
            Vector inputNames = inMD.getColumnNames();
            for (int i = 0; i < inputNames.size(); ++i) {
                String inputName = (String)inputNames.get(i);
                if (vars.contains(inputName)) {
                    if (!copyVars) continue;
                    v.add(OutputSpec.getCopyInputSpec(inMD, i, XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG));
                    continue;
                }
                if (!copyOther) continue;
                v.add(OutputSpec.getCopyInputSpec(inMD, i, XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG));
            }
        }
        if (PredictEngineNode.propIsTrue(NEW_COLUMNS_ATTRIBUTE_TAG, SCORES_ATTRIBUTE_TAG, props, true) && model != null && (components = (xml = model.getXML()).getElementsByTagName("PrinComp")).getLength() == 1) {
            NamedNodeMap attr;
            Node comp = components.item(0);
            if (comp.hasAttributes() && (attr = comp.getAttributes()).getLength() > 0) {
                Node size = attr.getNamedItem("size");
                int n = Integer.parseInt(size.getNodeValue());
                for (int i = 0; i < n; ++i) {
                    String val = PredictEngineNode.getNewName("Component" + Integer.toString(i + 1), v);
                    v.add(new OutputSpec(val, false, XTMetaData.PREDICTION_ROLE_ATTRIBUTE_TAG, -1, val, "score"));
                }
            }
        }
        return v;
    }

    public static Vector getOutputSpecsForPredictor(XTMetaData inMD, XMLTree model, XTProps props, String depVar, Vector indepVars) throws Exception {
        Vector<String> depVars = new Vector<String>();
        depVars.add(depVar);
        return PredictEngineNode.getOutputSpecsForPredictor(inMD, model, props, depVars, indepVars);
    }

    public static Vector getOutputSpecsForPredictor(XTMetaData inMD, XMLTree model, XTProps props, Vector depVars, Vector indepVars) throws Exception {
        int depColumnNum;
        Vector<OutputSpec> v = new Vector<OutputSpec>();
        boolean copyDep = PredictEngineNode.propIsTrue(COPY_INPUT_COLUMNS_ATTRIBUTE_TAG, DEPENDENT_ATTRIBUTE_TAG, props);
        boolean copyIndep = PredictEngineNode.propIsTrue(COPY_INPUT_COLUMNS_ATTRIBUTE_TAG, INDEPENDENT_ATTRIBUTE_TAG, props);
        boolean copyOther = PredictEngineNode.propIsTrue(COPY_INPUT_COLUMNS_ATTRIBUTE_TAG, OTHER_ATTRIBUTE_TAG, props);
        String depVar = (String)depVars.get(0);
        int n = depColumnNum = depVar != null ? inMD.nameToOrdinal(depVar) : -1;
        if (copyDep || copyIndep || copyOther) {
            Vector inputNames = inMD.getColumnNames();
            for (int i = 0; i < inputNames.size(); ++i) {
                String inputName = (String)inputNames.get(i);
                if (depVars.contains(inputName)) {
                    if (!copyDep) continue;
                    v.add(OutputSpec.getCopyInputSpec(inMD, i, XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG));
                    continue;
                }
                if (indepVars.contains(inputName)) {
                    if (!copyIndep) continue;
                    v.add(OutputSpec.getCopyInputSpec(inMD, i, XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG));
                    continue;
                }
                if (!copyOther) continue;
                v.add(OutputSpec.getCopyInputSpec(inMD, i, XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG));
            }
        }
        String modelType = PredictNodeModel.getModelOutputType(model);
        boolean isGLM = PredictNodeModel.isGLM(model);
        if (modelType.length() == 0) {
            modelType = props.getValue(MODEL_ALGORITHM_PROPERTY_TAG);
        }
        if (PredictEngineNode.propIsTrue(NEW_COLUMNS_ATTRIBUTE_TAG, CLASSIFICATION_PROBABILITY_ATTRIBUTE_TAG, props, modelType.equals("classification"))) {
            Vector allLevs;
            if (model != null && !PredictEngineNode.isCategoricalVariable(model, depVar)) {
                throw new Exception("Requested class probabilities but variable " + depVar + " is not categorical");
            }
            Vector vector = allLevs = model != null ? PredictEngineNode.getVariableCategories(model, depVar) : new Vector();
            if (props.getValue(new String[]{NEW_COLUMNS_ATTRIBUTE_TAG, PROBABILITY_FOR_ATTRIBUTE_TAG}).equals(FOR_LAST_CATEGORY_ATTRIBUTE_TAG)) {
                String newColName = PredictEngineNode.getNewName(PREDICT_PROB_COLUMN_NAME, v);
                String vName = allLevs.size() == 0 ? "" : (String)PredictEngineNode.getSpecifiedOutputCategories(props, allLevs).get(0);
                v.add(new OutputSpec(newColName, false, XTMetaData.PREDICTION_ROLE_ATTRIBUTE_TAG, depColumnNum, vName, CLASSIFICATION_PROBABILITY_ATTRIBUTE_TAG));
            } else if (allLevs.size() > 0) {
                Vector levels = PredictEngineNode.getSpecifiedOutputCategories(props, allLevs);
                int ncol = levels.size();
                for (int i = 0; i < ncol; ++i) {
                    String newColName = PREDICT_PROB_COLUMN_NAME;
                    if (ncol != 1 || !props.getValue(new String[]{NEW_COLUMNS_ATTRIBUTE_TAG, PROBABILITY_FOR_ATTRIBUTE_TAG}).equals(FOR_LAST_CATEGORY_ATTRIBUTE_TAG)) {
                        newColName = PredictEngineNode.getNewName("Pr(" + (String)levels.get(i) + ")", v);
                    }
                    v.add(new OutputSpec(newColName, false, XTMetaData.PREDICTION_ROLE_ATTRIBUTE_TAG, depColumnNum, (String)levels.get(i), CLASSIFICATION_PROBABILITY_ATTRIBUTE_TAG));
                }
            }
        }
        if (isGLM) {
            if (PredictEngineNode.propIsTrue(NEW_COLUMNS_ATTRIBUTE_TAG, REGRESSION_WEIGHTS_ATTRIBUTE_TAG, props) && depColumnNum >= 0) {
                v.add(new OutputSpec(PredictEngineNode.getNewName(PREDICT_WEIGHTS_COLUMN_NAME, v), false, XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG, depColumnNum, depVar, "weight"));
            }
            if (PredictEngineNode.propIsTrue(NEW_COLUMNS_ATTRIBUTE_TAG, REGRESSION_ETA_ATTRIBUTE_TAG, props) && depColumnNum >= 0) {
                v.add(new OutputSpec(PredictEngineNode.getNewName(PREDICT_ETA_COLUMN_NAME, v), false, XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG, depColumnNum, depVar, REGRESSION_ETA_ATTRIBUTE_TAG));
            }
        }
        if (modelType.equals(REGRESSION_MODEL_OUTPUT_TYPE) && PredictEngineNode.propIsTrue(NEW_COLUMNS_ATTRIBUTE_TAG, REGRESSION_FITTED_VALUES_ATTRIBUTE_TAG, props, true)) {
            v.add(new OutputSpec(PredictEngineNode.getNewName(PREDICT_FIT_COLUMN_NAME, v), false, XTMetaData.PREDICTION_ROLE_ATTRIBUTE_TAG, depColumnNum, depVar, "fitted.value"));
        }
        if ((modelType.equals("classification") || modelType.equals(NAIVE_BAYES_MODEL_ALGORITHM)) && PredictEngineNode.propIsTrue(NEW_COLUMNS_ATTRIBUTE_TAG, "classification", props, true)) {
            v.add(new OutputSpec(PredictEngineNode.getNewName(PREDICT_CLASS_COLUMN_NAME, v), true, XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG, depColumnNum, depVar, "category"));
        }
        if (modelType.equals("classification") && PredictEngineNode.propIsTrue(NEW_COLUMNS_ATTRIBUTE_TAG, CLASSIFICATION_AGREEMENT_ATTRIBUTE_TAG, props, true) && depColumnNum >= 0) {
            v.add(new OutputSpec(PredictEngineNode.getNewName(PREDICT_AGREEMENT_COLUMN_NAME, v), false, XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG, depColumnNum, depVar, CLASSIFICATION_AGREEMENT_ATTRIBUTE_TAG));
        }
        if ((modelType.equals(REGRESSION_MODEL_OUTPUT_TYPE) || isGLM) && PredictEngineNode.propIsTrue(NEW_COLUMNS_ATTRIBUTE_TAG, REGRESSION_RESIDUALS_ATTRIBUTE_TAG, props, true) && depColumnNum >= 0) {
            v.add(new OutputSpec(PredictEngineNode.getNewName(PREDICT_RESIDUALS_COLUMN_NAME, v), false, XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG, depColumnNum, depVar, "residual"));
        }
        if (modelType.equals("survival") && PredictEngineNode.propIsTrue(NEW_COLUMNS_ATTRIBUTE_TAG, SURVIVAL_RISK_ATTRIBUTE_TAG, props, true)) {
            v.add(new OutputSpec(PredictEngineNode.getNewName(PREDICT_RISK_COLUMN_NAME, v), false, XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG, depColumnNum, depVar, SURVIVAL_RISK_ATTRIBUTE_TAG));
            v.add(new OutputSpec(PredictEngineNode.getNewName(PREDICT_RISK_SE_COLUMN_NAME, v), false, XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG, depColumnNum, depVar, SURVIVAL_RISK_SE_ATTRIBUTE_TAG));
        }
        String val = props.getValue(new String[]{NEW_COLUMNS_ATTRIBUTE_TAG, "survival"}, NONE_ATTRIBUTE_TAG);
        if (!(val = props.getValue(new String[]{NEW_COLUMNS_ATTRIBUTE_TAG, SURVIVAL_TYPE_ATTRIBUTE_TAG}, val)).equals(NONE_ATTRIBUTE_TAG)) {
            String[] path;
            if (val.equals(COLUMN_ATTRIBUTE_TAG) && (val = props.getValue(path = new String[]{NEW_COLUMNS_ATTRIBUTE_TAG, "survival", SURVIVAL_TIME_COLUMN_ATTRIBUTE_TAG}, "")).length() > 0) {
                int i;
                int n2 = v.size();
                for (i = 0; i < n2 && !val.equals(((OutputSpec)v.get((int)i)).m_colName); ++i) {
                }
                if (i >= n2) {
                    OutputSpec spec = new OutputSpec(PredictEngineNode.getNewName(val, v), false, XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG, inMD.nameToOrdinal(val), val, "copy");
                    spec.m_inputVarType = inMD.getColumnType(val);
                    v.add(spec);
                }
            }
            v.add(new OutputSpec(PredictEngineNode.getNewName(PREDICT_SURVIVAL_COLUMN_NAME, v), false, XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG, depColumnNum, depVar, "survival"));
        }
        return v;
    }

    private static String getNewName(String name, Vector v) {
        return name;
    }

    public static boolean anyOutputs(XTProps props) {
        return PredictEngineNode.propIsTrue(NEW_COLUMNS_ATTRIBUTE_TAG, CLASSIFICATION_PROBABILITY_ATTRIBUTE_TAG, props) || PredictEngineNode.propIsTrue(NEW_COLUMNS_ATTRIBUTE_TAG, "classification", props) || PredictEngineNode.propIsTrue(NEW_COLUMNS_ATTRIBUTE_TAG, CLASSIFICATION_AGREEMENT_ATTRIBUTE_TAG, props) || PredictEngineNode.propIsTrue(NEW_COLUMNS_ATTRIBUTE_TAG, REGRESSION_FITTED_VALUES_ATTRIBUTE_TAG, props) || PredictEngineNode.propIsTrue(NEW_COLUMNS_ATTRIBUTE_TAG, REGRESSION_RESIDUALS_ATTRIBUTE_TAG, props) || PredictEngineNode.propIsTrue(COPY_INPUT_COLUMNS_ATTRIBUTE_TAG, INDEPENDENT_ATTRIBUTE_TAG, props) || PredictEngineNode.propIsTrue(COPY_INPUT_COLUMNS_ATTRIBUTE_TAG, DEPENDENT_ATTRIBUTE_TAG, props) || PredictEngineNode.propIsTrue(COPY_INPUT_COLUMNS_ATTRIBUTE_TAG, OTHER_ATTRIBUTE_TAG, props) || PredictEngineNode.propIsTrue(NEW_COLUMNS_ATTRIBUTE_TAG, SURVIVAL_RISK_ATTRIBUTE_TAG, props) || PredictEngineNode.propIsTrue(NEW_COLUMNS_ATTRIBUTE_TAG, SURVIVAL_RISK_SE_ATTRIBUTE_TAG, props) || PredictEngineNode.propIsTrue(NEW_COLUMNS_ATTRIBUTE_TAG, SCORES_ATTRIBUTE_TAG, props) || !props.getValue(new String[]{NEW_COLUMNS_ATTRIBUTE_TAG, "survival"}, NONE_ATTRIBUTE_TAG).equals(NONE_ATTRIBUTE_TAG) || !props.getValue(new String[]{NEW_COLUMNS_ATTRIBUTE_TAG, SURVIVAL_TYPE_ATTRIBUTE_TAG}, NONE_ATTRIBUTE_TAG).equals(NONE_ATTRIBUTE_TAG) || PredictEngineNode.propIsTrue(COPY_INPUT_COLUMNS_ATTRIBUTE_TAG, FEATURE_VARIABLES_ATTRIBUTE_TAG, props) || PredictEngineNode.propIsTrue(NEW_COLUMNS_ATTRIBUTE_TAG, CLUSTER_MEMBERSHIP_ATTRIBUTE_TAG, props) || PredictEngineNode.propIsTrue(NEW_COLUMNS_ATTRIBUTE_TAG, CLUSTER_DISTANCE_TO_CENTER_ATTRIBUTE_TAG, props) || PredictEngineNode.propIsTrue(COPY_INPUT_COLUMNS_ATTRIBUTE_TAG, CLUSTER_COLUMNS_ATTRIBUTE_TAG, props) || PredictEngineNode.propIsTrue(COPY_INPUT_COLUMNS_ATTRIBUTE_TAG, CLUSTER_OTHER_ATTRIBUTE_TAG, props);
    }

    public static boolean propIsTrue(String str1, String str2, XTProps props) {
        return PredictEngineNode.propIsTrue(str1, str2, props, false);
    }

    public static boolean propIsTrue(String str1, String str2, XTProps props, boolean defaultVal) {
        String[] index = new String[]{str1, str2};
        String val = props.getValue(index, Boolean.toString(defaultVal));
        return val.equalsIgnoreCase("true");
    }

    public static void defineOutputsFromSpecs(CNKProcPredict proc, Vector outputSpecs) {
        proc.clearOutputs();
        for (int outputColNum = 0; outputColNum < outputSpecs.size(); ++outputColNum) {
            OutputSpec spec = (OutputSpec)outputSpecs.get(outputColNum);
            proc.defineOutput(outputColNum, spec.m_glmTag, spec.m_varName);
        }
    }

    public static Vector getVarsWithRole(XTProps props, XTMetaData md, String roleType) {
        String roleName;
        Vector v;
        block5: {
            Vector roleVars;
            block3: {
                String dVar;
                block4: {
                    v = new Vector();
                    roleVars = props.getSubProperties("columnRoles");
                    if (roleVars.size() != 0) break block3;
                    if (!roleType.equals(XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG)) break block4;
                    v = props.getSubProperties(MODEL_INDEPENDENT_VARIABLE_PROPERTY_TAG);
                    break block5;
                }
                if (!roleType.equals(XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG) || (dVar = props.getValue(MODEL_DEPENDENT_VARIABLE_PROPERTY_TAG)).length() <= 0) break block5;
                v.add(dVar);
                break block5;
            }
            for (String varName : roleVars) {
                roleName = props.getValue(new String[]{"columnRoles", varName});
                if (roleName == null || !roleName.equals(roleType)) continue;
                v.add(varName);
            }
        }
        if (v.size() == 0) {
            Vector varNames = md.getColumnNames();
            for (String varName : varNames) {
                roleName = md.getColumnRole(varName);
                if (roleName == null || !roleName.equals(roleType)) continue;
                v.add(varName);
            }
        }
        return v;
    }

    public static Node getColumnInfoNode(XMLTree tree, String variable) {
        Node result = null;
        try {
            Element xml = tree.getXML();
            NodeList colInfo = xml.getElementsByTagName(ColumnDefinitions.DATA_FIELD_NODE_TAG);
            for (int i = 0; i < colInfo.getLength(); ++i) {
                Node coli = colInfo.item(i);
                if (!coli.hasAttributes()) continue;
                NamedNodeMap attr = coli.getAttributes();
                if (attr.getLength() != 0) {
                    Node vari = attr.getNamedItem(ColumnDefinitions.NAME_ATTRIBUTE_TAG);
                    if (!vari.getNodeValue().equals(variable)) continue;
                    result = coli;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static boolean isCategoricalVariable(XMLTree tree, String variable) {
        boolean result = false;
        try {
            if (tree instanceof XTProps) {
                result = true;
            } else {
                Node col = PredictEngineNode.getColumnInfoNode(tree, variable);
                if (col != null) {
                    NamedNodeMap attr = col.getAttributes();
                    Node type = attr.getNamedItem(XTMetaData.TYPE_ATTRIBUTE_TAG);
                    result = type.getNodeValue().equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static Vector getVariableCategories(XMLTree tree, String variable) throws Exception {
        Vector<String> result = null;
        if (tree instanceof XTProps) {
            XTProps xtpTree = (XTProps)tree;
            if (xtpTree.getValue(NaiveBayesEngineNode.DEPENDENT_COLUMN_ATTRIBUTE_TAG).equals(variable)) {
                result = xtpTree.getSubProperties(NaiveBayesEngineNode.DEPENDENT_COLUMN_ATTRIBUTE_TAG);
                result.remove("NaN");
                result.remove("total");
            } else {
                Element element = xtpTree.findProperty("counts");
                NodeList list = element.getChildNodes();
                int n = list.getLength();
                for (int i = 0; i < n; ++i) {
                    Element ele = (Element)list.item(i);
                    if (!ele.getAttribute(XTProps.NAME_ATTRIBUTE_TAG).equals(variable)) continue;
                    int n1 = list.getLength();
                    result = new Vector();
                    for (int j = 0; j < n1; ++j) {
                        result.add(((Element)list.item(i)).getAttribute(XTProps.NAME_ATTRIBUTE_TAG));
                    }
                }
            }
        } else {
            Node col = PredictEngineNode.getColumnInfoNode(tree, variable);
            if (col != null) {
                NodeList levels = col.getChildNodes();
                int n = levels.getLength();
                result = new Vector<String>();
                for (int i = 0; i < n; ++i) {
                    Node level = levels.item(i);
                    if (!level.getNodeName().equals(ColumnDefinitions.LEVEL_NODE_TAG) || !level.hasAttributes()) continue;
                    NamedNodeMap attr = level.getAttributes();
                    Node value = attr.getNamedItem(ColumnDefinitions.VALUE_ATTRIBUTE_TAG);
                    result.add(value.getNodeValue());
                }
            }
        }
        if (result == null || result.size() == 0) {
            throw new Exception("Could not obtain the categories for varible " + variable);
        }
        return result;
    }

    public static Vector getSpecifiedOutputCategories(XTProps props, Vector levels) throws Exception {
        String[] path = new String[]{NEW_COLUMNS_ATTRIBUTE_TAG, CLASSIFICATION_PROBABILITY_ATTRIBUTE_TAG};
        Vector<String> ret = new Vector<String>();
        String category = ALL_CATEGORIES_ATTRIBUTE_TAG;
        if (props.getBoolean(path, false)) {
            path[1] = PROBABILITY_FOR_ATTRIBUTE_TAG;
            category = props.getValue(path, FOR_LAST_CATEGORY_ATTRIBUTE_TAG);
        }
        if (category.equals(FOR_SPECIFIED_CATEGORY_ATTRIBUTE_TAG)) {
            path[1] = SPECIFIED_CATEGORY_ATTRIBUTE_TAG;
            String desired = props.getValue(path, "");
            if (desired.length() == 0) {
                category = FOR_LAST_CATEGORY_ATTRIBUTE_TAG;
            } else {
                ret.add(desired);
                return ret;
            }
        }
        int n = levels.size();
        for (int i = 0; i < n; ++i) {
            int j;
            String levi = (String)levels.get(i);
            int n1 = ret.size();
            for (j = 0; j < n1; ++j) {
                if (((String)ret.get(j)).compareToIgnoreCase(levi) < 0) continue;
                ret.add(j, levi);
                break;
            }
            if (j < n1) continue;
            ret.add(levi);
        }
        if (category.equals(FOR_LAST_CATEGORY_ATTRIBUTE_TAG)) {
            ret.setElementAt((String)ret.get(ret.size() - 1), 0);
            ret.setSize(1);
        }
        return ret;
    }

    public static Vector getIndependentVars(XTProps props, XTMetaData md) {
        return PredictEngineNode.getVarsWithRole(props, md, XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG);
    }

    public static Vector getDependentVars(XTProps props, XTMetaData md) {
        return PredictEngineNode.getVarsWithRole(props, md, XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG);
    }

    public static String getFirstDependentVar(XTProps props, XTMetaData md) {
        return PredictEngineNode.getFirstDependentVar(props, md, null);
    }

    public static String getFirstDependentVar(XTProps props, XTMetaData md, String type) {
        Vector v = PredictEngineNode.getDependentVars(props, md);
        if (v == null) {
            return null;
        }
        int size = v.size();
        for (int i = 0; i < size; ++i) {
            String column = (String)v.get(i);
            if (column.length() <= 0 || type != null && !md.getColumnType(column).equals(type)) continue;
            return column;
        }
        return null;
    }

    public static boolean anyNAsInModelVariables(EngineNode node, XTProps props, XTMetaData md, boolean printBadVariables) {
        String depVar = PredictEngineNode.getFirstDependentVar(props, md);
        Vector indepVars = PredictEngineNode.getIndependentVars(props, md);
        return PredictEngineNode.anyNAsInModelVariables(node, depVar, indepVars, md, printBadVariables);
    }

    public static boolean anyNAsInModelVariables(EngineNode node, String depVar, Vector indepVars, XTMetaData md, boolean printBadVariables) {
        Vector<String> allVars = new Vector<String>(indepVars);
        if (depVar != null) {
            allVars.add(depVar);
        }
        boolean anyNAVars = false;
        for (int i = 0; i < allVars.size(); ++i) {
            long naCount;
            String mVar = (String)allVars.get(i);
            if (md.nameToOrdinal(mVar) < 0 || (naCount = (long)md.getColumnMissingCount(mVar)) <= 0L) continue;
            if (printBadVariables) {
                node.printlnError("bad model variable: " + mVar + " has " + naCount + " missing values");
            }
            anyNAVars = true;
        }
        return anyNAVars;
    }

    public static class OutputSpec {
        public String m_colName;
        public boolean m_isFactor;
        public String m_role;
        public int m_inputColNum;
        public String m_varName;
        public String m_glmTag;
        public String m_inputVarType = null;
        public int m_inputVarStringBytes = 32;
        public String m_inputVarBlobClassName = null;

        OutputSpec(String colName, boolean isFactor, String role, int inputColNum, String varName, String glmTag) {
            this.m_colName = colName;
            this.m_isFactor = isFactor;
            this.m_role = role;
            this.m_inputColNum = inputColNum;
            this.m_varName = varName;
            this.m_glmTag = glmTag;
        }

        static OutputSpec getCopyInputSpec(XTMetaData md, int inputColNum, String role) {
            String inputName = md.ordinalToName(inputColNum);
            boolean isFactor = md.isCategoricalColumn(inputColNum);
            OutputSpec spec = new OutputSpec(inputName, isFactor, role, inputColNum, inputName, "copy");
            spec.m_inputVarType = md.getColumnType(inputColNum);
            spec.m_inputVarStringBytes = md.getStringDataFieldWidth(inputColNum);
            spec.m_inputVarBlobClassName = md.getBlobDataFieldClassName(inputColNum);
            return spec;
        }
    }
}

