/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.ActivityNodeArea;
import com.insightful.miner.ActivityNodeComputed;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.ActivityNodeState;
import com.insightful.miner.BaseNodeArea;
import com.insightful.miner.ClassificationNeuralNetworkNodeModel;
import com.insightful.miner.HtmlFrame;
import com.insightful.miner.LogisticRegressionEngineNode;
import com.insightful.miner.MinerApp;
import com.insightful.miner.MinerClassificationTreeGUI;
import com.insightful.miner.NaiveBayesNodeModel;
import com.insightful.miner.PMMLExportable;
import com.insightful.miner.PMMLImportable;
import com.insightful.miner.PredictEngineNode;
import com.insightful.miner.PredictableNodeModel;
import com.insightful.miner.PredictionDialog;
import com.insightful.miner.PredictionPanel;
import com.insightful.miner.ReadPMMLFileNodeModel;
import com.insightful.miner.SurvivalViewer;
import com.insightful.miner.WorksheetDocument;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTNetwork;
import com.insightful.miner.XTProps;
import com.insightful.miner.tree.model.TreeCollection;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PredictNodeModel
extends ActivityNodeModel
implements PMMLImportable,
PMMLExportable {
    public static final String DEFAULT_LABEL = "Predict";
    private static final Element DEFAULT_XML_ELEMENT = PredictNodeModel.buildDefaultElement();
    private static final XTNetwork.NodeInfo DEFAULT_INFO = PredictNodeModel.buildDefaultInfo();
    private static final String[] modelTypes = new String[]{"GeneralRegressionModel", "TreeModel"};
    private static final int[] modelTypeCodes = new int[]{0, 1};

    public PredictNodeModel(Element elt) {
        super(elt);
    }

    public PredictNodeModel(XTNetwork.NodeInfo elt) {
        super(elt);
    }

    public PredictNodeModel(PredictableNodeModel nodeModel) {
        this(nodeModel, true, true);
    }

    public PredictNodeModel(PredictableNodeModel nodeModel, boolean setModel, boolean setProperties) {
        super(DEFAULT_INFO.copy());
        if (setModel) {
            this.setPredictNodeModel(nodeModel, true);
        }
        if (setProperties) {
            this.setPredictNodeProperties(nodeModel, true);
        }
    }

    public void setPredictNodeModel(PMMLExportable exportModel, boolean staticModel) {
        PredictNodeModel.setPredictNodeModel(this, exportModel, staticModel);
    }

    public static void setPredictNodeModel(PMMLImportable importModel, PMMLExportable exportModel, boolean staticModel) {
        ActivityNodeModel aNodeModel = (ActivityNodeModel)((Object)exportModel);
        ActivityNodeModel thisModel = (ActivityNodeModel)((Object)importModel);
        thisModel.m_nodeInfo.executeAfter = thisModel.m_nodeInfo.modelParent = Integer.toString(aNodeModel.getID());
        if (staticModel) {
            if (aNodeModel.getState() == ActivityNodeComputed.instance()) {
                XMLTree fitXmlTree = exportModel.getFittedModel();
                if (fitXmlTree != null) {
                    thisModel.m_nodeInfo.model = new XTNetwork.ModelInfo(fitXmlTree);
                    fitXmlTree = null;
                    System.gc();
                } else {
                    AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), MinerApp.getText("PredictNodeModel_msg_nodeHasnoFittedModel"), MinerApp.getText("PredictNodeModel_msg_predictNodeCreationError"), 0);
                }
            } else {
                thisModel.m_nodeInfo.executeAfter = null;
                thisModel.m_nodeInfo.modelParent = null;
                thisModel.m_nodeInfo.model = null;
            }
        } else {
            thisModel.m_nodeInfo.model = null;
        }
    }

    public void setPredictNodeProperties(PMMLExportable exportModel, boolean changeLabel) {
        PredictNodeModel.setPredictNodeProperties(this, exportModel, true, changeLabel);
    }

    public static void setPredictNodeProperties(PMMLImportable importModel, PMMLExportable exportModel, boolean predictNode, boolean changeLabel) {
        String modelOutputType = null;
        String modelAlgorithm = null;
        String dependentVar = null;
        Vector independentVars = null;
        String[] booleanPath = null;
        XTProps props = null;
        if (MinerApp.isRunning()) {
            return;
        }
        ActivityNodeModel aNodeModel = (ActivityNodeModel)((Object)exportModel);
        ActivityNodeModel thisModel = (ActivityNodeModel)((Object)importModel);
        if (exportModel instanceof ReadPMMLFileNodeModel && !aNodeModel.getState().equals(ActivityNodeComputed.instance())) {
            thisModel.getXTProps().removeProperty(new String[]{"modelOutputType"});
            return;
        }
        if (predictNode) {
            thisModel.setDefaultLabel("Predict: " + aNodeModel.getDefaultLabel());
            if (changeLabel) {
                thisModel.setLabelText("Predict: " + aNodeModel.getLabelText());
            }
        }
        props = thisModel.getXTProps();
        modelOutputType = exportModel.getModelOutputType();
        modelAlgorithm = exportModel.getModelAlgorithm();
        dependentVar = exportModel.getDependentVariable();
        independentVars = exportModel.getIndependentVariables();
        booleanPath = new String[]{"newColumns", ""};
        XTProps parentProps = aNodeModel.getXTProps();
        boolean sameType = modelOutputType.equals(importModel.getModelOutputType()) && modelAlgorithm.equals(importModel.getModelAlgorithm());
        String[] delPath = new String[]{"hiddenLayers"};
        props.removeProperty(delPath);
        delPath[0] = "numNodesHiddenLayer";
        props.removeProperty(delPath);
        if (!sameType) {
            delPath[0] = "newColumns";
            props.removeProperty(delPath);
            delPath[0] = "copyInputColumns";
            props.removeProperty(delPath);
        }
        delPath[0] = "columnRoles";
        props.removeProperty(delPath);
        delPath[0] = "modelDependentVar";
        props.removeProperty(delPath);
        if (modelOutputType.equals("classification")) {
            booleanPath[1] = "probability";
            props.set(booleanPath, props.getBoolean(booleanPath, true));
            booleanPath[1] = "classification";
            props.set(booleanPath, props.getBoolean(booleanPath, true));
            booleanPath[1] = "agreement";
            props.set(booleanPath, props.getBoolean(booleanPath, false));
            booleanPath[1] = "probabilityFor";
            String temp = parentProps.getValue(booleanPath, "allCategories");
            props.set(booleanPath, props.getValue(booleanPath, temp));
            booleanPath[1] = "specifiedCategory";
            temp = props.getValue(booleanPath, parentProps.getValue(booleanPath, ""));
            if (!temp.equals("")) {
                props.set(booleanPath, temp);
            }
        } else if (modelOutputType.equals("regression")) {
            booleanPath[1] = "fittedValues";
            props.set(booleanPath, props.getBoolean(booleanPath, true));
            booleanPath[1] = "residuals";
            props.set(booleanPath, props.getBoolean(booleanPath, false));
        } else if (modelOutputType.equals("cluster")) {
            booleanPath[1] = "clusterMembership";
            props.set(booleanPath, props.getBoolean(booleanPath, true));
            booleanPath[1] = "distanceToCenter";
            props.set(booleanPath, props.getBoolean(booleanPath, false));
            booleanPath[0] = "copyInputColumns";
            booleanPath[1] = "clusterColumns";
            props.set(booleanPath, props.getBoolean(booleanPath, true));
            booleanPath[1] = "clusterOther";
            props.set(booleanPath, props.getBoolean(booleanPath, false));
        } else if (modelOutputType.equals("dimensionReduction")) {
            booleanPath[0] = "newColumns";
            booleanPath[1] = "scores";
            props.set(booleanPath, props.getBoolean(booleanPath, true));
            booleanPath[0] = "copyInputColumns";
            booleanPath[1] = XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG;
            props.set(booleanPath, props.getBoolean(booleanPath, false));
            booleanPath[1] = "other";
            props.set(booleanPath, props.getBoolean(booleanPath, false));
            booleanPath[0] = "featureVariables";
            independentVars = parentProps.getSubProperties("featureVariables");
            for (int i = 0; i < independentVars.size(); ++i) {
                booleanPath[1] = (String)independentVars.get(i);
                props.set(booleanPath, true);
            }
        } else if (modelOutputType.equals("survival")) {
            booleanPath[0] = "newColumns";
            booleanPath[1] = "risk";
            props.set(booleanPath, props.getBoolean(booleanPath, true));
            booleanPath[1] = "survival";
            props.set(booleanPath, props.getValue(booleanPath, "none"));
        } else {
            throw new RuntimeException("Model type not recognized: " + modelOutputType);
        }
        if (modelAlgorithm.equals("NNet")) {
            String prop = "hiddenLayers";
            props.set(prop, parentProps.getValue(prop));
            prop = "numNodesHiddenLayer";
            props.set(prop, parentProps.getValue(prop));
            booleanPath[0] = "columnRoles";
            Vector columns = parentProps.getSubProperties(booleanPath[0]);
            for (int i = 0; i < columns.size(); ++i) {
                booleanPath[1] = (String)columns.get(i);
                props.set(booleanPath, parentProps.getValue(booleanPath, ""));
            }
        }
        if (!modelOutputType.equals("cluster") && !modelOutputType.equals("dimensionReduction")) {
            booleanPath[0] = "copyInputColumns";
            booleanPath[1] = XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG;
            props.set(booleanPath, props.getBoolean(booleanPath, false));
            booleanPath[1] = XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG;
            props.set(booleanPath, props.getBoolean(booleanPath, true));
            booleanPath[1] = "other";
            props.set(booleanPath, props.getBoolean(booleanPath, false));
            if (modelOutputType.equals("survival")) {
                Vector responseVars = exportModel.getDependentVariables();
                booleanPath[0] = "modelDependentVar";
                for (int i = 0; i < responseVars.size(); ++i) {
                    booleanPath[1] = (String)responseVars.get(i);
                    props.set(booleanPath, true);
                }
            } else {
                props.set("modelDependentVar", dependentVar);
            }
            booleanPath[0] = "modelIndependentVar";
            for (int i = 0; i < independentVars.size(); ++i) {
                booleanPath[1] = (String)independentVars.get(i);
                props.set(booleanPath, true);
            }
        }
        props.set("modelOutputType", modelOutputType);
        props.set("modelAlgorithm", modelAlgorithm);
        dependentVar = null;
        modelAlgorithm = null;
        modelOutputType = null;
        independentVars = null;
        booleanPath = null;
        props = null;
        System.gc();
    }

    public boolean isPropertiesValid() {
        XTNetwork.NodeInfo nodeInfo = this.getNodeInfo();
        return nodeInfo.modelParent != null || nodeInfo.model != null;
    }

    public void stateChanged(ChangeEvent e) {
        if (ActivityNodeState.isDeepMode()) {
            ActivityNodeState.setDeepMode(false);
            MinerApp.invalidateNode(Integer.toString(this.getID()));
            if (this.m_modelInputs.size() > 0) {
                PMMLExportable parent = (PMMLExportable)this.m_modelInputs.get(0);
                XTNetwork.NodeInfo old = this.getNodeInfo().copy();
                this.setPredictNodeProperties(parent, false);
                this.setPredictNodeModel(parent, false);
                if (!old.equals(this.getNodeInfo())) {
                    this.getDocument().setEngineNetworkDirty();
                }
            }
            ActivityNodeState.setDeepMode(true);
            super.stateChanged(e);
        }
    }

    private void setModel(XMLTree fitXmlTree) {
        this.m_nodeInfo.model = new XTNetwork.ModelInfo(fitXmlTree);
    }

    public void setDefaultLabel(String newLabel) {
        this.m_nodeInfo.defaultLabelText = newLabel;
    }

    public String getDefaultLabel() {
        return this.m_nodeInfo.defaultLabelText;
    }

    public void showPropertiesDialog(boolean modality) {
        String modelTypeFromModel;
        XTProps props = this.getXTProps();
        String modelType = props.getValue("modelOutputType");
        if (modelType.length() == 0 && (modelTypeFromModel = this.getModelOutputType()) != null && modelTypeFromModel.length() > 0) {
            modelType = modelTypeFromModel;
        }
        int type = 0;
        if (modelType.equals("regression")) {
            type = 0;
        } else if (modelType.equals("classification")) {
            type = 1;
        } else if (modelType.equals("cluster")) {
            type = 2;
        } else if (modelType.equals("dimensionReduction")) {
            type = 3;
        } else if (modelType.equals("survival")) {
            type = 4;
        } else {
            JComboBox<String> modelSelCB = new JComboBox<String>(PredictionPanel.modelTypes);
            JPanel modelTypePanel = new JPanel(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.fill = 2;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 1.0;
            modelTypePanel.add((Component)new JLabel(MinerApp.getText("PredictionDialog_modelSelect")), gbc);
            ++gbc.gridx;
            gbc.weightx = 1.0;
            modelTypePanel.add(modelSelCB, gbc);
            int act = AcceleratorOptionPane.showOKCancelDialog(MinerApp.getMainFrame(), modelTypePanel, MinerApp.getText("PredictionDialog_unknownModel"), 1);
            if (act == 2) {
                return;
            }
            type = modelSelCB.getSelectedIndex();
            switch (type) {
                case 0: {
                    props.set("modelOutputType", "regression");
                    break;
                }
                case 1: {
                    props.set("modelOutputType", "classification");
                    break;
                }
                case 2: {
                    props.set("modelOutputType", "cluster");
                    break;
                }
                case 3: {
                    props.set("modelOutputType", "dimensionReduction");
                    break;
                }
                case 4: {
                    props.set("modelOutputType", "survival");
                }
            }
        }
        PredictionDialog dialog = PredictionDialog.getInstance();
        dialog.setModal(modality);
        dialog.show(this, type);
    }

    private static final XTNetwork.NodeInfo buildDefaultInfo() {
        XTNetwork.NodeInfo info = new XTNetwork.NodeInfo();
        info.guiClass = "com.insightful.miner.PredictNodeModel";
        info.engineClass = "com.insightful.miner.PredictEngineNode";
        info.numInputs = 1;
        info.numOutputs = 1;
        info.labelText = DEFAULT_LABEL;
        info.smallIcon = "predict_small.gif";
        info.largeIcon = "predict_large.gif";
        return info;
    }

    private static final Element buildDefaultElement() {
        Element activityNode = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            Document doc = factory.newDocumentBuilder().newDocument();
            activityNode = doc.createElement(XTNetwork.ACTIVITY_NODE_NODE_TAG);
            activityNode.setAttribute(XTNetwork.GUI_CLASS_ATTRIBUTE_TAG, "com.insightful.miner.PredictNodeModel");
            activityNode.setAttribute(XTNetwork.ENGINE_CLASS_ATTRIBUTE_TAG, "com.insightful.miner.PredictEngineNode");
            activityNode.setAttribute(XTNetwork.NUM_INPUTS_ATTRIBUTE_TAG, "1");
            activityNode.setAttribute(XTNetwork.NUM_OUTPUTS_ATTRIBUTE_TAG, "1");
            Element displayInfo = doc.createElement(XTNetwork.DISPLAY_INFO_NODE_TAG);
            activityNode.appendChild(displayInfo);
            displayInfo.setAttribute(XTNetwork.LABEL_TEXT_ATTRIBUTE_TAG, DEFAULT_LABEL);
            displayInfo.setAttribute(XTNetwork.SMALL_ICON_ATTRIBUTE_TAG, "predict_small.gif");
            displayInfo.setAttribute(XTNetwork.LARGE_ICON_ATTRIBUTE_TAG, "predict_large.gif");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return activityNode;
    }

    public XMLTree getModelProperties() {
        return PredictNodeModel.getModelProperties(this);
    }

    protected static XMLTree getModelProperties(ActivityNodeModel thisModel) {
        XMLTree tree = null;
        try {
            if (thisModel.m_nodeInfo.model != null) {
                tree = thisModel.m_nodeInfo.model.getXMLTree();
            } else if (thisModel.m_nodeInfo.modelParent != null) {
                ActivityNodeModel model;
                BaseNodeArea area = thisModel.getDocument().findFlatNodeByID(Integer.parseInt(thisModel.m_nodeInfo.modelParent));
                ActivityNodeModel activityNodeModel = model = area != null ? ((ActivityNodeArea)area).getNodeModel() : null;
                if (model != null && model instanceof PMMLExportable) {
                    tree = ((PMMLExportable)((Object)model)).getFittedModel();
                }
            }
        }
        catch (Exception e) {
            return null;
        }
        return tree;
    }

    public void showView(Frame frame) {
        try {
            XMLTree modTree = this.getFittedModel();
            String modelOutputType = PredictNodeModel.getModelOutputType(modTree);
            String modelAlgorithm = PredictNodeModel.getModelAlgorithm(modTree);
            XMLTree xt = null;
            boolean isClassification = modelOutputType.equals("classification");
            boolean isRegression = modelOutputType.equals("regression");
            boolean isCluster = modelOutputType.equals("cluster");
            boolean isTree = modelAlgorithm.equals("tree");
            boolean isNaiveBayes = modelAlgorithm.equals("naiveBayes");
            boolean isGLM = modelAlgorithm.equals("glm");
            boolean isNeuralNet = modelAlgorithm.equals("NNet");
            boolean isSurvival = modelOutputType.equals("survival");
            boolean isPrinComp = modelAlgorithm.equals("principleComponent");
            xt = isNaiveBayes ? new XTProps(modTree.getXML()) : new XMLTree(modTree);
            if (xt != null && (isClassification || isRegression) && isTree) {
                MinerClassificationTreeGUI gui = new MinerClassificationTreeGUI(new TreeCollection(xt, this.getInputMetaData(0), this.getID(), this.getDocument().getWorksheetID()), this.getLabelText());
                gui.show();
            } else if (xt != null && isClassification && isNaiveBayes) {
                String htmlString = NaiveBayesNodeModel.getView(new XTProps(xt), this.getInputMetaData(0), this.getLabelText());
                new HtmlFrame(htmlString);
            } else if (xt != null && (isClassification || isRegression) && isGLM) {
                String htmlString = xt.getHtmlString(XMLTree.GENERAL_REGRESSION_XSL_FILE, this.getLabelText());
                new HtmlFrame(htmlString);
            } else if (xt != null && isCluster) {
                String htmlString = xt.getHtmlString(XMLTree.CLUSTER_XSL_FILE, this.getLabelText());
                new HtmlFrame(htmlString);
            } else if (xt != null && isNeuralNet) {
                String htmlString = xt.getHtmlString(XMLTree.NEURAL_NETWORK_XSL_FILE, this.getLabelText());
                ClassificationNeuralNetworkNodeModel.showNeuralNetViewer(htmlString, this, isRegression);
            } else if (xt != null && isPrinComp) {
                String htmlString = xt.getHtmlString(XMLTree.PRINCIPLE_COMPONENTS_XSL_FILE, this.getLabelText());
                new HtmlFrame(htmlString);
            } else if (xt != null && isSurvival) {
                Element ele = xt.getXML();
                NodeList list = ele.getElementsByTagName("BaslineSurvival");
                if (list.getLength() > 0) {
                    SurvivalViewer gui = new SurvivalViewer(xt, this.getDocument().getWorksheetID(), this.getID(), this.getLabelText());
                    gui.show();
                } else {
                    String htmlString = xt.getHtmlString(XMLTree.SURVIVAL_XSL_FILE, this.getLabelText());
                    new HtmlFrame(htmlString);
                }
            } else {
                super.showView(frame);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public XMLTree getFittedModel() {
        return PredictNodeModel.getFittedModel(this);
    }

    public String getModelOutputType() {
        return PredictNodeModel.getModelOutputType(this);
    }

    public String getModelAlgorithm() {
        return PredictNodeModel.getModelAlgorithm(this);
    }

    public String getDependentVariable() {
        return PredictNodeModel.getDependentVariable(this);
    }

    public Vector getIndependentVariables() {
        return PredictNodeModel.getIndependentVariables(this);
    }

    public Vector getDependentVariables() {
        return PredictNodeModel.getDependentVariables(this);
    }

    public static XMLTree getFittedModel(ActivityNodeModel model) {
        XTNetwork.NodeInfo ni = model.getNodeInfo();
        if (model instanceof PMMLExportable && !(model instanceof PMMLImportable)) {
            return ((PMMLExportable)((Object)model)).getFittedModel();
        }
        if (ni.model != null) {
            return ni.model.getXMLTree();
        }
        if (ni.modelParent != null) {
            WorksheetDocument doc = model.getDocument();
            if (doc == null) {
                return null;
            }
            ActivityNodeArea area = (ActivityNodeArea)doc.findFlatNodeByID(Integer.parseInt(ni.modelParent));
            if (area == null) {
                return null;
            }
            return ((PMMLExportable)((Object)area.getNodeModel())).getFittedModel();
        }
        return null;
    }

    public static String getModelOutputType(ActivityNodeModel model) {
        return PredictNodeModel.getModelOutputType(PredictNodeModel.getFittedModel(model));
    }

    public static String getModelAlgorithm(ActivityNodeModel model) {
        return PredictNodeModel.getModelAlgorithm(PredictNodeModel.getFittedModel(model));
    }

    public static XTMetaData getFittedModelMetaData(ActivityNodeModel model) {
        return PredictNodeModel.getFittedModelMetaData(PredictNodeModel.getFittedModel(model));
    }

    public static XTMetaData getFittedModelMetaData(XMLTree fittedModel) {
        XTMetaData md = null;
        if (fittedModel == null) {
            return null;
        }
        try {
            Element element = (Element)fittedModel.getXML().getElementsByTagName(XTMetaData.META_DATA_NODE_TAG).item(0);
            if (element != null) {
                md = new XTMetaData(element);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return md;
    }

    public static String getDependentVariable(ActivityNodeModel model) {
        try {
            XTMetaData md = PredictNodeModel.getFittedModelMetaData(model);
            if (md == null) {
                return "";
            }
            XTProps props = model.getXTProps();
            return PredictEngineNode.getFirstDependentVar(props, md);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return "";
        }
    }

    public static Vector getDependentVariables(ActivityNodeModel model) {
        try {
            XTMetaData md = PredictNodeModel.getFittedModelMetaData(model);
            if (md == null) {
                return new Vector();
            }
            XTProps props = model.getXTProps();
            return PredictEngineNode.getDependentVars(props, md);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new Vector();
        }
    }

    public static Vector getIndependentVariables(ActivityNodeModel model) {
        try {
            XTMetaData md = PredictNodeModel.getFittedModelMetaData(model);
            if (md == null) {
                return new Vector();
            }
            XTProps props = model.getXTProps();
            return PredictEngineNode.getIndependentVars(props, md);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return new Vector();
        }
    }

    protected static String getModelAlgorithm(XMLTree fittedModel) {
        Element modelElement = PredictNodeModel.getModelElement(fittedModel);
        if (modelElement != null) {
            String modelName = modelElement.getNodeName();
            if (modelName.equals("NeuralNetwork")) {
                return "NNet";
            }
            if (modelName.equals("TreeList")) {
                return "tree";
            }
            if (modelName.equals("GeneralRegressionModel")) {
                return "glm";
            }
            if (modelName.equals("NaiveBayesModel")) {
                return "naiveBayes";
            }
            if (modelName.equals("ClusteringModel")) {
                return "cluster";
            }
            if (modelName.equals("PrincipalComponentsModel")) {
                return "principleComponent";
            }
            if (modelName.equals("SurvivalModel")) {
                return "coxRegression";
            }
        }
        return "";
    }

    protected static Element getModelElement(XMLTree fittedModel) {
        if (fittedModel == null || !fittedModel.getXML().getNodeName().equals("IMML")) {
            return null;
        }
        Element modelElement = (Element)fittedModel.getXML().getFirstChild();
        if (modelElement.getNodeName().equals("Header")) {
            modelElement = (Element)modelElement.getNextSibling();
        }
        if (modelElement.getNodeName().equals(XTMetaData.META_DATA_NODE_TAG)) {
            modelElement = (Element)modelElement.getNextSibling();
        }
        return modelElement;
    }

    protected static String getModelOutputType(XMLTree fittedModel) {
        Element modelElement = PredictNodeModel.getModelElement(fittedModel);
        if (modelElement != null) {
            String modelType = modelElement.getAttribute("modelType");
            String nodeName = modelElement.getNodeName();
            if (nodeName.equals("NaiveBayesModel")) {
                return "classification";
            }
            if (nodeName.equals("ClusteringModel")) {
                return "cluster";
            }
            if (nodeName.equals("PrincipalComponentsModel")) {
                return "dimensionReduction";
            }
            if (nodeName.equals("SurvivalModel")) {
                return "survival";
            }
            if (nodeName.equals("GeneralRegressionModel")) {
                if (modelType.equals(LogisticRegressionEngineNode.MODEL_TYPE_MULINOMIALLOGISTIC)) {
                    return "classification";
                }
                return "regression";
            }
            return modelType;
        }
        return "";
    }

    protected static boolean isGLM(XMLTree fittedModel) {
        String nodeName;
        Element modelElement = PredictNodeModel.getModelElement(fittedModel);
        return modelElement != null && (nodeName = modelElement.getNodeName()).equals("GeneralRegressionModel");
    }
}

