/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.HtmlFrame;
import com.insightful.miner.NaiveBayesNodeModel;
import com.insightful.miner.PredictNodeModel;
import com.insightful.miner.PredictableNodeModel;
import com.insightful.miner.ReadPMMLFileDialog;
import com.insightful.miner.WriteHTMLFileEngineNode;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.Frame;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Vector;
import org.w3c.dom.Element;

public class ReadPMMLFileNodeModel
extends PredictableNodeModel {
    public void showPropertiesDialog(boolean modality) {
        ReadPMMLFileDialog dlg = ReadPMMLFileDialog.getReadPMMLFileDialog();
        dlg.setModal(modality);
        dlg.show(this);
    }

    public boolean isPropertiesValid() {
        return this.getXTProps().getValue("filePath").length() > 0;
    }

    public void showView(Frame frame) {
        ReadPMMLFileNodeModel.showHTMLViewer(this, this.getFittedModel());
    }

    public static String transformModel(String title, XMLTree model, String type, String xslFile) {
        ByteArrayOutputStream outs = new ByteArrayOutputStream();
        ReadPMMLFileNodeModel.transformModel(outs, title, model, type, xslFile);
        return ((Object)outs).toString();
    }

    public static void transformModel(OutputStream outs, String title, XMLTree model, String type, String xslFile) {
        int iType = -1;
        boolean rtf = false;
        if (type.equals(WriteHTMLFileEngineNode.m_typeDescriptionList[1])) {
            iType = 1;
        } else if (type.equals(WriteHTMLFileEngineNode.m_typeDescriptionList[2])) {
            iType = 6;
        } else if (type.equals(WriteHTMLFileEngineNode.m_typeDescriptionList[3])) {
            rtf = true;
        } else {
            try {
                String str = ReadPMMLFileNodeModel.getModelHTML(title, model);
                outs.write(str.getBytes());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return;
        }
        String modelType = PredictNodeModel.getModelAlgorithm(model);
        String xslFilename = "";
        if (xslFile != null && xslFile.length() > 0) {
            xslFilename = xslFile;
        } else if (modelType.equals("NNet")) {
            xslFilename = XMLTree.NEURAL_NETWORK_XSL_FO_FILE;
        } else if (modelType.equals("tree")) {
            xslFilename = XMLTree.TREE_XSL_FO_FILE;
        } else if (modelType.equals("glm")) {
            xslFilename = XMLTree.GENERAL_REGRESSION_XSL_FO_FILE;
        } else if (modelType.equals("cluster")) {
            xslFilename = XMLTree.CLUSTER_XSL_FO_FILE;
        } else if (modelType.equals("coxRegression")) {
            xslFilename = XMLTree.SURVIVAL_XSL_FO_FILE;
        } else if (modelType.equals("principleComponent")) {
            xslFilename = XMLTree.PRINCIPLE_COMPONENTS_XSL_FO_FILE;
        } else if (modelType.equals("naiveBayes")) {
            xslFilename = XMLTree.NAIVE_BAYES_XSL_FO_FILE;
        }
        try {
            if (rtf) {
                model.transformWithJFOR(outs, title, xslFilename);
            } else {
                model.transformWithFOP(outs, title, iType, xslFilename);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getModelHTML(String title, XMLTree model) {
        String modelType = PredictNodeModel.getModelAlgorithm(model);
        String xslTransform = "";
        if (modelType.equals("NNet")) {
            xslTransform = model.getHtmlString(XMLTree.NEURAL_NETWORK_XSL_FILE, title);
        } else if (modelType.equals("tree")) {
            xslTransform = model.getHtmlString(XMLTree.TREE_XSL_FILE, title);
        } else if (modelType.equals("glm")) {
            xslTransform = model.getHtmlString(XMLTree.GENERAL_REGRESSION_XSL_FILE, title);
        } else if (modelType.equals("cluster")) {
            xslTransform = model.getHtmlString(XMLTree.CLUSTER_XSL_FILE, title);
        } else if (modelType.equals("coxRegression")) {
            xslTransform = model.getHtmlString(XMLTree.SURVIVAL_XSL_FILE, title);
        } else if (modelType.equals("principleComponent")) {
            xslTransform = model.getHtmlString(XMLTree.PRINCIPLE_COMPONENTS_XSL_FILE, title);
        } else if (modelType.equals("naiveBayes")) {
            try {
                Element mdelm = (Element)model.getXML().getElementsByTagName(XTMetaData.META_DATA_NODE_TAG).item(0);
                Element propselm = (Element)model.getXML().getElementsByTagName("NaiveBayesModel").item(0);
                XTProps props = new XTProps((Element)propselm.getFirstChild());
                XTMetaData md = new XTMetaData(mdelm);
                xslTransform = NaiveBayesNodeModel.getView(props, md, title);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return xslTransform;
    }

    public static void showHTMLViewer(ActivityNodeModel thisModel, XMLTree model) {
        String title = thisModel.getLabelText() + ": Model";
        String xslTransform = ReadPMMLFileNodeModel.getModelHTML(title, model);
        if (xslTransform.length() > 0) {
            new HtmlFrame(xslTransform);
        }
    }

    public XMLTree getFittedModel() {
        return super.getFittedModel();
    }

    public String getModelOutputType() {
        return PredictNodeModel.getModelOutputType(this);
    }

    public String getModelAlgorithm() {
        return PredictNodeModel.getModelAlgorithm(this);
    }

    public String getDependentVariable() {
        return PredictNodeModel.getDependentVariable(this);
    }

    public Vector getIndependentVariables() {
        return PredictNodeModel.getIndependentVariables(this);
    }

    public Vector getDependentVariables() {
        return PredictNodeModel.getDependentVariables(this);
    }
}

