/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.MinerApp;
import com.insightful.miner.ReadOtherFileDialog;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ReadSASFileDialog
extends ReadOtherFileDialog {
    private static String[] m_typeCodeList = new String[]{"SAS7", "SASV6", "SAS1", "SAS4", "SAS_TPT"};
    private static String[] m_typeDescriptionList = new String[]{"SAS Version 7/8/9 (*.sas7bdat)", "SAS - Windows/OS2 (*.sd2)", "SAS - HP IBM & SUN Unix (*.ssd01)", "SAS - Dec Unix (*.ssd04)", "SAS Transport File (*.tpt;*.xpt)"};
    private static String[][] m_extensionList = new String[][]{{".sas7bdat"}, {".sd2"}, {".ssd01"}, {".ssd04"}, {".tpt", ".xpt"}};
    private static ReadSASFileDialog m_ReadSASFileDialog = null;

    public static ReadSASFileDialog getReadSASFileDialog() {
        if (m_ReadSASFileDialog == null) {
            m_ReadSASFileDialog = new ReadSASFileDialog();
        }
        return m_ReadSASFileDialog;
    }

    protected ReadSASFileDialog() {
        Dimension min = new Dimension(525, 525);
        this.setMinimumSize(min);
        this.setSize(min);
    }

    protected void restoreSpecialFileProperties(XTProps props) {
        String type = props.getValue("fileType", "SAS7");
        ReadSASFileDialog.setComboBoxFromTypeString(type, m_typeCodeList, this.m_typeComboBox);
        String currentPath = props.getValue("filePath", "");
        this.m_fileNameTextField.setText(currentPath);
    }

    protected void saveSpecialFileProperties(XTProps props) {
        String filename = this.m_fileNameTextField.getText();
        props.set("filePath", filename);
        props.set("fileType", m_typeCodeList[this.m_typeComboBox.getSelectedIndex()]);
    }

    public JPanel createOptionsPanel() {
        JPanel optionsPanel = new JPanel(new BorderLayout());
        optionsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel saveFilePanel = new JPanel(new GridBagLayout());
        this.m_fileNameTextField = new JTextField(25);
        this.m_fileNameTextField.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.checkReadFileName(ReadSASFileDialog.this.m_fileNameTextField, m_extensionList, ReadSASFileDialog.this.m_typeComboBox);
            }
        });
        this.m_fileNameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!e.isTemporary()) {
                    ReadOtherFileDialog.checkReadFileName(ReadSASFileDialog.this.m_fileNameTextField, m_extensionList, ReadSASFileDialog.this.m_typeComboBox);
                }
            }
        });
        JLabel fileNameLabel = new JLabel(MinerApp.getText("ReadTextFileDialog_filename"));
        fileNameLabel.setDisplayedMnemonic(70);
        JButton browseButton = new JButton(new AbstractAction(MinerApp.getText("ReadTextFileDialog_browse")){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.browseReadFileName(m_ReadSASFileDialog, ReadSASFileDialog.this.m_fileNameTextField, m_extensionList, m_typeDescriptionList, ReadSASFileDialog.this.m_typeComboBox);
            }
        });
        browseButton.setMnemonic(66);
        fileNameLabel.setLabelFor(browseButton);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridwidth = 2;
        constraints.weightx = 0.0;
        saveFilePanel.add((Component)fileNameLabel, constraints);
        constraints.gridwidth = 6;
        constraints.gridx = 2;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        saveFilePanel.add((Component)this.m_fileNameTextField, constraints);
        constraints.gridx = 8;
        constraints.weightx = 0.0;
        constraints.gridwidth = 2;
        constraints.fill = 0;
        saveFilePanel.add((Component)browseButton, constraints);
        JPanel moreOptionsPanel = new JPanel(new GridBagLayout());
        moreOptionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("ReadTextFileDialog_options")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JLabel typeLabel = new JLabel(MinerApp.getText("ReadOtherFileDialog_type"));
        typeLabel.setDisplayedMnemonic(89);
        this.m_typeComboBox = new JComboBox<String>(m_typeDescriptionList);
        this.m_typeComboBox.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.checkFileNameOnComboBoxAction(ReadSASFileDialog.this.m_fileNameTextField, m_extensionList, ReadSASFileDialog.this.m_typeComboBox);
            }
        });
        typeLabel.setLabelFor(this.m_typeComboBox);
        JLabel defaultStringTypeLabel = new JLabel(MinerApp.getText("ReadTextFileDialog_columnType"));
        defaultStringTypeLabel.setDisplayedMnemonic('t');
        this.m_defaultStringColumnTypeComboBox = new JComboBox<Object>(new Object[]{XTMetaData.STRING_TYPE_ATTRIBUTE_TAG, XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG});
        defaultStringTypeLabel.setLabelFor(this.m_defaultStringColumnTypeComboBox);
        Insets noIndent = new Insets(0, 0, 0, 8);
        Insets indent = new Insets(0, 5, 0, 8);
        int gridy = 1;
        GridBagConstraints optionsConstraints = new GridBagConstraints();
        optionsConstraints.anchor = 18;
        optionsConstraints.fill = 0;
        moreOptionsPanel.add((Component)typeLabel, optionsConstraints);
        optionsConstraints.gridx = 1;
        optionsConstraints.weightx = 1.0;
        optionsConstraints.insets = indent;
        optionsConstraints.fill = 2;
        moreOptionsPanel.add((Component)this.m_typeComboBox, optionsConstraints);
        optionsConstraints.gridx = 0;
        optionsConstraints.gridy = gridy++;
        optionsConstraints.weightx = 0.0;
        optionsConstraints.insets = noIndent;
        optionsConstraints.fill = 0;
        moreOptionsPanel.add((Component)defaultStringTypeLabel, optionsConstraints);
        optionsConstraints.gridx = 1;
        optionsConstraints.weightx = 1.0;
        optionsConstraints.weighty = 1.0;
        optionsConstraints.insets = indent;
        optionsConstraints.fill = 2;
        moreOptionsPanel.add((Component)this.m_defaultStringColumnTypeComboBox, optionsConstraints);
        JPanel topPanel = new JPanel(new BorderLayout());
        topPanel.add((Component)saveFilePanel, "North");
        topPanel.add((Component)moreOptionsPanel, "Center");
        topPanel.add((Component)this.createSamplePanel(true), "South");
        optionsPanel.add((Component)topPanel, "North");
        optionsPanel.add((Component)this.createPreviewPanel(), "Center");
        return optionsPanel;
    }
}

