/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SetRolesPanelBase
extends JPanel {
    protected NodeDialog.DNDList availableList;
    protected NodeDialog.DNDList independentList;
    protected NodeDialog.SortingScrollPane availableScrollPane;
    protected NodeDialog.SortingScrollPane independentScrollPane;
    protected NodeDialog.DNDListModel availableListModel;
    protected NodeDialog.DNDListModel independentListModel;
    protected JButton interactionsButton;
    protected JButton autoFillButton;
    protected boolean allowInteractions = true;
    protected Vector excludedColumnTypes;
    protected Vector availableSel;
    protected static final String interactionsString = "SetRolesPanel_interactions";
    protected static final String actionNotSuccesfulString = "SetRolesPanel_actionNotSuccesful";
    protected static final String variablesNotSelectedString = "SetRolesPanel_variablesNotSelected";
    protected static final String dependentVariableErrorString = "SetRolesPanel_dependentVariableError";
    protected static final String variablesString = "SetRolesPanel_variables";
    protected static final String availableString = "SetRolesPanel_available";
    protected static final String independentString = "SetRolesPanel_independent";
    protected static final String displayDefaultsString = "SetRolesPanel_displayDefaults";
    protected static final String setRolesString = "SetRolesPanel_setRoles";
    protected static final String addIndependentString = ">>";
    protected static final String removeIndependentString = "<<";
    protected static final String interactionsHotkeyString = "SetRolesPanel_interactionsHotkey";
    public static final String PROPERTIES_SET_ATTRIBUTE_TAG = "propertiesSet";
    public static final String COLUMN_ROLES_ATTRIBUTE_TAG = "columnRoles";
    public static final String INTERACTIONS_ATTRIBUTE_TAG = "interactions";
    public static final String SUMMARY_COLUMNS_ATTRIBUTE_TAG = "summaryColumns";
    public static final String SUMMARY_METHOD_ATTRIBUTE_TAG = "summaryMethod";
    public static final String MODEL_SPECIALS_ATTRIBUTE_TAG = "modelSpecials";
    public static final String EXCLUDE_ATTRIBUTE_TAG = "exclude";
    protected AbstractAction addIndependentAction;
    protected AbstractAction removeIndependentAction;
    protected AbstractAction interactionsAction;
    protected AbstractAction autoFillAction = null;

    public SetRolesPanelBase(boolean allowInteractions) {
        this.allowInteractions = allowInteractions;
        this.excludedColumnTypes = new Vector();
        this.setExcludedColumnType(XTMetaData.BLOB_TYPE_ATTRIBUTE_TAG);
        this.createActions();
    }

    public void setExcludedColumnType(String type) {
        this.excludedColumnTypes.add(type);
    }

    public void restoreProperties(ActivityNodeModel model) {
        this.independentListModel.removeAllElements();
        this.availableListModel.removeAllElements();
        XTProps props = model.getXTProps();
        XTMetaData metaData = null;
        try {
            metaData = model.getInputMetaData(0);
        }
        catch (Exception e) {
            AcceleratorOptionPane.showOKDialog(this, MinerApp.getText("NodeDialog_cannotRestoreProperties"), MinerApp.getText("NodeDialog_propertiesNotRestored"), 0);
            e.printStackTrace();
            return;
        }
        Vector names = metaData.getColumnNames();
        Vector types = metaData.getColumnTypes();
        Vector roles = metaData.getColumnRoles();
        Vector propNames = props.getSubProperties(COLUMN_ROLES_ATTRIBUTE_TAG);
        Vector propRoles = props.getSubPropertyValues(COLUMN_ROLES_ATTRIBUTE_TAG);
        int size = names.size();
        Vector<Integer> indepIndex = new Vector<Integer>();
        Vector<NodeDialog.ModelTerm> indepObj = new Vector<NodeDialog.ModelTerm>();
        boolean enabledAutoButton = false;
        for (int i = 0; i < size; ++i) {
            String name = (String)names.get(i);
            String role = (String)roles.get(i);
            String type = (String)types.get(i);
            if (this.excludedColumnTypes.contains(type)) continue;
            enabledAutoButton |= role.length() != 0 && !role.equals(XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG);
            NodeDialog.ModelTerm info = new NodeDialog.ModelTerm(name, type, role, i);
            int index = propNames.indexOf(name);
            if (index != -1) {
                String propRole = (String)propRoles.get(index);
                if (propRole.equals(XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG)) {
                    indepIndex.addElement(new Integer(index));
                    indepObj.addElement(info);
                    continue;
                }
                this.availableListModel.addElement(info);
                continue;
            }
            this.availableListModel.addElement(info);
        }
        while (indepIndex.size() > 0) {
            int minInd = propNames.size();
            int imin = -1;
            for (int i = 0; i < indepIndex.size(); ++i) {
                int j = (Integer)indepIndex.get(i);
                if (j >= minInd) continue;
                imin = i;
                minInd = j;
            }
            if (imin < 0) {
                indepIndex.clear();
                while (indepObj.size() > 0) {
                    this.independentListModel.addElement(indepObj.remove(0));
                }
                continue;
            }
            this.independentListModel.addElement(indepObj.remove(imin));
            indepIndex.remove(imin);
        }
        Vector terms = props.getSubProperties(INTERACTIONS_ATTRIBUTE_TAG);
        int nterms = terms.size();
        if (nterms > 0) {
            int i;
            String[] path = new String[]{INTERACTIONS_ATTRIBUTE_TAG, (String)terms.get(0)};
            Vector vars = props.getSubProperties(path);
            if (vars.size() == 0) {
                vars = props.getSubPropertyValues(INTERACTIONS_ATTRIBUTE_TAG);
                int[] ord = new int[]{1, 1};
                for (i = 0; i < nterms; ++i) {
                    NodeDialog.ColumnInformationObject[] objs = new NodeDialog.ColumnInformationObject[]{null, null};
                    String var1 = (String)terms.get(i);
                    String var2 = (String)vars.get(i);
                    for (int k = 0; k < this.independentListModel.size() && objs[0] == null && objs[1] == null; ++k) {
                        NodeDialog.ColumnInformationObject obj = (NodeDialog.ColumnInformationObject)this.independentListModel.get(k);
                        if (var1.equals(obj.getText())) {
                            objs[0] = obj;
                            continue;
                        }
                        if (!var2.equals(obj.getText())) continue;
                        objs[1] = obj;
                    }
                    if (objs[0] != null && objs[1] != null) {
                        this.independentListModel.addElement(new NodeDialog.ModelTerm(objs, ord));
                        continue;
                    }
                    break;
                }
            } else {
                Vector order = null;
                for (i = 0; i < nterms; ++i) {
                    int j;
                    path[1] = (String)terms.get(i);
                    vars = props.getSubProperties(path);
                    order = props.getSubPropertyValues(path);
                    int nv = vars.size();
                    if (nv == 0) continue;
                    NodeDialog.ColumnInformationObject[] objs = new NodeDialog.ColumnInformationObject[nv];
                    int[] ord = new int[nv];
                    for (j = 0; j < nv; ++j) {
                        int k;
                        ord[j] = Integer.parseInt((String)order.get(j));
                        String vari = (String)vars.get(j);
                        for (k = 0; k < this.independentListModel.size(); ++k) {
                            NodeDialog.ColumnInformationObject obj = (NodeDialog.ColumnInformationObject)this.independentListModel.get(k);
                            if (!vari.equals(obj.getText())) continue;
                            objs[j] = obj;
                            break;
                        }
                        if (k >= this.independentListModel.size() || ord[j] < 1) break;
                    }
                    if (j < nv) continue;
                    this.independentListModel.addElement(new NodeDialog.ModelTerm(objs, ord));
                }
            }
            Vector excludeVars = SetRolesPanelBase.getVarsWithSpecials(props, EXCLUDE_ATTRIBUTE_TAG);
            block11: for (int i2 = 0; i2 < excludeVars.size(); ++i2) {
                NodeDialog.ColumnInformationObject object;
                String exVar = (String)excludeVars.get(i2);
                for (int j = 0; j < this.independentListModel.size() && !(object = (NodeDialog.ColumnInformationObject)this.independentListModel.getElementAt(j)).isInteraction(); ++j) {
                    if (exVar.compareTo(object.getText()) != 0) continue;
                    this.independentListModel.removeElementAt(j);
                    this.availableListModel.addElement(object);
                    continue block11;
                }
            }
            this.availableScrollPane.sort();
        }
        if (this.independentListModel.getSize() > 1 && this.allowInteractions) {
            this.interactionsButton.setEnabled(true);
        }
        this.autoFillButton.setEnabled(enabledAutoButton);
    }

    public void saveProperties(ActivityNodeModel model) {
        XTProps props = model.getXTProps();
        props.set(PROPERTIES_SET_ATTRIBUTE_TAG, true);
        props.removeProperty(new String[]{COLUMN_ROLES_ATTRIBUTE_TAG});
        props.removeProperty(new String[]{INTERACTIONS_ATTRIBUTE_TAG});
        NodeDialog.ColumnInformationObject object = null;
        NodeDialog.ColumnInformationObject object1 = null;
        Enumeration availables = this.availableListModel.elements();
        while (availables.hasMoreElements()) {
            object = (NodeDialog.ColumnInformationObject)availables.nextElement();
            props.set(COLUMN_ROLES_ATTRIBUTE_TAG, object.getText(), "");
        }
        availables = null;
        Enumeration independents = this.independentListModel.elements();
        while (independents.hasMoreElements()) {
            object = (NodeDialog.ColumnInformationObject)independents.nextElement();
            if (object.isInteraction()) {
                NodeDialog.ColumnInformationObject[] vars = ((NodeDialog.ModelTerm)object).getTermVariables();
                int[] order = ((NodeDialog.ModelTerm)object).getTermVariablesOrder();
                String[] path = new String[3];
                path[0] = INTERACTIONS_ATTRIBUTE_TAG;
                path[1] = object.getText();
                int n = this.independentListModel.size();
                for (int i = 0; i < vars.length; ++i) {
                    int j;
                    String vari = vars[i].getText();
                    for (j = 0; j < n && ((object1 = (NodeDialog.ColumnInformationObject)this.independentListModel.getElementAt(j)).isInteraction() || vari.compareTo(object1.getText()) != 0); ++j) {
                    }
                    if (j >= n) {
                        props.set(COLUMN_ROLES_ATTRIBUTE_TAG, vari, XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG);
                        props.set(MODEL_SPECIALS_ATTRIBUTE_TAG, vari, EXCLUDE_ATTRIBUTE_TAG);
                    } else {
                        props.set(MODEL_SPECIALS_ATTRIBUTE_TAG, vari, "");
                    }
                    path[2] = vari;
                    props.set(path, Integer.toString(order[i]));
                }
                continue;
            }
            props.set(COLUMN_ROLES_ATTRIBUTE_TAG, object.getText(), XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG);
        }
        independents = null;
    }

    public void createActions() {
        this.addIndependentAction = new AbstractAction(addIndependentString){

            public void actionPerformed(ActionEvent e) {
                int i1;
                if (SetRolesPanelBase.this.availableList.isSelectionEmpty()) {
                    return;
                }
                SetRolesPanelBase.this.availableListModel.removeListDataListeners();
                SetRolesPanelBase.this.independentListModel.removeListDataListeners();
                for (i1 = SetRolesPanelBase.this.independentListModel.size() - 1; i1 >= 0; --i1) {
                    NodeDialog.ColumnInformationObject object = (NodeDialog.ColumnInformationObject)SetRolesPanelBase.this.independentListModel.getElementAt(i1);
                    if (object.isInteraction()) continue;
                    ++i1;
                    break;
                }
                Object[] vals = SetRolesPanelBase.this.availableList.getSelectedValues();
                for (int i = 0; i < vals.length; ++i) {
                    if (i1 < 0) {
                        SetRolesPanelBase.this.independentListModel.addElement(vals[i]);
                        continue;
                    }
                    SetRolesPanelBase.this.independentListModel.add(i1++, vals[i]);
                }
                vals = null;
                int[] ind = SetRolesPanelBase.this.availableList.getSelectedIndices();
                SetRolesPanelBase.this.availableList.getSelectionModel().clearSelection();
                for (int i = ind.length - 1; i >= 0; --i) {
                    SetRolesPanelBase.this.availableListModel.removeElementAt(ind[i]);
                }
                ind = null;
                SetRolesPanelBase.this.availableListModel.undoRemoveListDataListeners();
                SetRolesPanelBase.this.independentListModel.undoRemoveListDataListeners();
                if (SetRolesPanelBase.this.independentListModel.getSize() > 1 && SetRolesPanelBase.this.allowInteractions) {
                    SetRolesPanelBase.this.interactionsButton.setEnabled(true);
                }
                SetRolesPanelBase.this.repaint();
                SetRolesPanelBase.this.availableListModel.listContentsChanged();
                SetRolesPanelBase.this.independentListModel.listContentsChanged();
            }
        };
        this.removeIndependentAction = new AbstractAction(removeIndependentString){

            public void actionPerformed(ActionEvent e) {
                int i;
                if (SetRolesPanelBase.this.independentList.isSelectionEmpty()) {
                    return;
                }
                Object[] values = SetRolesPanelBase.this.independentList.getSelectedValues();
                int[] indices = SetRolesPanelBase.this.independentList.getSelectedIndices();
                SetRolesPanelBase.this.independentList.getSelectionModel().clearSelection();
                SetRolesPanelBase.this.independentListModel.removeListDataListeners();
                SetRolesPanelBase.this.availableListModel.removeListDataListeners();
                boolean ctrlKeyDown = (e.getModifiers() & 2) == 2;
                for (i = 0; i < values.length; ++i) {
                    SetRolesPanelBase.this.independentListModel.removeElementAt(indices[i] - i);
                    if (((NodeDialog.ColumnInformationObject)values[i]).isInteraction()) continue;
                    SetRolesPanelBase.this.availableListModel.addElement(values[i]);
                }
                for (i = 0; i < values.length; ++i) {
                    NodeDialog.ModelTerm obj = (NodeDialog.ModelTerm)values[i];
                    if (ctrlKeyDown) continue;
                    for (int j = SetRolesPanelBase.this.independentListModel.size() - 1; j >= 0; --j) {
                        NodeDialog.ModelTerm objI = (NodeDialog.ModelTerm)SetRolesPanelBase.this.independentListModel.getElementAt(j);
                        if (!objI.contains(obj)) continue;
                        SetRolesPanelBase.this.independentListModel.removeElementAt(j);
                    }
                }
                SetRolesPanelBase.this.independentListModel.undoRemoveListDataListeners();
                SetRolesPanelBase.this.availableListModel.undoRemoveListDataListeners();
                SetRolesPanelBase.this.availableScrollPane.sort();
                if (SetRolesPanelBase.this.independentListModel.getSize() < 1 && SetRolesPanelBase.this.allowInteractions) {
                    SetRolesPanelBase.this.interactionsButton.setEnabled(false);
                }
                SetRolesPanelBase.this.repaint();
                SetRolesPanelBase.this.independentListModel.listContentsChanged();
                SetRolesPanelBase.this.availableListModel.listContentsChanged();
                indices = null;
                values = null;
            }
        };
        this.interactionsAction = new AbstractAction(MinerApp.getText(interactionsString)){

            public void actionPerformed(ActionEvent e) {
                int i;
                Object[] values = SetRolesPanelBase.this.independentList.getSelectedValues();
                if (values.length < 1) {
                    return;
                }
                boolean ctrlKeyDown = (e.getModifiers() & 2) == 2;
                Vector<NodeDialog.ColumnInformationObject> objs = new Vector<NodeDialog.ColumnInformationObject>();
                Vector<Integer> order = new Vector<Integer>();
                for (i = 0; i < values.length; ++i) {
                    NodeDialog.ModelTerm termi = (NodeDialog.ModelTerm)values[i];
                    NodeDialog.ColumnInformationObject[] vars = termi.getTermVariables();
                    int[] ord = termi.getTermVariablesOrder();
                    for (int k = 0; k < vars.length; ++k) {
                        String objName;
                        int j;
                        for (j = 0; j < objs.size() && !(objName = ((NodeDialog.ColumnInformationObject)objs.get(j)).getText()).equals(vars[k].getText()); ++j) {
                        }
                        if (j < objs.size()) {
                            if (!vars[k].getType().equals(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG)) continue;
                            int n = (Integer)order.get(j);
                            order.setElementAt(new Integer(n + ord[k]), j);
                            continue;
                        }
                        objs.addElement(vars[k]);
                        order.addElement(new Integer(ord[k]));
                    }
                }
                if (!ctrlKeyDown && objs.size() > 31) {
                    return;
                }
                if (objs.size() == 1) {
                    if (!((NodeDialog.ColumnInformationObject)objs.get(0)).getType().equals(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG)) {
                        return;
                    }
                    int n = (Integer)order.get(0) + 1;
                    order.setElementAt(new Integer(n), 0);
                }
                NodeDialog.ColumnInformationObject[] vars = new NodeDialog.ColumnInformationObject[objs.size()];
                int[] ord = new int[objs.size()];
                for (i = 0; i < objs.size(); ++i) {
                    vars[i] = (NodeDialog.ColumnInformationObject)objs.get(i);
                    ord[i] = (Integer)order.get(i);
                }
                NodeDialog.ModelTerm term = new NodeDialog.ModelTerm(vars, ord);
                if (vars.length == 1 || ctrlKeyDown) {
                    SetRolesPanelBase.this.independentListModel.addElement(term);
                } else {
                    int np = vars.length;
                    long denom = 1L;
                    long num = vars.length;
                    long dec = vars.length;
                    long[] table = new long[vars.length];
                    for (int j = 0; j < vars.length; ++j) {
                        table[j] = 1 << j;
                    }
                    long[] ivars = table;
                    for (int ig = 2; ig <= vars.length; ++ig) {
                        int np2 = (int)((num *= --dec) / (denom *= (long)vars.length - dec + 1L));
                        long[] table2 = new long[np2];
                        NodeDialog.ColumnInformationObject[] subvars = new NodeDialog.ColumnInformationObject[ig];
                        int[] subord = new int[ig];
                        int[] ord1 = new int[ig];
                        int nterm = 0;
                        for (int j = 0; j < vars.length && nterm < np2; ++j) {
                            for (int k = 0; k < np; ++k) {
                                int l;
                                long termi = ivars[j] | table[k];
                                for (l = 0; l < nterm && (termi | table2[l]) != termi; ++l) {
                                }
                                if (l < nterm) continue;
                                int ivar = -1;
                                for (l = 0; l < vars.length; ++l) {
                                    if ((termi & ivars[l]) != ivars[l]) continue;
                                    if (++ivar >= ig) break;
                                    subvars[ivar] = vars[l];
                                    subord[ivar] = 1;
                                    ord1[ivar] = ord[l];
                                }
                                if (ivar != ig - 1) continue;
                                table2[nterm++] = termi;
                                boolean done = false;
                                while (!done) {
                                    NodeDialog.ModelTerm subterm = new NodeDialog.ModelTerm(subvars, subord);
                                    i = 0;
                                    for (i = 0; i < SetRolesPanelBase.this.independentListModel.size() && !subterm.equals((NodeDialog.ModelTerm)SetRolesPanelBase.this.independentListModel.get(i)); ++i) {
                                    }
                                    if (i >= SetRolesPanelBase.this.independentListModel.size()) {
                                        SetRolesPanelBase.this.independentListModel.addElement(subterm);
                                    }
                                    subterm = null;
                                    done = true;
                                    for (l = 0; l < ig && done; ++l) {
                                        if (subord[l] + 1 <= ord1[l]) {
                                            done = false;
                                            int n = l;
                                            subord[n] = subord[n] + 1;
                                            continue;
                                        }
                                        subord[l] = 1;
                                    }
                                }
                            }
                        }
                        table = table2;
                        np = np2;
                        subvars = null;
                        subord = null;
                        ord1 = null;
                    }
                }
            }
        };
    }

    protected void addAvailableScrollPane(Container container, NodeDialog.ColumnInformationRenderer renderer, int xoffset, int yoffset) {
        GridBagConstraints constraints = new GridBagConstraints();
        this.availableListModel = new NodeDialog.DNDListModel();
        this.availableList = new NodeDialog.DNDList(this.availableListModel);
        this.availableList.setCellRenderer(renderer);
        this.availableList.setSelectionMode(2);
        this.availableScrollPane = new NodeDialog.SortingScrollPane(this.availableList);
        this.availableScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        constraints.gridx = xoffset;
        constraints.gridy = yoffset;
        constraints.gridwidth = 5;
        constraints.weightx = 1.0;
        constraints.anchor = 11;
        constraints.fill = 0;
        if (container == this) {
            JLabel availableLabel = new JLabel(MinerApp.getText(availableString) + ":");
            availableLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            container.add((Component)availableLabel, constraints);
        }
        constraints.fill = 1;
        constraints.gridheight = 8;
        constraints.weighty = 1.0;
        constraints.gridy = ++yoffset;
        container.add((Component)this.availableScrollPane, constraints);
    }

    protected void addIndependentScrollPane(Container container, NodeDialog.ColumnInformationRenderer renderer, int xoffset, int yoffset) {
        this.addIndependentScrollPane(container, renderer, xoffset, yoffset, MinerApp.getText(independentString));
    }

    protected void addIndependentScrollPane(Container container, NodeDialog.ColumnInformationRenderer renderer, int xoffset, int yoffset, String depLabel) {
        int top = yoffset++;
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = xoffset;
        constraints.gridy = yoffset;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.gridheight = 1;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 5, 0, 5);
        container.add((Component)new JButton(this.removeIndependentAction), constraints);
        constraints.gridx = xoffset + 2;
        container.add((Component)new JButton(this.addIndependentAction), constraints);
        constraints.gridx = xoffset;
        constraints.gridy = yoffset += 3;
        constraints.gridwidth = 3;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(5, 5, 0, 5);
        constraints.fill = 2;
        constraints.anchor = 15;
        if (this.allowInteractions) {
            this.interactionsButton = new JButton(this.interactionsAction);
            this.interactionsButton.setMnemonic(MinerApp.getText(interactionsHotkeyString).charAt(0));
            this.interactionsAction.setEnabled(false);
        } else {
            this.interactionsButton = null;
        }
        if (this.autoFillAction != null) {
            this.autoFillButton = new JButton(this.autoFillAction);
            this.autoFillButton.setMnemonic('a');
            if (this.interactionsButton != null) {
                this.autoFillButton.setPreferredSize(this.interactionsButton.getPreferredSize());
            }
            container.add((Component)this.autoFillButton, constraints);
        } else {
            this.autoFillButton = null;
        }
        constraints.weighty = 0.0;
        if (this.interactionsButton != null) {
            constraints.gridy = ++yoffset;
            container.add((Component)this.interactionsButton, constraints);
        }
        yoffset = top;
        this.independentListModel = new NodeDialog.DNDListModel();
        this.independentList = new NodeDialog.DNDList(this.independentListModel);
        this.independentList.setCellRenderer(renderer);
        this.independentList.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 8 && SetRolesPanelBase.this.removeIndependentAction.isEnabled()) {
                    SetRolesPanelBase.this.removeIndependentAction.actionPerformed(new ActionEvent(SetRolesPanelBase.this, 0, "Remove"));
                }
            }
        });
        this.independentScrollPane = new NodeDialog.SortingScrollPane(this.independentList);
        this.independentScrollPane.setBorder(BorderFactory.createLoweredBevelBorder());
        constraints.gridx = xoffset += 4;
        constraints.gridy = yoffset;
        constraints.weightx = 1.0;
        constraints.gridwidth = 5;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 0, 0);
        if (container == this) {
            JLabel independentLabel = new JLabel(depLabel + ":");
            independentLabel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            constraints.fill = 0;
            container.add((Component)independentLabel, constraints);
            constraints.gridy = yoffset;
        }
        constraints.fill = 1;
        constraints.gridy = ++yoffset;
        constraints.weighty = 1.0;
        constraints.gridheight = 6;
        container.add((Component)this.independentScrollPane, constraints);
    }

    public static Vector getVarsWithSpecials(XTProps props, String specType) {
        Vector<String> v = new Vector<String>();
        Vector specVars = props.getSubProperties(MODEL_SPECIALS_ATTRIBUTE_TAG);
        String[] path = new String[2];
        path[0] = MODEL_SPECIALS_ATTRIBUTE_TAG;
        for (int i = 0; i < specVars.size(); ++i) {
            String varName;
            path[1] = varName = (String)specVars.get(i);
            String specName = props.getValue(path);
            if (specName == null || !specName.equals(specType)) continue;
            v.add(varName);
        }
        return v;
    }

    public abstract class ModelSelectionListener
    implements ListSelectionListener {
        public void valueChanged(ListSelectionEvent e) {
        }
    }
}

