/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.SortEngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class SortDialog
extends NodeDialog {
    private JTable table;
    private SortTableModel tableModel;
    private NodeDialog.SortingScrollPane scrollingList;
    private NodeDialog.DNDList list;
    private NodeDialog.DNDListModel listModel;
    private HashMap columnObjects;
    private String[] columnOrderStringArray;
    private String[] naOrderStringArray;
    private JCheckBox alphaCheckBox;
    private AbstractAction addAction;
    private AbstractAction removeAction;
    public static final DataFlavor rowFlavor = new DataFlavor(Vector.class, null);
    private static SortDialog instance = null;

    public static SortDialog getInstance() {
        if (instance == null) {
            instance = new SortDialog();
        }
        return instance;
    }

    private SortDialog() {
        this.setResizable(true);
        this.setMinimumSize(new Dimension(600, 400));
    }

    public void restoreProperties() {
        String name;
        int i;
        super.restoreProperties();
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        this.listModel.removeAllElements();
        this.tableModel.clearTable();
        XTProps props = this.getNodeModel().getXTProps();
        XTMetaData metaData = null;
        try {
            metaData = this.getNodeModel().getInputMetaData(0);
        }
        catch (Exception e) {
            AcceleratorOptionPane.showOKDialog(this, MinerApp.getText("NodeDialog_cannotRestoreProperties"), MinerApp.getText("NodeDialog_propertiesNotRestored"), 0);
            e.printStackTrace();
            return;
        }
        Vector names = metaData.getColumnNames();
        Vector types = metaData.getColumnTypes();
        Vector roles = metaData.getColumnRoles();
        Vector propNames = props.getSubProperties(SortEngineNode.COLUMN_TO_SORT_ATTRIBUTE_TAG);
        String[] searchPath = new String[]{SortEngineNode.COLUMN_TO_SORT_ATTRIBUTE_TAG, "", ""};
        this.columnObjects = new HashMap();
        boolean[] isProp = new boolean[names.size()];
        for (i = 0; i < propNames.size(); ++i) {
            name = (String)propNames.get(i);
            int loc = metaData.nameToOrdinal(name);
            if (loc == -1) continue;
            isProp[loc] = true;
            searchPath[1] = name;
            String order = null;
            searchPath[2] = SortEngineNode.ASCENDING_ATTRIBUTE_TAG;
            order = props.getBoolean(searchPath, true) ? this.columnOrderStringArray[0] : this.columnOrderStringArray[1];
            searchPath[2] = SortEngineNode.NAN_ATTRIBUTE_TAG;
            String na = null;
            na = props.getBoolean(searchPath, true) ? this.naOrderStringArray[0] : this.naOrderStringArray[1];
            this.tableModel.addRow(new Object[]{name, order, na});
        }
        for (i = 0; i < names.size(); ++i) {
            name = (String)names.get(i);
            String type = (String)types.get(i);
            String role = (String)roles.get(i);
            NodeDialog.ColumnInformationObject object = new NodeDialog.ColumnInformationObject(name, type, role, false, i);
            if (!isProp[i]) {
                this.listModel.addElement(object);
            }
            this.columnObjects.put(object.getText(), object);
        }
        this.alphaCheckBox.setSelected(props.getBoolean(SortEngineNode.ALPHABETICAL_ATTRIBUTE_TAG, true));
    }

    public void saveProperties() throws NodeDialog.DialogException {
        super.saveProperties();
        XTProps props = this.getNodeModel().getXTProps();
        String[] searchPath = new String[]{SortEngineNode.COLUMN_TO_SORT_ATTRIBUTE_TAG, "", ""};
        props.removeProperty(new String[]{SortEngineNode.COLUMN_TO_SORT_ATTRIBUTE_TAG});
        props.removeProperty(new String[]{SortEngineNode.ALPHABETICAL_ATTRIBUTE_TAG});
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        int rowCount = this.table.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            String name;
            searchPath[1] = name = (String)this.table.getValueAt(i, 0);
            String sel = (String)this.table.getValueAt(i, 1);
            boolean ascending = sel.equals(this.columnOrderStringArray[0]);
            searchPath[2] = SortEngineNode.ASCENDING_ATTRIBUTE_TAG;
            props.set(searchPath, ascending);
            sel = (String)this.table.getValueAt(i, 2);
            boolean nAn = sel.equals(this.naOrderStringArray[0]);
            searchPath[2] = SortEngineNode.NAN_ATTRIBUTE_TAG;
            props.set(searchPath, nAn);
        }
        props.set(SortEngineNode.ALPHABETICAL_ATTRIBUTE_TAG, this.alphaCheckBox.isSelected());
    }

    public void createActions() {
        super.createActions();
        this.addAction = new AbstractAction(">>"){

            public void actionPerformed(ActionEvent e) {
                if (SortDialog.this.table.isEditing()) {
                    SortDialog.this.table.getCellEditor().stopCellEditing();
                }
                Object[] objects = SortDialog.this.list.getSelectedValues();
                int[] indices = SortDialog.this.list.getSelectedIndices();
                SortDialog.this.list.getSelectionModel().clearSelection();
                SortDialog.this.listModel.removeListDataListeners();
                for (int i = 0; i < objects.length; ++i) {
                    NodeDialog.ColumnInformationObject object = (NodeDialog.ColumnInformationObject)objects[i];
                    SortDialog.this.listModel.removeElementAt(indices[i] - i);
                    SortDialog.this.tableModel.addRow(new Object[]{object.getText(), SortDialog.this.columnOrderStringArray[0], SortDialog.this.naOrderStringArray[0]});
                }
                SortDialog.this.listModel.undoRemoveListDataListeners();
                SortDialog.this.listModel.listContentsChanged();
                objects = null;
                indices = null;
            }
        };
        this.removeAction = new AbstractAction("<<"){

            public void actionPerformed(ActionEvent e) {
                int i;
                if (SortDialog.this.table.isEditing()) {
                    SortDialog.this.table.getCellEditor().stopCellEditing();
                }
                int[] rows = SortDialog.this.table.getSelectedRows();
                SortDialog.this.table.getSelectionModel().clearSelection();
                TableModelListener[] listeners = SortDialog.this.tableModel.getTableModelListeners();
                for (i = 0; i < listeners.length; ++i) {
                    SortDialog.this.tableModel.removeTableModelListener(listeners[i]);
                }
                for (i = rows.length - 1; i >= 0; --i) {
                    int row = rows[i];
                    if (row == -1) continue;
                    String name = (String)SortDialog.this.table.getValueAt(row, 0);
                    SortDialog.this.tableModel.removeRow(row);
                    Object obj = SortDialog.this.columnObjects.get(name);
                    if (obj == null) continue;
                    SortDialog.this.listModel.addElement(obj);
                }
                SortDialog.this.scrollingList.sort();
                for (int ii = 0; ii < listeners.length; ++ii) {
                    SortDialog.this.tableModel.addTableModelListener(listeners[ii]);
                }
                SortDialog.this.tableModel.fireTableDataChanged();
                listeners = null;
                rows = null;
            }
        };
    }

    public JPanel createOptionsPanel() {
        JPanel selectColumnsPanel = new JPanel(new GridBagLayout());
        selectColumnsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("SortDialog_selectColumns")), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        this.columnOrderStringArray = new String[2];
        this.columnOrderStringArray[0] = MinerApp.getText("SortDialog_ascending");
        this.columnOrderStringArray[1] = MinerApp.getText("SortDialog_descending");
        this.naOrderStringArray = new String[2];
        this.naOrderStringArray[0] = "Missing on Top";
        this.naOrderStringArray[1] = "Missing on Bottom";
        JLabel listLabel = new JLabel(MinerApp.getText("SortDialog_availableColumns"));
        this.listModel = new NodeDialog.DNDListModel();
        this.list = new NodeDialog.DNDList(this.listModel);
        NodeDialog.ColumnInformationRenderer renderer = new NodeDialog.ColumnInformationRenderer();
        this.list.setCellRenderer(renderer);
        this.list.setSelectionMode(2);
        this.scrollingList = new NodeDialog.SortingScrollPane(this.list);
        this.scrollingList.setBorder(BorderFactory.createLoweredBevelBorder());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.gridheight = 1;
        constraints.gridwidth = 2;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        selectColumnsPanel.add((Component)listLabel, constraints);
        constraints.gridy = 1;
        constraints.gridheight = 5;
        constraints.weightx = 0.4;
        constraints.weighty = 0.25;
        constraints.anchor = 10;
        constraints.fill = 1;
        selectColumnsPanel.add((Component)this.scrollingList, constraints);
        JButton addButton = new JButton(this.addAction);
        JButton removeButton = new JButton(this.removeAction);
        constraints.gridx = 2;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.insets = new Insets(0, 10, 10, 10);
        constraints.fill = 0;
        constraints.anchor = 11;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        selectColumnsPanel.add((Component)addButton, constraints);
        constraints.gridy = 2;
        selectColumnsPanel.add((Component)removeButton, constraints);
        JLabel tableLabel = new JLabel(MinerApp.getText("SortDialog_sortKeys"));
        this.tableModel = new SortTableModel();
        this.tableModel.setColumnIdentifiers(new Object[]{MinerApp.getText("SortDialog_columnNames"), MinerApp.getText("SortDialog_columnOrder"), MinerApp.getText("SortDialog_missing")});
        this.table = new JTable(this.tableModel);
        NodeDialog.addKeyboardNavigation(this.table);
        this.table.setRowHeight(25);
        this.table.setAutoResizeMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        TableColumnModel tcm = this.table.getColumnModel();
        JComboBox<String> orderCB = new JComboBox<String>(this.columnOrderStringArray);
        JComboBox<String> naCB = new JComboBox<String>(this.naOrderStringArray);
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            TableColumn column = tcm.getColumn(i);
            if (i == 1) {
                column.setCellEditor(new DefaultCellEditor(orderCB));
                column.setCellRenderer(new NodeDialog.LeftJustifiedStringRenderer());
            } else if (i == 2) {
                column.setCellEditor(new DefaultCellEditor(naCB));
                column.setCellRenderer(new NodeDialog.LeftJustifiedStringRenderer());
            }
            column.setPreferredWidth(120);
        }
        JScrollPane scrollingTable = new JScrollPane(this.table);
        constraints.gridx = 3;
        constraints.gridy = 0;
        constraints.gridheight = 1;
        constraints.gridwidth = 5;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.anchor = 18;
        selectColumnsPanel.add((Component)tableLabel, constraints);
        constraints.gridy = 1;
        constraints.gridheight = 5;
        constraints.weightx = 0.6;
        constraints.weighty = 1.0;
        constraints.anchor = 10;
        constraints.fill = 1;
        selectColumnsPanel.add((Component)scrollingTable, constraints);
        JPanel optionsPanel = new JPanel(new GridBagLayout());
        optionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("SortDialog_options")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.alphaCheckBox = new JCheckBox(MinerApp.getText("SortDialog_alphaSort"));
        this.alphaCheckBox.setMnemonic('a');
        GridBagConstraints optionsConstraints = new GridBagConstraints();
        optionsConstraints.anchor = 18;
        optionsConstraints.weightx = 1.0;
        optionsConstraints.weighty = 1.0;
        optionsPanel.add((Component)this.alphaCheckBox, optionsConstraints);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)selectColumnsPanel, "Center");
        panel.add((Component)optionsPanel, "South");
        return panel;
    }

    private class SortTableModel
    extends DefaultTableModel {
        private SortTableModel() {
        }

        public void clearTable() {
            this.dataVector.removeAllElements();
            this.fireTableDataChanged();
        }
    }

    private class DraggableJTable
    extends JTable
    implements DropTargetListener,
    DragSourceListener,
    DragGestureListener {
        private DropTarget dropTarget;
        private DragSource dragSource;
        private int rowDragged;
        private Vector draggableRowVector;

        DraggableJTable(TableModel model) {
            super(model);
            this.dropTarget = new DropTarget(this, this);
            this.dragSource = DragSource.getDefaultDragSource();
            this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            if (this.isEditing()) {
                return;
            }
            int rowDragged = this.rowAtPoint(dragGestureEvent.getDragOrigin());
            if (rowDragged != -1) {
                this.draggableRowVector = new Vector();
                this.draggableRowVector.add(SortDialog.this.tableModel.getValueAt(rowDragged, 0));
                this.draggableRowVector.add(SortDialog.this.tableModel.getValueAt(rowDragged, 1));
                this.draggableRowVector.add(SortDialog.this.tableModel.getValueAt(rowDragged, 2));
                SortDialog.this.tableModel.removeRow(rowDragged);
                DraggableRow transferable = new DraggableRow(this.draggableRowVector);
                dragGestureEvent.startDrag(DragSource.DefaultMoveDrop, transferable, this);
            }
        }

        public void dragDropEnd(DragSourceDropEvent DragSourceDropEvent2) {
            if (!DragSourceDropEvent2.getDropSuccess()) {
                SortDialog.this.tableModel.insertRow(this.rowDragged, this.draggableRowVector);
            }
        }

        public synchronized void drop(DropTargetDropEvent dropTargetDropEvent) {
            try {
                Transferable tr = dropTargetDropEvent.getTransferable();
                if (tr.isDataFlavorSupported(rowFlavor)) {
                    dropTargetDropEvent.acceptDrop(2);
                    Vector rowVector = (Vector)tr.getTransferData(rowFlavor);
                    int row = SortDialog.this.table.rowAtPoint(dropTargetDropEvent.getLocation());
                    SortDialog.this.tableModel.insertRow(row, rowVector);
                    dropTargetDropEvent.getDropTargetContext().dropComplete(true);
                } else {
                    dropTargetDropEvent.rejectDrop();
                }
            }
            catch (IOException io) {
                io.printStackTrace();
                dropTargetDropEvent.rejectDrop();
            }
            catch (UnsupportedFlavorException ufe) {
                ufe.printStackTrace();
                dropTargetDropEvent.rejectDrop();
            }
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            dropTargetDragEvent.acceptDrag(3);
        }

        public void dragEnter(DragSourceDragEvent DragSourceDragEvent2) {
        }

        public void dragExit(DragSourceEvent DragSourceEvent2) {
        }

        public void dragOver(DragSourceDragEvent DragSourceDragEvent2) {
        }

        public void dropActionChanged(DragSourceDragEvent DragSourceDragEvent2) {
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
        }
    }

    public class DraggableRow
    implements Transferable {
        private Vector row;
        private final DataFlavor[] flavors = new DataFlavor[]{rowFlavor};

        public DraggableRow(Vector row) {
            this.row = row;
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(rowFlavor)) {
                return this.row;
            }
            throw new UnsupportedFlavorException(flavor);
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(rowFlavor);
        }

        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }
    }
}

