/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.WideFileChooser;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTNetwork;
import com.insightful.miner.XTProps;
import com.insightful.splus.SplusSystem;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class SplusScriptDialog
extends NodeDialog {
    private JTextArea functionTextArea;
    private JComboBox numInputsComboBox;
    private JComboBox numOutputsComboBox;
    private JCheckBox showResultsCheckBox;
    private JCheckBox storeForViewCheckBox;
    private JCheckBox m_showParametersTableCheckBox;
    private JCheckBox m_bigdataCheckBox;
    private String lastLoadFileName = null;
    private JPanel m_settingsPanel;
    private NameValuePanel m_parameterPanel;
    private JRadioButton m_simpleRequirementsRadioButton;
    private JRadioButton m_advancedRequirementsRadioButton;
    private JButton m_insertTemplateButton;
    private JButton m_parseButton;
    private JRadioButton m_singleBlockRadioButton;
    private JRadioButton m_multipleBlocksRadioButton;
    private JRadioButton m_allRowsRadioButton;
    private JRadioButton m_maxRowsRadioButton;
    private JTextField m_maxRowsTextField;
    private JRadioButton m_dynamicOutputsRadioButton;
    private JRadioButton m_prespecifiedOutputsRadioButton;
    private JCheckBox m_copyInputColsCheckBox;
    private JCheckBox m_newColsCheckBox;
    private JTable m_newColsTable;
    private LocalNewColumnsTableModel m_newColsTableModel;
    private ActionListener m_requirementsListener;
    private static final String[] range = new String[]{"0", "1", "2", "3", "4", "5"};
    private static SplusScriptDialog instance = null;
    private static final String DEFAULT_FUNCTION = MinerApp.getText("SplusScriptDialog_exampleScript");
    private static final String TEST_EXAMPLE_CODE = MinerApp.getText("SplusScriptDialog_exampleTestCode");
    private static final String[] columnTypes = new String[]{"", XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG, XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG, XTMetaData.STRING_TYPE_ATTRIBUTE_TAG, XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG};
    private static final String[] columnRoles = new String[]{"", XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG, XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG, XTMetaData.INFORMATION_ROLE_ATTRIBUTE_TAG, XTMetaData.PREDICTION_ROLE_ATTRIBUTE_TAG};

    public static SplusScriptDialog getInstance() {
        if (instance == null) {
            instance = new SplusScriptDialog();
        }
        return instance;
    }

    protected SplusScriptDialog() {
        this.setSize(800, 600);
        this.setMinimumSize(new Dimension(700, 500));
        this.setResizable(true);
        this.m_settingsPanel = new JPanel(new BorderLayout());
        this.m_settingsPanel.setName(MinerApp.getText("SplusScriptDialog_settingsPage"));
        this.m_settingsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("SplusScriptDialog_settingsGroup")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.m_settingsPanel.add((Component)this.createParametersTablePanel(), "Center");
    }

    public boolean displaySeedPanel() {
        return true;
    }

    public void restoreProperties() {
        super.restoreProperties();
        if (this.m_newColsTable.isEditing()) {
            this.m_newColsTable.getCellEditor().stopCellEditing();
        }
        XTProps props = this.getNodeModel().getXTProps();
        this.functionTextArea.setText(props.getValue("function", DEFAULT_FUNCTION));
        this.functionTextArea.setCaretPosition(0);
        String inputPorts = props.getValue("numInputs", "1");
        if (inputPorts.startsWith("-")) {
            inputPorts = "Multiple";
        }
        this.numInputsComboBox.setSelectedItem(inputPorts);
        this.numOutputsComboBox.setSelectedItem(props.getValue("numOutputs", "1"));
        this.showResultsCheckBox.setSelected(props.getBoolean("showOutputDuringRun", false));
        this.storeForViewCheckBox.setSelected(props.getBoolean("storeOutputForView", true));
        this.m_showParametersTableCheckBox.setSelected(props.getBoolean("showParametersTable", false));
        this.m_bigdataCheckBox.setSelected(props.getBoolean("bigdataScript", false));
        if (props.getBoolean("includeTestPhase", true)) {
            this.m_advancedRequirementsRadioButton.setSelected(true);
        } else {
            this.m_simpleRequirementsRadioButton.setSelected(true);
        }
        if (props.getBoolean("oneBlock", true)) {
            this.m_singleBlockRadioButton.setSelected(true);
        } else {
            this.m_multipleBlocksRadioButton.setSelected(true);
        }
        if (props.getBoolean("doSample")) {
            this.m_maxRowsRadioButton.setSelected(true);
        } else {
            this.m_allRowsRadioButton.setSelected(true);
        }
        String str = props.getValue("sampleSize");
        if (str.length() == 0 && !inputPorts.equals("0")) {
            try {
                str = Long.toString(this.getNodeModel().getInputMetaData(0).getNumRows());
            }
            catch (Exception e) {
                str = "0";
            }
        }
        this.m_maxRowsTextField.setText(str);
        if (props.getBoolean("dynamicOutputs", true)) {
            this.m_dynamicOutputsRadioButton.setSelected(true);
        } else {
            this.m_prespecifiedOutputsRadioButton.setSelected(true);
        }
        this.m_copyInputColsCheckBox.setSelected(props.getBoolean("copyInputCols", false));
        this.m_newColsCheckBox.setSelected(props.getBoolean("newColumns", false));
        this.updateRequirementsControls();
        this.m_newColsTableModel.clearTableData();
        this.m_parameterPanel.restoreProperties(props, new String[]{"scriptArguments"});
        Vector names = props.getSubProperties("newColumns");
        if (names.size() > 0) {
            String curName = "";
            String curType = "";
            String curRole = "";
            for (int i = names.size() - 1; i >= 0; --i) {
                curName = (String)names.elementAt(i);
                curType = props.getValue(new String[]{"newColumns", curName, XTMetaData.TYPE_ATTRIBUTE_TAG});
                curRole = props.getValue(new String[]{"newColumns", curName, XTMetaData.ROLE_ATTRIBUTE_TAG});
                this.m_newColsTableModel.setValueAt(curName, i, 0);
                this.m_newColsTableModel.setValueAt(curType, i, 1);
                this.m_newColsTableModel.setValueAt(curRole, i, 2);
            }
        }
        if (this.m_showParametersTableCheckBox.isSelected()) {
            if (this.tabbedPane.indexOfComponent(this.m_settingsPanel) < 0) {
                this.tabbedPane.add((Component)this.m_settingsPanel, 0);
                this.tabbedPane.setSelectedIndex(0);
            }
        } else if (this.tabbedPane.indexOfComponent(this.m_settingsPanel) >= 0) {
            this.tabbedPane.remove(this.m_settingsPanel);
            this.tabbedPane.setSelectedIndex(0);
        }
        this.m_parseButton.setEnabled(MinerApp.isSplusLicensed() && !MinerApp.isRunning());
    }

    public void saveProperties() throws NodeDialog.DialogException {
        super.saveProperties();
        XTProps props = this.getNodeModel().getXTProps();
        props.set("function", this.functionTextArea.getText());
        String newNumInputsStr = (String)this.numInputsComboBox.getSelectedItem();
        if (newNumInputsStr.equals("Multiple")) {
            newNumInputsStr = "-1";
        }
        String newNumOutputsStr = (String)this.numOutputsComboBox.getSelectedItem();
        int newNumInputs = Integer.parseInt(newNumInputsStr);
        int newNumOutputs = Integer.parseInt(newNumOutputsStr);
        props.set("numInputs", newNumInputs);
        props.set("numOutputs", newNumOutputs);
        if (newNumInputs != this.getNodeModel().getNumInputs() || newNumOutputs != this.getNodeModel().getNumOutputs()) {
            this.getNodeModel().setNumPorts(newNumInputs, newNumOutputs);
        }
        props.removeProperty(new String[]{"scriptArguments"});
        if (this.m_newColsTable.isEditing()) {
            this.m_newColsTable.getCellEditor().stopCellEditing();
        }
        this.m_parameterPanel.saveProperties(props, new String[]{"scriptArguments"});
        props.set("showOutputDuringRun", this.showResultsCheckBox.isSelected());
        props.set("storeOutputForView", this.storeForViewCheckBox.isSelected());
        props.set("showParametersTable", this.m_showParametersTableCheckBox.isSelected());
        props.set("bigdataScript", this.m_bigdataCheckBox.isSelected());
        props.set("includeTestPhase", this.m_advancedRequirementsRadioButton.isSelected());
        props.set("oneBlock", this.m_singleBlockRadioButton.isSelected());
        props.set("doSample", this.m_maxRowsRadioButton.isSelected());
        props.set("sampleSize", this.m_maxRowsTextField.getText());
        props.set("dynamicOutputs", this.m_dynamicOutputsRadioButton.isSelected());
        props.set("copyInputCols", this.m_copyInputColsCheckBox.isSelected());
        props.removeProperty(new String[]{"newColumns"});
        props.set("newColumns", this.m_newColsCheckBox.isSelected());
        int numRows = this.m_newColsTableModel.getRowCount();
        String curName = "";
        String curType = "";
        String curRole = "";
        for (int i = 0; i < numRows; ++i) {
            curName = ((String)this.m_newColsTableModel.getValueAt(i, 0)).trim();
            curType = ((String)this.m_newColsTableModel.getValueAt(i, 1)).trim();
            curRole = ((String)this.m_newColsTableModel.getValueAt(i, 2)).trim();
            if (curName.length() <= 0) continue;
            props.set(new String[]{"newColumns", curName}, "");
            props.set(new String[]{"newColumns", curName, XTMetaData.TYPE_ATTRIBUTE_TAG}, curType);
            props.set(new String[]{"newColumns", curName, XTMetaData.ROLE_ATTRIBUTE_TAG}, curRole);
        }
    }

    public void createActions() {
        super.createActions();
    }

    public JPanel createOptionsPanel() {
        return this.getScriptPanel();
    }

    public Vector createOtherTabs() {
        Vector<JPanel> tabsVec = new Vector<JPanel>();
        tabsVec.add(this.getOtherOptionsPanel());
        return tabsVec;
    }

    private JPanel getScriptPanel() {
        this.functionTextArea = new JTextArea();
        return this.getScriptPanel(this.functionTextArea);
    }

    protected JPanel getScriptPanel(JTextArea textArea) {
        JPanel scriptPanel = new JPanel(new BorderLayout());
        scriptPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("SplusScriptDialog_script")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        scriptPanel.setName(MinerApp.getText("SplusScriptDialog_script"));
        textArea.setBorder(BorderFactory.createLoweredBevelBorder());
        JScrollPane scrollPane = new JScrollPane(textArea);
        scrollPane.getViewport().setPreferredSize(textArea.getPreferredSize());
        scriptPanel.add((Component)scrollPane, "Center");
        ScriptButtonListener listener = new ScriptButtonListener(textArea);
        JButton loadButton = new JButton(MinerApp.getText("SplusScriptDialog_loadButton"));
        loadButton.addActionListener(listener);
        JButton editButton = new JButton(MinerApp.getText("SplusScriptDialog_editButton"));
        editButton.addActionListener(listener);
        this.m_parseButton = new JButton(MinerApp.getText("SplusScriptDialog_parseButton"));
        this.m_parseButton.addActionListener(listener);
        JPanel scriptButtonPanel = new JPanel();
        scriptButtonPanel.setLayout(new BoxLayout(scriptButtonPanel, 1));
        scriptButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        scriptPanel.add((Component)scriptButtonPanel, "East");
        scriptButtonPanel.add(loadButton);
        scriptButtonPanel.add(Box.createVerticalStrut(5));
        scriptButtonPanel.add(editButton);
        scriptButtonPanel.add(Box.createVerticalGlue());
        scriptButtonPanel.add(this.m_parseButton);
        return scriptPanel;
    }

    private JPanel getOtherOptionsPanel() {
        JPanel numPortsPanel = new JPanel(new GridBagLayout());
        numPortsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("SplusScriptDialog_numPortsPanel")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        Dimension comboBoxSize = new Dimension(120, 20);
        JLabel numInputsLabel = new JLabel(MinerApp.getText("SplusScriptDialog_numInputs"));
        this.numInputsComboBox = new JComboBox<String>(range);
        numInputsLabel.setDisplayedMnemonic('u');
        numInputsLabel.setLabelFor(this.numInputsComboBox);
        this.numInputsComboBox.setPreferredSize(comboBoxSize);
        this.numInputsComboBox.addItem("Multiple");
        this.numInputsComboBox.setEditable(true);
        JTextField tf = (JTextField)this.numInputsComboBox.getEditor().getEditorComponent();
        tf.setDocument(new InputDocument());
        this.numInputsComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                SplusScriptDialog.this.updateRequirementsControls();
            }
        });
        JLabel numOutputsLabel = new JLabel(MinerApp.getText("SplusScriptDialog_numOutputs"));
        this.numOutputsComboBox = new JComboBox<String>(range);
        numOutputsLabel.setDisplayedMnemonic('m');
        numOutputsLabel.setLabelFor(this.numOutputsComboBox);
        this.numOutputsComboBox.setPreferredSize(comboBoxSize);
        this.numOutputsComboBox.setEditable(true);
        tf = (JTextField)this.numOutputsComboBox.getEditor().getEditorComponent();
        tf.setDocument(new NodeDialog.InputIntegerDoc());
        JPanel interfacePanel = new JPanel(new GridBagLayout());
        interfacePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("SplusScriptDialog_interfacePanel")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JPanel bigdataPanel = new JPanel(new GridBagLayout());
        bigdataPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("SplusScriptDialog_bigdataScriptPanel")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.m_showParametersTableCheckBox = new JCheckBox(MinerApp.getText("SplusScriptDialog_showParametersPage"));
        this.m_showParametersTableCheckBox.setMnemonic('r');
        this.m_showParametersTableCheckBox.setPreferredSize(new Dimension(240, 20));
        this.m_bigdataCheckBox = new JCheckBox(MinerApp.getText("SplusScriptDialog_executeBigdataScript"));
        this.m_bigdataCheckBox.setPreferredSize(new Dimension(240, 20));
        this.m_bigdataCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                SplusScriptDialog.this.updateRequirementsControls();
            }
        });
        JPanel resultsPanel = new JPanel(new GridBagLayout());
        resultsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("SplusScriptDialog_resultsPanel")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.showResultsCheckBox = new JCheckBox(MinerApp.getText("SplusScriptDialog_showResults"));
        this.showResultsCheckBox.setMnemonic('r');
        this.showResultsCheckBox.setPreferredSize(new Dimension(240, 20));
        this.storeForViewCheckBox = new JCheckBox(MinerApp.getText("SplusScriptDialog_storeForView"));
        this.storeForViewCheckBox.setMnemonic('v');
        this.storeForViewCheckBox.setPreferredSize(new Dimension(240, 20));
        ActionListener m_requirementsListener = new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                SplusScriptDialog.this.updateRequirementsControls();
            }
        };
        JPanel requirementsPanel = new JPanel(new GridBagLayout());
        requirementsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("SplusScriptDialog_requirementsPanel")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.m_simpleRequirementsRadioButton = new JRadioButton(MinerApp.getText("SplusScriptDialog_simpleRequirements"));
        this.m_simpleRequirementsRadioButton.addActionListener(m_requirementsListener);
        this.m_simpleRequirementsRadioButton.setSelected(true);
        this.m_advancedRequirementsRadioButton = new JRadioButton(MinerApp.getText("SplusScriptDialog_advancedRequirements"));
        this.m_advancedRequirementsRadioButton.addActionListener(m_requirementsListener);
        this.m_insertTemplateButton = new JButton(MinerApp.getText("SplusScriptDialog_insertTemplate"));
        this.m_insertTemplateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                if (!SplusScriptDialog.this.functionTextArea.getText().startsWith(TEST_EXAMPLE_CODE)) {
                    SplusScriptDialog.this.functionTextArea.insert(TEST_EXAMPLE_CODE, 0);
                }
            }
        });
        ButtonGroup requirementsButtons = new ButtonGroup();
        requirementsButtons.add(this.m_simpleRequirementsRadioButton);
        requirementsButtons.add(this.m_advancedRequirementsRadioButton);
        JPanel blockPanel = new JPanel(new GridBagLayout());
        blockPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("SplusScriptDialog_blockPanel")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.m_singleBlockRadioButton = new JRadioButton(MinerApp.getText("SplusScriptDialog_singleBlock"));
        this.m_singleBlockRadioButton.setSelected(true);
        this.m_singleBlockRadioButton.addActionListener(m_requirementsListener);
        this.m_multipleBlocksRadioButton = new JRadioButton(MinerApp.getText("SplusScriptDialog_multipleBlocks"));
        this.m_multipleBlocksRadioButton.addActionListener(m_requirementsListener);
        this.m_allRowsRadioButton = new JRadioButton(MinerApp.getText("SplusScriptDialog_allRows"));
        this.m_allRowsRadioButton.setSelected(true);
        this.m_allRowsRadioButton.addActionListener(m_requirementsListener);
        this.m_maxRowsTextField = new JTextField(10);
        this.m_maxRowsRadioButton = new JRadioButton(MinerApp.getText("SplusScriptDialog_maxRows"));
        this.m_maxRowsRadioButton.setMnemonic('x');
        this.m_maxRowsTextField.setDocument(new NodeDialog.InputIntegerDoc());
        this.m_maxRowsRadioButton.addActionListener(m_requirementsListener);
        ButtonGroup blockButtons = new ButtonGroup();
        blockButtons.add(this.m_singleBlockRadioButton);
        blockButtons.add(this.m_multipleBlocksRadioButton);
        ButtonGroup rowHandlingButtons = new ButtonGroup();
        rowHandlingButtons.add(this.m_allRowsRadioButton);
        rowHandlingButtons.add(this.m_maxRowsRadioButton);
        this.m_dynamicOutputsRadioButton = new JRadioButton(MinerApp.getText("SplusScriptDialog_dynamicOutputs"));
        this.m_dynamicOutputsRadioButton.addActionListener(m_requirementsListener);
        this.m_dynamicOutputsRadioButton.setSelected(true);
        this.m_prespecifiedOutputsRadioButton = new JRadioButton(MinerApp.getText("SplusScriptDialog_prespecifiedOutputs"));
        this.m_prespecifiedOutputsRadioButton.addActionListener(m_requirementsListener);
        ButtonGroup outputsButtons = new ButtonGroup();
        outputsButtons.add(this.m_dynamicOutputsRadioButton);
        outputsButtons.add(this.m_prespecifiedOutputsRadioButton);
        JPanel outputColsPanel = new JPanel(new GridBagLayout());
        outputColsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("SplusScriptDialog_outputColsPanel")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.m_copyInputColsCheckBox = new JCheckBox(MinerApp.getText("SplusScriptDialog_copyInputCols"));
        this.m_newColsCheckBox = new JCheckBox(MinerApp.getText("SplusScriptDialog_newCols"));
        this.m_newColsCheckBox.addActionListener(m_requirementsListener);
        JPanel newColsPanel = this.createNewColsTablePanel();
        Insets none = new Insets(0, 0, 0, 0);
        Insets indent = new Insets(0, 15, 0, 0);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 18;
        constraints.fill = 2;
        constraints.gridy = 0;
        constraints.gridx = 0;
        constraints.weightx = 0.0;
        numPortsPanel.add((Component)numInputsLabel, constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        constraints.insets = indent;
        numPortsPanel.add((Component)this.numInputsComboBox, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.weightx = 0.0;
        constraints.insets = none;
        numPortsPanel.add((Component)numOutputsLabel, constraints);
        ++constraints.gridx;
        constraints.weightx = 1.0;
        constraints.insets = indent;
        numPortsPanel.add((Component)this.numOutputsComboBox, constraints);
        constraints.insets = none;
        constraints.gridy = 0;
        constraints.gridx = 0;
        constraints.weightx = 1.0;
        resultsPanel.add((Component)this.storeForViewCheckBox, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.weightx = 1.0;
        resultsPanel.add((Component)this.showResultsCheckBox, constraints);
        constraints.gridy = 0;
        constraints.gridx = 0;
        constraints.weightx = 1.0;
        interfacePanel.add((Component)this.m_showParametersTableCheckBox, constraints);
        bigdataPanel.add((Component)this.m_bigdataCheckBox, constraints);
        constraints.insets = none;
        constraints.gridy = 0;
        constraints.gridx = 0;
        constraints.weightx = 1.0;
        blockPanel.add((Component)this.m_singleBlockRadioButton, constraints);
        constraints.insets = indent;
        ++constraints.gridy;
        blockPanel.add((Component)this.m_allRowsRadioButton, constraints);
        ++constraints.gridy;
        blockPanel.add((Component)this.m_maxRowsRadioButton, constraints);
        ++constraints.gridx;
        blockPanel.add((Component)this.m_maxRowsTextField, constraints);
        constraints.insets = none;
        constraints.gridx = 0;
        ++constraints.gridy;
        blockPanel.add((Component)this.m_multipleBlocksRadioButton, constraints);
        constraints.gridx = 0;
        constraints.gridy = 0;
        outputColsPanel.add((Component)this.m_dynamicOutputsRadioButton, constraints);
        ++constraints.gridy;
        outputColsPanel.add((Component)this.m_prespecifiedOutputsRadioButton, constraints);
        ++constraints.gridy;
        constraints.insets = indent;
        outputColsPanel.add((Component)this.m_copyInputColsCheckBox, constraints);
        ++constraints.gridy;
        outputColsPanel.add((Component)this.m_newColsCheckBox, constraints);
        ++constraints.gridy;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        outputColsPanel.add((Component)newColsPanel, constraints);
        constraints.insets = none;
        constraints.gridy = 0;
        constraints.gridx = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        constraints.fill = 2;
        requirementsPanel.add((Component)this.m_simpleRequirementsRadioButton, constraints);
        ++constraints.gridy;
        constraints.gridx = 0;
        constraints.weightx = 0.0;
        requirementsPanel.add((Component)this.m_advancedRequirementsRadioButton, constraints);
        ++constraints.gridx;
        constraints.weightx = 0.0;
        requirementsPanel.add((Component)this.m_insertTemplateButton, constraints);
        JPanel leftPanel = new JPanel(new GridBagLayout());
        constraints.anchor = 18;
        constraints.fill = 2;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.insets = none;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        leftPanel.add((Component)numPortsPanel, constraints);
        ++constraints.gridy;
        leftPanel.add((Component)requirementsPanel, constraints);
        ++constraints.gridy;
        leftPanel.add((Component)resultsPanel, constraints);
        ++constraints.gridy;
        leftPanel.add((Component)interfacePanel, constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        leftPanel.add((Component)bigdataPanel, constraints);
        JPanel rightPanel = new JPanel(new GridBagLayout());
        constraints.anchor = 18;
        constraints.fill = 2;
        constraints.gridy = 0;
        constraints.gridx = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        rightPanel.add((Component)blockPanel, constraints);
        ++constraints.gridy;
        constraints.fill = 1;
        constraints.weighty = 1.0;
        rightPanel.add((Component)outputColsPanel, constraints);
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setName(MinerApp.getText("SplusScriptDialog_otherTabLabel"));
        mainPanel.add((Component)leftPanel, "West");
        mainPanel.add((Component)rightPanel, "Center");
        return mainPanel;
    }

    private JPanel createParametersTablePanel() {
        this.m_parameterPanel = new NameValuePanel(false);
        return this.m_parameterPanel;
    }

    private JPanel createNewColsTablePanel() {
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 0));
        this.m_newColsTableModel = new LocalNewColumnsTableModel();
        this.m_newColsTable = new JTable(this.m_newColsTableModel);
        NodeDialog.addKeyboardNavigation(this.m_newColsTable);
        this.m_newColsTable.getTableHeader().setReorderingAllowed(false);
        this.m_newColsTable.setRowSelectionAllowed(false);
        this.m_newColsTable.setColumnSelectionAllowed(false);
        this.m_newColsTable.setRowHeight(25);
        this.m_newColsTable.setDefaultEditor(String.class, new DefaultCellEditor(new JTextField()));
        this.m_newColsTable.getColumn(this.m_newColsTable.getColumnName(1)).setCellEditor(new DefaultCellEditor(new JComboBox<String>(columnTypes)));
        this.m_newColsTable.getColumn(this.m_newColsTable.getColumnName(2)).setCellEditor(new DefaultCellEditor(new JComboBox<String>(columnRoles)));
        JScrollPane scrollingTable = new JScrollPane(this.m_newColsTable);
        tablePanel.add((Component)scrollingTable, "Center");
        Dimension dim = new Dimension(300, 100);
        tablePanel.setMinimumSize(dim);
        tablePanel.setSize(dim);
        return tablePanel;
    }

    protected void doParseTest(String text) {
        String msg = "[Error performing parse test]";
        int msgType = 0;
        if (!MinerApp.isSplusLicensed()) {
            msg = MinerApp.getText("SplusScriptDialog_parseMsg_SplusNotLicensed");
            msgType = 0;
        } else {
            try {
                String parseResult = MinerApp.splusParseTest("{" + text + "}");
                if (parseResult.equals("complete")) {
                    msg = MinerApp.getText("SplusScriptDialog_parseMsg_complete");
                    msgType = 1;
                } else if (parseResult.equals("partial")) {
                    msg = MinerApp.getText("SplusScriptDialog_parseMsg_partial");
                    msgType = 0;
                } else {
                    msg = MinerApp.getText("SplusScriptDialog_parseMsg_error") + "\n\n\t" + parseResult;
                    msgType = 0;
                }
            }
            catch (Exception ex) {
                System.out.println(ex);
            }
        }
        AcceleratorOptionPane.showOKDialog(this.tabbedPane, msg, MinerApp.getText("SplusScriptDialog_parseTestDialogTitle"), msgType);
    }

    protected void doLoad(JTextArea textArea) {
        String defaultPath = this.lastLoadFileName == null ? SplusSystem.getCwd().getAbsolutePath() : MinerApp.getAbsolutePath(this.lastLoadFileName);
        WideFileChooser chooser = new WideFileChooser(defaultPath);
        if (chooser.showOpenDialog(this) != 0) {
            return;
        }
        File selectedFile = chooser.getSelectedFile();
        if (selectedFile == null) {
            return;
        }
        this.lastLoadFileName = selectedFile.getAbsolutePath();
        try {
            FileInputStream ins = new FileInputStream(selectedFile);
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            int blockSize = 4096;
            byte[] buf = new byte[blockSize];
            int numRead = 0;
            while (numRead != -1) {
                numRead = ins.read(buf, 0, buf.length);
                if (numRead == -1) continue;
                os.write(buf, 0, numRead);
            }
            ins.close();
            os.close();
            textArea.setText(os.toString());
        }
        catch (Exception e) {
            AcceleratorOptionPane.showOKDialog(this.tabbedPane, "Cannot load file.  An error occurred:\n\n\t" + e.getMessage(), "Error Loading File", 0);
            e.printStackTrace();
        }
    }

    protected void doEdit(JTextArea textArea) {
        try {
            File tempFile = File.createTempFile("editScript", ".txt", new File(MinerApp.getTempDir()));
            FileOutputStream fos = new FileOutputStream(tempFile);
            String text = textArea.getText();
            if (MinerApp.isWindowsOS()) {
                text = this.unix2Dos(text);
            }
            fos.write(text.getBytes());
            fos.close();
            String app = MinerApp.getGlobalOptions().getValue("textEditor", "");
            if (app.length() == 0) {
                app = MinerApp.isWindowsOS() ? "notepad.exe" : "emacs";
            }
            Process process = Runtime.getRuntime().exec("\"" + app + "\" " + "\"" + tempFile.getAbsolutePath() + "\"");
            process.waitFor();
            if (process.exitValue() == 0) {
                FileInputStream ins = new FileInputStream(tempFile);
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                int blockSize = 4096;
                byte[] buf = new byte[blockSize];
                int numRead = 0;
                while (numRead != -1) {
                    numRead = ins.read(buf, 0, buf.length);
                    if (numRead == -1) continue;
                    bos.write(buf, 0, numRead);
                }
                ins.close();
                bos.close();
                if (MinerApp.isWindowsOS()) {
                    textArea.setText(bos.toString().replaceAll("\r", ""));
                } else {
                    textArea.setText(bos.toString());
                }
            }
        }
        catch (Exception e) {
            AcceleratorOptionPane.showOKDialog(this.tabbedPane, "Cannot edit file.  An error occurred:\n\n\t" + e.getMessage(), "Error Editing File", 0);
            e.printStackTrace();
        }
    }

    private String unix2Dos(String unixStr) {
        String dosStr = new String();
        int end = 0;
        int start = 0;
        while (end < unixStr.length()) {
            end = unixStr.indexOf("\n", start);
            if (end == -1) {
                dosStr = dosStr + unixStr.substring(start, unixStr.length());
                break;
            }
            dosStr = dosStr + unixStr.substring(start, end);
            dosStr = dosStr + (unixStr.substring(end - 1, end).equals("\r") ? "\n" : "\r\n");
            start = ++end;
        }
        return dosStr;
    }

    private void updateRequirementsControls() {
        boolean enableTable;
        boolean simpleReqs = this.m_simpleRequirementsRadioButton.isSelected();
        boolean singleBlock = this.m_singleBlockRadioButton.isSelected();
        boolean prespecifiedOutputs = this.m_prespecifiedOutputsRadioButton.isSelected();
        boolean runningBigdataScript = this.m_bigdataCheckBox.isSelected();
        this.m_insertTemplateButton.setEnabled(!simpleReqs);
        boolean rowHandling = simpleReqs && !runningBigdataScript;
        this.m_singleBlockRadioButton.setEnabled(rowHandling);
        this.m_multipleBlocksRadioButton.setEnabled(rowHandling);
        this.m_allRowsRadioButton.setEnabled(rowHandling && singleBlock);
        this.m_maxRowsRadioButton.setEnabled(rowHandling && singleBlock);
        this.m_maxRowsTextField.setEnabled(rowHandling && singleBlock && this.m_maxRowsRadioButton.isSelected());
        this.m_dynamicOutputsRadioButton.setEnabled(simpleReqs);
        this.m_prespecifiedOutputsRadioButton.setEnabled(simpleReqs);
        this.m_copyInputColsCheckBox.setEnabled(simpleReqs && prespecifiedOutputs);
        this.m_newColsCheckBox.setEnabled(simpleReqs && prespecifiedOutputs);
        boolean bl = enableTable = simpleReqs && prespecifiedOutputs && this.m_newColsCheckBox.isSelected();
        if (!enableTable && this.m_newColsTable.isEditing()) {
            this.m_newColsTable.getCellEditor().stopCellEditing();
        }
        this.m_newColsTable.setEnabled(enableTable);
    }

    public static class NameValuePanel
    extends JPanel {
        private LocalParametersTableModel m_parametersTableModel;
        private JTable m_parametersTable;
        private boolean m_stripPercent;

        public NameValuePanel(boolean stripPercent) {
            super(new BorderLayout());
            this.setBorder(BorderFactory.createEmptyBorder(0, 15, 0, 0));
            this.m_stripPercent = stripPercent;
            this.m_parametersTableModel = new LocalParametersTableModel();
            this.m_parametersTable = new JTable(this.m_parametersTableModel);
            NodeDialog.addKeyboardNavigation(this.m_parametersTable);
            this.m_parametersTable.getTableHeader().setReorderingAllowed(false);
            this.m_parametersTable.setRowSelectionAllowed(false);
            this.m_parametersTable.setColumnSelectionAllowed(false);
            JScrollPane scrollingTable = new JScrollPane(this.m_parametersTable);
            this.add((Component)scrollingTable, "Center");
        }

        public void saveProperties(XTProps props, String[] prePath) {
            if (this.m_parametersTable.isEditing()) {
                this.m_parametersTable.getCellEditor().stopCellEditing();
            }
            String[] path = new String[prePath.length + 1];
            for (int i = 0; i < prePath.length; ++i) {
                path[i] = prePath[i];
            }
            int numRows = this.m_parametersTableModel.getRowCount();
            String str = "";
            for (int i = 0; i < numRows; ++i) {
                str = ((String)this.m_parametersTableModel.getValueAt(i, 0)).trim();
                if (str.length() <= 0) continue;
                if (this.m_stripPercent) {
                    if (!str.startsWith(XTNetwork.PARAMETER_DELIMITER)) {
                        str = XTNetwork.PARAMETER_DELIMITER + str;
                    }
                    if (!str.endsWith(XTNetwork.PARAMETER_DELIMITER)) {
                        str = str + XTNetwork.PARAMETER_DELIMITER;
                    }
                }
                path[prePath.length] = str;
                props.set(path, ((String)this.m_parametersTableModel.getValueAt(i, 1)).trim());
            }
        }

        public void restoreProperties(XTProps props, String[] prePath) {
            if (this.m_parametersTable.isEditing()) {
                this.m_parametersTable.getCellEditor().stopCellEditing();
            }
            this.m_parametersTableModel.clearTableData();
            Vector names = props.getSubProperties(prePath);
            Vector values = props.getSubPropertyValues(prePath);
            for (int i = names.size() - 1; i >= 0; --i) {
                String name = (String)names.elementAt(i);
                if (this.m_stripPercent && name.startsWith(XTNetwork.PARAMETER_DELIMITER) && name.endsWith(XTNetwork.PARAMETER_DELIMITER) && name.length() > 2) {
                    name = name.substring(1, name.length() - 1);
                }
                if (name.length() <= 0) continue;
                this.m_parametersTableModel.setValueAt(name, i, 0);
                this.m_parametersTableModel.setValueAt(values.elementAt(i), i, 1);
            }
        }
    }

    private class ScriptButtonListener
    implements ActionListener {
        JTextArea m_textArea = null;

        public ScriptButtonListener(JTextArea textArea) {
            this.m_textArea = textArea;
        }

        public void actionPerformed(ActionEvent ae) {
            Object source = ae.getSource();
            if (source instanceof JButton) {
                String buttonText = ((JButton)source).getText();
                if (buttonText.equals(MinerApp.getText("SplusScriptDialog_loadButton"))) {
                    SplusScriptDialog.this.doLoad(this.m_textArea);
                } else if (buttonText.equals(MinerApp.getText("SplusScriptDialog_editButton"))) {
                    SplusScriptDialog.this.doEdit(this.m_textArea);
                } else if (buttonText.equals(MinerApp.getText("SplusScriptDialog_parseButton"))) {
                    SplusScriptDialog.this.doParseTest(this.m_textArea.getText());
                }
            }
        }
    }

    private class LocalNewColumnsTableModel
    extends AbstractTableModel {
        private final int TABLE_NUM_ROWS = 50;
        private String[][] tableData = new String[50][3];
        private final String[] tableColumnNames = new String[]{MinerApp.getText("SplusScriptDialog_newColsTableNameLabel"), MinerApp.getText("SplusScriptDialog_newColsTableTypeLabel"), MinerApp.getText("SplusScriptDialog_newColsTableRoleLabel")};

        public LocalNewColumnsTableModel() {
            this.clearTableData();
        }

        public void clearTableData() {
            for (int i = 0; i < 50; ++i) {
                this.tableData[i][0] = "";
                this.tableData[i][1] = "";
                this.tableData[i][2] = "";
            }
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public String getColumnName(int column) {
            return this.tableColumnNames[column];
        }

        public int getRowCount() {
            return 50;
        }

        public int getColumnCount() {
            return this.tableData[0].length;
        }

        public Class getColumnClass(int columnIndex) {
            return this.tableData[0][columnIndex].getClass();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.tableData[rowIndex][columnIndex];
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.tableData[rowIndex][columnIndex] = (String)aValue;
        }
    }

    private static class LocalParametersTableModel
    extends AbstractTableModel {
        private final int TABLE_NUM_ROWS = 50;
        private String[][] tableData = new String[50][2];
        private final String[] tableColumnNames = new String[]{MinerApp.getText("SplusScriptDialog_parameterTableNameLabel"), MinerApp.getText("SplusScriptDialog_parameterTableValueLabel")};

        public LocalParametersTableModel() {
            this.clearTableData();
        }

        public void clearTableData() {
            for (int i = 0; i < 50; ++i) {
                this.tableData[i][0] = "";
                this.tableData[i][1] = "";
            }
        }

        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public String getColumnName(int column) {
            return this.tableColumnNames[column];
        }

        public int getRowCount() {
            return 50;
        }

        public int getColumnCount() {
            return this.tableData[0].length;
        }

        public Class getColumnClass(int columnIndex) {
            return this.tableData[0][columnIndex].getClass();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            return this.tableData[rowIndex][columnIndex];
        }

        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            this.tableData[rowIndex][columnIndex] = (String)aValue;
        }
    }

    private class InputDocument
    extends PlainDocument {
        private InputDocument() {
        }

        public void insertString(int offset, String s, AttributeSet attributeSet) throws BadLocationException {
            String pre = this.getText(0, offset);
            String post = this.getText(offset, this.getLength() - offset);
            String full = pre + s + post;
            if ("Multiple".startsWith(full)) {
                super.insertString(offset, s, attributeSet);
                return;
            }
            try {
                int eIndex = full.indexOf(101);
                if (eIndex == -1) {
                    eIndex = full.indexOf(69);
                }
                if (eIndex != -1) {
                    String longPart = full.substring(0, eIndex);
                    Long.parseLong(longPart);
                    Double.parseDouble(full + "1");
                } else {
                    Long.parseLong(s);
                }
                super.insertString(offset, s, attributeSet);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    private class CBFocusListener
    implements FocusListener {
        private Component last = null;

        public void focusGained(FocusEvent e) {
            this.last = e.getOppositeComponent();
        }

        public void focusLost(FocusEvent e) {
            Component comp = e.getOppositeComponent();
            if (comp == null) {
                comp = this.last;
            } else {
                this.last = comp;
            }
            if (!e.isTemporary()) {
                if (comp instanceof AbstractButton) {
                    ((AbstractButton)comp).doClick();
                }
            } else if (comp instanceof JComponent) {
                ((JComponent)comp).requestFocus();
            }
        }
    }
}

