/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.cnkjava.CNKBuf;
import com.insightful.cnkjava.CNKProc;
import com.insightful.cnkjava.CNKProcJavaTransform;
import com.insightful.cnkjava.CNKProcJavaTransformExec;
import com.insightful.miner.EngineNetworkManager;
import com.insightful.miner.EngineNode;
import com.insightful.miner.XTMetaData;
import com.insightful.miner.XTProps;
import java.util.HashMap;
import java.util.Vector;

public class TransposeEngineNode
extends EngineNode
implements CNKProcJavaTransformExec {
    public static String MAX_ROWS_ATTRIBUTE_TAG = "maxRows";
    public static int DEFAULT_MAX_ROWS = 10000;
    public static int DEFAULT_NUM_CHUNK_OUTPUT_ROWS = 3;
    private boolean m_firstExecution;
    private int m_lastInputColumn;
    private int m_lastOutputRow;
    private int m_lastOutputColumn;
    private XTMetaData m_outMD;
    private long m_totalInputRows;
    private int m_totalNumInputColumns;
    private int m_totalNumOutputColumns;
    private int[] m_inputColumnNums;
    private boolean m_isCategorical;
    private Vector[] m_columnLevels;
    private int m_columnNameColumn;
    private String[] m_columnNames;
    private HashMap m_usedColumnNames;
    private double[][] m_outputDblRows;
    private String[][] m_outputStrRows;

    public boolean hasCNKProc() {
        return false;
    }

    public boolean hasDataCacheProc() {
        return false;
    }

    public boolean hasDynamicOutputs() {
        return true;
    }

    public CNKProc procCreate() {
        CNKProcJavaTransform proc = new CNKProcJavaTransform();
        proc.setExecObject(this);
        proc.setOutputNumRows(1);
        return proc;
    }

    private void getColumnsAndRoles(XTProps props, XTMetaData md, Vector columns, Vector columnRoles) {
        Vector localColumns = props.getSubProperties("columnRoles");
        Vector localColumnRoles = props.getSubPropertyValues("columnRoles");
        if (localColumns.size() == 0 || localColumnRoles.size() == 0) {
            localColumns = md.getColumnNames();
            localColumnRoles = md.getColumnRoles();
        }
        for (int i = 0; i < localColumns.size(); ++i) {
            columns.add(localColumns.get(i));
            columnRoles.add(localColumnRoles.get(i));
        }
    }

    public void procSetProperties(CNKProc proc) throws Exception {
        int i;
        this.m_firstExecution = true;
        this.m_outputDblRows = null;
        this.m_outputStrRows = null;
        this.m_lastOutputColumn = 0;
        this.m_lastOutputRow = 0;
        this.m_lastInputColumn = 0;
        this.m_columnNameColumn = -1;
        XTMetaData inMD = this.getInputMetaData(0);
        XTProps props = this.getNodeProperties();
        Vector columns = new Vector();
        Vector columnRoles = new Vector();
        this.getColumnsAndRoles(props, inMD, columns, columnRoles);
        String iType = "";
        int size = columns.size();
        int minus = 0;
        for (i = 0; i < size; ++i) {
            int index = i - minus;
            String name = (String)columns.get(index);
            String role = (String)columnRoles.get(i);
            String type = inMD.getColumnType(name);
            if (!role.equals(XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG)) {
                int val;
                if (role.equals(XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG) && (inMD.isStringColumn(name) || inMD.isCategoricalColumn(name)) && (val = inMD.nameToOrdinal(name)) >= 0) {
                    this.m_columnNameColumn = val;
                }
                columns.remove(index);
                ++minus;
                continue;
            }
            if (iType.length() == 0) {
                iType = type;
            }
            if (iType.equals(type)) continue;
            columns.remove(index);
            ++minus;
        }
        this.m_totalNumInputColumns = columns.size();
        this.m_inputColumnNums = new int[this.m_totalNumInputColumns];
        for (i = 0; i < this.m_totalNumInputColumns; ++i) {
            this.m_inputColumnNums[i] = inMD.nameToOrdinal((String)columns.get(i));
            if (i != 0) continue;
            this.m_isCategorical = inMD.isCategoricalColumn(this.m_inputColumnNums[i]);
        }
        this.m_outMD = this.calculateOutputMetaData(0, true);
        this.m_totalNumOutputColumns = this.m_outMD.getNumColumns();
        this.m_columnLevels = new Vector[this.m_totalNumOutputColumns];
        for (i = 0; this.m_isCategorical && i < this.m_totalNumOutputColumns; ++i) {
            this.m_columnLevels[i] = new Vector();
        }
        this.m_totalInputRows = props.getInt(MAX_ROWS_ATTRIBUTE_TAG, -1);
        this.m_totalInputRows = this.m_totalInputRows <= 0L ? inMD.getNumRows() : Math.min(this.m_totalInputRows, inMD.getNumRows());
        this.m_columnNames = null;
    }

    public void execute(CNKProcJavaTransform proc) {
        int oC;
        int row;
        int iC;
        int i;
        boolean isString;
        int numChunkInputRows;
        long curInputPosition = proc.getChunkInputPosition(0);
        int totalNumInputRows = proc.getChunkInputRows(0);
        int numChunkInputColumns = Math.min(this.m_totalNumInputColumns, DEFAULT_NUM_CHUNK_OUTPUT_ROWS);
        if (this.m_lastInputColumn + numChunkInputColumns > this.m_totalNumInputColumns) {
            numChunkInputColumns = this.m_totalNumInputColumns - this.m_lastInputColumn;
        }
        if (curInputPosition + (long)(numChunkInputRows = (int)Math.min((long)totalNumInputRows, this.m_totalInputRows)) > this.m_totalInputRows) {
            numChunkInputRows = (int)(this.m_totalInputRows - curInputPosition);
        }
        int numChunkOutputColumns = numChunkInputRows;
        int numChunkOutputRows = numChunkInputColumns;
        boolean bl = isString = this.m_totalNumOutputColumns > 0 && (this.m_outMD.isStringColumn(0) || this.m_outMD.isCategoricalColumn(0));
        if (this.m_columnNameColumn != -1 && this.m_columnNames == null) {
            this.m_columnNames = new String[this.m_totalNumOutputColumns];
            this.m_usedColumnNames = new HashMap(this.m_totalNumOutputColumns);
        }
        if (this.m_firstExecution) {
            try {
                EngineNetworkManager.setBufColumnDescription(proc.getOutbuf(0), this.m_outMD, this.getWorksheetPropertiesManager().getMaxCategoricalLevels());
                proc.setOutputNumRows(numChunkOutputRows);
                proc.getOutbuf(0).setNumRows(proc.getOutbuf(0).getMinRowsToAvoidDeadlock());
                proc.resetDynamicOutputs();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.m_firstExecution = false;
            return;
        }
        if (this.m_outputStrRows == null && this.m_outputDblRows == null) {
            if (isString) {
                this.m_outputStrRows = new String[this.m_totalNumOutputColumns][numChunkOutputRows];
            } else {
                this.m_outputDblRows = new double[this.m_totalNumOutputColumns][numChunkOutputRows];
            }
        }
        if (this.m_outputDblRows != null) {
            i = 0;
            iC = this.m_lastInputColumn;
            while (i < numChunkInputColumns) {
                double[] iDblColData = proc.getChunkInputColumnData(0, this.m_inputColumnNums[iC]);
                row = 0;
                oC = this.m_lastOutputColumn;
                while (row < numChunkInputRows) {
                    this.m_outputDblRows[oC][i] = iDblColData[row];
                    ++row;
                    ++oC;
                }
                iDblColData = null;
                ++i;
                ++iC;
            }
        } else if (this.m_outputStrRows != null) {
            i = 0;
            iC = this.m_lastInputColumn;
            while (i < numChunkInputColumns) {
                String[] iStrColData = proc.getChunkInputColumnStrings(0, this.m_inputColumnNums[iC]);
                row = 0;
                oC = this.m_lastOutputColumn;
                while (row < numChunkInputRows) {
                    if (this.m_isCategorical && !this.m_columnLevels[oC].contains(iStrColData[row])) {
                        this.m_columnLevels[oC].add(iStrColData[row]);
                    }
                    this.m_outputStrRows[oC][i] = iStrColData[row];
                    ++row;
                    ++oC;
                }
                iStrColData = null;
                ++i;
                ++iC;
            }
        }
        if (this.m_lastInputColumn == 0 && this.m_columnNames != null) {
            String[] iColumnNames = proc.getChunkInputColumnStrings(0, this.m_columnNameColumn);
            int row2 = 0;
            int oC2 = this.m_lastOutputColumn;
            while (row2 < numChunkInputRows) {
                Integer lastVal = (Integer)this.m_usedColumnNames.get(iColumnNames[row2]);
                String cName = iColumnNames[row2];
                if (lastVal == null) {
                    this.m_usedColumnNames.put(cName, new Integer(1));
                } else {
                    this.m_usedColumnNames.remove(cName);
                    lastVal = new Integer(lastVal + 1);
                    this.m_usedColumnNames.put(cName, lastVal);
                    cName = cName + lastVal.toString();
                }
                this.m_columnNames[oC2] = cName;
                ++row2;
                ++oC2;
            }
            iColumnNames = null;
        }
        if (curInputPosition + (long)numChunkInputRows >= this.m_totalInputRows) {
            int i2;
            if (isString) {
                String[] outputStrRow = null;
                for (i2 = 0; i2 < this.m_totalNumOutputColumns; ++i2) {
                    outputStrRow = proc.getChunkOutputColumnStrings(0, i2);
                    for (int j = 0; j < this.m_outputStrRows[i2].length; ++j) {
                        outputStrRow[j] = this.m_outputStrRows[i2][j];
                    }
                }
                outputStrRow = null;
            } else {
                double[] outputDblRow = null;
                for (i2 = 0; i2 < this.m_totalNumOutputColumns; ++i2) {
                    outputDblRow = proc.getChunkOutputColumnData(0, i2);
                    for (int j = 0; j < this.m_outputDblRows[i2].length; ++j) {
                        outputDblRow[j] = this.m_outputDblRows[i2][j];
                    }
                }
                outputDblRow = null;
            }
            proc.setChunkOutputReleaseRows(0, numChunkOutputRows);
            this.m_lastInputColumn += numChunkInputColumns;
            this.m_lastOutputRow += numChunkOutputRows;
            this.m_lastOutputColumn = 0;
            this.m_outputDblRows = null;
            this.m_outputStrRows = null;
            if (this.m_lastInputColumn >= this.m_totalNumInputColumns) {
                if (this.m_columnNames != null) {
                    CNKBuf oBuf = proc.getOutbuf(0);
                    oBuf.setColumnNames(this.m_columnNames);
                    for (i2 = 0; this.m_isCategorical && i2 < this.m_totalNumOutputColumns; ++i2) {
                        oBuf.setColumnLevelStrings(i2, this.convertVectorToStringArray(this.m_columnLevels[i2]));
                    }
                }
                proc.setChunkInputReleaseAll(0);
            } else {
                proc.setChunkNextInputPosition(0, 0L);
            }
        } else {
            this.m_lastOutputColumn += numChunkOutputColumns;
            proc.setChunkNextInputPosition(0, curInputPosition + (long)numChunkInputRows);
            proc.setChunkOutputReleaseRows(0, 0);
        }
    }

    private String[] convertVectorToStringArray(Vector from) {
        String[] to = new String[from.size()];
        for (int i = 0; i < to.length; ++i) {
            to[i] = (String)from.get(i);
        }
        return to;
    }

    public XTMetaData calculateOutputMetaData(int outputNum) {
        return this.calculateOutputMetaData(outputNum, false);
    }

    public XTMetaData calculateOutputMetaData(int outputNum, boolean genericColumnNames) {
        XTMetaData md = this.getInputMetaData(0);
        XTProps props = this.getNodeProperties();
        Vector propNames = new Vector();
        Vector propRoles = new Vector();
        this.getColumnsAndRoles(props, md, propNames, propRoles);
        long inputRows = props.getInt(MAX_ROWS_ATTRIBUTE_TAG, DEFAULT_MAX_ROWS);
        inputRows = Math.min(md.getNumRows(), inputRows);
        int outputRows = 0;
        int maxWidth = 0;
        int colNameColumn = -1;
        String type = "";
        for (int i = 0; i < propNames.size(); ++i) {
            String name = (String)propNames.get(i);
            String role = (String)propRoles.get(i);
            if (role.equals(XTMetaData.DEPENDENT_ROLE_ATTRIBUTE_TAG)) {
                if (colNameColumn >= 0 || !md.isCategoricalColumn(name) && !md.isStringColumn(name)) continue;
                colNameColumn = md.nameToOrdinal(name);
                continue;
            }
            if (!role.equals(XTMetaData.INDEPENDENT_ROLE_ATTRIBUTE_TAG)) continue;
            if (md.isStringColumn(name) && maxWidth < md.getStringDataFieldWidth(name)) {
                maxWidth = md.getStringDataFieldWidth(name);
            }
            if (outputRows == 0) {
                type = md.getColumnType(name);
            }
            if (!type.equals(md.getColumnType(name))) continue;
            ++outputRows;
        }
        try {
            XTMetaData outputMD = new XTMetaData();
            outputMD.setNumRows(outputRows);
            String[] emptyLevels = new String[]{};
            boolean useUserSpecifiedNames = !genericColumnNames && this.m_columnNames != null;
            int i = 0;
            while ((long)i < inputRows) {
                String columnName;
                String string = columnName = useUserSpecifiedNames && this.m_columnNames[i] != null ? this.m_columnNames[i] : "Column " + Integer.toString(i + 1);
                if (type.equals(XTMetaData.CONTINUOUS_TYPE_ATTRIBUTE_TAG)) {
                    outputMD.appendContinousDataField(columnName);
                } else if (type.equals(XTMetaData.DATE_TIME_TYPE_ATTRIBUTE_TAG)) {
                    outputMD.appendDateTimeDataField(columnName);
                } else if (type.equals(XTMetaData.CATEGORICAL_TYPE_ATTRIBUTE_TAG)) {
                    outputMD.appendCategoricalDataField(columnName, emptyLevels);
                } else {
                    outputMD.appendStringDataField(columnName, maxWidth);
                }
                ++i;
            }
            return outputMD;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

