/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.MinerApp;
import java.awt.Frame;

public class Win32Tools {
    private static boolean g_librariesLoaded = false;
    private static int g_mainHwnd = 0;
    private static int g_mainCwnd = 0;

    private Win32Tools() {
    }

    public static final void init() {
        Win32Tools.loadLibraries();
        Win32Tools.setMainWindowHandles();
    }

    public static final void setMainWindowHandles() {
        if (!g_librariesLoaded) {
            Win32Tools.loadLibraries();
        }
        g_mainHwnd = Win32Tools.getHwnd(MinerApp.getMainFrame());
        g_mainCwnd = Win32Tools.getCwnd(MinerApp.getMainFrame());
    }

    public static final void loadLibraries() {
        if (!g_librariesLoaded) {
            if (System.getProperty("os.name", "").toLowerCase().indexOf("windows") < 0) {
                throw new RuntimeException("Cannot load required DLL.  Not on Windows.");
            }
            try {
                Win32Tools.loadWinLinkDLL();
            }
            catch (Exception e) {
                AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), MinerApp.getText("Win32Tools_msg_errorLoadingReqiredLib"), MinerApp.getText("Win32Tools_msg_errorLoadingLib"), 2);
                System.exit(1);
            }
            g_librariesLoaded = true;
        }
    }

    public static void loadWinLinkDLL() {
        String loadDir = System.getProperty("cnk.library.dir", null);
        if (loadDir == null || loadDir.length() < 1) {
            loadDir = MinerApp.getSprimeHome() + "\\splus\\cmd";
        }
        String loadFile = loadDir.replace('/', '\\') + "\\" + "WinLink.dll";
        System.load(loadFile);
    }

    public static void loadLicenseManagerDLL() {
        String loadDir = System.getProperty("cnk.library.dir", null);
        if (loadDir == null || loadDir.length() < 1) {
            loadDir = MinerApp.getSprimeHome() + "\\bin";
        }
        String loadFile = loadDir.replace('/', '\\') + "\\" + "ILA.dll";
        System.load(loadFile);
    }

    public static final int getMainHwnd() {
        return g_mainHwnd;
    }

    public static final int getMainCwnd() {
        return g_mainCwnd;
    }

    public static final int getHwnd(Frame wn) {
        if (wn == null) {
            return 0;
        }
        String origTitle = wn.getTitle();
        String newTitle = Long.toString(System.currentTimeMillis());
        wn.setTitle(newTitle);
        int hwnd = Win32Tools.nativeGetHwnd(newTitle);
        wn.setTitle(origTitle);
        return hwnd;
    }

    public static final int getCwnd(Frame wn) {
        if (wn == null) {
            return 0;
        }
        String origTitle = wn.getTitle();
        String newTitle = Long.toString(System.currentTimeMillis());
        wn.setTitle(newTitle);
        int hwnd = Win32Tools.nativeGetCwnd(newTitle);
        wn.setTitle(origTitle);
        return hwnd;
    }

    public static final boolean showURL(String url, boolean bSeparateWindow) {
        return Win32Tools.nativeShowURL(url, Win32Tools.getMainHwnd(), bSeparateWindow);
    }

    private static final native int nativeGetHwnd(String var0);

    private static final native int nativeGetCwnd(String var0);

    private static final native boolean nativeShowURL(String var0, int var1, boolean var2);
}

