/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.ActivityNodeArea;
import com.insightful.miner.ActivityNodeModel;
import com.insightful.miner.ActivityNodeState;
import com.insightful.miner.AppAction;
import com.insightful.miner.BaseLink;
import com.insightful.miner.BaseNodeArea;
import com.insightful.miner.BaseNodePort;
import com.insightful.miner.CollapsedLink;
import com.insightful.miner.CollapsedNodeArea;
import com.insightful.miner.CommentUtilities;
import com.insightful.miner.MinerApp;
import com.insightful.miner.MinerFrame;
import com.insightful.miner.MinerTextNode;
import com.insightful.miner.PMMLExportable;
import com.insightful.miner.PMMLImportable;
import com.insightful.miner.PredictorLink;
import com.insightful.miner.PredictorPort;
import com.insightful.miner.StateVisualCueImage;
import com.insightful.miner.WideFileChooser;
import com.insightful.miner.WorksheetFileFilter;
import com.insightful.miner.XMLTree;
import com.insightful.miner.XTNetwork;
import com.insightful.miner.XTProps;
import com.insightful.splus.SplusSystem;
import com.insightful.splus.util.FileUtilities;
import com.nwoods.jgo.JGoCopyEnvironment;
import com.nwoods.jgo.JGoCopyMap;
import com.nwoods.jgo.JGoDocument;
import com.nwoods.jgo.JGoDocumentChangedEdit;
import com.nwoods.jgo.JGoImage;
import com.nwoods.jgo.JGoLayer;
import com.nwoods.jgo.JGoLink;
import com.nwoods.jgo.JGoListPosition;
import com.nwoods.jgo.JGoObject;
import com.nwoods.jgo.JGoObjectSimpleCollection;
import com.nwoods.jgo.JGoPen;
import com.nwoods.jgo.JGoPort;
import com.nwoods.jgo.JGoUndoManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class WorksheetDocument
extends JGoDocument {
    private static int MAX_NUM_UNDO = 30;
    public static final String DUMMY_WORKSHEET_ID = "dummy-worksheet-id";
    private static transient DataFlavor m_localJVMDataFlavor = null;
    private static transient DataFlavor[] m_localJVMDataFlavors = null;
    private boolean collapsingTransaction = false;
    private static int numNewDocs;
    private static Vector tempObjects;
    public static final int NAME_CHANGED = 65536;
    public static final int LOCATION_CHANGED = 65537;
    private JGoPen myPen = JGoPen.make((int)65535, (int)2, (Color)Color.black);
    private boolean myOrthoLinks = false;
    private XMLTree m_comments = null;
    private XTProps m_worksheetProperties = null;
    private XTProps m_worksheetParameters = null;
    private transient String myWorksheetID = "dummy-worksheet-id";
    private String myName = "";
    private String myLocation = "";
    private String myAuthor = "";
    private String myVersion = "";
    private long myCreatedDate = 0L;
    private int myLastNodeID = -1;
    private transient boolean m_isTemp = false;
    private transient boolean myIsModified = false;
    private boolean myIsEngineNetworkDirty = true;
    private boolean m_pre_version_7_0 = false;

    public WorksheetDocument() {
    }

    public WorksheetDocument(boolean init) {
        this(init, null);
    }

    public WorksheetDocument(boolean init, String worksheetName) {
        if (init) {
            if (worksheetName == null) {
                this.setName("Worksheet" + ++numNewDocs);
            } else {
                this.setName(worksheetName);
            }
            this.setUndoManager(new JGoUndoManager());
            this.setCreatedDate(System.currentTimeMillis());
            this.setAuthor(MinerApp.getUserName());
            try {
                this.setWorksheetProperties(new XTProps());
                this.setWorksheetParameters(new XTProps());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String getName() {
        return this.myName;
    }

    public String getAuthor() {
        return this.myAuthor;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public long getCreatedDate() {
        return this.myCreatedDate;
    }

    public boolean isPreVersion70() {
        return this.m_pre_version_7_0;
    }

    public Element getComments() {
        if (this.m_comments == null) {
            return null;
        }
        return this.m_comments.getXML();
    }

    public void setComments(Element elt) {
        try {
            this.m_comments = new XMLTree(elt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public XTProps getWorksheetProperties() {
        return this.m_worksheetProperties;
    }

    public XTProps getWorksheetParameters() {
        return this.m_worksheetParameters;
    }

    public void setWorksheetProperties(XTProps props) {
        this.m_worksheetProperties = props;
    }

    public void setWorksheetParameters(XTProps props) {
        this.m_worksheetParameters = props;
    }

    public void setName(String newname) {
        String oldName = this.getName();
        if (!oldName.equals(newname)) {
            this.myName = newname;
            this.fireUpdate(65536, 0, null, 0, oldName);
        }
    }

    public void setAuthor(String newAuthor) {
        this.myAuthor = newAuthor;
    }

    public void setVersion(String newVersion) {
        this.myVersion = newVersion;
    }

    public void setCreatedDate(long created) {
        this.myCreatedDate = created;
    }

    public String getLocation() {
        return this.myLocation;
    }

    public void setLocation(String newloc) {
        String oldLocation = this.getLocation();
        if (!oldLocation.equals(newloc)) {
            this.myLocation = newloc;
            this.fireUpdate(65537, 0, null, 0, oldLocation);
        }
    }

    public String getWorksheetID() {
        return this.myWorksheetID;
    }

    public boolean isDummyEngineConnection() {
        return DUMMY_WORKSHEET_ID.equals(this.getWorksheetID());
    }

    public void initEngineConnection() {
        this.setWorksheetID("");
        this.setEngineNetworkDirty();
    }

    public void setWorksheetID(String worksheetID) {
        this.myWorksheetID = worksheetID;
    }

    public boolean getIsTemp() {
        return this.m_isTemp;
    }

    public void setIsTemp(boolean val) {
        this.m_isTemp = val;
        this.fireUpdate(65536, 0, null, 0, this.getName());
    }

    public boolean isLocationReadOnly() {
        File file;
        boolean canwrite = true;
        if (!this.getLocation().equals("") && (file = new File(this.getLocation())).exists() && !file.canWrite()) {
            canwrite = false;
        }
        return !canwrite;
    }

    public boolean isModifiable() {
        return super.isModifiable();
    }

    public void updatePaperColor() {
        if (this.isModifiable()) {
            this.setPaperColor(Color.white);
        } else {
            this.setPaperColor(new Color(221, 221, 221));
        }
    }

    public boolean isModified() {
        return this.myIsModified;
    }

    public void setModified(boolean b) {
        if (this.isModified() != b) {
            this.myIsModified = b;
        }
    }

    public void fireUpdate(int hint, int flags, Object object, int prevInt, Object prevVal) {
        if (hint == 8) {
            this.updatePaperColor();
        } else if (!(object instanceof JGoImage) && hint != 6) {
            this.setModified(true);
        }
        super.fireUpdate(hint, flags, object, prevInt, prevVal);
    }

    public void setWorksheetNextNodeID(WorksheetDocument doc) {
        doc.setNextNodeID(this.myLastNodeID);
    }

    public void setNextNodeID(int num) {
        this.myLastNodeID = num;
    }

    public int getNextNodeID() {
        return ++this.myLastNodeID;
    }

    public BaseNodeArea findNodeByID(int id) {
        JGoListPosition pos = this.getFirstObjectPos();
        while (pos != null) {
            BaseNodeArea node;
            JGoObject obj = this.getObjectAtPos(pos);
            pos = this.getNextObjectPosAtTop(pos);
            if (!(obj instanceof BaseNodeArea) || (node = (BaseNodeArea)obj).getID() != id) continue;
            return node;
        }
        return null;
    }

    public CollapsedNodeArea findContainedNodeByID(int id) {
        JGoListPosition pos = this.getFirstObjectPos();
        while (pos != null) {
            CollapsedNodeArea node;
            JGoObject obj = this.getObjectAtPos(pos);
            pos = this.getNextObjectPosAtTop(pos);
            if (!(obj instanceof CollapsedNodeArea) || !(node = (CollapsedNodeArea)obj).containsNode(id)) continue;
            return node;
        }
        return null;
    }

    public BaseNodeArea findFlatNodeByID(int id) {
        JGoListPosition pos = this.getFirstObjectPos();
        while (pos != null) {
            BaseNodeArea node;
            JGoObject obj = this.getObjectAtPos(pos);
            pos = this.getNextObjectPosAtTop(pos);
            if (!(obj instanceof ActivityNodeArea ? (node = (BaseNodeArea)obj).getID() == id : obj instanceof CollapsedNodeArea && (node = ((CollapsedNodeArea)obj).getFlatNodeByID(id)) != null)) continue;
            return node;
        }
        return null;
    }

    public void removeModelLinksInvolving(int nodeID) {
        JGoListPosition pos = this.getFirstObjectPos();
        while (pos != null) {
            PredictorLink pl;
            JGoObject obj = this.getObjectAtPos(pos);
            pos = this.getNextObjectPosAtTop(pos);
            if (!(obj instanceof PredictorLink) || (pl = (PredictorLink)obj).getFromNode().getID() != nodeID && pl.getToNode().getID() != nodeID) continue;
            this.removeObject((JGoObject)pl);
            return;
        }
    }

    public BaseLink newLink(JGoPort from, JGoPort to, boolean completelySpecified) {
        BaseLink bl = null;
        if (from instanceof CollapsedNodeArea.CollapsedNodePort || to instanceof CollapsedNodeArea.CollapsedNodePort) {
            CollapsedLink cl = new CollapsedLink(from, to);
            if (from instanceof CollapsedNodeArea.CollapsedNodePort) {
                if (to instanceof CollapsedNodeArea.CollapsedNodePort) {
                    cl.addRepresentedLink(((CollapsedNodeArea.CollapsedNodePort)from).getRepresentedPort(), ((CollapsedNodeArea.CollapsedNodePort)to).getRepresentedPort(), this.isOrthogonalFlows());
                } else {
                    cl.addRepresentedLink(((CollapsedNodeArea.CollapsedNodePort)from).getRepresentedPort(), to, this.isOrthogonalFlows());
                }
            } else if (to instanceof CollapsedNodeArea.CollapsedNodePort) {
                cl.addRepresentedLink(from, ((CollapsedNodeArea.CollapsedNodePort)to).getRepresentedPort(), this.isOrthogonalFlows());
            }
            bl = cl;
        } else {
            bl = new BaseLink(from, to);
        }
        bl.setPen(this.getLinkPen());
        boolean ortho = this.isOrthogonalFlows();
        bl.setOrthogonal(ortho);
        this.addObjectAtHead((JGoObject)bl);
        return bl;
    }

    public BaseLink newCollapsedLink(CollapsedLink collapsedLink) {
        CollapsedLink ll = collapsedLink;
        ll.setPen(this.getLinkPen());
        ((BaseLink)ll).setOrthogonal(this.isOrthogonalFlows());
        this.addObjectAtHead((JGoObject)ll);
        return ll;
    }

    public boolean mapCollNodeInputs() {
        return true;
    }

    public boolean mapCollNodeOutputs() {
        return true;
    }

    public BaseLink findLinkByNodes(BaseNodeArea from, BaseNodeArea to) {
        if (from == null || to == null) {
            return null;
        }
        Vector outputVector = from.getOutputPorts();
        Vector inputVector = to.getInputPorts();
        if (outputVector == null || outputVector.size() == 0) {
            return null;
        }
        if (inputVector == null || inputVector.size() == 0) {
            return null;
        }
        for (int i = 0; i < inputVector.size(); ++i) {
            JGoPort toPort = (JGoPort)inputVector.elementAt(i);
            JGoListPosition pos = toPort.getFirstLinkPos();
            while (pos != null) {
                JGoLink l = toPort.getLinkAtPos(pos);
                pos = toPort.getNextLinkPos(pos);
                JGoPort src = l.getFromPort();
                for (int j = 0; j < outputVector.size(); ++j) {
                    JGoPort fromPort = (JGoPort)outputVector.elementAt(i);
                    if (src != fromPort) continue;
                    return (BaseLink)l;
                }
            }
        }
        return null;
    }

    public JGoPen getLinkPen() {
        return this.myPen;
    }

    public void setLinkPen(JGoPen p) {
        if (!this.getLinkPen().equals(p)) {
            this.myPen = p;
            JGoListPosition pos = this.getFirstObjectPos();
            while (pos != null) {
                JGoObject obj = this.getObjectAtPos(pos);
                pos = this.getNextObjectPosAtTop(pos);
                if (!(obj instanceof JGoLink)) continue;
                JGoLink link = (JGoLink)obj;
                link.setPen(p);
            }
        }
    }

    public boolean isOrthogonalFlows() {
        return this.myOrthoLinks;
    }

    void setOrthogonalFlows(boolean b) {
        if (this.isOrthogonalFlows() != b) {
            this.myOrthoLinks = b;
            JGoListPosition pos = this.getFirstObjectPos();
            while (pos != null) {
                JGoObject obj = this.getObjectAtPos(pos);
                pos = this.getNextObjectPosAtTop(pos);
                if (obj instanceof JGoLink) {
                    JGoLink link = (JGoLink)obj;
                    link.setOrthogonal(b);
                    continue;
                }
                if (!(obj instanceof CollapsedNodeArea)) continue;
                ((CollapsedNodeArea)obj).setLinksOrthogonal(b);
            }
        }
    }

    void toggleOrthogonalFlows() {
        this.myOrthoLinks = !this.isOrthogonalFlows();
        JGoListPosition pos = this.getFirstObjectPos();
        while (pos != null) {
            JGoObject obj = this.getObjectAtPos(pos);
            pos = this.getNextObjectPosAtTop(pos);
            if (obj instanceof JGoLink) {
                JGoLink link;
                link.setOrthogonal(!(link = (JGoLink)obj).isOrthogonal());
                continue;
            }
            if (!(obj instanceof CollapsedNodeArea)) continue;
            ((CollapsedNodeArea)obj).toggleLinksOrthogonal();
        }
    }

    public static WorksheetDocument open() {
        WorksheetDocument doc = null;
        WideFileChooser chooser = new WideFileChooser(SplusSystem.getCwd(), SplusSystem.getServerFileHandler().getServerFileSystemView());
        chooser.addChoosableFileFilter(new WorksheetFileFilter());
        int returnVal = chooser.showOpenDialog(MinerApp.getMainFrame());
        if (returnVal == 0) {
            File curFile = chooser.getSelectedFile();
            SplusSystem.setCwd((File)chooser.getCurrentDirectory());
            doc = WorksheetDocument.open(curFile);
        }
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WorksheetDocument open(File file) {
        FileInputStream fstream = null;
        WorksheetDocument doc = null;
        String loc = file.getAbsolutePath();
        try {
            fstream = new FileInputStream(loc);
            doc = WorksheetDocument.loadXML(fstream, loc);
            if (doc != null) {
                doc.setName(file.getName());
                doc.setUndoManager(new JGoUndoManager());
            }
        }
        catch (IOException x) {
            AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), x.getMessage(), MinerApp.getText("WorksheetDocument_msg_openDocumentError"), 0);
        }
        catch (Exception x) {
            AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), x.getMessage(), MinerApp.getText("WorksheetDocument_msg_loadingDocException"), 0);
        }
        finally {
            try {
                if (fstream != null) {
                    fstream.close();
                }
            }
            catch (Exception x) {}
        }
        return doc;
    }

    public void save() {
        if (this.getLocation().equals("") || this.getIsTemp()) {
            this.saveAs();
        } else {
            this.store();
        }
    }

    public Exception store() {
        return this.store(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Exception store(boolean noDialogs) {
        if (!this.getLocation().equals("")) {
            FileOutputStream fstream = null;
            try {
                File location = new File(this.getLocation()).getParentFile();
                if (location != null && !location.canWrite()) {
                    Exception exception = new Exception("Cannot write to read only location: " + this.getLocation());
                    return exception;
                }
                fstream = new FileOutputStream(this.getLocation());
                this.storeXML(fstream);
                this.setIsTemp(false);
            }
            catch (Exception x) {
                if (noDialogs) {
                    Exception exception = x;
                    return exception;
                }
                AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), x.getMessage(), MinerApp.getText("WorksheetDocument_msg_saveDocumentError"), 0);
            }
            finally {
                try {
                    if (fstream != null) {
                        fstream.close();
                    }
                }
                catch (Exception x) {}
                this.setModified(false);
            }
        }
        return null;
    }

    public void saveAs() {
        String prevStatus;
        File curFile;
        block11: {
            int returnVal;
            curFile = null;
            prevStatus = MinerApp.getMainFrame().getStatusText();
            MinerApp.getMainFrame().setStatusText("Saving " + this.getName());
            WideFileChooser chooser = new WideFileChooser(SplusSystem.getCwd(), SplusSystem.getServerFileHandler().getServerFileSystemView());
            chooser.addChoosableFileFilter(new WorksheetFileFilter());
            chooser.setDialogTitle("Save As");
            String location = this.getLocation();
            if (location.length() > 0) {
                chooser.setSelectedFile(new File(location));
            } else {
                chooser.setSelectedFile(new File(SplusSystem.getCwd() + "/" + this.getName()));
            }
            while ((returnVal = chooser.showSaveDialog(MinerApp.getMainFrame())) == 0) {
                curFile = chooser.getSelectedFile();
                if (!curFile.getName().endsWith(".imw")) {
                    curFile = new File(curFile.getParentFile(), curFile.getName() + ".imw");
                }
                if (!FileUtilities.confirmSaveAs((Component)MinerApp.getMainFrame(), (String)curFile.getAbsolutePath())) {
                    continue;
                }
                break block11;
            }
            curFile = null;
        }
        if (curFile != null) {
            String errorString;
            SplusSystem.setCwd((File)curFile.getParentFile());
            String loc = curFile.getAbsolutePath();
            String name = curFile.getName();
            String origName = this.getName();
            String origLoc = this.getLocation();
            this.setLocation(loc);
            this.setName(name);
            MinerFrame frame = MinerApp.getMainFrame();
            frame.setStatusText("Saving " + name);
            CopyWorksheetThread copyWorksheetThread = new CopyWorksheetThread(this, prevStatus);
            copyWorksheetThread.start();
            while (!copyWorksheetThread.isDone()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                    break;
                }
            }
            if ((errorString = copyWorksheetThread.getErrorString()) != null) {
                AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), errorString, MinerApp.getText("WorksheetDocument_msg_saveDocumentError"), 0);
                this.setLocation(origLoc);
                this.setName(origName);
            }
        } else {
            MinerApp.getMainFrame().setStatusText(prevStatus);
        }
    }

    public static WorksheetDocument loadXML(InputStream ins, String actualPath) throws IOException, UnsupportedOperationException {
        WorksheetDocument doc = new WorksheetDocument(true);
        try {
            XTNetwork network = XTNetwork.readXTNetworkFromFile(ins);
            if (network == null) {
                throw new SAXParseException("Input is not a Worksheet", null);
            }
            doc.m_pre_version_7_0 = network.isPreVersion70();
            doc.myLastNodeID = Integer.parseInt(network.getLastUsedID());
            doc.setLocation(actualPath);
            boolean orthogonal = network.getLinkType().equals(XTNetwork.ORTHOGONAL_LINK_ATTRIBUTE_TAG);
            doc.setOrthogonalFlows(orthogonal);
            doc.setAuthor(network.getFileInfoAuthor());
            doc.setVersion(network.getFileInfoVersion());
            try {
                doc.setCreatedDate(new Long(network.getFileInfoCreated()));
            }
            catch (Exception e) {
                doc.setCreatedDate(0L);
            }
            try {
                doc.setComments(network.getComments().getXML());
            }
            catch (Exception e) {
                Date now = new Date(System.currentTimeMillis());
                SimpleDateFormat df = new SimpleDateFormat("MMMMMMMMM dd, yyyy");
                doc.setComments(CommentUtilities.createNewComments(null, MinerApp.getUserName(), df.format(now)));
            }
            doc.setWorksheetProperties(network.getWorksheetProperties());
            doc.setWorksheetParameters(network.getWorksheetParameters());
            boolean prevDeep = ActivityNodeState.isDeepMode();
            ActivityNodeState.setDeepMode(false);
            WorksheetDocument.loadElements(doc, network);
            ActivityNodeState.setDeepMode(prevDeep);
            boolean isCollapsing = doc.isCollapsing();
            doc.setCollapseTransaction(true);
            WorksheetDocument.removeTempObjects(doc);
            doc.setCollapseTransaction(isCollapsing);
        }
        catch (SAXParseException spe) {
            AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), MinerApp.getText("WorksheetDocument_msg_fileisCorrupted"), MinerApp.getText("WorksheetDocument_msg_fileParsingError"), 0);
            doc = null;
        }
        catch (SAXException sxe) {
            Exception x = sxe;
            if (sxe.getException() != null) {
                x = sxe.getException();
            }
            x.printStackTrace();
            doc = null;
        }
        catch (ClassNotFoundException cnfe) {
            String msg = MinerApp.getText("WorksheetDocument_msg_classNotFound") + " " + cnfe.getMessage();
            AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), msg, MinerApp.getText("WorksheetDocument_msg_fileParseError"), 0);
            doc = null;
        }
        catch (Exception x) {
            x.printStackTrace();
            AcceleratorOptionPane.showOKDialog(MinerApp.getMainFrame(), MinerApp.getText("WorksheetDocument_msg_fileisCorrupted"), MinerApp.getText("WorksheetDocument_msg_fileParsingError"), 0);
            doc = null;
        }
        return doc;
    }

    private static void loadElements(WorksheetDocument doc, XTNetwork network) throws InvocationTargetException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InstantiationException {
        Vector visNodes = network.getVisibleNodesInfo();
        HashMap lazyModelLinks = new HashMap();
        for (int i = 0; i < visNodes.size(); ++i) {
            Object obj = visNodes.get(i);
            if (obj instanceof XTNetwork.NodeInfo) {
                XTNetwork.NodeInfo info = (XTNetwork.NodeInfo)obj;
                ActivityNodeArea area = ActivityNodeArea.buildActivityNodeFromInfo(info);
                if (area == null) continue;
                doc.addObjectAtTail((JGoObject)area);
                area.getNodeModel().setDocument(doc);
                continue;
            }
            if (obj instanceof XTNetwork.CollapsedNodeInfo) {
                CollapsedNodeArea.buildCollapsedNodeFromInfo(network, doc, (XTNetwork.CollapsedNodeInfo)obj, null, lazyModelLinks);
                continue;
            }
            if (!(obj instanceof XTNetwork.TextNodeInfo)) continue;
        }
        Vector textNodes = network.getTextNodes();
        for (int i = 0; i < textNodes.size(); ++i) {
            XTNetwork.TextNodeInfo obj = (XTNetwork.TextNodeInfo)textNodes.get(i);
            MinerTextNode mtn = MinerTextNode.buildTextNodeFromInfo(obj);
            if (mtn == null) continue;
            doc.addObjectAtTail((JGoObject)mtn);
        }
        for (XTNetwork.ModelLinkInfo mli : lazyModelLinks.keySet()) {
            CollapsedNodeArea cna = (CollapsedNodeArea)lazyModelLinks.get(mli);
            PredictorLink pl = PredictorLink.buildLinkFromInfo(mli, doc);
            doc.addObjectAtHead((JGoObject)pl);
            cna.addPredictorLink(pl);
        }
        Vector visLinks = network.getVisibleLinksInfo();
        for (int i = 0; i < visLinks.size(); ++i) {
            Object obj = visLinks.get(i);
            if (obj instanceof XTNetwork.ModelLinkInfo) {
                boolean coll = doc.isCollapsing();
                doc.setCollapseTransaction(true);
                PredictorLink.buildLinkFromInfo((XTNetwork.ModelLinkInfo)obj, doc);
                doc.setCollapseTransaction(coll);
                continue;
            }
            if (obj instanceof XTNetwork.LinkInfo) {
                BaseLink.buildLinkFromInfo((XTNetwork.LinkInfo)obj, doc);
                continue;
            }
            if (!(obj instanceof XTNetwork.ExternalLinkInfo)) continue;
            CollapsedLink.buildLinkFromInfo((XTNetwork.ExternalLinkInfo)obj, doc);
        }
    }

    public static void storeForRemoval(JGoObject obj) {
        if (tempObjects == null) {
            tempObjects = new Vector();
        }
        tempObjects.add(obj);
    }

    public static void removeTempObjects(WorksheetDocument doc) {
        if (tempObjects != null) {
            for (int i = 0; i < tempObjects.size(); ++i) {
                JGoObject remObj = (JGoObject)tempObjects.elementAt(i);
                doc.removeObject(remObj);
            }
        }
    }

    public void storeXML(FileOutputStream outs) throws IOException, UnsupportedOperationException {
        try {
            XTNetwork net = this.createNetwork();
            net.saveToFile(outs);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    public XTNetwork getXTNetwork() throws Exception {
        try {
            return this.createNetwork();
        }
        catch (Exception x) {
            x.printStackTrace();
            return null;
        }
    }

    public XTNetwork createNetwork() {
        XTNetwork net = null;
        try {
            net = new XTNetwork();
            if (this.m_comments != null) {
                net.setComments(this.m_comments);
            }
            if (this.m_worksheetProperties != null) {
                net.setWorksheetProperties((XTProps)this.m_worksheetProperties.copy());
            }
            if (this.m_worksheetParameters != null) {
                net.setWorksheetParameters((XTProps)this.m_worksheetParameters.copy());
            }
            net.setFileInfo(this.getAuthor(), this.getVersion(), this.getLocation(), Long.toString(this.getCreatedDate()));
            net.setLastUsedID(Integer.toString(this.myLastNodeID));
            if (this.isOrthogonalFlows()) {
                net.setLinkType(XTNetwork.ORTHOGONAL_LINK_ATTRIBUTE_TAG);
            } else {
                net.setLinkType(XTNetwork.DIAGONAL_LINK_ATTRIBUTE_TAG);
            }
            JGoListPosition pos = this.getFirstObjectPos();
            while (pos != null) {
                JGoObject obj = this.getObjectAtPos(pos);
                pos = this.getNextObjectPosAtTop(pos);
                if (obj instanceof ActivityNodeArea) {
                    XTNetwork.NodeInfo info = ((ActivityNodeArea)obj).getNodeInfo();
                    info.container = null;
                    net.addFlatNode(info);
                    continue;
                }
                if (obj instanceof CollapsedNodeArea) {
                    net.addCollapsedNode(((CollapsedNodeArea)obj).createCollapsedNodeInfo(net));
                    continue;
                }
                if (obj instanceof MinerTextNode) {
                    net.addTextNode(((MinerTextNode)obj).createTextNodeInfo());
                    continue;
                }
                if (obj instanceof CollapsedLink) {
                    net.addExternalLink(((CollapsedLink)obj).createExternalLinkInfo(net));
                    continue;
                }
                if (obj instanceof PredictorLink) {
                    net.addModelLink(((PredictorLink)obj).createLinkInfo(net));
                    continue;
                }
                if (!(obj instanceof BaseLink)) continue;
                net.addFlatLink(((BaseLink)obj).createLinkInfo(net));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return net;
    }

    public void getAvailableNodes(boolean from, Vector normalList, Vector modelList) {
        JGoListPosition pos = this.getFirstObjectPos();
        while (pos != null) {
            JGoObject obj = this.getObjectAtPos(pos);
            if (obj instanceof ActivityNodeArea) {
                ActivityNodeModel mod = ((ActivityNodeArea)obj).getNodeModel();
                if (from) {
                    Vector oPorts = ((ActivityNodeArea)obj).getOutputPorts();
                    if (oPorts != null && oPorts.size() > 0) {
                        normalList.add(obj);
                    }
                    if (mod instanceof PMMLExportable) {
                        modelList.add(obj);
                    }
                } else {
                    PredictorPort port;
                    Vector iPorts = ((ActivityNodeArea)obj).getInputPorts();
                    if (iPorts != null) {
                        for (int i = 0; i < iPorts.size(); ++i) {
                            BaseNodePort iPort = (BaseNodePort)((Object)iPorts.get(i));
                            if (iPort.isSingle() && iPort.getNumLinks() != 0) continue;
                            normalList.add(obj);
                            break;
                        }
                    }
                    if (mod instanceof PMMLImportable && (port = ((ActivityNodeArea)obj).getModelLinkInputPort()).getNumLinks() == 0) {
                        modelList.add(obj);
                    }
                }
            }
            pos = this.getNextObjectPos(pos);
        }
    }

    public JGoListPosition getPrevObjectPosAtTop(JGoListPosition pos) {
        if (pos == null) {
            return null;
        }
        JGoObject obj = this.getObjectAtPos(pos);
        while (obj.getParent() != null) {
            pos = this.findObject((JGoObject)obj.getParent());
            obj = obj.getParent();
        }
        if ((pos = this.getPrevObjectPos(pos)) == null) {
            JGoLayer layer = obj.getLayer();
            for (layer = layer.getNextLayer(); layer != null; layer = layer.getNextLayer()) {
                JGoListPosition firstpos = layer.getFirstObjectPos();
                if (firstpos == null) continue;
                return firstpos;
            }
        }
        return pos;
    }

    private void copyLoop(JGoObjectSimpleCollection coll, Point offset, JGoCopyEnvironment map, boolean copyBaseNodeAreas) {
        JGoObject obj;
        Point oldloc = new Point();
        JGoListPosition pos = coll.getFirstObjectPos();
        while (pos != null) {
            JGoObject newobj;
            obj = coll.getObjectAtPos(pos);
            pos = coll.getNextObjectPosAtTop(pos);
            boolean notLink = (obj = obj.getTopLevelObject()) instanceof BaseNodeArea || obj instanceof MinerTextNode;
            if (notLink != copyBaseNodeAreas || (newobj = obj.copyObject(map)) == null) continue;
            oldloc = newobj.getLocation(oldloc);
            newobj.setLocationOffset(oldloc, offset);
            JGoLayer oldlayer = obj.getLayer();
            JGoLayer newlayer = null;
            if (oldlayer != null) {
                newlayer = oldlayer.getDocument() == this ? oldlayer : this.findLayer(oldlayer.getIdentifier());
            }
            if (newlayer == null) {
                newlayer = this.getDefaultLayer();
            }
            if (newobj instanceof CollapsedNodeArea) {
                ((CollapsedNodeArea)newobj).hiddenExpandForState(this);
                ((CollapsedNodeArea)newobj).addStateVisualCue();
            }
            if (newobj instanceof BaseLink) {
                newlayer.addObjectAtHead(newobj);
                continue;
            }
            newlayer.addObjectAtTail(newobj);
        }
        if (copyBaseNodeAreas) {
            pos = coll.getFirstObjectPos();
            while (pos != null) {
                obj = coll.getObjectAtPos(pos).getTopLevelObject();
                pos = coll.getNextObjectPosAtTop(pos);
                if (!(obj instanceof ActivityNodeArea)) continue;
                ActivityNodeArea newobj = (ActivityNodeArea)map.get((Object)obj);
                newobj.updateModelInfo(map, (ActivityNodeArea)obj);
            }
        }
    }

    public JGoCopyEnvironment ourCopyFromCollection(JGoObjectSimpleCollection coll, Point offset, JGoCopyEnvironment map) {
        if (map == null) {
            map = this.createDefaultCopyEnvironment();
        }
        this.copyLoop(coll, offset, map, true);
        this.copyLoop(coll, offset, map, false);
        Vector delayeds = map.getDelayeds();
        for (int i = 0; i < delayeds.size(); ++i) {
            Object obj = delayeds.get(i);
            if (!(obj instanceof JGoLink)) continue;
            JGoLink oldlink = (JGoLink)obj;
            JGoLink newlink = (JGoLink)map.get((Object)oldlink);
            JGoPort oldFromP = oldlink.getFromPort();
            JGoPort oldToP = oldlink.getToPort();
            JGoPort newFromP = (JGoPort)map.get((Object)oldFromP);
            JGoPort newToP = (JGoPort)map.get((Object)oldToP);
            if (newFromP != null && newToP != null) {
                newlink.setFromPort(newFromP);
                newlink.setToPort(newToP);
                continue;
            }
            this.removeObject((JGoObject)newlink);
        }
        return map;
    }

    public JGoCopyEnvironment copyFromCollection(JGoObjectSimpleCollection coll, Point offset, JGoCopyEnvironment map) {
        JGoCopyEnvironment copyEnvironment = this.ourCopyFromCollection(coll, offset, map);
        JGoCopyMap filteredMap = new JGoCopyMap();
        JGoListPosition pos = coll.getFirstObjectPos();
        while (pos != null) {
            JGoObject obj = coll.getObjectAtPos(pos).getTopLevelObject();
            if (obj instanceof CollapsedNodeArea && !filteredMap.containsKey((Object)obj)) {
                CollapsedNodeArea newObj = (CollapsedNodeArea)copyEnvironment.get((Object)obj);
                newObj.adjustContainedNodesLocation(offset);
            }
            filteredMap.put((Object)obj, copyEnvironment.get((Object)obj));
            pos = coll.getNextObjectPos(pos);
        }
        Vector<JGoObject> needsToBeRemoved = new Vector<JGoObject>();
        Iterator keys = copyEnvironment.keySet().iterator();
        while (keys.hasNext()) {
            JGoObject key = ((JGoObject)keys.next()).getTopLevelObject();
            if (filteredMap.containsKey((Object)key)) continue;
            needsToBeRemoved.add(key);
        }
        for (int i = needsToBeRemoved.size() - 1; i >= 0; --i) {
            copyEnvironment.remove(needsToBeRemoved.get(i));
        }
        return copyEnvironment;
    }

    public void copyNewValueForRedo(JGoDocumentChangedEdit e) {
        switch (e.getHint()) {
            case 65536: {
                e.setNewValue((Object)this.getName());
                return;
            }
            case 65537: {
                e.setNewValue((Object)this.getLocation());
                return;
            }
        }
        super.copyNewValueForRedo(e);
    }

    public void changeValue(JGoDocumentChangedEdit e, boolean undo) {
        Object obj = e.getObject();
        switch (e.getHint()) {
            case 65536: {
                this.setName((String)e.getValue(undo));
                return;
            }
            case 65537: {
                this.setLocation((String)e.getValue(undo));
                return;
            }
        }
        if (obj instanceof StateVisualCueImage) {
            return;
        }
        super.changeValue(e, undo);
    }

    public void undo() {
        JGoUndoManager m = this.getUndoManager();
        if (m != null) {
            try {
                String presName = m.getUndoPresentationName();
                if (presName.endsWith("Expanding Collapsed Nodes") || presName.endsWith("Expanding All Collapsed Nodes") || presName.endsWith("Creating Collapsed Nodes")) {
                    boolean isCollapsing = this.isCollapsing();
                    this.setCollapseTransaction(true);
                    m.undo();
                    this.setCollapseTransaction(isCollapsing);
                } else {
                    m.undo();
                }
                this.update();
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
        }
    }

    public void redo() {
        JGoUndoManager m = this.getUndoManager();
        if (m != null) {
            try {
                String presName = m.getRedoPresentationName();
                if (presName.endsWith("Expanding Collapsed Nodes") || presName.endsWith("Expanding All Collapsed Nodes") || presName.endsWith("Creating Collapsed Nodes")) {
                    boolean isCollapsing = this.isCollapsing();
                    this.setCollapseTransaction(true);
                    m.redo();
                    this.setCollapseTransaction(isCollapsing);
                } else {
                    m.redo();
                }
                this.update();
            }
            catch (CannotRedoException cannotRedoException) {
                // empty catch block
            }
        }
    }

    public void endTransaction(String pname) {
        super.endTransaction(pname);
        AppAction.updateAllActions();
    }

    public static DataFlavor getLocalJVMDataFlavor() {
        if (m_localJVMDataFlavor == null) {
            try {
                m_localJVMDataFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=com.nwoods.jgo.JGoSelection", "JGo Selection");
                DataFlavor[] v = new DataFlavor[]{m_localJVMDataFlavor};
                m_localJVMDataFlavors = v;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return m_localJVMDataFlavor;
    }

    public DataFlavor[] getTransferDataFlavors() {
        WorksheetDocument.getLocalJVMDataFlavor();
        return m_localJVMDataFlavors;
    }

    public boolean isDataFlavorSupported(DataFlavor f) {
        return f.equals(WorksheetDocument.getLocalJVMDataFlavor());
    }

    public synchronized Object getTransferData(DataFlavor f) throws UnsupportedFlavorException, IOException {
        if (f.equals(WorksheetDocument.getLocalJVMDataFlavor())) {
            return this;
        }
        throw new UnsupportedFlavorException(f);
    }

    public boolean isEngineNetworkDirty() {
        return this.myIsEngineNetworkDirty;
    }

    public void setEngineNetworkDirty() {
        this.myIsEngineNetworkDirty = true;
    }

    public void resetEngineNetworkDirty() {
        this.myIsEngineNetworkDirty = false;
    }

    public void setCollapseTransaction(boolean collapsing) {
        this.collapsingTransaction = collapsing;
    }

    public boolean isCollapsing() {
        return this.collapsingTransaction;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
    }

    static {
        tempObjects = null;
    }

    public class CopyWorksheetThread
    extends Thread {
        private WorksheetDocument doc = null;
        private String prevStatus = null;
        private String errorString = null;
        private boolean done = false;

        public CopyWorksheetThread(WorksheetDocument doc, String prevStatus) {
            this.doc = doc;
            this.prevStatus = prevStatus;
            this.done = false;
        }

        public String getErrorString() {
            return this.errorString;
        }

        public boolean isDone() {
            return this.done;
        }

        public void run() {
            try {
                MinerFrame frame = MinerApp.getMainFrame();
                frame.setStatusText("Copying worksheet files to new directory.");
                Component comp = frame.getGlassPane();
                Cursor oldCursor = comp.getCursor();
                comp.setCursor(Cursor.getPredefinedCursor(3));
                MouseAdapter ma = new MouseAdapter(){};
                KeyAdapter ka = new KeyAdapter(){};
                comp.addMouseListener(ma);
                comp.addKeyListener(ka);
                comp.setVisible(true);
                Exception e = WorksheetDocument.this.store(true);
                String string = this.errorString = e == null ? null : e.getMessage();
                if (e == null) {
                    MinerApp.changeDocWorksheetDir(this.doc, true);
                }
                comp.setCursor(oldCursor);
                comp.removeKeyListener(ka);
                comp.removeMouseListener(ma);
                comp.setVisible(false);
                frame.setStatusText(this.prevStatus);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.done = true;
        }
    }

    private static class LimitedUndoManager
    extends JGoUndoManager {
        public LimitedUndoManager() {
            this.getAllEdits().ensureCapacity(MAX_NUM_UNDO);
            this.setLimit(MAX_NUM_UNDO);
        }

        protected void trimEdits(int from, int to) {
            super.trimEdits(from, to);
            System.gc();
        }
    }
}

