/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.AcceleratorOptionPane;
import com.insightful.miner.MinerApp;
import com.insightful.miner.NodeDialog;
import com.insightful.miner.ReadOtherFileDialog;
import com.insightful.miner.XTProps;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class WriteOtherFileDialog
extends NodeDialog {
    private JComboBox typeComboBox;
    protected JTextField fileNameTextField;
    private JTextField m_accessTableTextField;
    private JLabel accessLabel;
    private static String[] typeCodeList = new String[]{"DBASE", "GAUSS", "GAUSS96", "LOTUS", "MATLAB", "ACCESS97", "ACCESS2K", "MINITAB", "QUATTRO", "SPSS", "SPSSP", "STATA", "SYSTAT"};
    private static String[] m_typeDescriptionList = new String[]{"dBASE File (*.dbf)", "Gauss Data File (*.dat)", "Gauss Data File - Unix (*.dat)", "Lotus 1-2-3 (*.wks;*.wk1;*.wk3;*.wk4;*.wrk)", "Matlab Matrix (*.mat)", "Microsoft Access 97 (*.mdb)", "Microsoft Access 2000 (*.mdb)", "Mintab Workbook (*.mtw)", "Quattro Pro Worksheet (*.wq1;*.wb2;*.wb3)", "SPSS Data File (*.sav)", "SPSS Portable Data File (*.por)", "Stata Data File (*.dta)", "Systat File (*.syd, *.sys)"};
    private static String[][] m_extensionList = new String[][]{{".dbf"}, {".dat"}, {".dat"}, {".wks", ".wk1", ".wk3", ".wk4", ".wrk"}, {".mat"}, {".mdb"}, {".mdb"}, {".mtw"}, {".wq1", ".wb2", ".wb3"}, {".sav"}, {".por"}, {".dta"}, {".syd", ".sys"}};
    private AbstractAction fileNameTextFieldAction;
    private AbstractAction typeComboBoxAction;
    private AbstractAction saveAsAction;
    private static WriteOtherFileDialog instance = null;

    public static WriteOtherFileDialog getInstance() {
        if (instance == null) {
            instance = new WriteOtherFileDialog();
        }
        return instance;
    }

    protected WriteOtherFileDialog() {
        this.setResizable(true);
        this.setSize(440, 400);
        this.setMinimumSize(new Dimension(440, 400));
    }

    public void onOk() {
        if (WriteOtherFileDialog.hasFilenameChanged(this.fileNameTextField, this.getNodeModel().getXTProps()) && !ReadOtherFileDialog.checkOverWriteFile(this, this.fileNameTextField.getText())) {
            return;
        }
        super.onOk();
    }

    public void restoreProperties() {
        super.restoreProperties();
        XTProps props = this.getNodeModel().getXTProps();
        this.restoreWriteProperties(props);
    }

    void restoreWriteProperties(XTProps props) {
        String type = props.getValue("fileType", "ACCESS97");
        if (type.equals("ACCESS")) {
            type = "ACCESS97";
        }
        ReadOtherFileDialog.setComboBoxFromTypeString(type, typeCodeList, this.typeComboBox);
        this.setAccessLabelEnabled();
        this.fileNameTextField.setText(props.getValue("filePath", ""));
        this.m_accessTableTextField.setText(props.getValue("dbTable", ""));
    }

    private void setAccessLabelEnabled() {
        int selectedIndex = this.typeComboBox.getSelectedIndex();
        boolean isMDB = selectedIndex >= 0 && selectedIndex < m_extensionList.length && m_extensionList[selectedIndex][0].equals(".mdb");
        this.m_accessTableTextField.setEnabled(isMDB);
        this.accessLabel.setEnabled(isMDB);
    }

    public void saveProperties() throws NodeDialog.DialogException {
        super.saveProperties();
        XTProps props = this.getNodeModel().getXTProps();
        this.saveWriteProperties(props);
    }

    void saveWriteProperties(XTProps props) throws NodeDialog.DialogException {
        int sel;
        String path = this.fileNameTextField.getText();
        if (WriteOtherFileDialog.hasFilenameChanged(this.fileNameTextField, this.getNodeModel().getXTProps())) {
            WriteOtherFileDialog.directoryCreationCheck(this.tabbedPane, path);
        }
        if ((sel = this.typeComboBox.getSelectedIndex()) < 0) {
            throw new NodeDialog.DialogException("Unrecognized file type.  Please select file type.");
        }
        props.set("filePath", path);
        props.set("fileType", typeCodeList[sel]);
        props.set("dbTable", this.m_accessTableTextField.getText());
    }

    public void createActions() {
        super.createActions();
        this.fileNameTextFieldAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.checkWriteFileName(WriteOtherFileDialog.this.fileNameTextField, m_extensionList, WriteOtherFileDialog.this.typeComboBox);
            }
        };
        this.typeComboBoxAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.checkFileNameOnComboBoxAction(WriteOtherFileDialog.this.fileNameTextField, m_extensionList, WriteOtherFileDialog.this.typeComboBox);
            }
        };
        this.saveAsAction = new AbstractAction(MinerApp.getText("WriteTextFileDialog_browse")){

            public void actionPerformed(ActionEvent e) {
                ReadOtherFileDialog.browseWriteFileName(instance, WriteOtherFileDialog.this.fileNameTextField, m_extensionList, m_typeDescriptionList, WriteOtherFileDialog.this.typeComboBox);
            }
        };
    }

    public JPanel createOptionsPanel() {
        JPanel optionsPanel = new JPanel(new BorderLayout());
        optionsPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JPanel saveFilePanel = new JPanel(new GridBagLayout());
        this.fileNameTextField = new JTextField(30);
        this.fileNameTextField.setAction(this.fileNameTextFieldAction);
        this.fileNameTextField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (!e.isTemporary() && WriteOtherFileDialog.hasFilenameChanged(WriteOtherFileDialog.this.fileNameTextField, WriteOtherFileDialog.this.getNodeModel().getXTProps())) {
                    ReadOtherFileDialog.checkWriteFileName(WriteOtherFileDialog.this.fileNameTextField, m_extensionList, WriteOtherFileDialog.this.typeComboBox);
                }
            }
        });
        JLabel fileNameLabel = new JLabel(MinerApp.getText("WriteTextFileDialog_filename"));
        fileNameLabel.setDisplayedMnemonic(70);
        JButton browseButton = new JButton(this.saveAsAction);
        browseButton.setMnemonic('b');
        fileNameLabel.setLabelFor(browseButton);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(5, 5, 5, 5);
        constraints.gridwidth = 2;
        constraints.weightx = 0.0;
        saveFilePanel.add((Component)fileNameLabel, constraints);
        constraints.gridwidth = 6;
        constraints.gridx = 2;
        constraints.weightx = 1.0;
        constraints.fill = 2;
        saveFilePanel.add((Component)this.fileNameTextField, constraints);
        constraints.gridx = 8;
        constraints.weightx = 0.0;
        constraints.gridwidth = 2;
        constraints.fill = 0;
        saveFilePanel.add((Component)browseButton, constraints);
        JPanel moreOptionsPanel = new JPanel(new GridBagLayout());
        moreOptionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MinerApp.getText("ReadTextFileDialog_options")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        JLabel typeLabel = new JLabel(MinerApp.getText("WriteOtherFileDialog_type"));
        typeLabel.setDisplayedMnemonic(84);
        this.typeComboBox = new JComboBox<String>(m_typeDescriptionList);
        this.typeComboBox.setAction(this.typeComboBoxAction);
        this.typeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WriteOtherFileDialog.this.setAccessLabelEnabled();
            }
        });
        typeLabel.setLabelFor(this.typeComboBox);
        this.accessLabel = new JLabel(MinerApp.getText("ReadOtherFileDialog_accessTable"));
        this.m_accessTableTextField = new JTextField(25);
        this.typeComboBox.setPreferredSize(this.m_accessTableTextField.getPreferredSize());
        this.accessLabel.setDisplayedMnemonic('a');
        this.accessLabel.setLabelFor(this.m_accessTableTextField);
        GridBagConstraints optionsConstraints = new GridBagConstraints();
        optionsConstraints.anchor = 18;
        moreOptionsPanel.add((Component)typeLabel, optionsConstraints);
        optionsConstraints.gridx = 1;
        optionsConstraints.weightx = 1.0;
        optionsConstraints.insets = new Insets(0, 15, 0, 0);
        moreOptionsPanel.add((Component)this.typeComboBox, optionsConstraints);
        optionsConstraints.gridy = 2;
        optionsConstraints.gridx = 0;
        optionsConstraints.weightx = 0.0;
        optionsConstraints.insets = new Insets(0, 0, 0, 0);
        moreOptionsPanel.add((Component)this.accessLabel, optionsConstraints);
        optionsConstraints.gridx = 1;
        optionsConstraints.weightx = 1.0;
        optionsConstraints.weighty = 1.0;
        optionsConstraints.insets = new Insets(0, 15, 0, 0);
        moreOptionsPanel.add((Component)this.m_accessTableTextField, optionsConstraints);
        optionsPanel.add((Component)saveFilePanel, "North");
        optionsPanel.add((Component)moreOptionsPanel, "Center");
        return optionsPanel;
    }

    public static boolean hasFilenameChanged(JTextField tf, XTProps props) {
        String original;
        String current = tf.getText();
        return !current.equals(original = props.getValue("filePath", ""));
    }

    public static void directoryCreationCheck(JComponent comp, String fullPath) throws NodeDialog.DialogException {
        File file = new File(fullPath);
        String fileName = file.getName();
        if (fullPath.equals(fileName)) {
            return;
        }
        String onlyPath = fullPath.substring(0, fullPath.length() - fileName.length());
        File path = new File(onlyPath);
        if (!path.exists()) {
            String msg = MinerApp.getText("WriteOtherFileDialog_msg_directory") + " (" + onlyPath + ") " + MinerApp.getText("WriteOtherFileDialog_msg_doesnotExist") + "\n" + MinerApp.getText("WriteOtherFileDialog_msg_doYouWantCreateDir");
            int result = AcceleratorOptionPane.showYesNoCancelDialog(comp, msg, MinerApp.getText("WriteOtherFileDialog_msg_createDirectory"), 3);
            if (result == 0) {
                if (!path.mkdirs()) {
                    String str = MinerApp.getText("WriteOtherFileDialog_msg_couldnotCreateDir") + " (" + onlyPath + ").";
                    throw new NodeDialog.DialogException(str);
                }
            } else if (result == 2) {
                throw new NodeDialog.DialogException("");
            }
        }
    }
}

