/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner;

import com.insightful.miner.ColumnDefinitions;
import com.insightful.miner.ColumnStats;
import com.insightful.miner.XMLTree;
import java.util.List;
import java.util.Vector;
import org.w3c.dom.Element;

public class XMLTreeMetaData
extends XMLTree
implements Cloneable {
    private int numColumns = 0;
    private Element metaDataRootNode = null;
    private ColumnDefinitions dataDictionary = null;
    private ColumnStats dataStats = null;
    public static String META_DATA_NODE_TAG = "XTMetaData";
    public static String DATA_DICTIONARY_NODE_TAG = ColumnDefinitions.DATA_DICTIONARY_NODE_TAG;
    public static String DATA_FIELD_NODE_TAG = ColumnDefinitions.DATA_FIELD_NODE_TAG;
    public static String FIELD_COUNT_ATTRIBUTE_TAG = ColumnDefinitions.FIELD_COUNT_ATTRIBUTE_TAG;
    public static String LEVEL_NODE_TAG = ColumnDefinitions.LEVEL_NODE_TAG;
    public static String NAME_ATTRIBUTE_TAG = ColumnDefinitions.NAME_ATTRIBUTE_TAG;
    public static String TYPE_ATTRIBUTE_TAG = ColumnDefinitions.TYPE_ATTRIBUTE_TAG;
    public static String CONTINUOUS_TYPE_ATTRIBUTE_TAG = ColumnDefinitions.CONTINUOUS_TYPE_ATTRIBUTE_TAG;
    public static String CATEGORICAL_TYPE_ATTRIBUTE_TAG = ColumnDefinitions.CATEGORICAL_TYPE_ATTRIBUTE_TAG;
    public static String STRING_TYPE_ATTRIBUTE_TAG = ColumnDefinitions.STRING_TYPE_ATTRIBUTE_TAG;
    public static String DATE_TIME_TYPE_ATTRIBUTE_TAG = ColumnDefinitions.DATE_TIME_TYPE_ATTRIBUTE_TAG;
    public static String BLOB_TYPE_ATTRIBUTE_TAG = ColumnDefinitions.BLOB_TYPE_ATTRIBUTE_TAG;
    public static String BLOB_CLASS_NAME_ATTRIBUTE_TAG = ColumnDefinitions.BLOB_CLASS_NAME_ATTRIBUTE_TAG;
    public static String ROLE_ATTRIBUTE_TAG = ColumnDefinitions.ROLE_ATTRIBUTE_TAG;
    public static String DEPENDENT_ROLE_ATTRIBUTE_TAG = ColumnDefinitions.DEPENDENT_ROLE_ATTRIBUTE_TAG;
    public static String INDEPENDENT_ROLE_ATTRIBUTE_TAG = ColumnDefinitions.INDEPENDENT_ROLE_ATTRIBUTE_TAG;
    public static String INFORMATION_ROLE_ATTRIBUTE_TAG = ColumnDefinitions.INFORMATION_ROLE_ATTRIBUTE_TAG;
    public static String PREDICTION_ROLE_ATTRIBUTE_TAG = ColumnDefinitions.PREDICTION_ROLE_ATTRIBUTE_TAG;
    public static String VALUE_ATTRIBUTE_TAG = ColumnDefinitions.VALUE_ATTRIBUTE_TAG;
    public static String WIDTH_ATTRIBUTE_TAG = ColumnDefinitions.WIDTH_ATTRIBUTE_TAG;
    public static String DATA_STATS_NODE_TAG = ColumnStats.DATA_STATS_NODE_TAG;
    public static String TABLE_STATS_NODE_TAG = ColumnStats.TABLE_STATS_NODE_TAG;
    public static String UNIVARIATE_STATS_NODE_TAG = ColumnStats.UNIVARIATE_STATS_NODE_TAG;
    public static String FIELD_ATTRIBUTE_TAG = ColumnStats.FIELD_ATTRIBUTE_TAG;
    public static String COUNTS_NODE_TAG = ColumnStats.COUNTS_NODE_TAG;
    public static String CONTINUOUS_STATS_NODE_TAG = ColumnStats.CONTINUOUS_STATS_NODE_TAG;
    public static String CATEGORY_NODE_TAG = ColumnStats.CATEGORY_NODE_TAG;
    public static String NUMERIC_INFO_NODE_TAG = ColumnStats.NUMERIC_INFO_NODE_TAG;
    public static String QUANTILE_NODE_TAG = ColumnStats.QUANTILE_NODE_TAG;
    public static String ROW_COUNT_ATTRIBUTE_TAG = ColumnStats.ROW_COUNT_ATTRIBUTE_TAG;
    public static String TOTAL_FREQUENCY_ATTRIBUTE_TAG = ColumnStats.TOTAL_FREQUENCY_ATTRIBUTE_TAG;
    public static String MISSING_FREQUENCY_ATTRIBUTE_TAG = ColumnStats.MISSING_FREQUENCY_ATTRIBUTE_TAG;
    public static String FREQUENCY_ATTRIBUTE_TAG = ColumnStats.FREQUENCY_ATTRIBUTE_TAG;
    public static String MINIMUM_ATTRIBUTE_TAG = ColumnStats.MINIMUM_ATTRIBUTE_TAG;
    public static String MAXIMUM_ATTRIBUTE_TAG = ColumnStats.MAXIMUM_ATTRIBUTE_TAG;
    public static String MEAN_ATTRIBUTE_TAG = ColumnStats.MEAN_ATTRIBUTE_TAG;
    public static String STANDARD_DEVIATION_ATTRIBUTE_TAG = ColumnStats.STANDARD_DEVIATION_ATTRIBUTE_TAG;
    public static String MEDIAN_ATTRIBUTE_TAG = ColumnStats.MEDIAN_ATTRIBUTE_TAG;
    public static String IQR_ATTRIBUTE_TAG = ColumnStats.IQR_ATTRIBUTE_TAG;
    public static String LIMIT_ATTRIBUTE_TAG = ColumnStats.QUANTILE_LIMIT_ATTRIBUTE_TAG;
    public static String QUANTILE_LIMIT_ATTRIBUTE_TAG = ColumnStats.QUANTILE_LIMIT_ATTRIBUTE_TAG;
    public static String QUANTILE_VALUE_ATTRIBUTE_TAG = ColumnStats.QUANTILE_VALUE_ATTRIBUTE_TAG;

    public XMLTreeMetaData() throws Exception {
        this.metaDataRootNode = this.m_document.createElement(META_DATA_NODE_TAG);
        this.m_xml.appendChild(this.metaDataRootNode);
        this.dataDictionary = new ColumnDefinitions(this.m_document);
        this.metaDataRootNode.appendChild(this.dataDictionary.getElement());
        this.dataStats = new ColumnStats(this.m_document);
        this.metaDataRootNode.appendChild(this.dataStats.getElement());
    }

    public XMLTreeMetaData(Element elt) throws Exception {
        super(elt);
        this.metaDataRootNode = this.m_xml.getNodeName().equals(XMLTree.IMML_NODE_TAG) ? (Element)this.m_xml.getFirstChild() : this.m_xml;
        if (this.metaDataRootNode == null) {
            throw new Exception("Root node was not found.");
        }
        if (!this.metaDataRootNode.getNodeName().equals(META_DATA_NODE_TAG)) {
            throw new Exception("Malformed XML: " + META_DATA_NODE_TAG + " tag was missing.");
        }
        Element dict = (Element)this.metaDataRootNode.getFirstChild();
        this.dataDictionary = new ColumnDefinitions(dict);
        Element stats = (Element)dict.getNextSibling();
        this.dataStats = stats != null ? new ColumnStats(stats) : new ColumnStats(this.getDocument());
        this.numColumns = this.dataDictionary.getNumColumns();
    }

    public XMLTreeMetaData(XMLTree md) throws Exception {
        super(md);
        this.metaDataRootNode = this.m_xml.getNodeName().equals(META_DATA_NODE_TAG) ? this.m_xml : (Element)this.m_xml.getFirstChild();
        if (this.metaDataRootNode == null) {
            throw new Exception("Root node was not found.");
        }
        if (!this.metaDataRootNode.getNodeName().equals(META_DATA_NODE_TAG)) {
            throw new Exception("Malformed XML: " + META_DATA_NODE_TAG + " tag was missing.");
        }
        this.dataDictionary = new ColumnDefinitions((Element)this.metaDataRootNode.getFirstChild());
        this.dataStats = new ColumnStats((Element)this.metaDataRootNode.getFirstChild().getNextSibling());
        this.numColumns = this.dataDictionary.getNumColumns();
    }

    public double getColumnRowCount(String name) {
        return this.dataStats.getColumnRowCount(name);
    }

    public double getColumnRowCount(int num) {
        return this.dataStats.getColumnRowCount(num);
    }

    public double getColumnMissingCount(String name) {
        return this.dataStats.getColumnMissingCount(name);
    }

    public double getColumnMissingCount(int num) {
        return this.dataStats.getColumnMissingCount(num);
    }

    public double getColumnMean(String name) {
        return this.dataStats.getColumnMean(name);
    }

    public double getColumnMean(int num) {
        return this.dataStats.getColumnMean(num);
    }

    public double getColumnMin(String name) {
        return this.dataStats.getColumnMin(name);
    }

    public double getColumnMin(int num) {
        return this.dataStats.getColumnMin(num);
    }

    public double getColumnMax(String name) {
        return this.dataStats.getColumnMax(name);
    }

    public double getColumnMax(int num) {
        return this.dataStats.getColumnMax(num);
    }

    public double getColumnStandardDeviation(String name) {
        return this.dataStats.getColumnStandardDeviation(name);
    }

    public double getColumnStandardDeviation(int num) {
        return this.dataStats.getColumnStandardDeviation(num);
    }

    public boolean isContinuousColumn(String name) {
        return this.dataDictionary.isContinuousColumn(name);
    }

    public boolean isContinuousColumn(int num) {
        return this.dataDictionary.isContinuousColumn(num);
    }

    public boolean isCategoricalColumn(String name) {
        return this.dataDictionary.isCategoricalColumn(name);
    }

    public boolean isCategoricalColumn(int num) {
        return this.dataDictionary.isCategoricalColumn(num);
    }

    public boolean isStringColumn(String name) {
        return this.dataDictionary.isStringColumn(name);
    }

    public boolean isStringColumn(int num) {
        return this.dataDictionary.isStringColumn(num);
    }

    public boolean isDateTimeColumn(String name) {
        return this.dataDictionary.isDateTimeColumn(name);
    }

    public boolean isDateTimeColumn(int num) {
        return this.dataDictionary.isDateTimeColumn(num);
    }

    public boolean isBlobColumn(String name) {
        return this.dataDictionary.isBlobColumn(name);
    }

    public boolean isBlobColumn(int num) {
        return this.dataDictionary.isBlobColumn(num);
    }

    public String getColumnType(String name) {
        return this.dataDictionary.getColumnType(name);
    }

    public String getColumnType(int num) {
        return this.dataDictionary.getColumnType(num);
    }

    public String getColumnRole(String name) {
        return this.dataDictionary.getColumnRole(name);
    }

    public String getColumnRole(int num) {
        return this.dataDictionary.getColumnRole(num);
    }

    public int getStringDataFieldWidth(String name) {
        return this.dataDictionary.getStringDataFieldWidth(name);
    }

    public int getStringDataFieldWidth(int num) {
        return this.dataDictionary.getStringDataFieldWidth(num);
    }

    public String getBlobDataFieldClassName(String name) {
        return this.dataDictionary.getBlobDataFieldClassName(name);
    }

    public String getBlobDataFieldClassName(int num) {
        return this.dataDictionary.getBlobDataFieldClassName(num);
    }

    public Vector getColumnNames() {
        return this.dataDictionary.getColumnNames();
    }

    public Vector getColumnRoles() {
        return this.dataDictionary.getColumnRoles();
    }

    public Vector getColumnTypes() {
        return this.dataDictionary.getColumnTypes();
    }

    public String getCategoricalDataFieldLevel(int column, int level) {
        return this.dataDictionary.getCategoricalDataFieldLevel(column, level);
    }

    public Vector getCategoricalDataFieldLevels(String name) {
        return this.dataDictionary.getCategoricalDataFieldLevels(name);
    }

    public Vector getSortedCategoricalDataFieldLevels(String name) {
        return this.dataDictionary.getSortedCategoricalDataFieldLevels(name);
    }

    public Vector getQuantileLimits(String col) {
        return this.dataStats.getQuantileLimts(col);
    }

    public Vector getQuantileValues(String col) {
        return this.dataStats.getQuantileValues(col);
    }

    public String getLevelCount(String col, String level) {
        return this.dataStats.getLevelCount(col, level);
    }

    public int getNumColumns() {
        return this.dataDictionary.getNumColumns();
    }

    public int nameToOrdinal(String columnName) {
        return this.dataDictionary.nameToOrdinal(columnName);
    }

    public String ordinalToName(int ordinal) {
        return this.dataDictionary.ordinalToName(ordinal);
    }

    public long getNumRows() {
        return this.dataStats.getNumRows();
    }

    public boolean appendCategoricalDataField(String name, List levels) {
        return this.dataDictionary.appendCategoricalDataField(name, levels);
    }

    public boolean appendCategoricalDataField(String name, String[] levels) {
        return this.dataDictionary.appendCategoricalDataField(name, levels);
    }

    public boolean removeDataFieldLevels(String name) {
        return this.dataDictionary.removeDataFieldLevels(name);
    }

    public boolean appendCategoricalLevel(String name, String level) {
        return this.dataDictionary.appendCategoricalLevel(name, level);
    }

    public boolean setCategoricalLevels(String name, String[] levels) {
        return this.dataDictionary.setCategoricalLevels(name, levels);
    }

    public boolean appendContinousDataField(String name) {
        return this.dataDictionary.appendContinousDataField(name);
    }

    public boolean appendDateTimeDataField(String name) {
        return this.dataDictionary.appendDateTimeDataField(name);
    }

    public boolean appendBlobDataField(String name, String blobClassName) {
        return this.dataDictionary.appendBlobDataField(name, blobClassName);
    }

    public boolean appendStringDataField(String name, int width) {
        return this.dataDictionary.appendStringDataField(name, width);
    }

    public boolean removeDataField(String name) {
        return this.dataDictionary.removeDataField(name);
    }

    public boolean setDataFieldRole(String name, String role) {
        return this.dataDictionary.setDataFieldRole(name, role);
    }

    public boolean setDataFieldRole(int num, String role) {
        return this.dataDictionary.setDataFieldRole(num, role);
    }

    public boolean setDataFieldRoleDependent(String name) {
        return this.dataDictionary.setDataFieldRoleDependent(name);
    }

    public boolean setDataFieldRoleIndependent(String name) {
        return this.dataDictionary.setDataFieldRoleIndependent(name);
    }

    public boolean setDataFieldRoleInformation(String name) {
        return this.dataDictionary.setDataFieldRoleInformation(name);
    }

    public boolean setDataFieldRolePrediction(String name) {
        return this.dataDictionary.setDataFieldRolePrediction(name);
    }

    public Vector getDataFieldsWithType(String type) {
        return this.dataDictionary.getDataFieldsWithType(type);
    }

    public Vector getDataFieldsWithRole(String role) {
        return this.dataDictionary.getDataFieldsWithRole(role);
    }

    public boolean setNumRows(long numRows) {
        return this.dataStats.setTableStats(numRows);
    }

    public boolean setTableStats(long numRows) {
        return this.dataStats.setTableStats(numRows);
    }

    public boolean appendUnivariateStats(String name) {
        return this.dataStats.appendUnivariateStats(name);
    }

    public boolean removeUnivariateStats(String name) {
        return this.dataStats.removeUnivariateStats(name);
    }

    public boolean appendCounts(String name, long totalFreq, long missingFreq) {
        return this.dataStats.appendCounts(name, totalFreq, missingFreq);
    }

    public boolean appendCountsCategories(String name, String[] values, long[] frequencies) {
        return this.dataStats.appendCountsCategories(name, values, frequencies);
    }

    public boolean appendCountsCategory(String name, String value, long frequency) {
        return this.dataStats.appendCountsCategory(name, value, frequency);
    }

    public boolean appendNumericInfo(String name, double mean, double min, double max, double stdDev, double median, double iqr) {
        return this.dataStats.appendNumericInfo(name, mean, min, max, stdDev, median, iqr);
    }

    public boolean replaceNumericInfo(String name, double mean, double min, double max, double stdDev, double median, double iqr) {
        try {
            if (!this.removeUnivariateStats(name)) {
                if (this.dataStats.appendUnivariateStats(name)) {
                    return false;
                }
                return this.appendNumericInfo(name, mean, min, max, stdDev, median, iqr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean appendQuantiles(String name, double[] limits, double[] values) {
        return this.dataStats.appendQuantiles(name, limits, values);
    }

    public boolean appendQuantile(String name, double limit, double value) {
        return this.dataStats.appendQuantile(name, limit, value);
    }

    public boolean modifyColumnName(String oldName, String newName) {
        boolean dict = this.dataDictionary.modifyColumnName(oldName, newName);
        boolean stat = this.dataStats.modifyColumnName(oldName, newName);
        return dict || stat;
    }

    private boolean isStringInVector(String name, Vector list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            if (!name.equals(list.get(i))) continue;
            return true;
        }
        return false;
    }

    public XMLTree copy() {
        try {
            return new XMLTreeMetaData(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Object clone() {
        try {
            return new XMLTreeMetaData(this);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void test() {
    }
}

