/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.graphdlg.controls;

import com.insightful.miner.graphdlg.controls.MinerControlMetrics;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class MinerLabelBox
extends JComponent {
    private JLabel label;
    private JComponent actionControl;
    static final Dimension labelDimension = MinerControlMetrics.getLabelDimension();
    static final Dimension fullDimension = MinerControlMetrics.getFullDimension();
    private Dimension boxDimension = fullDimension;

    public MinerLabelBox(String text, char mnemonic) {
        this(text);
        this.setMnemonic(mnemonic);
    }

    public MinerLabelBox(String text) {
        if (!text.endsWith(":")) {
            text = text + ":";
        }
        this.label = new JLabel(text);
    }

    public String getText() {
        return this.label.getText();
    }

    public void setText(String text) {
        if (!text.endsWith(":")) {
            text = text + ":";
        }
        this.label.setText(text);
    }

    public int getMnemonic() {
        return this.label.getDisplayedMnemonic();
    }

    public void setMnemonic(char aChar) {
        this.label.setDisplayedMnemonic(aChar);
    }

    public void setMnemonic(int key) {
        this.label.setDisplayedMnemonic(key);
    }

    public void setLabelEnabled(boolean b) {
        this.label.setEnabled(b);
    }

    public void setActionControl(JComponent aControl) {
        this.actionControl = aControl;
        this.label.setLabelFor(aControl);
        this.layoutBox();
    }

    public void setLabelFor(JComponent aControl) {
        this.label.setLabelFor(aControl);
    }

    private void layoutBox() {
        if (!MinerControlMetrics.isLongLabel(this.label)) {
            Dimension actionDimension = this.actionControl.getPreferredSize();
            this.label.setPreferredSize(new Dimension(MinerLabelBox.labelDimension.width, actionDimension.height));
            if (actionDimension.height == MinerLabelBox.labelDimension.height) {
                this.label.setVerticalAlignment(0);
            } else {
                this.label.setVerticalAlignment(1);
            }
            this.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.anchor = 18;
            constraints.fill = 0;
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.weightx = 0.0;
            constraints.weighty = 0.0;
            constraints.insets = new Insets(0, 5, 0, 0);
            this.add((Component)this.label, constraints);
            constraints.gridx = 1;
            constraints.weightx = 1.0;
            constraints.fill = 2;
            constraints.insets = new Insets(0, 5, 0, 0);
            this.add((Component)this.actionControl, constraints);
            this.boxDimension = new Dimension(MinerLabelBox.fullDimension.width, this.actionControl.getPreferredSize().height + 5);
        } else {
            this.label.setPreferredSize(new Dimension(MinerLabelBox.labelDimension.width * 2, MinerLabelBox.labelDimension.height));
            this.label.setMinimumSize(new Dimension(MinerLabelBox.labelDimension.width * 2, MinerLabelBox.labelDimension.height));
            this.setLayout(new GridLayout(2, 1));
            Box labelBox = new Box(0);
            labelBox.add(Box.createHorizontalStrut(5));
            labelBox.add(this.label);
            this.add(labelBox);
            Box controlBox = new Box(0);
            controlBox.add(Box.createRigidArea(new Dimension(MinerLabelBox.labelDimension.width + 10, MinerLabelBox.labelDimension.height)));
            controlBox.add(this.actionControl);
            this.add(controlBox);
            this.boxDimension = new Dimension(MinerLabelBox.fullDimension.width, MinerLabelBox.fullDimension.height + this.actionControl.getPreferredSize().height + 5);
        }
        this.setPreferredSize(this.boxDimension);
        this.setMinimumSize(this.boxDimension);
    }
}

