/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.graphdlg.controls;

import com.insightful.miner.graphdlg.controls.MinerControlMethods;
import com.insightful.miner.graphdlg.controls.MinerControlMetrics;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeListener;

public class MinerRadioButton
extends JComponent
implements MinerControlMethods {
    JRadioButton checkBox;

    public MinerRadioButton(String text, char mnemonic) {
        this(text);
        this.setMnemonic(mnemonic);
    }

    public MinerRadioButton(String text, int mnemonic) {
        this(text);
        this.setMnemonic(mnemonic);
    }

    public MinerRadioButton(String text) {
        this.checkBox = new JRadioButton(text);
        this.checkBox.setSelected(false);
        Dimension labelDimension = MinerControlMetrics.getLabelDimension();
        Dimension fullDimension = MinerControlMetrics.getFullDimension();
        this.checkBox.setPreferredSize(new Dimension(fullDimension.width, labelDimension.height));
        this.add(this.checkBox);
        this.setLayout(new FlowLayout(0, 5, 0));
        this.setPreferredSize(fullDimension);
        this.setMinimumSize(fullDimension);
    }

    public String getValue() {
        if (this.checkBox.isSelected()) {
            return "T";
        }
        return "F";
    }

    public void setValue(String value) {
        if ((value = value.toUpperCase()).equals("T") || value.equals("TRUE")) {
            this.checkBox.setSelected(true);
        } else {
            this.checkBox.setSelected(false);
        }
    }

    public String[] getOptionList() {
        return null;
    }

    public void setOptionList(String[] listData) {
    }

    public String getText() {
        return this.checkBox.getText();
    }

    public void setText(String text) {
        this.checkBox.setText(text);
    }

    public int getMnemonic() {
        return this.checkBox.getMnemonic();
    }

    public void setMnemonic(int key) {
        this.checkBox.setMnemonic(key);
    }

    public void setMnemonic(char key) {
        this.checkBox.setMnemonic(key);
    }

    public boolean isEnabled() {
        return this.checkBox.isEnabled();
    }

    public void setEnabled(boolean b) {
        this.checkBox.setEnabled(b);
    }

    public void addActionListener(ActionListener listener) {
        this.checkBox.addActionListener(listener);
    }

    public void addChangeListener(ChangeListener listener) {
        this.checkBox.addChangeListener(listener);
    }

    public void addItemListener(ItemListener listener) {
        this.checkBox.addItemListener(listener);
    }

    public String getActionCommand() {
        return this.checkBox.getActionCommand();
    }

    public void setActionCommand(String aCommand) {
        this.checkBox.setActionCommand(aCommand);
    }

    public boolean isSelected() {
        return this.checkBox.isSelected();
    }

    public AbstractButton getAbstractButton() {
        return this.checkBox;
    }
}

