/*
 * Decompiled with CFR 0.152.
 */
package com.insightful.miner.tree.gui;

import com.insightful.miner.HtmlFrame;
import com.insightful.miner.MinerApp;
import com.insightful.miner.MinerPopupMenu;
import com.insightful.miner.ModifiableViewerFrame;
import com.insightful.miner.XMLTree;
import com.insightful.miner.tree.gui.CRTreeRenderer;
import com.insightful.miner.tree.gui.DendrogramPanel;
import com.insightful.miner.tree.gui.TreeComparisonTableFrame;
import com.insightful.miner.tree.gui.TreeLegendViewPanel;
import com.insightful.miner.tree.gui.TreeNodeViewPanel;
import com.insightful.miner.tree.gui.TreeVariableDevianceFrame;
import com.insightful.miner.tree.gui.TreeVisualizer_AboutBox;
import com.insightful.miner.tree.model.ClassificationRegressionTree;
import com.insightful.miner.tree.model.ClassificationRegressionTreeNode;
import com.insightful.miner.tree.model.TreeCollection;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ClassificationTreeGUI
extends ModifiableViewerFrame {
    private static ResourceBundle treeBundles = null;
    private JMenuBar menuBar = new JMenuBar();
    private JMenu fileMenu = new JMenu();
    private JMenuItem fileMenuExit = new JMenuItem();
    private JMenuItem fileMenuPrint = new JMenuItem();
    private JMenuItem fileMenuPrintPreview = new JMenuItem();
    private JMenuItem fileMenuSave = new JMenuItem();
    private JMenu helpMenu = new JMenu();
    private JMenuItem helpMenuUserGuide = new JMenuItem();
    private JMenuItem helpMenuAbout = new JMenuItem();
    private JMenu treeMenu = new JMenu();
    private JCheckBoxMenuItem treeMenuShowProportions = null;
    private JMenuItem viewMenuPrune = new JMenuItem();
    private JCheckBoxMenuItem dendViewMenuShowShading = null;
    private JMenuItem treeViewMenuCompareTrees = new JMenuItem();
    private JMenuItem treeViewMenuCompareVars = new JMenuItem();
    private JMenuItem treeViewMenuDisplayHTML = new JMenuItem();
    private JMenu dendMenu = new JMenu();
    private JCheckBoxMenuItem dendViewMenuMapDendro = null;
    private JCheckBoxMenuItem dendViewMenuShowColors = null;
    private JCheckBoxMenuItem dendViewMenuSetShowPath = null;
    private JPopupMenu nodeContextMenu = new MinerPopupMenu();
    private JMenuItem pruneMenuItem = new JMenuItem();
    private JMenuItem burlMenuItem = new JMenuItem();
    private JPopupMenu contextMenu = new MinerPopupMenu();
    private JMenuItem expandTreeMenuItem = new JMenuItem();
    private JMenuItem collapseTreeMenuItem = new JMenuItem();
    private JMenuItem autoPruneMenuItem = new JMenuItem();
    private JMenuItem showPropsContextMenuItem = null;
    private JPanel treeCollectionPanel = null;
    private TreeNodeViewPanel descriptionView = null;
    private TreeLegendViewPanel legendView = null;
    private DendrogramPanel dendroPanel = null;
    private TreeCollection treecollection = null;
    private DrawableJTree jtree = null;
    private DefaultTreeModel treeModel = null;
    private JScrollPane treeView = null;
    private Vector[] visibleNodes = null;
    private TreePath[] selectedNodes = null;
    private int[] maxDepth = null;
    private int[] desiredLevel = null;
    private ClassificationRegressionTreeNode rightSelNode = null;
    private int currentTree = 0;
    private boolean proportionsSet = true;
    private int sizeIconWidth = 20;
    private int[] dendrogramScrollPositions = null;
    private int jTreeScrollPos = 0;
    public static Font labelFont = MinerApp.getFont(1, 9);
    public static Font buttonFont = MinerApp.getFont(1, 9);
    public static Font titleFont = MinerApp.getFont(1, 12);
    boolean myPrintBegun = false;
    Dimension myPrintDocSize = null;
    Point myPrintDocTopLeft = null;
    Rectangle2D.Double myPrintPageRect = null;
    int myPrintNumPagesAcross = 1;
    int myPrintNumPagesDown = 1;
    double myPrintHorizScale = 1.0;
    double myPrintVertScale = 1.0;
    private String htmlTitle = null;

    public ClassificationTreeGUI(TreeCollection treeColl, String htmlTitleParameter) {
        this.htmlTitle = htmlTitleParameter;
        Point loc = MinerApp.getMainFrame().getLocation();
        this.setLocation(loc.x + 25, loc.y + 25);
        this.treecollection = treeColl;
        this.treecollection.setParentFrame(this);
        this.visibleNodes = new Vector[this.treecollection.getNumberTrees()];
        this.dendrogramScrollPositions = new int[this.treecollection.getNumberTrees()];
        this.selectedNodes = new TreePath[this.treecollection.getNumberTrees()];
        this.maxDepth = new int[this.treecollection.getNumberTrees()];
        this.desiredLevel = new int[this.treecollection.getNumberTrees()];
        for (int a = 0; a < this.treecollection.getNumberTrees(); ++a) {
            this.desiredLevel[a] = 1;
        }
        try {
            this.jbInit(this.treecollection.getTree(0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.show_tree();
        this.descriptionView.updateUI();
        ActionListener cancelListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassificationTreeGUI.this.exit();
            }
        };
        this.getJMenuBar().registerKeyboardAction(cancelListener, KeyStroke.getKeyStroke("ESCAPE"), 2);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ClassificationTreeGUI.this.exit();
            }
        });
    }

    public ClassificationTreeGUI(TreeCollection treeColl) {
        this(treeColl, "");
    }

    public void exit() {
        int i;
        if (this.visibleNodes != null) {
            for (i = 0; i < this.visibleNodes.length; ++i) {
                if (this.visibleNodes[i] == null) continue;
                this.visibleNodes[i].removeAllElements();
            }
            this.visibleNodes = null;
        }
        if (this.selectedNodes != null) {
            for (i = 0; i < this.selectedNodes.length; ++i) {
                this.selectedNodes[i] = null;
            }
            this.selectedNodes = null;
        }
        this.dispose();
    }

    public ClassificationTreeGUI getTreeGUI() {
        return this;
    }

    public TreeCollection getTreeCollection() {
        return this.treecollection;
    }

    private void jbInit(ClassificationRegressionTree currtree) throws Exception {
        this.setMaxDepth(currtree.getRootNode());
        this.treeCollectionPanel = new JPanel(new BorderLayout());
        this.legendView = new TreeLegendViewPanel(this, this.treecollection);
        this.descriptionView = new TreeNodeViewPanel(this, currtree.getRootNode());
        this.descriptionView.setText(this.getSummaryText());
        this.treeModel = new DefaultTreeModel(currtree.getRootNode());
        this.jtree = new DrawableJTree(this.treeModel);
        this.jtree.setFont(labelFont);
        this.jtree.setEditable(false);
        this.jtree.getSelectionModel().setSelectionMode(1);
        this.jtree.setShowsRootHandles(true);
        this.jtree.putClientProperty("JTree.lineStyle", "Angled");
        this.jtree.setCellRenderer(new CRTreeRenderer(this.treecollection));
        this.jtree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                ClassificationRegressionTreeNode node = (ClassificationRegressionTreeNode)ClassificationTreeGUI.this.jtree.getLastSelectedPathComponent();
                if (node != null) {
                    ClassificationTreeGUI.this.descriptionView.setText(ClassificationTreeGUI.this.getSummaryText() + "\n" + node.getRule());
                    ClassificationTreeGUI.this.descriptionView.getDendroPanel().setSelected(node);
                    ClassificationTreeGUI.this.descriptionView.getDendroPanel().setSelectionPath(ClassificationTreeGUI.this.jtree.getSelectionPath());
                    ClassificationTreeGUI.this.descriptionView.getDendroPanel().repaint();
                }
            }
        });
        this.jtree.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                ClassificationTreeGUI.this.doMousePressed(e);
            }
        });
        this.legendView.setCheckboxDefaults();
        String prunenode = ClassificationTreeGUI.getText("treevis_dend_prunenode");
        this.pruneMenuItem.setText(prunenode);
        this.pruneMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassificationTreeGUI.this.pruneCurrentNode(ClassificationTreeGUI.this.rightSelNode);
            }
        });
        String viewsplits = ClassificationTreeGUI.getText("treevis_gui_view_splits");
        this.burlMenuItem.setText(viewsplits);
        this.burlMenuItem.setEnabled(false);
        this.burlMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        });
        String exptree = ClassificationTreeGUI.getText("treevis_gui_expand_tree");
        this.expandTreeMenuItem.setText(exptree);
        this.expandTreeMenuItem.setMnemonic(88);
        this.expandTreeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassificationTreeGUI.this.expandAll();
                ((ClassificationTreeGUI)ClassificationTreeGUI.this).desiredLevel[((ClassificationTreeGUI)ClassificationTreeGUI.this).currentTree] = ClassificationTreeGUI.this.maxDepth[ClassificationTreeGUI.this.currentTree];
            }
        });
        this.contextMenu.add(this.expandTreeMenuItem);
        String colltree = ClassificationTreeGUI.getText("treevis_gui_collapse_tree");
        this.collapseTreeMenuItem.setText(colltree);
        this.collapseTreeMenuItem.setMnemonic(79);
        this.collapseTreeMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int numLevels;
                int i = numLevels = ClassificationTreeGUI.this.desiredLevel[ClassificationTreeGUI.this.currentTree];
                while (i > 0) {
                    ((ClassificationTreeGUI)ClassificationTreeGUI.this).desiredLevel[((ClassificationTreeGUI)ClassificationTreeGUI.this).currentTree] = i--;
                    ClassificationTreeGUI.this.showChildrenAboveLevel((ClassificationRegressionTreeNode)ClassificationTreeGUI.this.treeModel.getRoot());
                }
            }
        });
        this.contextMenu.add(this.collapseTreeMenuItem);
        String winner = ClassificationTreeGUI.getText("treevis_legend_show_winner");
        this.showPropsContextMenuItem = new JCheckBoxMenuItem(winner, false);
        if (this.treecollection.isRegression()) {
            this.showPropsContextMenuItem.setEnabled(false);
        }
        this.showPropsContextMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassificationTreeGUI.this.doShowProportions();
            }
        });
        this.contextMenu.add(this.showPropsContextMenuItem);
        String prunetree = ClassificationTreeGUI.getText("treevis_gui_prune_tree");
        Dimension treeViewMinSize = new Dimension(340, 300);
        Dimension legendViewMinSize = new Dimension(340, 125);
        int leftSplitPaneDividerLocation = 395;
        Dimension leftSplitPanePrefSize = new Dimension(340, 530);
        int splitPaneDividerLocation = 340;
        Dimension splitPanePrefSize = new Dimension(720, 530);
        if (this.treecollection.getNumberTrees() > 1) {
            treeViewMinSize = new Dimension(340, 260);
            legendViewMinSize = new Dimension(340, 155);
            leftSplitPaneDividerLocation = 365;
        }
        this.treeView = new JScrollPane(this.jtree);
        this.legendView.setMinimumSize(legendViewMinSize);
        JSplitPane leftSplitPane = new JSplitPane(0);
        leftSplitPane.setDividerSize(9);
        leftSplitPane.setDividerLocation(leftSplitPaneDividerLocation);
        leftSplitPane.setOneTouchExpandable(true);
        leftSplitPane.setPreferredSize(leftSplitPanePrefSize);
        leftSplitPane.setTopComponent(this.treeView);
        leftSplitPane.setBottomComponent(this.legendView);
        leftSplitPane.setResizeWeight(1.0);
        JSplitPane splitPane = new JSplitPane(1);
        splitPane.setDividerSize(9);
        splitPane.setDividerLocation(splitPaneDividerLocation);
        splitPane.setOneTouchExpandable(true);
        splitPane.setPreferredSize(splitPanePrefSize);
        splitPane.setLeftComponent(leftSplitPane);
        splitPane.setRightComponent(this.descriptionView);
        this.treeCollectionPanel.add((Component)splitPane, "Center");
        String filemenu = ClassificationTreeGUI.getText("treevis_gui_filemenu");
        this.fileMenu.setText(filemenu);
        this.fileMenu.setMnemonic(70);
        String fileexit = ClassificationTreeGUI.getText("treevis_gui_fileexit");
        this.fileMenuExit.setText(fileexit);
        this.fileMenuExit.setMnemonic(69);
        this.fileMenuExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassificationTreeGUI.this.setVisible(false);
                ClassificationTreeGUI.this.exit();
            }
        });
        String fileprint = ClassificationTreeGUI.getText("treevis_gui_fileprint");
        this.fileMenuPrint.setText(fileprint);
        this.fileMenuPrint.setMnemonic(80);
        this.fileMenuPrint.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        this.fileMenuPrint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassificationTreeGUI.this.print();
            }
        });
        String fileprintpreview = ClassificationTreeGUI.getText("treevis_gui_fileprintpreview");
        this.fileMenuPrintPreview.setText(fileprintpreview);
        this.fileMenuPrintPreview.setMnemonic(82);
        this.fileMenuPrintPreview.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.fileMenuPrintPreview.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassificationTreeGUI.this.printPreview();
            }
        });
        String filesave = ClassificationTreeGUI.getText("treevis_gui_filesavejpeg");
        this.fileMenuSave.setText(filesave);
        this.fileMenuSave.setMnemonic(83);
        this.fileMenuSave.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.fileMenuSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MinerApp.saveAsJPEG(ClassificationTreeGUI.this.jtree);
            }
        });
        String help = ClassificationTreeGUI.getText("treevis_gui_help");
        this.helpMenu.setText(help);
        this.helpMenu.setMnemonic(72);
        String helpsystem = ClassificationTreeGUI.getText("treevis_gui_helpsystem");
        this.helpMenuUserGuide.setText(helpsystem);
        this.helpMenuUserGuide.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.helpMenuUserGuide.setMnemonic(84);
        this.helpMenuUserGuide.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassificationTreeGUI.this.handleHelp();
            }
        });
        String helpabout = ClassificationTreeGUI.getText("treevis_gui_helpabout");
        this.helpMenuAbout.setText(helpabout);
        this.helpMenuAbout.setMnemonic(65);
        this.helpMenuAbout.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassificationTreeGUI.this.handleAboutBox();
            }
        });
        String treemenu = ClassificationTreeGUI.getText("treevis_gui_treemenu");
        this.treeMenu.setText(treemenu);
        this.treeMenu.setMnemonic(84);
        String dendmenu = ClassificationTreeGUI.getText("treevis_gui_dendmenu");
        this.dendMenu.setText(dendmenu);
        this.dendMenu.setMnemonic(68);
        this.viewMenuPrune.setText(prunetree);
        this.viewMenuPrune.setEnabled(false);
        this.viewMenuPrune.setMnemonic(80);
        this.viewMenuPrune.setAccelerator(KeyStroke.getKeyStroke(82, 2));
        this.viewMenuPrune.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
            }
        });
        String showAsHTML = ClassificationTreeGUI.getText("treevis_gui_showHTML");
        this.treeViewMenuDisplayHTML.setText(showAsHTML);
        this.treeViewMenuDisplayHTML.setMnemonic(77);
        this.treeViewMenuDisplayHTML.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassificationTreeGUI.this.showTreeAsHtml();
            }
        });
        String treecompare = ClassificationTreeGUI.getText("treevis_gui_comparetrees");
        if (this.treecollection.getNumberTrees() == 1) {
            this.treeViewMenuCompareTrees.setEnabled(false);
        }
        this.treeViewMenuCompareTrees.setText(treecompare);
        this.treeViewMenuCompareTrees.setMnemonic(67);
        this.treeViewMenuCompareTrees.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TreeComparisonTableFrame comparetreesFrame = new TreeComparisonTableFrame(ClassificationTreeGUI.this.treecollection);
                Dimension size = comparetreesFrame.getSize();
                Dimension frmSize = ClassificationTreeGUI.this.getSize();
                Point loc = ClassificationTreeGUI.this.getLocation();
                comparetreesFrame.setLocation((frmSize.width - size.width) / 2 + loc.x, (frmSize.height - size.height) / 2 + loc.y);
                comparetreesFrame.setVisible(true);
            }
        });
        String vardevcompare = ClassificationTreeGUI.getText("treevis_gui_comparedev");
        this.treeViewMenuCompareVars.setText(vardevcompare);
        this.treeViewMenuCompareVars.setMnemonic(68);
        if (this.treecollection.getVarDevVals() == null || this.treecollection.getVarDevVals()[0].length == 1) {
            this.treeViewMenuCompareVars.setEnabled(false);
        }
        this.treeViewMenuCompareVars.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TreeVariableDevianceFrame compareDevianceFrame = new TreeVariableDevianceFrame(ClassificationTreeGUI.this.htmlTitle, ClassificationTreeGUI.this.treecollection);
                compareDevianceFrame.setSize(400, 300);
                compareDevianceFrame.setLocation(MinerApp.getNextWindowLocation());
                compareDevianceFrame.setVisible(true);
            }
        });
        this.treeMenuShowProportions = new JCheckBoxMenuItem(winner, false);
        if (this.treecollection.isRegression()) {
            this.treeMenuShowProportions.setEnabled(false);
        }
        this.treeMenuShowProportions.setMnemonic(83);
        this.treeMenuShowProportions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassificationTreeGUI.this.doShowProportions();
            }
        });
        String maptodev = ClassificationTreeGUI.getText("treevis_dend_maptodev");
        this.dendViewMenuMapDendro = new JCheckBoxMenuItem(maptodev, false);
        this.dendViewMenuMapDendro.setMnemonic(83);
        this.dendViewMenuMapDendro.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ClassificationTreeGUI.this.descriptionView.getDendroPanel().getDiversityMap()) {
                    ClassificationTreeGUI.this.descriptionView.getDendroPanel().setDiversityMap(false);
                } else {
                    ClassificationTreeGUI.this.descriptionView.getDendroPanel().setDiversityMap(true);
                }
                ClassificationTreeGUI.this.descriptionView.getDendroPanel().computeSize();
                ClassificationTreeGUI.this.descriptionView.getDendroPanel().setPreferredSize(new Dimension(ClassificationTreeGUI.this.descriptionView.getDendroPanel().getWidth(), ClassificationTreeGUI.this.descriptionView.getDendroPanel().getHeight()));
                ClassificationTreeGUI.this.descriptionView.getDendroPanel().revalidate();
                ClassificationTreeGUI.this.descriptionView.getDendroPanel().repaint();
            }
        });
        String showcolors = ClassificationTreeGUI.getText("treevis_gui_showcolors");
        this.dendViewMenuShowColors = new JCheckBoxMenuItem(showcolors, false);
        if (this.treecollection.isRegression()) {
            this.dendViewMenuShowColors.setEnabled(false);
        }
        this.dendViewMenuShowColors.setMnemonic(80);
        this.dendViewMenuShowColors.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ClassificationTreeGUI.this.descriptionView.getDendroPanel().getShowColors()) {
                    ClassificationTreeGUI.this.descriptionView.getDendroPanel().setShowColors(false);
                } else {
                    ClassificationTreeGUI.this.descriptionView.getDendroPanel().setShowColors(true);
                }
                ClassificationTreeGUI.this.descriptionView.getDendroPanel().repaint();
            }
        });
        String showpathsplits = ClassificationTreeGUI.getText("treevis_gui_showpathsplits");
        this.dendViewMenuSetShowPath = new JCheckBoxMenuItem(showpathsplits, false);
        this.dendViewMenuSetShowPath.setMnemonic(78);
        this.dendViewMenuSetShowPath.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ClassificationTreeGUI.this.descriptionView.getDendroPanel().getShowPath()) {
                    ClassificationTreeGUI.this.descriptionView.getDendroPanel().setShowPath(false);
                } else {
                    ClassificationTreeGUI.this.descriptionView.getDendroPanel().setShowPath(true);
                }
                ClassificationTreeGUI.this.descriptionView.getDendroPanel().repaint();
            }
        });
        String showshading = ClassificationTreeGUI.getText("treevis_gui_showshading");
        this.dendViewMenuShowShading = new JCheckBoxMenuItem(showshading, false);
        this.dendViewMenuShowShading.setMnemonic(82);
        this.dendViewMenuShowShading.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (ClassificationTreeGUI.this.descriptionView.getDendroPanel().getShowShading()) {
                    ClassificationTreeGUI.this.descriptionView.getDendroPanel().setShowShading(false);
                    ClassificationTreeGUI.this.treecollection.setDisplaySizeGraphic(false);
                    ClassificationTreeGUI.this.jtree.setSizeIconWidth(0);
                } else {
                    ClassificationTreeGUI.this.descriptionView.getDendroPanel().setShowShading(true);
                    ClassificationTreeGUI.this.treecollection.setDisplaySizeGraphic(true);
                    ClassificationTreeGUI.this.jtree.setSizeIconWidth(ClassificationTreeGUI.this.sizeIconWidth);
                }
                ClassificationTreeGUI.this.descriptionView.getDendroPanel().repaint();
                ClassificationTreeGUI.this.jtree.updateUI();
            }
        });
        this.fileMenu.add(this.fileMenuSave);
        this.fileMenu.add(this.fileMenuPrint);
        this.fileMenu.add(this.fileMenuPrintPreview);
        this.fileMenu.add(this.fileMenuExit);
        this.treeMenu.add(this.expandTreeMenuItem);
        this.treeMenu.add(this.collapseTreeMenuItem);
        this.treeMenu.add(this.treeViewMenuCompareTrees);
        this.treeMenu.add(this.treeViewMenuCompareVars);
        this.treeMenu.add(this.treeMenuShowProportions);
        this.treeMenu.add(this.dendViewMenuShowShading);
        this.treeMenu.add(this.treeViewMenuDisplayHTML);
        this.dendMenu.add(this.dendViewMenuMapDendro);
        this.dendMenu.add(this.dendViewMenuShowColors);
        this.dendMenu.add(this.dendViewMenuSetShowPath);
        this.helpMenu.add(this.helpMenuUserGuide);
        this.helpMenu.add(this.helpMenuAbout);
        this.menuBar.add(this.fileMenu);
        this.menuBar.add(this.treeMenu);
        this.menuBar.add(this.dendMenu);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
    }

    protected void handleAboutBox() {
        TreeVisualizer_AboutBox tvab = new TreeVisualizer_AboutBox();
        Dimension tvabSize = tvab.getPreferredSize();
        Dimension frmSize = this.getSize();
        Point loc = this.getLocation();
        tvab.setLocation((frmSize.width - tvabSize.width) / 2 + loc.x, (frmSize.height - tvabSize.height) / 2 + loc.y);
        tvab.setModal(true);
        tvab.show();
    }

    protected void handleHelp() {
    }

    private void doShowProportions() {
        if (!this.proportionsSet) {
            this.treecollection.setShowProportions(true);
            this.proportionsSet = true;
        } else {
            this.treecollection.setShowProportions(false);
            this.proportionsSet = false;
        }
        this.jtree.updateUI();
    }

    private String getSummaryText() {
        String s = this.treecollection.getString();
        s = s + "NUMBER OBSERVATIONS:  " + this.treecollection.getTree(this.currentTree).getRootNode().getNumItems() + "\n";
        s = s + "CURRENT TREE: " + (this.currentTree + 1) + "\n";
        return s;
    }

    public void dispose() {
        super.dispose();
    }

    public void expandAll() {
        int rows = this.jtree.getRowCount();
        for (int index = 0; index < rows; ++index) {
            this.jtree.expandRow(index);
            rows = this.jtree.getRowCount();
        }
    }

    private void showTreeAsHtml() {
        try {
            XMLTree xmltree = this.treecollection.getXMLTree();
            StringBuffer htmlBuf = new StringBuffer();
            htmlBuf.append(xmltree.getHtmlString(XMLTree.TREE_XSL_FILE, this.htmlTitle));
            new HtmlFrame(htmlBuf.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void showChildrenAboveLevel(ClassificationRegressionTreeNode node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            ClassificationRegressionTreeNode child = (ClassificationRegressionTreeNode)node.getChildAt(i);
            if (child.getLevel() <= this.desiredLevel[this.currentTree]) {
                Object[] path = child.getPath();
                TreePath tp = new TreePath(path);
                this.jtree.collapsePath(tp);
            }
            this.showChildrenAboveLevel(child);
        }
    }

    public void pruneCurrentNode(ClassificationRegressionTreeNode node) {
        if (node.isLeaf()) {
            return;
        }
        node.removeAllChildren();
        this.jtree.updateUI();
        this.descriptionView.getDendroPanel().repaint();
    }

    public DrawableJTree getJTree() {
        return this.jtree;
    }

    public void viewTree(int treeIndex) {
        if (treeIndex >= this.treecollection.getNumberTrees()) {
            return;
        }
        this.updateVisibleNodes(this.currentTree);
        this.updateSelectedNodes(this.currentTree);
        this.dendrogramScrollPositions[this.currentTree] = this.descriptionView.getScrollPosition();
        this.currentTree = treeIndex;
        if (this.currentTree == this.treecollection.getNumberTrees() - 1) {
            this.legendView.enableNextTreeButton(false);
        } else {
            this.legendView.enableNextTreeButton(true);
        }
        if (this.currentTree == 0) {
            this.legendView.enablePrevTreeButton(false);
        } else {
            this.legendView.enablePrevTreeButton(true);
        }
        ClassificationRegressionTreeNode rootnode = this.treecollection.getTree(this.currentTree).getRootNode();
        this.treeModel = new DefaultTreeModel(rootnode);
        this.setMaxDepth(rootnode);
        this.jtree.setModel(this.treeModel);
        this.descriptionView.getDendroPanel().resetRoot(rootnode);
        this.descriptionView.setScrollPosition(this.dendrogramScrollPositions[treeIndex]);
        this.descriptionView.getDendroPanel().setSelected(null);
        this.descriptionView.getDendroPanel().computeSize();
        this.descriptionView.getDendroPanel().setPreferredSize(new Dimension(this.descriptionView.getDendroPanel().getWidth(), this.descriptionView.getDendroPanel().getHeight()));
        this.descriptionView.getDendroPanel().revalidate();
        this.descriptionView.setText(this.getSummaryText());
        this.descriptionView.getDendroPanel().repaint();
        if (this.visibleNodes != null && this.visibleNodes[this.currentTree] != null) {
            for (int i = 0; i < this.visibleNodes[this.currentTree].size(); ++i) {
                this.jtree.makeVisible((TreePath)this.visibleNodes[this.currentTree].elementAt(i));
            }
        }
        this.jtree.updateUI();
        if (this.selectedNodes != null && this.selectedNodes[this.currentTree] != null && !this.jtree.isPathSelected(this.selectedNodes[this.currentTree])) {
            this.jtree.setSelectionPath(this.selectedNodes[this.currentTree]);
        }
    }

    private void updateVisibleNodes(int currTree) {
        if (this.visibleNodes == null) {
            return;
        }
        for (int i = 0; i < this.jtree.getVisibleRowCount(); ++i) {
            if (this.visibleNodes[currTree] == null) {
                this.visibleNodes[currTree] = new Vector();
            }
            this.visibleNodes[currTree].add(this.jtree.getPathForRow(i));
        }
    }

    private void updateSelectedNodes(int currTree) {
        TreePath path = this.jtree.getSelectionPath();
        if (path != null && this.selectedNodes != null && this.selectedNodes.length > currTree) {
            this.selectedNodes[currTree] = path;
        }
    }

    public int getCurrentTreeIndex() {
        return this.currentTree;
    }

    public void updateUI() {
        this.treeCollectionPanel.updateUI();
    }

    public void setMaxDepth(ClassificationRegressionTreeNode node) {
        for (int i = 0; i < node.getChildCount(); ++i) {
            ClassificationRegressionTreeNode child = (ClassificationRegressionTreeNode)node.getChildAt(i);
            if (this.maxDepth[this.currentTree] < child.getLevel()) {
                this.maxDepth[this.currentTree] = child.getLevel();
            }
            this.setMaxDepth(child);
        }
    }

    private void doMousePressed(MouseEvent e) {
        if (e.getModifiers() == 4) {
            if (this.jtree.getPathForLocation(e.getX(), e.getY()) == null) {
                // empty if block
            }
        } else {
            this.descriptionView.getDendroPanel().setDrawExplanationLine(false);
            this.descriptionView.getDendroPanel().repaint();
        }
    }

    public void expandLevel() {
        if (this.desiredLevel[this.currentTree] < this.maxDepth[this.currentTree]) {
            int n = this.currentTree;
            this.desiredLevel[n] = this.desiredLevel[n] + 1;
            this.showChildrenAboveLevel((ClassificationRegressionTreeNode)this.treeModel.getRoot());
        }
    }

    public void collapseLevel() {
        if (this.desiredLevel[this.currentTree] > 1) {
            int n = this.currentTree;
            this.desiredLevel[n] = this.desiredLevel[n] - 1;
            this.showChildrenAboveLevel((ClassificationRegressionTreeNode)this.treeModel.getRoot());
        }
    }

    public void show_tree() {
        try {
            String title_extra = ClassificationTreeGUI.getText("treevis_gui_title");
            String title = "";
            if (this.htmlTitle != null) {
                title = this.htmlTitle + "  -  " + this.treecollection.getModelName();
            } else {
                String title_reg = ClassificationTreeGUI.getText("treevis_gui_title_reg");
                String title_clas = ClassificationTreeGUI.getText("treevis_gui_title_clas");
                title = (this.treecollection.isRegression() ? title_reg : title_clas) + " " + title_extra + "  " + this.treecollection.getModelName();
            }
            this.setTitle(title);
            this.setIconImage(MinerApp.getResourceManager().getImage("minerapp.gif"));
            Container contentPane = this.getContentPane();
            this.treeCollectionPanel.setVisible(true);
            contentPane.add(this.treeCollectionPanel);
            this.pack();
            this.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace(System.out);
        }
    }

    public void setVisible(boolean flag) {
        super.setVisible(flag);
        this.treecollection.setDisplaySizeGraphic(false);
    }

    public static String getText(String key) {
        if (treeBundles == null) {
            treeBundles = MinerApp.getBundle("treeBundles");
        }
        String string = MinerApp.getBundleString(treeBundles, key);
        return string;
    }

    private void printPreview() {
        this.descriptionView.getDendroPanel().printPreview();
    }

    public void print() {
        PrintThread thrd = new PrintThread(this);
        thrd.start();
    }

    public class DrawableJTree
    extends JTree
    implements Printable {
        private boolean showSize;
        private Rectangle minusBox;
        private Rectangle plusBox;
        private int sizeIconWidth;
        private BufferedImage m_img;
        private boolean m_printing;
        private Point m_lastOrigin;
        private Rectangle2D.Double m_pageRect;

        public DrawableJTree(DefaultTreeModel treemodel) {
            super(treemodel);
            this.showSize = false;
            this.minusBox = null;
            this.plusBox = null;
            this.sizeIconWidth = 0;
            this.m_img = null;
            this.m_printing = false;
            this.m_lastOrigin = null;
            this.m_pageRect = null;
        }

        public void setShowSize(boolean flag) {
            this.showSize = flag;
        }

        public boolean getShowSize() {
            return this.showSize;
        }

        public int getRowHeight() {
            int srh = super.getRowHeight();
            return srh > 0 ? srh + 2 : 20;
        }

        public void setSizeIconWidth(int val) {
            this.sizeIconWidth = val;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int print(Graphics g, PageFormat pf, int pnum) {
            Point myOrigin = new Point();
            Graphics2D g2 = (Graphics2D)g;
            if (!ClassificationTreeGUI.this.myPrintBegun) {
                ClassificationTreeGUI.this.myPrintBegun = true;
                ClassificationTreeGUI.this.myPrintDocTopLeft = new Point((int)this.getAlignmentX(), (int)this.getAlignmentY());
                ClassificationTreeGUI.this.myPrintDocSize = this.getSize();
                int docWidth = ClassificationTreeGUI.this.myPrintDocSize.width;
                int docHeight = ClassificationTreeGUI.this.myPrintDocSize.height;
                ClassificationTreeGUI.this.myPrintPageRect = new Rectangle2D.Double(pf.getImageableX(), pf.getImageableY(), pf.getImageableWidth(), pf.getImageableHeight());
                double pageWidth = ClassificationTreeGUI.this.myPrintPageRect.width;
                double pageHeight = ClassificationTreeGUI.this.myPrintPageRect.height;
                ClassificationTreeGUI.this.myPrintVertScale = ClassificationTreeGUI.this.myPrintHorizScale = ClassificationTreeGUI.this.myPrintPageRect.width / (double)ClassificationTreeGUI.this.myPrintDocSize.width;
                ClassificationTreeGUI.this.myPrintNumPagesAcross = (int)Math.ceil((double)docWidth * ClassificationTreeGUI.this.myPrintHorizScale / pageWidth);
                ClassificationTreeGUI.this.myPrintNumPagesDown = (int)Math.ceil((double)docHeight * ClassificationTreeGUI.this.myPrintVertScale / pageHeight);
            }
            double pageX = ClassificationTreeGUI.this.myPrintPageRect.x;
            double pageY = ClassificationTreeGUI.this.myPrintPageRect.y;
            double pageWidth = ClassificationTreeGUI.this.myPrintPageRect.width;
            double pageHeight = ClassificationTreeGUI.this.myPrintPageRect.height;
            if (pnum >= ClassificationTreeGUI.this.myPrintNumPagesAcross * ClassificationTreeGUI.this.myPrintNumPagesDown) {
                ClassificationTreeGUI.this.myPrintBegun = false;
                return 1;
            }
            int hpnum = pnum % ClassificationTreeGUI.this.myPrintNumPagesAcross;
            int vpnum = pnum / ClassificationTreeGUI.this.myPrintNumPagesAcross;
            try {
                myOrigin = new Point((int)(((double)ClassificationTreeGUI.this.myPrintDocTopLeft.x + (double)hpnum * pageWidth) / ClassificationTreeGUI.this.myPrintHorizScale), (int)(((double)ClassificationTreeGUI.this.myPrintDocTopLeft.y + (double)vpnum * pageHeight) / ClassificationTreeGUI.this.myPrintVertScale));
                g2.clip(ClassificationTreeGUI.this.myPrintPageRect);
                Rectangle clipRect = new Rectangle();
                g2.getClipBounds(clipRect);
                clipRect.x -= (int)pageX;
                clipRect.y -= (int)pageY;
                clipRect.x = (int)((double)clipRect.x / ClassificationTreeGUI.this.myPrintHorizScale) + myOrigin.x;
                clipRect.y = (int)((double)clipRect.y / ClassificationTreeGUI.this.myPrintVertScale) + myOrigin.y;
                clipRect.width = (int)Math.ceil((double)clipRect.width / ClassificationTreeGUI.this.myPrintHorizScale);
                clipRect.height = (int)Math.ceil((double)clipRect.height / ClassificationTreeGUI.this.myPrintVertScale);
                g2.translate(pageX, pageY);
                g2.translate(-myOrigin.x, -myOrigin.y);
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
                this.paint(g2);
                Object var18_15 = null;
            }
            catch (Throwable throwable) {
                Object var18_16 = null;
                throw throwable;
            }
            return 0;
        }
    }

    protected class PrintThread
    extends Thread {
        private ClassificationTreeGUI m_ui;

        public PrintThread(ClassificationTreeGUI ui) {
            this.m_ui = ui;
        }

        public void run() {
            PrinterJob pj = PrinterJob.getPrinterJob();
            if (pj.printDialog(MinerApp.getPrintAttributeSet())) {
                PageFormat pf = pj.validatePage(MinerApp.getDefaultPageFormat());
                Paper paper = pf.getPaper();
                double margin = 36.0;
                paper.setImageableArea(margin, margin, paper.getWidth() - margin * 2.0, paper.getHeight() - margin * 2.0);
                pf.setPaper(paper);
                pj.setPrintable(this.m_ui.jtree, pf);
                new MinerApp.GenericPrintThread(pj).start();
            }
            MinerApp.getMainFrame().requestFocus();
            this.m_ui.requestFocus();
        }
    }
}

