/*
 * Decompiled with CFR 0.152.
 */
package com.jrefinery.data.junit;

import com.jrefinery.data.TimePeriodFormatException;
import com.jrefinery.data.Year;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class YearTests
extends TestCase {
    static /* synthetic */ Class class$com$jrefinery$data$junit$YearTests;

    public static Test suite() {
        return new TestSuite(class$com$jrefinery$data$junit$YearTests == null ? (class$com$jrefinery$data$junit$YearTests = YearTests.class$("com.jrefinery.data.junit.YearTests")) : class$com$jrefinery$data$junit$YearTests);
    }

    public YearTests(String string) {
        super(string);
    }

    protected void setUp() {
    }

    public void testDateConstructor1() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        Year year = new Year(new Date(1009843199999L), timeZone);
        Year year2 = new Year(new Date(1009843200000L), timeZone);
        Assert.assertEquals((int)2001, (int)year.getYear());
        Assert.assertEquals((long)1009843199999L, (long)year.getEnd(timeZone));
        Assert.assertEquals((int)2002, (int)year2.getYear());
        Assert.assertEquals((long)1009843200000L, (long)year2.getStart(timeZone));
    }

    public void testDateConstructor2() {
        TimeZone timeZone = TimeZone.getTimeZone("America/Los_Angeles");
        Year year = new Year(new Date(1009871999999L), timeZone);
        Year year2 = new Year(new Date(1009872000000L), timeZone);
        Assert.assertEquals((int)2001, (int)year.getYear());
        Assert.assertEquals((long)1009871999999L, (long)year.getEnd(timeZone));
        Assert.assertEquals((int)2002, (int)year2.getYear());
        Assert.assertEquals((long)1009872000000L, (long)year2.getStart(timeZone));
    }

    public void test1900_previous() {
        Year year = new Year(1900);
        Year year2 = (Year)year.previous();
        Assert.assertNull((Object)year2);
    }

    public void test1900_next() {
        Year year = new Year(1900);
        Year year2 = (Year)year.next();
        Assert.assertEquals((int)1901, (int)year2.getYear());
    }

    public void test9999_previous() {
        Year year = new Year(9999);
        Year year2 = (Year)year.previous();
        Assert.assertEquals((int)9998, (int)year2.getYear());
    }

    public void test9999_next() {
        Year year = new Year(9999);
        Year year2 = (Year)year.next();
        Assert.assertNull((Object)year2);
    }

    public void testParseYear() {
        Year year = null;
        try {
            year = Year.parseYear("2000");
        }
        catch (TimePeriodFormatException timePeriodFormatException) {
            year = new Year(1900);
        }
        Assert.assertEquals((int)2000, (int)year.getYear());
        try {
            year = Year.parseYear(" 2001 ");
        }
        catch (TimePeriodFormatException timePeriodFormatException) {
            year = new Year(1900);
        }
        Assert.assertEquals((int)2001, (int)year.getYear());
        try {
            year = Year.parseYear("99");
        }
        catch (TimePeriodFormatException timePeriodFormatException) {
            year = new Year(1900);
        }
        Assert.assertEquals((int)1900, (int)year.getYear());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

