/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.participants;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.IConditionChecker;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;

public class CheckConditionsContext {
    private Map fCheckers = new HashMap();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public IConditionChecker getChecker(Class clazz) {
        return (IConditionChecker)this.fCheckers.get(clazz);
    }

    public void add(IConditionChecker checker) throws CoreException {
        IConditionChecker old = this.fCheckers.put(checker.getClass(), checker);
        if (old != null) {
            this.fCheckers.put(checker.getClass(), old);
            throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), 10003, Messages.format(RefactoringCoreMessages.CheckConditionContext_error_checker_exists, checker.getClass().toString()), null));
        }
    }

    public RefactoringStatus check(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        RefactoringStatus result = new RefactoringStatus();
        this.mergeResourceOperationAndValidateEdit();
        ArrayList values = new ArrayList(this.fCheckers.values());
        Collections.sort(values, new Comparator(){

            public int compare(Object o1, Object o2) {
                if (o1 instanceof ResourceChangeChecker) {
                    return -1;
                }
                if (o2 instanceof ResourceChangeChecker) {
                    return 1;
                }
                return 0;
            }
        });
        pm.beginTask("", values.size());
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            IConditionChecker checker = (IConditionChecker)iter.next();
            result.merge(checker.check((IProgressMonitor)new SubProgressMonitor(pm, 1)));
            if (!pm.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        return result;
    }

    private void mergeResourceOperationAndValidateEdit() throws CoreException {
        ResourceChangeChecker resourceChangeChecker;
        ValidateEditChecker validateEditChecker;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((validateEditChecker = (ValidateEditChecker)this.getChecker(clazz)) == null) {
            return;
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((resourceChangeChecker = (ResourceChangeChecker)this.getChecker(clazz2)) == null) {
            return;
        }
        IFile[] changedFiles = resourceChangeChecker.getChangedFiles();
        validateEditChecker.addFiles(changedFiles);
    }
}

