/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.extensionlocation;

import java.net.URL;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.extensionlocation.Activator;
import org.eclipse.equinox.internal.p2.extensionlocation.ExtensionLocationArtifactRepository;
import org.eclipse.equinox.internal.p2.extensionlocation.Messages;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.artifact.repository.IFileArtifactRepository;
import org.eclipse.equinox.internal.provisional.p2.core.ProvisionException;
import org.eclipse.equinox.internal.provisional.spi.p2.artifact.repository.IArtifactRepositoryFactory;
import org.eclipse.equinox.internal.provisional.spi.p2.artifact.repository.SimpleArtifactRepositoryFactory;
import org.eclipse.osgi.util.NLS;

public class ExtensionLocationArtifactRepositoryFactory
implements IArtifactRepositoryFactory {
    public IArtifactRepository create(URL location, String name, String type, Map properties) throws ProvisionException {
        IStatus status = this.validate(location, null);
        if (!status.isOK()) {
            throw new ProvisionException(status);
        }
        URL repoLocation = ExtensionLocationArtifactRepository.getLocalRepositoryLocation(location);
        if (repoLocation == null) {
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", Messages.failed_create_local_artifact_repository));
        }
        boolean failed = false;
        try {
            new SimpleArtifactRepositoryFactory().load(repoLocation, null);
            failed = true;
        }
        catch (ProvisionException provisionException) {}
        if (failed) {
            String msg = NLS.bind((String)Messages.repo_already_exists, (Object)location.toExternalForm());
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", 1001, msg, null));
        }
        IFileArtifactRepository repo = (IFileArtifactRepository)new SimpleArtifactRepositoryFactory().create(repoLocation, name, type, properties);
        return new ExtensionLocationArtifactRepository(location, repo, null);
    }

    public IArtifactRepository load(URL location, IProgressMonitor monitor) throws ProvisionException {
        IStatus status = this.validate(location, null);
        if (!status.isOK()) {
            throw new ProvisionException(status);
        }
        URL repoLocation = ExtensionLocationArtifactRepository.getLocalRepositoryLocation(location);
        if (repoLocation == null) {
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", Messages.failed_create_local_artifact_repository));
        }
        try {
            IFileArtifactRepository repo = (IFileArtifactRepository)new SimpleArtifactRepositoryFactory().load(repoLocation, null);
            return new ExtensionLocationArtifactRepository(location, repo, monitor);
        }
        catch (ProvisionException provisionException) {
            return this.create(location, Activator.getRepositoryName(location), "org.eclipse.equinox.p2.extensionlocation.artifactRepository", null);
        }
    }

    public IStatus validate(URL location, IProgressMonitor monitor) {
        try {
            ExtensionLocationArtifactRepository.validate(location, monitor);
        }
        catch (ProvisionException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }
}

