/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.codecimpl.fpx;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGDecodeParam;
import com.sun.image.codec.jpeg.JPEGImageDecoder;
import com.sun.media.jai.codec.FPXDecodeParam;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.SeekableStream;
import com.sun.media.jai.codecimpl.SimpleRenderedImage;
import com.sun.media.jai.codecimpl.fpx.FPXUtils;
import com.sun.media.jai.codecimpl.fpx.PropertySet;
import com.sun.media.jai.codecimpl.fpx.StructuredStorage;
import com.sun.media.jai.codecimpl.util.RasterFactory;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;

public class FPXImage
extends SimpleRenderedImage {
    private static final int SUBIMAGE_COLOR_SPACE_COLORLESS = 0;
    private static final int SUBIMAGE_COLOR_SPACE_MONOCHROME = 0;
    private static final int SUBIMAGE_COLOR_SPACE_PHOTOYCC = 0;
    private static final int SUBIMAGE_COLOR_SPACE_NIFRGB = 0;
    private static final String[] COLORSPACE_NAME = new String[]{"Colorless", "Monochrome", "PhotoYCC", "NIF RGB"};
    StructuredStorage storage;
    int numResolutions;
    int highestResWidth;
    int highestResHeight;
    float defaultDisplayHeight;
    float defaultDisplayWidth;
    int displayHeightWidthUnits;
    boolean[] subimageValid;
    int[] subimageWidth;
    int[] subimageHeight;
    int[][] subimageColor;
    int[] decimationMethod;
    float[] decimationPrefilterWidth;
    int highestResolution = -1;
    int maxJPEGTableIndex;
    byte[][] JPEGTable;
    int numChannels;
    int tileHeaderTableOffset;
    int tileHeaderEntryLength;
    SeekableStream subimageHeaderStream;
    SeekableStream subimageDataStream;
    int resolution;
    int tilesAcross;
    int[] bandOffsets;
    private static final int[] RGBBits8 = new int[]{8, 8, 8};
    private static final ComponentColorModel colorModelRGB8 = new ComponentColorModel(ColorSpace.getInstance(1004), RGBBits8, false, false, 1, 0);
    private static final byte[] PhotoYCCToRGBLUT;
    Hashtable properties;

    static {
        byte[] byArray = new byte[361];
        byArray[1] = 1;
        byArray[2] = 1;
        byArray[3] = 2;
        byArray[4] = 2;
        byArray[5] = 3;
        byArray[6] = 4;
        byArray[7] = 5;
        byArray[8] = 6;
        byArray[9] = 7;
        byArray[10] = 8;
        byArray[11] = 9;
        byArray[12] = 10;
        byArray[13] = 11;
        byArray[14] = 12;
        byArray[15] = 13;
        byArray[16] = 14;
        byArray[17] = 15;
        byArray[18] = 16;
        byArray[19] = 17;
        byArray[20] = 18;
        byArray[21] = 19;
        byArray[22] = 20;
        byArray[23] = 22;
        byArray[24] = 23;
        byArray[25] = 24;
        byArray[26] = 25;
        byArray[27] = 26;
        byArray[28] = 28;
        byArray[29] = 29;
        byArray[30] = 30;
        byArray[31] = 31;
        byArray[32] = 33;
        byArray[33] = 34;
        byArray[34] = 35;
        byArray[35] = 36;
        byArray[36] = 38;
        byArray[37] = 39;
        byArray[38] = 40;
        byArray[39] = 41;
        byArray[40] = 43;
        byArray[41] = 44;
        byArray[42] = 45;
        byArray[43] = 47;
        byArray[44] = 48;
        byArray[45] = 49;
        byArray[46] = 51;
        byArray[47] = 52;
        byArray[48] = 53;
        byArray[49] = 55;
        byArray[50] = 56;
        byArray[51] = 57;
        byArray[52] = 59;
        byArray[53] = 60;
        byArray[54] = 61;
        byArray[55] = 63;
        byArray[56] = 64;
        byArray[57] = 65;
        byArray[58] = 67;
        byArray[59] = 68;
        byArray[60] = 70;
        byArray[61] = 71;
        byArray[62] = 72;
        byArray[63] = 74;
        byArray[64] = 75;
        byArray[65] = 76;
        byArray[66] = 78;
        byArray[67] = 79;
        byArray[68] = 81;
        byArray[69] = 82;
        byArray[70] = 83;
        byArray[71] = 85;
        byArray[72] = 86;
        byArray[73] = 88;
        byArray[74] = 89;
        byArray[75] = 91;
        byArray[76] = 92;
        byArray[77] = 93;
        byArray[78] = 95;
        byArray[79] = 96;
        byArray[80] = 98;
        byArray[81] = 99;
        byArray[82] = 101;
        byArray[83] = 102;
        byArray[84] = 103;
        byArray[85] = 105;
        byArray[86] = 106;
        byArray[87] = 108;
        byArray[88] = 109;
        byArray[89] = 111;
        byArray[90] = 112;
        byArray[91] = 113;
        byArray[92] = 115;
        byArray[93] = 116;
        byArray[94] = 118;
        byArray[95] = 119;
        byArray[96] = 121;
        byArray[97] = 122;
        byArray[98] = 123;
        byArray[99] = 125;
        byArray[100] = 126;
        byArray[101] = -128;
        byArray[102] = -127;
        byArray[103] = -126;
        byArray[104] = -124;
        byArray[105] = -123;
        byArray[106] = -122;
        byArray[107] = -120;
        byArray[108] = -119;
        byArray[109] = -118;
        byArray[110] = -116;
        byArray[111] = -115;
        byArray[112] = -114;
        byArray[113] = -112;
        byArray[114] = -111;
        byArray[115] = -110;
        byArray[116] = -108;
        byArray[117] = -107;
        byArray[118] = -106;
        byArray[119] = -104;
        byArray[120] = -103;
        byArray[121] = -102;
        byArray[122] = -101;
        byArray[123] = -99;
        byArray[124] = -98;
        byArray[125] = -97;
        byArray[126] = -96;
        byArray[127] = -94;
        byArray[128] = -93;
        byArray[129] = -92;
        byArray[130] = -91;
        byArray[131] = -90;
        byArray[132] = -88;
        byArray[133] = -87;
        byArray[134] = -86;
        byArray[135] = -85;
        byArray[136] = -84;
        byArray[137] = -82;
        byArray[138] = -81;
        byArray[139] = -80;
        byArray[140] = -79;
        byArray[141] = -78;
        byArray[142] = -77;
        byArray[143] = -76;
        byArray[144] = -74;
        byArray[145] = -73;
        byArray[146] = -72;
        byArray[147] = -71;
        byArray[148] = -70;
        byArray[149] = -69;
        byArray[150] = -68;
        byArray[151] = -67;
        byArray[152] = -66;
        byArray[153] = -65;
        byArray[154] = -64;
        byArray[155] = -62;
        byArray[156] = -61;
        byArray[157] = -60;
        byArray[158] = -59;
        byArray[159] = -58;
        byArray[160] = -57;
        byArray[161] = -56;
        byArray[162] = -55;
        byArray[163] = -54;
        byArray[164] = -53;
        byArray[165] = -52;
        byArray[166] = -52;
        byArray[167] = -51;
        byArray[168] = -50;
        byArray[169] = -49;
        byArray[170] = -48;
        byArray[171] = -47;
        byArray[172] = -46;
        byArray[173] = -45;
        byArray[174] = -44;
        byArray[175] = -43;
        byArray[176] = -43;
        byArray[177] = -42;
        byArray[178] = -41;
        byArray[179] = -40;
        byArray[180] = -39;
        byArray[181] = -39;
        byArray[182] = -38;
        byArray[183] = -37;
        byArray[184] = -36;
        byArray[185] = -35;
        byArray[186] = -35;
        byArray[187] = -34;
        byArray[188] = -33;
        byArray[189] = -33;
        byArray[190] = -32;
        byArray[191] = -31;
        byArray[192] = -31;
        byArray[193] = -30;
        byArray[194] = -29;
        byArray[195] = -29;
        byArray[196] = -28;
        byArray[197] = -27;
        byArray[198] = -27;
        byArray[199] = -26;
        byArray[200] = -26;
        byArray[201] = -25;
        byArray[202] = -25;
        byArray[203] = -24;
        byArray[204] = -23;
        byArray[205] = -23;
        byArray[206] = -22;
        byArray[207] = -22;
        byArray[208] = -21;
        byArray[209] = -21;
        byArray[210] = -20;
        byArray[211] = -20;
        byArray[212] = -20;
        byArray[213] = -19;
        byArray[214] = -19;
        byArray[215] = -18;
        byArray[216] = -18;
        byArray[217] = -18;
        byArray[218] = -17;
        byArray[219] = -17;
        byArray[220] = -16;
        byArray[221] = -16;
        byArray[222] = -16;
        byArray[223] = -15;
        byArray[224] = -15;
        byArray[225] = -15;
        byArray[226] = -14;
        byArray[227] = -14;
        byArray[228] = -14;
        byArray[229] = -14;
        byArray[230] = -13;
        byArray[231] = -13;
        byArray[232] = -13;
        byArray[233] = -12;
        byArray[234] = -12;
        byArray[235] = -12;
        byArray[236] = -12;
        byArray[237] = -11;
        byArray[238] = -11;
        byArray[239] = -11;
        byArray[240] = -11;
        byArray[241] = -11;
        byArray[242] = -10;
        byArray[243] = -10;
        byArray[244] = -10;
        byArray[245] = -10;
        byArray[246] = -10;
        byArray[247] = -9;
        byArray[248] = -9;
        byArray[249] = -9;
        byArray[250] = -9;
        byArray[251] = -9;
        byArray[252] = -9;
        byArray[253] = -8;
        byArray[254] = -8;
        byArray[255] = -8;
        byArray[256] = -8;
        byArray[257] = -8;
        byArray[258] = -8;
        byArray[259] = -7;
        byArray[260] = -7;
        byArray[261] = -7;
        byArray[262] = -7;
        byArray[263] = -7;
        byArray[264] = -7;
        byArray[265] = -7;
        byArray[266] = -7;
        byArray[267] = -7;
        byArray[268] = -6;
        byArray[269] = -6;
        byArray[270] = -6;
        byArray[271] = -6;
        byArray[272] = -6;
        byArray[273] = -6;
        byArray[274] = -6;
        byArray[275] = -6;
        byArray[276] = -6;
        byArray[277] = -6;
        byArray[278] = -5;
        byArray[279] = -5;
        byArray[280] = -5;
        byArray[281] = -5;
        byArray[282] = -5;
        byArray[283] = -5;
        byArray[284] = -5;
        byArray[285] = -5;
        byArray[286] = -5;
        byArray[287] = -5;
        byArray[288] = -5;
        byArray[289] = -5;
        byArray[290] = -5;
        byArray[291] = -5;
        byArray[292] = -4;
        byArray[293] = -4;
        byArray[294] = -4;
        byArray[295] = -4;
        byArray[296] = -4;
        byArray[297] = -4;
        byArray[298] = -4;
        byArray[299] = -4;
        byArray[300] = -4;
        byArray[301] = -4;
        byArray[302] = -4;
        byArray[303] = -4;
        byArray[304] = -4;
        byArray[305] = -4;
        byArray[306] = -4;
        byArray[307] = -4;
        byArray[308] = -4;
        byArray[309] = -3;
        byArray[310] = -3;
        byArray[311] = -3;
        byArray[312] = -3;
        byArray[313] = -3;
        byArray[314] = -3;
        byArray[315] = -3;
        byArray[316] = -3;
        byArray[317] = -3;
        byArray[318] = -3;
        byArray[319] = -3;
        byArray[320] = -3;
        byArray[321] = -3;
        byArray[322] = -3;
        byArray[323] = -3;
        byArray[324] = -3;
        byArray[325] = -3;
        byArray[326] = -3;
        byArray[327] = -2;
        byArray[328] = -2;
        byArray[329] = -2;
        byArray[330] = -2;
        byArray[331] = -2;
        byArray[332] = -2;
        byArray[333] = -2;
        byArray[334] = -2;
        byArray[335] = -2;
        byArray[336] = -2;
        byArray[337] = -2;
        byArray[338] = -2;
        byArray[339] = -2;
        byArray[340] = -2;
        byArray[341] = -2;
        byArray[342] = -1;
        byArray[343] = -1;
        byArray[344] = -1;
        byArray[345] = -1;
        byArray[346] = -1;
        byArray[347] = -1;
        byArray[348] = -1;
        byArray[349] = -1;
        byArray[350] = -1;
        byArray[351] = -1;
        byArray[352] = -1;
        byArray[353] = -1;
        byArray[354] = -1;
        byArray[355] = -1;
        byArray[356] = -1;
        byArray[357] = -1;
        byArray[358] = -1;
        byArray[359] = -1;
        byArray[360] = -1;
        PhotoYCCToRGBLUT = byArray;
    }

    public FPXImage(SeekableStream seekableStream, FPXDecodeParam fPXDecodeParam) throws IOException {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 2;
        this.bandOffsets = nArray;
        this.properties = null;
        this.storage = new StructuredStorage(seekableStream);
        this.readImageContents();
        if (fPXDecodeParam == null) {
            fPXDecodeParam = new FPXDecodeParam();
        }
        this.resolution = fPXDecodeParam.getResolution();
        this.readResolution();
        this.bandOffsets = new int[this.numChannels];
        int n = 0;
        while (n < this.numChannels) {
            this.bandOffsets[n] = n;
            ++n;
        }
        this.minX = 0;
        this.minY = 0;
        this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(0, this.tileWidth, this.tileHeight, this.numChannels, this.numChannels * this.tileWidth, this.bandOffsets);
        this.colorModel = ImageCodec.createComponentColorModel(this.sampleModel);
    }

    private final byte PhotoYCCToNIFBlue(float f, float f2, float f3) {
        float f4 = f + 2.2179f * f2 - 345.99f;
        if (f4 < 0.0f) {
            return 0;
        }
        if (f4 > 360.0f) {
            return -1;
        }
        byte by = PhotoYCCToRGBLUT[(int)f4];
        return by;
    }

    private final byte PhotoYCCToNIFGreen(float f, float f2, float f3) {
        float f4 = f - 0.43031f * f2 - 0.9271f * f3 + 194.14f;
        if (f4 < 0.0f) {
            return 0;
        }
        if (f4 > 360.0f) {
            return -1;
        }
        byte by = PhotoYCCToRGBLUT[(int)f4];
        return by;
    }

    private final byte PhotoYCCToNIFRed(float f, float f2, float f3) {
        float f4 = f + 1.8215f * f3 - 249.55f;
        if (f4 < 0.0f) {
            return 0;
        }
        if (f4 > 360.0f) {
            return -1;
        }
        byte by = PhotoYCCToRGBLUT[(int)f4];
        return by;
    }

    private final byte YCCToNIFBlue(float f, float f2, float f3) {
        float f4 = f + 1.772f * f2 - 225.93f;
        if (f4 < 0.0f) {
            return 0;
        }
        if (f4 > 255.0f) {
            return -1;
        }
        return (byte)f4;
    }

    private final byte YCCToNIFGreen(float f, float f2, float f3) {
        float f4 = f - 0.34414f * f2 - 0.71414f * f3 + 134.9307f;
        if (f4 < 0.0f) {
            return 0;
        }
        if (f4 > 255.0f) {
            return -1;
        }
        return (byte)f4;
    }

    private final byte YCCToNIFRed(float f, float f2, float f3) {
        float f4 = f + 1.402f * f3 - 178.75499f;
        if (f4 < 0.0f) {
            return 0;
        }
        if (f4 > 255.0f) {
            return -1;
        }
        return (byte)f4;
    }

    private void addLPSTRProperty(String string, PropertySet propertySet, int n) {
        String string2 = propertySet.getLPSTR(n);
        if (string2 != null) {
            this.properties.put(string.toLowerCase(), string2);
        }
    }

    private void addLPWSTRProperty(String string, PropertySet propertySet, int n) {
        String string2 = propertySet.getLPWSTR(n);
        if (string2 != null) {
            this.properties.put(string.toLowerCase(), string2);
        }
    }

    private void addUI4Property(String string, PropertySet propertySet, int n) {
        if (propertySet.hasProperty(n)) {
            long l = propertySet.getUI4(n);
            this.properties.put(string.toLowerCase(), new Integer((int)l));
        }
    }

    private int getCompressionSubtype(int n) throws IOException {
        this.subimageHeaderStream.seek(this.tileHeaderTableOffset + 16 * n + 12);
        return this.subimageHeaderStream.readIntLE();
    }

    private int getCompressionType(int n) throws IOException {
        this.subimageHeaderStream.seek(this.tileHeaderTableOffset + 16 * n + 8);
        return this.subimageHeaderStream.readIntLE();
    }

    private void getImageInfo() {
        SeekableStream seekableStream = null;
        PropertySet propertySet = null;
        try {
            this.storage.changeDirectoryToRoot();
            seekableStream = this.storage.getStream("\u0005Image Info");
            if (seekableStream == null) {
                return;
            }
            propertySet = new PropertySet(seekableStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        this.addUI4Property("file source", propertySet, 0x21000000);
        this.addUI4Property("scene type", propertySet, 0x21000001);
        this.addLPWSTRProperty("software name/manufacturer/release", propertySet, 553648131);
        this.addLPWSTRProperty("user defined id", propertySet, 553648132);
        this.addLPWSTRProperty("copyright message", propertySet, 0x22000000);
        this.addLPWSTRProperty("legal broker for the original image", propertySet, 0x22000001);
        this.addLPWSTRProperty("legal broker for the digital image", propertySet, 0x22000002);
        this.addLPWSTRProperty("authorship", propertySet, 0x22000003);
        this.addLPWSTRProperty("intellectual property notes", propertySet, 0x22000004);
    }

    private Raster getJPEGCompressedTile(int n, int n2) throws IOException {
        byte by;
        byte by2;
        float f;
        float f2;
        float f3;
        int n3;
        int n4;
        Object object;
        JPEGImageDecoder jPEGImageDecoder;
        Object object2;
        int n5 = n2 * this.tilesAcross + n;
        int n6 = this.tileXToX(n);
        int n7 = this.tileYToY(n2);
        int n8 = this.getCompressionSubtype(n5);
        int n9 = n8 & 0xFF;
        int n10 = n8 >> 8 & 0xFF;
        int n11 = n8 >> 16 & 0xFF;
        int n12 = n8 >> 24 & 0xFF;
        JPEGDecodeParam jPEGDecodeParam = null;
        if (n12 != 0) {
            object2 = new ByteArrayInputStream(this.JPEGTable[n12]);
            jPEGImageDecoder = JPEGCodec.createJPEGDecoder((InputStream)object2);
            object = jPEGImageDecoder.decodeAsRaster();
            jPEGDecodeParam = jPEGImageDecoder.getJPEGDecodeParam();
        }
        this.subimageDataStream.seek(this.getTileOffset(n5));
        jPEGImageDecoder = jPEGDecodeParam != null ? JPEGCodec.createJPEGDecoder((InputStream)this.subimageDataStream, jPEGDecodeParam) : JPEGCodec.createJPEGDecoder((InputStream)this.subimageDataStream);
        object2 = jPEGImageDecoder.decodeAsRaster().createTranslatedChild(n6, n7);
        object = (DataBufferByte)((Raster)object2).getDataBuffer();
        byte[] byArray = ((DataBufferByte)object).getData();
        int n13 = this.subimageColor[this.resolution][0] >> 16;
        int n14 = this.tileWidth * this.tileHeight;
        if (n11 == 0 && n13 == 2) {
            n4 = 0;
            n3 = 0;
            while (n3 < n14) {
                f3 = byArray[n4] & 0xFF;
                f2 = byArray[n4 + 1] & 0xFF;
                f = byArray[n4 + 2] & 0xFF;
                float f4 = f3 * 1.3584f;
                by2 = this.PhotoYCCToNIFRed(f4, f2, f);
                by = this.PhotoYCCToNIFGreen(f4, f2, f);
                byte by3 = this.PhotoYCCToNIFBlue(f4, f2, f);
                byArray[n4] = by2;
                byArray[n4 + 1] = by;
                byArray[n4 + 2] = by3;
                n4 += this.numChannels;
                ++n3;
            }
        } else if (n11 == 1 && n13 == 3) {
            n4 = 0;
            n3 = 0;
            while (n3 < n14) {
                f3 = byArray[n4] & 0xFF;
                f2 = byArray[n4 + 1] & 0xFF;
                f = byArray[n4 + 2] & 0xFF;
                byte by4 = this.YCCToNIFRed(f3, f2, f);
                by2 = this.YCCToNIFGreen(f3, f2, f);
                by = this.YCCToNIFBlue(f3, f2, f);
                byArray[n4] = by4;
                byArray[n4 + 1] = by2;
                byArray[n4 + 2] = by;
                n4 += this.numChannels;
                ++n3;
            }
        }
        if (n11 == 1 && n13 == 3 && this.numChannels == 4) {
            n4 = 0;
            n3 = 0;
            while (n3 < n14) {
                byArray[n4] = (byte)(255 - byArray[n4]);
                byArray[n4 + 1] = (byte)(255 - byArray[n4 + 1]);
                byArray[n4 + 2] = (byte)(255 - byArray[n4 + 2]);
                n4 += 4;
                ++n3;
            }
        }
        return object2;
    }

    private synchronized void getProperties() {
        if (this.properties != null) {
            return;
        }
        this.properties = new Hashtable();
        this.getSummaryInformation();
        this.getImageInfo();
        this.properties.put("max_resolution", new Integer(this.highestResolution));
    }

    public Object getProperty(String string) {
        this.getProperties();
        return this.properties.get(string.toLowerCase());
    }

    public String[] getPropertyNames() {
        this.getProperties();
        int n = this.properties.size();
        String[] stringArray = new String[n];
        Enumeration enumeration = this.properties.keys();
        int n2 = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n2++] = (String)enumeration.nextElement();
        }
        return stringArray;
    }

    private Raster getSingleColorCompressedTile(int n, int n2) throws IOException {
        WritableRaster writableRaster;
        block4: {
            int n3;
            byte by;
            byte by2;
            byte by3;
            byte by4;
            block5: {
                int n4 = this.tileXToX(n);
                int n5 = this.tileYToY(n2);
                writableRaster = RasterFactory.createInterleavedRaster(0, this.tileWidth, this.tileHeight, this.numChannels * this.tileWidth, this.numChannels, this.bandOffsets, new Point(n4, n5));
                int n6 = this.subimageColor[this.resolution][0] >> 16;
                DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
                byte[] byArray = dataBufferByte.getData();
                int n7 = n2 * this.tilesAcross + n;
                int n8 = this.getCompressionSubtype(n7);
                byte by5 = (byte)(n8 & 0xFF);
                byte by6 = (byte)(n8 >> 8 & 0xFF);
                byte by7 = (byte)(n8 >> 16 & 0xFF);
                by4 = (byte)(n8 >> 24 & 0xFF);
                if (this.subimageColor[this.resolution][0] >> 16 == 2) {
                    float f = by5 & 0xFF;
                    float f2 = by6 & 0xFF;
                    float f3 = by7 & 0xFF;
                    float f4 = f * 1.3584f;
                    by3 = this.PhotoYCCToNIFRed(f4, f2, f3);
                    by2 = this.PhotoYCCToNIFGreen(f4, f2, f3);
                    by = this.PhotoYCCToNIFBlue(f4, f2, f3);
                } else {
                    by3 = by5;
                    by2 = by6;
                    by = by7;
                }
                int n9 = 0;
                n3 = this.tileWidth * this.tileHeight;
                if (this.numChannels == 1 || this.numChannels == 2) break block4;
                if (this.numChannels != 3) break block5;
                int n10 = 0;
                while (n10 < n3) {
                    byArray[n9] = by3;
                    byArray[n9 + 1] = by2;
                    byArray[n9 + 2] = by;
                    n9 += 3;
                    ++n10;
                }
                break block4;
            }
            if (this.numChannels != 4) break block4;
            int n11 = 0;
            while (n11 < n3) {
                byArray[n9] = by3;
                byArray[n9 + 1] = by2;
                byArray[n9 + 2] = by;
                byArray[n9 + 3] = by4;
                n9 += 4;
                ++n11;
            }
        }
        return writableRaster;
    }

    private void getSummaryInformation() {
        SeekableStream seekableStream = null;
        PropertySet propertySet = null;
        try {
            this.storage.changeDirectoryToRoot();
            seekableStream = this.storage.getStream("\u0005SummaryInformation");
            propertySet = new PropertySet(seekableStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        this.addLPSTRProperty("title", propertySet, 2);
        this.addLPSTRProperty("subject", propertySet, 3);
        this.addLPSTRProperty("author", propertySet, 4);
        this.addLPSTRProperty("keywords", propertySet, 5);
        this.addLPSTRProperty("comments", propertySet, 6);
        this.addLPSTRProperty("template", propertySet, 7);
        this.addLPSTRProperty("last saved by", propertySet, 8);
        this.addLPSTRProperty("revision number", propertySet, 9);
    }

    public Raster getTile(int n, int n2) {
        int n3 = n2 * this.tilesAcross + n;
        try {
            int n4 = this.getCompressionType(n3);
            if (n4 == 0) {
                return this.getUncompressedTile(n, n2);
            }
            if (n4 == 1) {
                return this.getSingleColorCompressedTile(n, n2);
            }
            if (n4 == 2) {
                return this.getJPEGCompressedTile(n, n2);
            }
            return null;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    private int getTileOffset(int n) throws IOException {
        this.subimageHeaderStream.seek(this.tileHeaderTableOffset + 16 * n);
        return this.subimageHeaderStream.readIntLE() + 28;
    }

    private int getTileSize(int n) throws IOException {
        this.subimageHeaderStream.seek(this.tileHeaderTableOffset + 16 * n + 4);
        return this.subimageHeaderStream.readIntLE();
    }

    private Raster getUncompressedTile(int n, int n2) throws IOException {
        int n3 = this.tileXToX(n);
        int n4 = this.tileYToY(n2);
        WritableRaster writableRaster = RasterFactory.createInterleavedRaster(0, this.tileWidth, this.tileHeight, this.numChannels * this.tileWidth, this.numChannels, this.bandOffsets, new Point(n3, n4));
        DataBufferByte dataBufferByte = (DataBufferByte)writableRaster.getDataBuffer();
        byte[] byArray = dataBufferByte.getData();
        int n5 = n2 * this.tilesAcross + n;
        this.subimageDataStream.seek(this.getTileOffset(n5));
        this.subimageDataStream.readFully(byArray, 0, this.numChannels * this.tileWidth * this.tileHeight);
        if (this.subimageColor[this.resolution][0] >> 16 == 2) {
            int n6 = this.tileWidth * this.tileHeight;
            int n7 = 0;
            while (n7 < n6) {
                float f = byArray[3 * n7] & 0xFF;
                float f2 = byArray[3 * n7 + 1] & 0xFF;
                float f3 = byArray[3 * n7 + 2] & 0xFF;
                float f4 = f * 1.3584f;
                byte by = this.PhotoYCCToNIFRed(f4, f2, f3);
                byte by2 = this.PhotoYCCToNIFGreen(f4, f2, f3);
                byte by3 = this.PhotoYCCToNIFBlue(f4, f2, f3);
                byArray[3 * n7] = by;
                byArray[3 * n7 + 1] = by2;
                byArray[3 * n7 + 2] = by3;
                ++n7;
            }
        }
        return writableRaster;
    }

    private void readImageContents() throws IOException {
        int n;
        this.storage.changeDirectoryToRoot();
        this.storage.changeDirectory("Data Object Store 000001");
        SeekableStream seekableStream = this.storage.getStream("\u0005Image Contents");
        PropertySet propertySet = new PropertySet(seekableStream);
        this.numResolutions = (int)propertySet.getUI4(0x1000000);
        this.highestResWidth = (int)propertySet.getUI4(0x1000002);
        this.highestResHeight = (int)propertySet.getUI4(0x1000003);
        this.displayHeightWidthUnits = (int)propertySet.getUI4(0x1000006, 0L);
        this.subimageValid = new boolean[this.numResolutions];
        this.subimageWidth = new int[this.numResolutions];
        this.subimageHeight = new int[this.numResolutions];
        this.subimageColor = new int[this.numResolutions][];
        this.decimationMethod = new int[this.numResolutions];
        this.decimationPrefilterWidth = new float[this.numResolutions];
        int n2 = 0;
        while (n2 < this.numResolutions) {
            n = n2 << 16;
            if (!propertySet.hasProperty(0x2000000 | n)) break;
            this.highestResolution = n2;
            this.subimageValid[n2] = true;
            this.subimageWidth[n2] = (int)propertySet.getUI4(0x2000000 | n);
            this.subimageHeight[n2] = (int)propertySet.getUI4(0x2000001 | n);
            byte[] byArray = propertySet.getBlob(0x2000002 | n);
            this.decimationMethod[n2] = propertySet.getI4(0x2000004 | n);
            int n3 = FPXUtils.getIntLE(byArray, 0);
            int n4 = FPXUtils.getIntLE(byArray, 4);
            this.subimageColor[n2] = new int[n4];
            int n5 = 0;
            while (n5 < n4) {
                int n6;
                this.subimageColor[n2][n5] = n6 = FPXUtils.getIntLE(byArray, 8 + 4 * n5);
                ++n5;
            }
            ++n2;
        }
        this.maxJPEGTableIndex = (int)propertySet.getUI4(0x3000002, -1L);
        this.JPEGTable = new byte[this.maxJPEGTableIndex + 1][];
        n = 0;
        while (n <= this.maxJPEGTableIndex) {
            int n7 = n << 16;
            this.JPEGTable[n] = (byte[])(propertySet.hasProperty(0x3000001 | n7) ? propertySet.getBlob(0x3000001 | n7) : null);
            ++n;
        }
    }

    private void readResolution() throws IOException {
        if (this.resolution == -1) {
            this.resolution = this.highestResolution;
        }
        this.storage.changeDirectoryToRoot();
        this.storage.changeDirectory("Data Object Store 000001");
        this.storage.changeDirectory("Resolution 000" + this.resolution);
        this.subimageHeaderStream = this.storage.getStream("Subimage 0000 Header");
        this.subimageHeaderStream.skip(28L);
        int n = this.subimageHeaderStream.readIntLE();
        this.width = this.subimageHeaderStream.readIntLE();
        this.height = this.subimageHeaderStream.readIntLE();
        int n2 = this.subimageHeaderStream.readIntLE();
        this.tileWidth = this.subimageHeaderStream.readIntLE();
        this.tileHeight = this.subimageHeaderStream.readIntLE();
        this.numChannels = this.subimageHeaderStream.readIntLE();
        this.tileHeaderTableOffset = this.subimageHeaderStream.readIntLE() + 28;
        this.tileHeaderEntryLength = this.subimageHeaderStream.readIntLE();
        this.subimageDataStream = this.storage.getStream("Subimage 0000 Data");
        this.tilesAcross = (this.width + this.tileWidth - 1) / this.tileWidth;
    }
}

