#ifndef S_R_INTERNALS_H /* ( */
#define S_R_INTERNALS_H

/* In R, Rinternals.h defines all of the internal R structures
 * line SEXP, etc.
 */

typedef long R_len_t; /* this is 'int' in R */

#include <R.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef s_object *SEXP ;

#define REALSXP S_MODE_DOUBLE
#define INTSXP  S_MODE_INT
#define VECSXP  S_MODE_LIST
#define STRSXP  S_MODE_CHAR
#define LGLSXP  S_MODE_LGL
#define CPLXSXP S_MODE_COMPLEX

#define allocVector(mode,length)       alcvec(mode,length,S_evaluator)
/* #define allocList(length)              allocVector(S_MODE_LIST,length) not same in R */
#define Rf_allocMatrix(sxptype,nrow,ncol) S_allocMatrix(sxptype,nrow,ncol,S_evaluator)
#define Rf_allocArray(sxptype,dims) S_allocArray(sxptype,dims,S_evaluator)
#define Rf_coerceVector(x,mode) coevec(x, mode, S_FALSE, CHECK_IT, S_evaluator)
#define Rf_TYPEOF(x) ((x)->mode)
#ifndef R_NO_REMAP
#define allocMatrix Rf_allocMatrix
#define allocArray Rf_allocArray
#define coerceVector Rf_coerceVector
#define TYPEOF Rf_TYPEOF
#endif

/* if R code uses DATAPTR, it will probably need to be rewritten. */
#define Rf_DATAPTR(x) ((void*)unsupported_R_entry_DATAPTR)
#ifndef R_NO_REMAP
#undef DATAPTR
#define DATAPTR Rf_DATAPTR
#endif

#define S_R_dataptr(x) (((x)->mode==S_MODE_STRUCTURE)?((x)->value.tree[0]):(x))

#define Rf_LOGICAL(x) LOGICAL_POINTER(S_R_dataptr(x))
#define Rf_INTEGER(x) INTEGER_POINTER(S_R_dataptr(x))
#define Rf_REAL(x)  NUMERIC_POINTER(S_R_dataptr(x))
/* R's Rcomplex is struct {double r,i;},
 * Splus's s_complex is struct {double re,im;}.
 * These have data in the same places so a cast
 * can cover up the differences.
 */
#define Rf_COMPLEX(x) ((Rcomplex *)COMPLEX_POINTER(S_R_dataptr(x)))
/* if R code uses RAW, it will probably need to be rewritten. */
#define Rf_RAW(x)	((unsigned char)unsupported_R_entry_RAW)

#ifndef R_NO_REMAP
#undef LOGICAL
#define LOGICAL Rf_LOGICAL
#undef INTEGER
#define INTEGER Rf_INTEGER
#undef REAL
#define REAL    Rf_REAL
#undef COMPLEX
#define COMPLEX Rf_COMPLEX
#undef RAW
#define RAW     Rf_RAW
#endif

/* coerce from long to int */
#define asInteger(sexp) S_get_integer_scalar(sexp,(char*)0,0,1,1,S_evaluator)
#define asLogical(sexp) S_get_logical_scalar(sexp,(char*)0,0,1,1,S_evaluator)
#define asReal(sexp)    S_get_numeric_scalar(sexp,(char*)0,0,1,1,S_evaluator)
#define asChar(sexp)    S_get_string_scalar(sexp,(char*)0,0,1,1,S_evaluator)
#define asComplex(x) (unsupported_R_entry_asComplex)
#ifndef R_NO_REMAP
#endif

#define isInteger(x) (S_R_dataptr(x)->mode==S_MODE_INT)
#define isLogical(x) (S_R_dataptr(x)->mode==S_MODE_LGL)
#define isReal(x)    (S_R_dataptr(x)->mode==S_MODE_DOUBLE)
#define isString(x)  (S_R_dataptr(x)->mode==S_MODE_CHAR)
#define isComplex(x) (S_R_dataptr(x)->mode==S_MODE_COMPLEX)
#define isVector(x)  unsupported_R_entry_isVector(x)
#define isNewList(x) (S_R_dataptr(x)->mode==S_MODE_LIST)
#define isNumeric(x) (S_R_dataptr(x)->mode==S_MODE_DOUBLE)
#define isArray(x) IS_OBJ(x, array)
#define isMatrix(x) IS_OBJ(x, matrix)
#define isNull(x)    (S_R_dataptr(x)->mode==S_MODE_NULL)
#ifndef R_NO_REMAP
#endif

#define Rf_ScalarReal(x)       NUMERIC_VECTOR(x,S_evaluator)
#define Rf_ScalarComplex(x)    S_COMPLEX_VECTOR(x,S_evaluator)
#define Rf_ScalarInteger(x)    S_INTEGER_VECTOR(x,S_evaluator)
/* #define ScalarString(x)     STRING_VECTOR(x,S_evaluator) see mkString */
#define Rf_ScalarLogical(x)    S_LOGICAL_VECTOR(x,S_evaluator)
#ifndef R_NO_REMAP
#define ScalarReal    Rf_ScalarReal
#define ScalarComplex Rf_ScalarComplex
#define ScalarInteger Rf_ScalarInteger
#define ScalarLogical Rf_ScalarLogical
#endif

/* mkChar returns char* rather than R's CHAR object, so we can pass it to SET_STRING_ELT */
#define mkChar(str) c_s_cpy(str, S_evaluator)
/* R's STRING_ELT returns a SEXP that points to a single string.
 * Splus uses one SEXP to point to a vector of char*'s.
 * Ths STRING_ELT returns a char**, unlike R's which returns SEXP,
 * but if we always use it with CHAR() is can work out.
 */
#define STRING_ELT(x,i)   (&CHARACTER_DATA(x)[i])
/* if R code uses CHAR, it will probably need to be rewritten. */
/* This kludge will let common cases work, where the i'th
 * string from a character vector x is gotten with
 *    CHAR(STRING_ELT(x,i))
 */
#define Rf_CHAR(x) (*(char**)x)
#ifndef R_NO_REMAP
#undef CHAR
#define CHAR Rf_CHAR
#endif

#define SET_STRING_ELT(v, pos, val) CHARACTER_DATA((v))[(pos)]=(val) 
  
#define VECTOR_ELT(x,i)   LIST_POINTER(S_R_dataptr(x))[i]
#define SET_VECTOR_ELT(v, pos, val) SET_ELEMENT(S_R_dataptr(v), pos, val)

#define NAMED(x)  (PRECIOUS(x)?2:0)
#define Rf_duplicate(obj) COPY_ALL(obj)
#ifndef R_NO_REMAP
#define duplicate Rf_duplicate
#endif

/* SEXP install(const char *name): return addr of character(1) containing name */
/* It could return fixed address for previously used or well known attribute names,
 * but it doesn't yet. */
#define Rf_install(name) STRING_VECTOR(c_s_cpy(name, S_evaluator), S_evaluator)
#ifndef R_NO_REMAP
#define install Rf_install
#endif

#define Rf_getAttrib(x,nm) S_RCOMPAT_getAttrib(x, string_value(nm, S_evaluator), S_evaluator)
#define Rf_setAttrib(x,nm,val) S_RCOMPAT_setAttrib(x, string_value(nm, S_evaluator), val, S_evaluator)
#define Rf_mkString(str)  S_RCOMPAT_mkString(str, S_evaluator)
#ifndef R_NO_REMAP
#define getAttrib Rf_getAttrib
#define setAttrib Rf_setAttrib
#define mkString  Rf_mkString
#endif

#define CAR(x) VECTOR_ELT(x,0)
#define CADR(x) VECTOR_ELT(x,1)
#define CAAR(x) CAR(CAR(x))
#define CDAR(x) CDR(CAR(x))
#define CDDR(x) CDR(CDR(x))

#define SETCAR(x,val) SET_VECTOR_ELT(x,0,val)
#define SETCADR(x,val) SET_VECTOR_ELT(x,1,val)

#define R_NilValue blt_in_NULL
#define R_BlankString      Rf_install("")

#define R_DimSymbol        Rf_install("dim")
#define R_DimNamesSymbol   Rf_install("dimnames")
#define R_NamesSymbol      Rf_install("names")
#define R_ClassSymbol      Rf_install("class")
#define R_RowNamesSymbol   Rf_install("row.names")
#define R_LevelsSymbol     Rf_install("levels")
#define R_TspSymbol        Rf_install("tsp")

#define PROTECT(obj) (obj)
#define UNPROTECT(obj) (obj)

/* don't use S version of length macro */
#ifdef LENGTH
#undef LENGTH
#endif
#define LENGTH(obj) GET_LENGTH(S_R_dataptr(obj))
#define length(obj) LENGTH(obj)
#define SETLENGTH(x,len) SET_LENGTH(x,len)

#define Rf_lang1(func) CALL_0_F(func,S_evaluator)
#define Rf_lang2(func,arg1) CALL_1_F(func,arg1,S_evaluator)
#define Rf_lang3(func,arg1,arg2) CALL_2_F(func,arg1,arg2,S_evaluator)
#define Rf_lang4(func,arg1,arg2,arg3) CALL_3_F(func,arg1,arg2,arg3,S_evaluator)

/* macros for unsupported R fns that will generate helpful compile errors. */
#define arraySubscript(i,sexp1,sexp2,func1,func2,sexp3) unsupported_R_entry_arraySubscript
#define allocString(x) ((SEXP)unsupported_R_entry_allocString)
#define errorcall unsupported_R_entry_errorcall
#define warningcall  unsupported_R_entry_warningcall
#define checkArity(sexp1,sexp2) (unsupported_R_entry_checkArity)
#define R_GlobalEnv ((SEXP)unsupported_R_entry_R_GlobalEnv)
#define R_MakeExternalPtr(voidp,sexp1,sexp2) ((SEXP)unsupported_R_entry_R_MakeExternalPtr)
#define CDR(x) ((SEXP)unsupported_R_entry_CDR)
#define CONS(sexp1,sexp2) ((SEXP)unsupported_R_entry_CONS)
#define LCONS(sexp1,sexp2) ((SEXP)unsupported_R_entry_LCONS)
#define NA_STRING ((char*)unsupported_R_entry_NA_STRING)

/* For now, we assume an 'environment' (rho) in Splus is the integer
 * output  by a call to new.frame() or sys.nframe().
 * (We would like to allow rho to be a list with names.
 * eval(expr,rho) and findVar(name,rho) could work in that case,
 * but {define,set}Var() would not work completely.)
 */
#define Rf_eval(expr, rho)  EVAL_IN_FRAME(expr, (int)asInteger(rho))
/* For now we ignore the difference betwen R's <- and <<- */
/* Note that typical usage of Rf_defineVar(install("z"), value, rho)
 * wastefully converts "z" to a character vector and back to string.
 */
#define Rf_defineVar(name, value, rho) ASSIGN_IN_FRAME(*asChar(name), value, asInteger(rho))
#define Rf_setVar(name, value, rho)    ASSIGN_IN_FRAME(*asChar(name), value, asInteger(rho))
#define Rf_findVar(name, rho)          find_in_frame(make_name(*asChar(name), S_evaluator), asInteger(rho), S_evaluator)

/* The following is pretty lame check.  isEnvironment could check that
 * the integer rho is in the range of current frame numbers.
 */
#define Rf_isEnvironment(rho) ( isInteger(rho) && LENGTH(rho)==1 )
#define Rf_gsetVar(name, value, rho) ((SEXP)unsupported_R_entry_Rf_gsetVar)(name, value, rho)

#ifndef R_NO_REMAP /* ( */
#define findVar         Rf_findVar
#define defineVar       Rf_defineVar
#define setVar          Rf_setVar
#define isEnvironment   Rf_isEnvironment
#define gsetVar         Rf_gsetVar
#define eval            Rf_eval
#define lang1           Rf_lang1
#define lang2           Rf_lang2
#define lang3           Rf_lang3
#define lang4           Rf_lang4
#endif /* ) R_NO_REMAP */


#ifdef __cplusplus
}
#endif

#endif /* S_R_INTERNALS_H) */
