#ifndef SX11_H
#define SX11_H


#include "S_engine.h"
#include "device.h"

#ifdef error_code
#undef error_code
#endif
#include <X11/X.h>
#include <X11/Xlib.h>

#include <X11/Intrinsic.h>

#define STRlen(p) ((p) ? strlen(p) : 0)


#define WINDOW_X_ORIGIN  0               /* default window upper left */
#define WINDOW_Y_ORIGIN  0
#define WINDOW_WIDTH   400
#define WINDOW_HEIGHT  400



#define MAX_COLORS     1024

#define NSHADES  sizeof(Shades)/sizeof(Shade16)
#define Bitmap_width 16
#define Bitmap_height 16

typedef unsigned char Shade16[32];

static Shade16 Shades[] = {
#include "x11texture.h"
};



#define NFONTS 4


typedef struct {
 Window window;
 GC xgc;
 Display *display;

 double xMapFudge, yMapFudge;
 int windowWidth, windowHeight;
 int trueWidth, trueHeight;
 double pixelAspectRatio;

 int AutoBackingStore;

 Pixmap      nmap, rmap;
 XImage* xim;

 Cursor      cursor_readpen, cursor_normal;

 int         char_color;
 int         pen_color;

 char *color_names[MAX_COLORS];
 unsigned long color_cookies[MAX_COLORS];
 int n_colors;

 Pixmap ShadePixmap[MAX_COLORS+1];
 Shade16 *Shades;
 
 int         blackpixel, whitepixel;

 Font        font,fonts[NFONTS];
 XFontStruct *fontstruct;

 int         font_width,font_height,font_widths[NFONTS],
             font_heights[NFONTS],currfont;

 device *dev;  /* Bootstrap itself as a real kludge to avoid re
                  prototyping many functions
                */
} X11_Attrs;



vector *
DNAME(long *iask, char **xgeom,
              long *xreverse,
              char **xdisplay,
              long *xcloseDisplay,
              long *autoBackingStore,
              char **title,
              long *keepdisplayList
          );


int setup_DNAME_device_instance(device *Ndevice);

#define DNAME_LOCAL_PARAMETERS_SIZE (sizeof(X11_Attrs))

void init_x11_struct(X11_Attrs* dev_parms_ptr, device *Ndevice, s_evaluator *S_evaluator);
void init_x11_device_parameters(X11_Attrs *dev_parms_ptr);
void init_x11_graphics_parameters(X11_Attrs *local_params,XGCValues *);
XGCValues *init_x11_screen_parameters(X11_Attrs *params, int xrev2, s_evaluator *S_evaluator);
int set_backing_store(X11_Attrs *params, Widget w, s_evaluator *S_evaluator);


device *create_device(X11_Attrs *params, s_evaluator *S_evaluator);
boolean fill_in_X11_device(X11_Attrs *params, Widget w, Dimension wd, Dimension ht);



/* #define DEBUG */

#ifdef DEBUG
#define ENTER(s) printf("entering %s\n",s);fflush(stdout);
#define LEAVE(s) printf("leaving %s\n",s);fflush(stdout);
#define MSG(s) printf("%s\n",s);fflush(stdout);
#else
#define ENTER(s) ;
#define LEAVE(s) ;
#define MSG(s) ;
#endif



#endif
