/* @(#) Copyright (c), 1987, 2006 Insightful Corp.  All rights reserved. */
/* @(#) $RCSfile: graphics.h,v $: $Revision: #14 $, $Date: 2006/07/10 $  */

#ifndef S_GRAPHICS_H
#define S_GRAPHICS_H 1

#include "libext.h"
#if defined(_MSC_VER) /*(*/
/* Microsoft Visual C++ */
/*YB: Fixed error C2371: 'BGRP' : redefinition; different basic types */
#ifndef WIN32
#undef F77_COMDECL
#undef F77_COM
#define F77_COMDECL(bgrp) BGRP
#define F77_COM(bgrp) BGRP
#endif
#endif /*)*/
/*YB: Removed warning LNK4049: locally defined symbol "_bgrp_" imported*/
#ifdef WIN32
	extern float F77_COMDECL(bgrp) [];
#else
	LibExtern float F77_COMDECL(bgrp) [];
#endif
#define amodes(p) (F77_COM(bgrp)+p-1)
#define am(p) (F77_COM(bgrp)[p-1])
#define amArray (F77_COM(bgrp))
#include "unlibext.h"

typedef struct s_gr_par {
	char *name;
	int action;
	int reset;
	int am_start;
	int length;
	int position;
} gr_par;

#define MARK 192
#define ONEW 121
#define LTY 8
#define MARK_NUMBER 136
#define UNSCALED ((F77_COM(bgrp)[16])<2.5)

extern s_object *S_gr_things(), *S_gr_disp(), *S_cur_pic(), *S_gr_set();
extern s_object *gr_distance(), *image_scale();
extern void gr_transform();

/* Set or get the value of an element in the am() array containing */
/* the graphics parameter settings for the current device.         */

extern double S_get_am(long n);
extern void S_set_am(long n, double value);

#endif /* !_S_GRAPHICS_H_ )*/
