/***
   NAME     Sqpe.h
   PURPOSE  This file contains platform specific functions exported from sqpe.dll(.so) 
***/
#ifndef __SQPE__
#define __SQPE__
#include "S_ansi.h"
#include "S_struct.h"
#include "libext.h"

#define S_CALL_API(returnType) LibExtern returnType S_STDCALL

#ifdef __cplusplus
extern "C" {
#endif

S_CALL_API(int)  Sqpe(	int argc, char *argv[], char *dlllist[]);
S_CALL_API(int)  SpSetupTextOutputRouting(long*, long* );
S_CALL_API(void) Sqpe_DllSearchList_Set(char *dlllist[]);
S_CALL_API(void) Sqpe_DllSearchList_Add(char *pszDllName);
S_CALL_API(void) Sqpe_DllSearchList_Remove(char *pszDllName);
S_CALL_API(void) Sqpe_DllSearchList_RemoveAll( void );
S_CALL_API(int)  SqpeReadFromPipe( void* hPipe, void* lpBuffer, long nBufferSize );  
S_CALL_API(void) SqpeTrace0(const char* lpszFormat);
S_CALL_API(void) SqpeAssert(int f);
S_CALL_API(int)  SqpeIsValidAddress(void * pMem, unsigned int nBytes);
/* Get the current global S evaluator. */
S_CALL_API(s_evaluator*) Sqpe_GetCurrentEvaluator(void);

S_CALL_API(void) SpSetEventLoopFlag(int bEventLoop);
S_CALL_API(void) SpSetSilentStartup(int bSilent);
S_CALL_API(void) SpSetAuditFlag(int bAudit);
S_CALL_API(void) SpGetStdioConsoleStatus(int iRetStatus[]);
S_CALL_API(void) SpInitArgs(int from_argc, char *from_argv[], int to_argc_max, char *to_argv[]);
S_CALL_API(void) SpAddArg(int *to_argc, char *to_argv[], char *arg_value);
S_CALL_API(void) SpTraceObj(s_object* );

#ifdef __cplusplus
}
#endif
#endif /* __SQPE__ */
