<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" standalone="yes" indent="yes"/>
	
	<xsl:template match="/">
		<xsl:variable name="root" select="." />
		<xsl:variable name="level1Children" select="./*" />
		<xsl:variable name="level1Child1" select="$level1Children[1]" />

		<xsl:variable name="children" select="$level1Child1/*"/>
		<xsl:variable name="nUniqueNames">
			<xsl:call-template name="CountLevel2Nodes">
				<xsl:with-param name="level2" select="$children" />
			</xsl:call-template>
		</xsl:variable>

		<xsl:element name="SPLUS">
			<xsl:choose>
				<xsl:when test="$nUniqueNames > 1">
					<xsl:element name="List">
						<xsl:attribute name="length">
							<xsl:value-of select="$nUniqueNames"/>
						</xsl:attribute>
						<xsl:attribute name="named">F</xsl:attribute>
						
						<xsl:element name="Components">
							<xsl:call-template name="Level2Nodes">
								<xsl:with-param name="level2" select="$children"/>
								<xsl:with-param name="needList" select="1" />
							</xsl:call-template>
						</xsl:element>
					</xsl:element>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="Level2Nodes">
						<xsl:with-param name="level2" select="$children"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:element>
	</xsl:template>
	
	<xsl:template name="CountLevel2Nodes">
		<xsl:param name="level2" select="''"/>
		<xsl:param name="rCount" select="1"/>
		
		<xsl:variable name="firstChild" select="$level2[1]"/>
		<xsl:variable name="child1Name" select="name($firstChild)" />
		<xsl:variable name="same" select="$level2[name(.) = $child1Name]" />
		<xsl:variable name="other" select="$level2[name(.) != $child1Name]" />

		<xsl:choose>
			<xsl:when test="boolean($other)">
				<xsl:call-template name="CountLevel2Nodes">
					<xsl:with-param name="level2" select="$other"/>
					<xsl:with-param name="rCount" select="$rCount + 1" />
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$rCount"/>
			</xsl:otherwise>
		</xsl:choose>		
	</xsl:template>

	<xsl:template name="Level2Nodes">
		<xsl:param name="level2" select="''"/>
		<xsl:param name="needList" select="''" />
		
		<xsl:variable name="firstChild" select="$level2[1]"/>
		<xsl:variable name="child1Name" select="name($firstChild)" />
		<xsl:variable name="same" select="$level2[name(.) = $child1Name]" />
		<xsl:variable name="other" select="$level2[name(.) != $child1Name]" />
		
		<xsl:if test="boolean($same)">
			<xsl:choose>
				<xsl:when test="boolean($needList)">
					<xsl:element name="Component">
						<xsl:call-template name="NodesOfOneName">
							<xsl:with-param name="nodes" select="$same"/>
						</xsl:call-template>
					</xsl:element>
				</xsl:when>
				<xsl:otherwise>
					<xsl:call-template name="NodesOfOneName">
						<xsl:with-param name="nodes" select="$same"/>
					</xsl:call-template>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>

		<xsl:if test="boolean($other)">
			<xsl:call-template name="Level2Nodes">
				<xsl:with-param name="level2" select="$other"/>
				<xsl:with-param name="needList" select="$needList"/>
			</xsl:call-template>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="NodesOfOneName">
		<xsl:param name="nodes" select="''"/>

		<xsl:variable name="firstChild" select="$nodes[1]"/>
		<xsl:variable name="child1Name" select="name($firstChild)" />
		<xsl:variable name="firstChildChildren" select="$firstChild/*" />
		
		<xsl:variable name="nRows" select="count($nodes)"/>
		<xsl:variable name="nCols" select="count($firstChildChildren)" />
		
		<xsl:element name="DataFrame">
			<xsl:attribute name="numRows"><xsl:value-of select="$nRows"/></xsl:attribute>
			<xsl:attribute name="numCols"><xsl:value-of select="$nCols"/></xsl:attribute>
			
			<xsl:element name="RowNames">
				<xsl:attribute name="length"><xsl:value-of select="$nRows"/></xsl:attribute>
				<Items>
					<xsl:for-each select="$nodes">
						<Item><xsl:value-of select="position()"/></Item>
					</xsl:for-each>
				</Items>
			</xsl:element>
			
			<xsl:element name="Columns">
				<xsl:for-each select="$firstChildChildren">
					<xsl:variable name="cName" select="name(.)" />
					<xsl:element name="Column">
						<xsl:attribute name="length"><xsl:value-of select="$nRows"/></xsl:attribute>
						<xsl:attribute name="type">character</xsl:attribute>
						<xsl:attribute name="name"><xsl:value-of select="$cName"/></xsl:attribute>
						
						<xsl:element name="Items">
							<xsl:for-each select="$nodes">
								<xsl:variable name="allColumns" select="./*"/>
								<xsl:variable name="thisColumn" select="$allColumns[name(.) = $cName]" />
								<xsl:element name="Item">
									<xsl:choose>
										<xsl:when test="not(boolean($thisColumn))">
											<xsl:text></xsl:text>
										</xsl:when>
										<xsl:otherwise>
											<xsl:value-of select="$thisColumn/text()"/>
										</xsl:otherwise>
									</xsl:choose>
								</xsl:element>
							</xsl:for-each>
						</xsl:element>
					</xsl:element>
				</xsl:for-each>
			</xsl:element>
		</xsl:element>
	</xsl:template>
	
</xsl:stylesheet>
