/*----------------------------------------------------------------------
  File    : vecops.h
  Contents: some special vector operations
  Author  : Christian Borgelt
  History : 16.09.1996 file created
            04.02.1999 long INT64 changed to INT64
            03.06.2001 function v_shuffle added
            02.01.2002 functions v_intsort, v_fltsort, v_dblsort added
            03.03.2002 functions v_reverse, v_intrev etc. added
            21.08.2003 function v_heapsort added
            16.01.2007 shuffle functions for basic data types added
----------------------------------------------------------------------*/
#ifndef __VECOPS__
#define __VECOPS__
#include "apriori_entries.h"

#ifdef __cplusplus
extern "C" {
#endif

/*----------------------------------------------------------------------
  Type Definitions
----------------------------------------------------------------------*/
typedef INT64 VCMPFN (const void *p1, const void *p2, void *data);

/*----------------------------------------------------------------------
  Functions
----------------------------------------------------------------------*/
extern void v_sort     (void *vec, INT64 n, VCMPFN cmpfn, void *data);
extern void v_heapsort (void *vec, INT64 n, VCMPFN cmpfn, void *data);
extern void v_move     (void *vec, INT64 off, INT64 n, INT64 pos, INT64 esz);
extern void v_shuffle  (void *vec, INT64 n, double randfn (void));
extern void v_reverse  (void *vec, INT64 n);

extern void v_intsort  (INT64    *vec, INT64 n);
extern void v_intrev   (INT64    *vec, INT64 n);
extern void v_intshfl  (INT64    *vec, INT64 n, double randfn (void));

extern void v_fltsort  (float  *vec, INT64 n);
extern void v_fltrev   (float  *vec, INT64 n);
extern void v_fltshfl  (float  *vec, INT64 n, double randfn (void));

extern void v_dblsort  (double *vec, INT64 n);
extern void v_dblrev   (double *vec, INT64 n);
extern void v_dblshfl  (double *vec, INT64 n, double randfn (void));

#ifdef __cplusplus
}
#endif


#endif
