// IMCSRGenerator.h: interface for the IMCSRGenerator class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(_IMCSRCGENERATOR__INCLUDED_)
#define _IMCSRCGENERATOR__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "IMObjects.h"
#include "IMNaiveBayes.h"
#include "IMTree.h"
#include "IMNeuralNetwork.h"
#include "IMKMeansCluster.h"
#include "IMCoxRegression.h"
#include "IMLinearRegression.h"
#include "IMLogisticRegression.h"
#include "IMPrincipalComponents.h"

class IMCSRCGenerator  
{
public:
	IMCSRCGenerator(const char* pszOutputDir=NULL, const char* pszInputDir=NULL );
	virtual ~IMCSRCGenerator();

	virtual long isValid(void);
	long copyFile(const char* pszFileTo, const char* pszFileFrom=NULL, const char* pszModelName=NULL);
	long copyCommonFiles(const char* pszModelName=NULL);
	long copyAllFilesForModel(const char* pszModelName);

	long writeModelAndC(const IMinerObject& model, const char* modelName);
	long writeModelInputAndC(const IMinerObject& model, const IMinerDataSet& rectDataInput, const char* modelName);

private:
	char* m_pszOutputDir;  //output directory
	char* m_pszInputDir;   //input directory
};

#endif // !defined(_IMCSRCGENERATOR__INCLUDED_)
