<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
          xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
>
<xsl:output method="html" indent="yes" encoding="ISO-8859-1"/>
     <xsl:template match="/">
               <html>
                    <head/>
                    <body>
                         <xsl:for-each select="ComponentComments">
                              <h3><font color="black" font-family="Arial">Component Information</font></h3>
                              <xsl:for-each select="AuthorComments">
                                   <xsl:if test="position()=1">
                                        <table bgcolor="white" border="1" cellpadding="5" cellspacing="0" width="425">
                                             <xsl:if test="position()=1">
                                                  <xsl:text disable-output-escaping="yes">&lt;tbody&gt;</xsl:text>
                                             </xsl:if>
                                             <tr>
                                                  <td bgcolor="black">
                                                       <font color="white" font-family="Arial">Author</font>
                                                  </td>
                                                  <xsl:for-each select="../AuthorComments">
                                                       <td bgcolor="#555555">
                                                            <xsl:for-each select="AuthorName">
                                                                 <font color="white" font-family="Arial">
                                                                      <xsl:apply-templates/>
                                                                 </font>
                                                            </xsl:for-each>
                                                       </td>
                                                  </xsl:for-each>
                                             </tr>
                                             <tr>
                                                  <td bgcolor="black">
                                                       <font color="white" font-family="Arial">Name</font>
                                                  </td>
                                                  <xsl:for-each select="../AuthorComments">
                                                       <td bgcolor="#555555">
                                                            <xsl:for-each select="AuthorCommentTitle">
                                                                 <font color="white" font-family="Arial">
                                                                      <xsl:apply-templates/>
                                                                 </font>
                                                            </xsl:for-each>
                                                       </td>
                                                  </xsl:for-each>
                                             </tr>
                                             <tr>
                                                  <td bgcolor="black">
                                                       <font color="white" font-family="Arial">Date</font>
                                                  </td>
                                                  <xsl:for-each select="../AuthorComments">
                                                       <td bgcolor="#555555">
                                                            <xsl:for-each select="AuthorCommentDateCreated">
                                                                 <font color="white" font-family="Arial">
                                                                      <xsl:apply-templates/>
                                                                 </font>
                                                            </xsl:for-each>
                                                       </td>
                                                  </xsl:for-each>
                                             </tr>
                                             <tr>
                                                  <td bgcolor="black">
                                                       <font color="white" font-family="Arial">Description</font>
                                                  </td>
                                                  <xsl:for-each select="../AuthorComments">
                                                       <td bgcolor="#555555">
                                                            <xsl:for-each select="AuthorCommentText">
                                                                 <font color="white" font-family="Arial">
                                                                      <xsl:apply-templates/>
                                                                 </font>
                                                            </xsl:for-each>
                                                       </td>
                                                  </xsl:for-each>
                                             </tr>
                                             <xsl:if test="position()=last()">
                                                  <xsl:text disable-output-escaping="yes">&lt;/tbody&gt;</xsl:text>
                                             </xsl:if>
                                        </table>
                                   </xsl:if>
                              </xsl:for-each>
                              <h3><font color="black" font-family="Arial">Discussion Comments</font></h3>
                              <xsl:for-each select="DiscussionComments">
                                   <xsl:for-each select="Comment">
								<xsl:if test="position()=1">
									<xsl:text disable-output-escaping="yes">&lt;table bgcolor="black" border="1" cellpadding="5" cellspacing="0" rules="all" width="475"&gt;</xsl:text>
								</xsl:if>
								<xsl:if test="position()=1">
									<thead>
										<tr bgcolor="black">
											<td width="75">
												<font color="white" font-family="Arial">Author</font>
											</td>
											<td width="100">
												<font color="white" font-family="Arial">Date</font>
											</td>
											<td width="300">
												<font color="white" font-family="Arial">Comment</font>
											</td>
										</tr>
									</thead>
								</xsl:if>
								<xsl:if test="position()=1">
									<xsl:text disable-output-escaping="yes">&lt;tbody&gt;</xsl:text>
								</xsl:if>
								<tr bgcolor="#555555">
									<td>
										<xsl:for-each select="CommentAuthor">
											<font color="white" font-family="Arial">
												<xsl:apply-templates/>
											</font>
										</xsl:for-each>
									</td>
									<td>
										<xsl:for-each select="CommentDateCreated">
											<font color="white" font-family="Arial">
												<xsl:apply-templates/>
											</font>
										</xsl:for-each>
									</td>
									<td>
										<xsl:for-each select="CommentText">
											<font color="white" font-family="Arial">
												<xsl:apply-templates/>
											</font>
										</xsl:for-each>
									</td>
								</tr>
								<xsl:if test="position()=last()">
									<xsl:text disable-output-escaping="yes">&lt;/tbody&gt;</xsl:text>
								</xsl:if>
								<xsl:if test="position()=last()">
									<xsl:text disable-output-escaping="yes">&lt;/table&gt;</xsl:text>
								</xsl:if>
                                   </xsl:for-each>
				   <br/>
                              </xsl:for-each>
                              <br/>
                              <br/>
                         </xsl:for-each>
                    </body>
               </html>
     </xsl:template>
</xsl:stylesheet>
