<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:decimal-format name="blankNaN" NaN=" "/>
	<!-- XSL style sheet for GeneralRegressionModel element -->
	<xsl:template match="XML">
		<xsl:apply-templates select="IMML"/>
	</xsl:template>
	<xsl:template match="IMML">
		<html>
			<title>
				<xsl:value-of select="DisplayOptions/@title"/>
			</title>
			<style type="text/css">
				<xsl:value-of select="CSSText/text()"/>
			</style>
			<body>
				<div>
					<h2 class="title">
						<xsl:value-of select="DisplayOptions/@title"/>
					</h2>
				</div>
				<xsl:apply-templates select="GeneralRegressionModel"/>
			</body>
		</html>
	</xsl:template>
	<xsl:template match="GeneralRegressionModel">
		<xsl:choose>
			<xsl:when test="@modelType='multinomialLogistic'">
				<h3 class="subtitle">
					<xsl:text>Dependent variable: </xsl:text>
					<xsl:value-of select="@targetVariableName"/>
				</h3>
			</xsl:when>
			<xsl:otherwise>
				<h3 class="subtitle">
					<xsl:text>Dependent variable: </xsl:text>
					<xsl:value-of select="@targetVariableName"/>
				</h3>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:apply-templates/>
	</xsl:template>
	<xsl:template match="ParamMatrix">
		<DIV>
			<table cellSpacing="0" cellPadding="3" border="0">
				<tbody>
					<tr>
						<td class="tableBG">
							<H3 class="tableHead">Coefficient Estimates</H3>
							<table class="content" cellSpacing="1" cellPadding="5" border="0">
								<tr>
									<th class="blueBG">Variable</th>
									<th class="blueBG">Estimate</th>
									<th class="blueBG">Std.Err.</th>
									<th class="blueBG">t-Statistic</th>
									<th class="blueBG">Pr(|t|)</th>
								</tr>
								<xsl:apply-templates select="PCell"/>
							</table>
						</td>
					</tr>
				</tbody>
			</table>
		</DIV>
	</xsl:template>
	<xsl:template match="PCell">
		<xsl:variable name="decimalPattern" select="../../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../../DisplayOptions/@scientificPattern"/>

		<xsl:element name="tr">
			<xsl:attribute name="class">
				<xsl:choose>
					<xsl:when test="position() mod 2 = 0">whiteBG</xsl:when>
					<xsl:otherwise>greyBG</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>

			<th align="left">
				<xsl:value-of select="@parameterName"/>
			</th>
			<td align="center">
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@beta" />
						<xsl:with-param name="NaNstring" select="'NaN'" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</td>
			<td align="center">
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@stdErr" />
						<xsl:with-param name="NaNstring" select="'NaN'" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</td>
			<td align="center">
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@t" />
						<xsl:with-param name="NaNstring" select="'NaN'" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</td>
			<td align="center">
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@Pr" />
						<xsl:with-param name="NaNstring" select="'NaN'" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</td>
		</xsl:element>
	</xsl:template>
	<xsl:template match="CoefCorr">
		<xsl:variable name="decimalPattern" select="../../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../../DisplayOptions/@scientificPattern"/>

		<br/>
		<DIV>
			<table cellSpacing="0" cellPadding="3" border="0">
				<tbody>
					<tr>
						<td class="tableBG">
							<H3 class="tableHead">Correlated Coefficients</H3>
							<table class="content" cellSpacing="1" cellPadding="5" border="0">
								<TR>
									<TH class="blueBG">Coefficients</TH>
									<TH class="blueBG">Correlation</TH>
								</TR>
								<xsl:apply-templates select="CorrCell"/>
							</table>
						</td>
					</tr>
				</tbody>
			</table>
		</DIV>

		<DIV>
			<xsl:text>Threshold correlation: </xsl:text>
			<xsl:call-template name="roundNumber">
					<xsl:with-param name="string" select="@threshold" />
					<xsl:with-param name="NaNstring" select="'NaN'" />
					<xsl:with-param name="decimalPattern" select="$decimalPattern" />
					<xsl:with-param name="scientificPattern" select="$scientificPattern" />
			</xsl:call-template>
		</DIV>
	</xsl:template>

	<xsl:template match="CorrCell">
		<xsl:variable name="decimalPattern" select="../../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../../DisplayOptions/@scientificPattern"/>

		<xsl:element name="tr">
			<xsl:attribute name="class">
				<xsl:choose>
					<xsl:when test="position() mod 2 = 0">whiteBG</xsl:when>
					<xsl:otherwise>greyBG</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>

			<th align="left">
				<xsl:value-of select="@coef"/>
			</th>
			<td align="center">
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@value" />
						<xsl:with-param name="NaNstring" select="'NaN'" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</td>
		</xsl:element>
	</xsl:template>

	<xsl:template match="GeneralRegressionModel[@modelType='multinomialLogistic']/DevMatrix">
		<br/>
		<DIV>
			<table cellSpacing="0" cellPadding="3" border="0">
				<tbody>
					<tr>
						<td class="tableBG">
							<H3 class="tableHead">Analysis of Deviance</H3>
							<table class="content" cellSpacing="1" cellPadding="5" border="0">
								<TH class="blueBG">Source</TH>
								<TH class="blueBG">DF</TH>
								<TH class="blueBG">Deviance</TH>
								<xsl:apply-templates select="DevCell"/>
							</table>
						</td>
					</tr>
				</tbody>
			</table>
		</DIV>
	</xsl:template>

	<xsl:template match="GeneralRegressionModel[@modelType='generalLinear']/DevMatrix">
		<xsl:variable name="decimalPattern" select="../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../DisplayOptions/@scientificPattern"/>

		<br/>
		<DIV>
			<table cellSpacing="0" cellPadding="3" border="0">
				<tbody>
					<tr>
						<td class="tableBG">
							<H3 class="tableHead">Analysis of Variance</H3>
							<table class="content" cellSpacing="1" cellPadding="5" border="0">
								<TH class="blueBG">Source</TH>
								<TH class="blueBG">DF</TH>
								<TH class="blueBG">Sum of Squares</TH>
								<TH class="blueBG">Mean Square</TH>
								<TH class="blueBG">F</TH>
								<TH class="blueBG">Pr(F)</TH>
								<xsl:apply-templates select="DevCell"/>
							</table>
						</td>
					</tr>
				</tbody>
			</table>
		</DIV>

		<p>
			<h4>
				<xsl:text>Multiple R-Squared: </xsl:text>
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@R2" />
						<xsl:with-param name="NaNstring" select="'NaN'" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</h4>
		</p>
	</xsl:template>

	<xsl:template match="GeneralRegressionModel[@modelType='generalLinear']/DevMatrix/DevCell">
		<xsl:variable name="decimalPattern" select="../../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../../DisplayOptions/@scientificPattern"/>

		<xsl:element name="tr">
			<xsl:attribute name="class">
				<xsl:choose>
					<xsl:when test="position() mod 2 = 0">whiteBG</xsl:when>
					<xsl:otherwise>greyBG</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>

			<th align="left">
				<xsl:value-of select="@source"/>
			</th>
			<td align="center">
				<xsl:number value="@df" grouping-size="3"/>
			</td>
			<td align="center">
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@dev" />
						<xsl:with-param name="NaNstring" select="' '" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</td>
			<td align="center">
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@scaledDev" />
						<xsl:with-param name="NaNstring" select="' '" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</td>
			<td align="center">
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@stat" />
						<xsl:with-param name="NaNstring" select="' '" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</td>
			<td align="center">
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@Pr" />
						<xsl:with-param name="NaNstring" select="' '" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</td>
		</xsl:element>
	</xsl:template>

	<xsl:template match="GeneralRegressionModel[@modelType='multinomialLogistic']/DevMatrix/DevCell">
		<xsl:variable name="decimalPattern" select="../../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../../DisplayOptions/@scientificPattern"/>

		<xsl:element name="tr">
			<xsl:attribute name="class">
				<xsl:choose>
					<xsl:when test="position() mod 2 = 0">whiteBG</xsl:when>
					<xsl:otherwise>greyBG</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>

			<th align="left">
				<xsl:value-of select="@source"/>
			</th>
			<td align="center">
				<xsl:number value="@df" grouping-size="3"/>
			</td>
			<td align="center">
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@dev" />
						<xsl:with-param name="NaNstring" select="'NaN'" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</td>
		</xsl:element>
	</xsl:template>


	<xsl:template match="GeneralRegressionModel[@modelType='multinomialLogistic']/Importance">
		<br/>
		<DIV>
			<table cellSpacing="0" cellPadding="3" border="0">
				<tbody>
					<tr>
						<td class="tableBG">
							<H3 class="tableHead">Term Importance</H3>
							<table class="content" cellSpacing="1" cellPadding="5" border="0">
								<TH class="blueBG">Source</TH>
								<TH class="blueBG">Wald Statistic</TH>
								<TH class="blueBG">DF</TH>
								<TH class="blueBG">Pr</TH>
								<xsl:apply-templates select="Effect"/>
							</table>
						</td>
					</tr>
				</tbody>
			</table>
		</DIV>
	</xsl:template>

	<xsl:template match="GeneralRegressionModel[@modelType='generalLinear']/Importance">
		<xsl:variable name="decimalPattern" select="../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../DisplayOptions/@scientificPattern"/>

		<br/>
		<DIV>
			<table cellSpacing="0" cellPadding="3" border="0">
				<tbody>
					<tr>
						<td class="tableBG">
							<H3 class="tableHead">Term Importance</H3>
							<table class="content" cellSpacing="1" cellPadding="5" border="0">
								<TH class="blueBG">Source</TH>
								<TH class="blueBG">Sum of Squares</TH>
								<TH class="blueBG">F</TH>
								<TH class="blueBG">Pr(F)</TH>
								<xsl:apply-templates select="Effect"/>
							</table>
						</td>
					</tr>
				</tbody>
			</table>
		</DIV>
	</xsl:template>

	<xsl:template match="GeneralRegressionModel[@modelType='generalLinear']/Importance/Effect">
		<xsl:variable name="decimalPattern" select="../../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../../DisplayOptions/@scientificPattern"/>

		<xsl:element name="tr">
			<xsl:attribute name="class">
				<xsl:choose>
					<xsl:when test="position() mod 2 = 0">whiteBG</xsl:when>
					<xsl:otherwise>greyBG</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>

			<th align="left">
				<xsl:value-of select="@name"/>
			</th>
			<td align="center">
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@value" />
						<xsl:with-param name="NaNstring" select="'NaN'" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</td>
			<td align="center">
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@stat" />
						<xsl:with-param name="NaNstring" select="'NaN'" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</td>
			<td align="center">
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@Pr" />
						<xsl:with-param name="NaNstring" select="'NaN'" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</td>
		</xsl:element>
	</xsl:template>

	<xsl:template match="GeneralRegressionModel[@modelType='multinomialLogistic']/Importance/Effect">
		<xsl:variable name="decimalPattern" select="../../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../../DisplayOptions/@scientificPattern"/>

		<xsl:element name="tr">
			<xsl:attribute name="class">
				<xsl:choose>
					<xsl:when test="position() mod 2 = 0">whiteBG</xsl:when>
					<xsl:otherwise>greyBG</xsl:otherwise>
				</xsl:choose>
			</xsl:attribute>

			<th align="left">
				<xsl:value-of select="@name"/>
			</th>
			<td align="center">
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@value" />
						<xsl:with-param name="NaNstring" select="'NaN'" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</td>
			<td align="center">
				<xsl:number value="@df" grouping-size="3"/>
			</td>
			<td align="center">
				<xsl:call-template name="roundNumber">
						<xsl:with-param name="string" select="@Pr" />
						<xsl:with-param name="NaNstring" select="'NaN'" />
						<xsl:with-param name="decimalPattern" select="$decimalPattern" />
						<xsl:with-param name="scientificPattern" select="$scientificPattern" />
				</xsl:call-template>
			</td>
		</xsl:element>
	</xsl:template>

	<xsl:template name="roundNumber">
		<xsl:param name="string" select="''" />
		<xsl:param name="NaNstring" select="''" />
		<xsl:param name="decimalPattern" select="''" />
		<xsl:param name="scientificPattern" select="''" />

	   	<xsl:variable name="lowerCasePattern" select="'e'" />
	   	<xsl:variable name="upperCasePattern" select="'E'" />

		<xsl:choose>
  			  <xsl:when test="$string = 'NaN'">
			  	    <xsl:value-of select="$NaNstring"/>
			  </xsl:when>
  			  <xsl:when test="string-length($string) = 0">
			  	    <xsl:value-of select="$NaNstring"/>
			  </xsl:when>
		      <xsl:when test="contains($string, $lowerCasePattern)">
			    <xsl:call-template name="outputRoundedScientific">
			        <xsl:with-param name="valueString" select="substring-before($string, $lowerCasePattern)" />
			        <xsl:with-param name="exponentString" select="substring-after($string, $lowerCasePattern)" />
		     		<xsl:with-param name="decimalPattern" select="$decimalPattern" />
			    </xsl:call-template>
 			  </xsl:when>
		      <xsl:when test="contains($string, $upperCasePattern)">
			    <xsl:call-template name="outputRoundedScientific">
			        <xsl:with-param name="valueString" select="substring-before($string, $upperCasePattern)" />
			        <xsl:with-param name="exponentString" select="substring-after($string, $upperCasePattern)" />
		     		<xsl:with-param name="decimalPattern" select="$decimalPattern" />
			    </xsl:call-template>
 			  </xsl:when>
		      <xsl:otherwise>
		      	 <xsl:choose>
					<xsl:when test="format-number($string, $decimalPattern) != format-number(0, $decimalPattern)">
						<xsl:value-of select="format-number($string, $decimalPattern)"/>
					</xsl:when>
					<xsl:when test="$string = 0">
						<xsl:value-of select="format-number($string, $decimalPattern)"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="format-number($string, $scientificPattern)"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:text>  </xsl:text>
		      </xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template name="outputRoundedScientific">
		<xsl:param name="valueString" select="''" />
		<xsl:param name="exponentString" select="''" />
		<xsl:param name="decimalPattern" select="''" />
		<xsl:value-of select="format-number($valueString, $decimalPattern)" />E<xsl:value-of select="format-number($exponentString, '#0')"/>
	</xsl:template>

</xsl:stylesheet>
