<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:decimal-format name="blankNaN" NaN=" "/>
	<!-- XSL style sheet for SurvivalModel element -->
	<xsl:template match="XML">
		<xsl:apply-templates select="IMML"/>
	</xsl:template>
	<xsl:template match="IMML">
		<html>
			<title>
				<xsl:value-of select="DisplayOptions/@title"/>
			</title>
			<style type="text/css">
				<xsl:value-of select="CSSText/text()"/>
			</style>
			<body>
				<div>
					<h2 class="title">
						<xsl:value-of select="DisplayOptions/@title"/>
					</h2>
				</div>
				<xsl:apply-templates select="SurvivalModel"/>
			</body>
		</html>
	</xsl:template>
	<xsl:template match="SurvivalModel">
		<h3 class="subtitle">
			<xsl:text>Survival response: </xsl:text>
			<xsl:apply-templates select="SurvResponse"/>
		</h3>
		<xsl:apply-templates select="Coefficients"/>
		<xsl:apply-templates select="SurvModelStats/LikelihoodRatio"/>
		<xsl:apply-templates select="SurvivalDist"/>
	</xsl:template>
	<xsl:template match="SurvResponse">
		<xsl:text>event=</xsl:text>
		<xsl:value-of select="@event"/>
		<xsl:if test="@start">
			<xsl:text>, start time=</xsl:text>
			<xsl:value-of select="@start"/>
		</xsl:if>
		<xsl:text>, time of failure=</xsl:text>
		<xsl:value-of select="@stop"/>
	</xsl:template>
	<xsl:template match="Coefficients">
		<DIV>
			<table cellSpacing="0" cellPadding="3" border="0">
				<tr>
					<td class="tableBG">
						<H3 class="tableHead">Coefficient Estimates</H3>
						<table class="content" cellSpacing="1" cellPadding="5" border="0">
							<tr>
								<th class="blueBG">Variable</th>
								<th class="blueBG">Estimate</th>
								<th class="blueBG">EXP(Estimate)</th>
								<th class="blueBG">Std.Err.</th>
								<th class="blueBG">z-Statistic</th>
								<th class="blueBG">Pr(z)</th>
							</tr>
							<xsl:apply-templates select="Coef"/>
						</table>
					</td>
				</tr>
			</table>
		</DIV>
	</xsl:template>
	<xsl:template match="Coef">
		<xsl:variable name="decimalPattern" select="../../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../../DisplayOptions/@scientificPattern"/>
		<xsl:element name="tr">
			<xsl:attribute name="class"><xsl:choose><xsl:when test="position() mod 2 = 0">whiteBG</xsl:when><xsl:otherwise>greyBG</xsl:otherwise></xsl:choose></xsl:attribute>
			<th align="left">
				<xsl:value-of select="@name"/>
			</th>
			<td align="center">
				<xsl:call-template name="roundNumber">
					<xsl:with-param name="string" select="@value"/>
					<xsl:with-param name="NaNstring" select="'NaN'"/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
					<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
				</xsl:call-template>
			</td>
			<td align="center">
				<xsl:call-template name="roundNumber">
					<xsl:with-param name="string" select="@expCoef"/>
					<xsl:with-param name="NaNstring" select="'NaN'"/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
					<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
				</xsl:call-template>
			</td>
			<td align="center">
				<xsl:call-template name="roundNumber">
					<xsl:with-param name="string" select="@stdErr"/>
					<xsl:with-param name="NaNstring" select="'NaN'"/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
					<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
				</xsl:call-template>
			</td>
			<td align="center">
				<xsl:call-template name="roundNumber">
					<xsl:with-param name="string" select="@z"/>
					<xsl:with-param name="NaNstring" select="'NaN'"/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
					<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
				</xsl:call-template>
			</td>
			<td align="center">
				<xsl:call-template name="roundNumber">
					<xsl:with-param name="string" select="@Pr"/>
					<xsl:with-param name="NaNstring" select="'NaN'"/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
					<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
				</xsl:call-template>
			</td>
		</xsl:element>
	</xsl:template>
	<xsl:template match="SurvModelStats/LikelihoodRatio">
		<xsl:variable name="decimalPattern" select="../../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../../DisplayOptions/@scientificPattern"/>
		<p>
			<xsl:text>Number of observations = </xsl:text>
			<xsl:value-of select="@N"/>
		</p>
		<xsl:text>Likelihood ratio test = </xsl:text>
		<xsl:call-template name="roundNumber">
			<xsl:with-param name="string" select="@value"/>
			<xsl:with-param name="NaNstring" select="'NaN'"/>
			<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
			<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
		</xsl:call-template>
		<xsl:text> on </xsl:text>
		<xsl:value-of select="@df"/>
		<xsl:text> degrees of freedom, probability = </xsl:text>
		<xsl:call-template name="roundNumber">
			<xsl:with-param name="string" select="@Pr"/>
			<xsl:with-param name="NaNstring" select="'NaN'"/>
			<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
			<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
		</xsl:call-template>
	</xsl:template>
	<xsl:template match="SurvivalDist">
		<p/>
		<DIV>
			<table cellSpacing="0" cellPadding="3" border="0">
				<tr>
					<td class="tableBG">
						<H3 class="tableHead">Survival Distribution Estimates</H3>
						<table class="content" cellSpacing="1" cellPadding="5" border="0">
							<tr>
								<th class="blueBG">Time</th>
								<th class="blueBG">Failures</th>
								<th class="blueBG">Risk Set</th>
								<th class="blueBG">Survival</th>
								<th class="blueBG">Std. Error</th>
							</tr>
							<xsl:apply-templates select="FailPoint"/>
						</table>
					</td>
				</tr>
			</table>
		</DIV>
	</xsl:template>
	<xsl:template match="FailPoint">
		<xsl:variable name="decimalPattern" select="../../../DisplayOptions/@decimalPattern"/>
		<xsl:variable name="scientificPattern" select="../../../DisplayOptions/@scientificPattern"/>
		<xsl:element name="tr">
			<xsl:attribute name="class"><xsl:choose><xsl:when test="position() mod 2 = 0">whiteBG</xsl:when><xsl:otherwise>greyBG</xsl:otherwise></xsl:choose></xsl:attribute>
			<td align="center">
				<xsl:call-template name="roundNumber">
					<xsl:with-param name="string" select="@time"/>
					<xsl:with-param name="NaNstring" select="'NaN'"/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
					<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
				</xsl:call-template>
			</td>
			<td align="center">
				<xsl:call-template name="roundNumber">
					<xsl:with-param name="string" select="@failures"/>
					<xsl:with-param name="NaNstring" select="'NaN'"/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
					<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
				</xsl:call-template>
			</td>
			<td align="center">
				<xsl:call-template name="roundNumber">
					<xsl:with-param name="string" select="@riskSet"/>
					<xsl:with-param name="NaNstring" select="'NaN'"/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
					<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
				</xsl:call-template>
			</td>
			<td align="center">
				<xsl:call-template name="roundNumber">
					<xsl:with-param name="string" select="@survival"/>
					<xsl:with-param name="NaNstring" select="'NaN'"/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
					<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
				</xsl:call-template>
			</td>
			<td align="center">
				<xsl:call-template name="roundNumber">
					<xsl:with-param name="string" select="@stdErr"/>
					<xsl:with-param name="NaNstring" select="'NaN'"/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
					<xsl:with-param name="scientificPattern" select="$scientificPattern"/>
				</xsl:call-template>
			</td>
		</xsl:element>
	</xsl:template>
	<xsl:template name="roundNumber">
		<xsl:param name="string" select="''"/>
		<xsl:param name="NaNstring" select="''"/>
		<xsl:param name="decimalPattern" select="''"/>
		<xsl:param name="scientificPattern" select="''"/>
		<xsl:variable name="lowerCasePattern" select="'e'"/>
		<xsl:variable name="upperCasePattern" select="'E'"/>
		<xsl:choose>
			<xsl:when test="$string = 'NaN'">
				<xsl:value-of select="$NaNstring"/>
			</xsl:when>
			<xsl:when test="string-length($string) = 0">
				<xsl:value-of select="$NaNstring"/>
			</xsl:when>
			<xsl:when test="contains($string, $lowerCasePattern)">
				<xsl:call-template name="outputRoundedScientific">
					<xsl:with-param name="valueString" select="substring-before($string, $lowerCasePattern)"/>
					<xsl:with-param name="exponentString" select="substring-after($string, $lowerCasePattern)"/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:when test="contains($string, $upperCasePattern)">
				<xsl:call-template name="outputRoundedScientific">
					<xsl:with-param name="valueString" select="substring-before($string, $upperCasePattern)"/>
					<xsl:with-param name="exponentString" select="substring-after($string, $upperCasePattern)"/>
					<xsl:with-param name="decimalPattern" select="$decimalPattern"/>
				</xsl:call-template>
			</xsl:when>
			<xsl:otherwise>
				<xsl:choose>
					<xsl:when test="format-number($string, $decimalPattern) != format-number(0, $decimalPattern)">
						<xsl:value-of select="format-number($string, $decimalPattern)"/>
					</xsl:when>
					<xsl:when test="$string = 0">
						<xsl:value-of select="format-number($string, $decimalPattern)"/>
					</xsl:when>
					<xsl:otherwise>
						<xsl:value-of select="format-number($string, $scientificPattern)"/>
					</xsl:otherwise>
				</xsl:choose>
				<xsl:text/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
	<xsl:template name="outputRoundedScientific">
		<xsl:param name="valueString" select="''"/>
		<xsl:param name="exponentString" select="''"/>
		<xsl:param name="decimalPattern" select="''"/>
		<xsl:value-of select="format-number($valueString, $decimalPattern)"/>E<xsl:value-of select="format-number($exponentString, '#0')"/>
	</xsl:template>
</xsl:stylesheet>
