package com.insightful.splus.statdlg;

import javax.swing.*;
import javax.swing.event.*;
import javax.swing.text.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import com.insightful.controls.*;
import com.insightful.splus.SplusDataSetComboBox;
import com.insightful.splus.SplusDataColumnComboBox;
import com.insightful.splus.SplusSubsetField;
import com.insightful.splus.SplusDataColumnListBox;

public class CorrelationsDialog extends SplusDialog {

    // Define any controls with listeners

    SplusDataSetComboBox dataSet;
    SplusDataColumnListBox dataColumnList;

    SplusRadioButtonGroup typeButtons;
    SplusTextField trimField;

    public CorrelationsDialog(){
	super("Correlations and Covariances");

	// A one page dialog with two columns
	// Controls and groups get added to the columns

	JPanel mainPanel = new JPanel();

	Box columnOne = new Box(BoxLayout.Y_AXIS);
	Box columnTwo = new Box(BoxLayout.Y_AXIS);
	mainPanel.setLayout(new BoxLayout(mainPanel, BoxLayout.X_AXIS));
	mainPanel.add(columnOne);
	mainPanel.add(columnTwo);

	/* Information needed to construct function call */
	SplusFunctionInfo funcInfo = new SplusFunctionInfo("menuCor");
	setFunctionInfo(funcInfo);

	// Data group

	SplusGroupPanel dataGroup = new SplusGroupPanel("Data");
	columnOne.add(dataGroup);

	dataSet = new SplusDataSetComboBox();
	dataGroup.add(dataSet);
	funcInfo.add(dataSet, "data");

	dataColumnList = new SplusDataColumnListBox(dataSet);
	dataColumnList.setPrepend(new String [] {"<ALL>"});
	dataColumnList.setValue("<ALL>");
	dataGroup.add(dataColumnList);
	funcInfo.add(dataColumnList, "variables", true, true);

	SplusComboBox naMethod = new 
	    SplusComboBox("Method to Handle Missing Values", 'M',
			  new String[] {"Fail", "Omit", "Include",
					"Available"});
	naMethod.setValue("Fail");
	naMethod.setEditable(false);
	dataGroup.add(naMethod);
	funcInfo.add(naMethod, "na.method", true);

	// Spacer for column one

	columnOne.add(new SplusBoxFiller());

	// Statistic group

	SplusGroupPanel statGroup = new SplusGroupPanel("Statistic");
	columnTwo.add(statGroup);

	typeButtons = new 
	    SplusRadioButtonGroup("Type", 'T', 
			  new String [] {"Correlations", "Covariances"});
	typeButtons.setValue("Correlations");
	statGroup.add(typeButtons);
	funcInfo.add(typeButtons, "statistic", true);

	// Listen to disable trimming for Covariances

	typeButtons.addActionListener( new ActionListener() {
		public void actionPerformed(ActionEvent ae){
		    trimField.setEnabled(
					 typeButtons.getValue().equals("Correlations"));
		}
	    });

	trimField = new SplusTextField("Fraction to Trim",
						      'F');
	trimField.setValue("0");
	statGroup.add(trimField);
	funcInfo.add(trimField, "trim");


	// Results group

	SplusGroupPanel resultsGroup = 
	    new SplusGroupPanel("Results");
	columnTwo.add(resultsGroup);

	SplusTextField saveAs =
	    new SplusTextField("Save As", 'S');
	resultsGroup.add(saveAs);
	funcInfo.setResultControl(saveAs);

	SplusCheckBox printResults =
	    new SplusCheckBox("Print Results", 'P');
	printResults.setValue("T");
	resultsGroup.add(printResults);
	funcInfo.add(printResults, "print.it");

	// Spacer for column two

	columnTwo.add(new SplusBoxFiller());

	// Add mainPanel to CENTER panel of dialog

	setCenterPanel(mainPanel);

    }

  // Redefine isComplete() to check for required arguments.

  public boolean isComplete() {
    return (warnIfEmpty(dataSet));
  }

}


