### Name: rtfDataFrameToTable
### Title: rtfDataFrameToTable
### Aliases: rtfDataFrameToTable
### Keywords: rtf table

### ** Examples

rtfFile <- "mytest.rtf"

cat(file=rtfFile, rtfInit(bLandscape=T), append=F)

# create sample data.frame
mydf <- data.frame(myCol1=format(rnorm(10), digits=3, justify="n"), 
        myCol2=format(rnorm(10), digits=3, justify="n"), 
        myCol3=format(rnorm(10), digits=3, justify="n"), 
        myCol4=format(rnorm(10), digits=3, justify="n"), stringsAsFactors=F)

rtfDataFrameToTable(mydf, rtfFile, tabletitle="Demo of RTF Functions", 
        rownames=F, colnames=T, colwidth=1000,
        cellBorder=rep(list(rep(SOLIDCELLBORDER,4)), ncol(mydf)))

rtfSpaceBetweenTables(rtfFile, pageBreak=F)

mydf2 <- data.frame(Subject=c("Subject1", "Subject2", "Subject3"), 
        "Heart Rate"=c(90, 70, 120), 
        Weight=c(170, 200, 210), stringsAsFactors=F)

rtfDataFrameToTable(mydf2, rtfFile, tabletitle="Subject Information", 
        rownames=F, colnames=T, colwidth=1440,
        cellBorder=rep(list(rep(SOLIDCELLBORDER,4)), ncol(mydf2)))
        
rtfClose(rtfFile)



