### Name: rtfStartInsertAtTag
### Title: rtfStartInsertAtTag
### Aliases: rtfStartInsertAtTag
### Keywords: rtf template

### ** Examples

library(rtftools, first=T)

############ specify template file ### "TemplateExample.rtf"
filenameIn <- system.file("TemplateExample.rtf", package="rtftools")

### output file
rtfFileOut <- paste(getenv("S_MYSWORK"), "ReportOut.rtf", sep="/")

###############################
### Sample section Number 1
restoftext <- rtfStartInsertAtTag(filenameIn, rtfFileOut, "_TABLEGOESHERE_")

mydf <- data.frame(myCol1=format(rnorm(20), digits=3, justify="n"), 
                myCol2=format(rnorm(20), digits=3, justify="n"), 
                myCol3=format(rnorm(20), digits=3, justify="n"), 
                myCol4=format(rnorm(20), digits=3, justify="n"),
                stringsAsFactors=F)

tableInit <- rtfTableInit(ncol(mydf), colwidth=rep(1000, ncol(mydf)), fontsize=10)

rtfWriteOutTableText(mydf, rtfFileOut, tableInit, "Table ",
        titl="Test splitting of table across pages",
        dimnames(mydf)[[2]], sortCol="myCol1", summStartRow=0,
        maxColumnsPage=3, maxRowsPage=10, 
        tableHeader=NULL, 
        cellBorder=rep(list(rep(SOLIDCELLBORDER,4)), tableInit$numCols))

############ end section
rtfEndInsertAtTag(rtfFileOut, restoftext)




